/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprbill.entryimport;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.business.adjapprbill.AdjBillEntryImpHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardImportHelper;
import kd.swc.hsbp.business.export.ListTemplateExporter;
import kd.swc.hsbp.business.export.SWCExportEntryHelper;
import kd.swc.hsbp.business.export.entity.ImportConfig;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.entity.EntryColumnWrapper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class AdjBillEntryImportStartEdit
extends AbstractFormPlugin
implements UploadListener {
    private static Log log = LogFactory.getLog(AdjBillEntryImportStartEdit.class);
    private AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
    private static final String FILEPATH = "filepath";
    private static final String FILEPANEL = "filepanel";
    private static final String SWC_HCDM_FORMPLUGIN = "swc-hcdm-formplugin";
    private static final Integer fixRemarkHeight = 2;
    private static final Integer fixHeadHeight = 5;
    private ImportConfig importConfig;
    private int maxImportSize = 100000;
    private String salaryadjrsnType;

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndownload", "btnresetfile"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
        this.salaryadjrsnType = (String)this.getView().getFormShowParameter().getCustomParam("salaryadjrsnType");
        this.initImportConfig();
    }

    public void initImportConfig() {
        Set mustInputSets;
        this.importConfig = new ImportConfig();
        this.importConfig.setMaxRowCount(this.maxImportSize);
        this.importConfig.setImportType(ImportConfig.ImportType.Partial);
        this.importConfig.setTemplateWarningInfo(ResManager.loadKDString((String)"\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"AdjBillEntryImportStartEdit_1", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
        if (AdjAttributionType.DECATTRTYPE.getCode().equals(this.salaryadjrsnType)) {
            this.importConfig.setModelName(ResManager.loadKDString((String)"\u5b9a\u85aa\u7533\u8bf7", (String)"AdjBillEntryImportStartEdit_2", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
            this.importConfig.setTemplateFileName(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_\u5b9a\u85aa\u6a21\u677f", (String)"AdjBillEntryImportStartEdit_3", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
            this.importConfig.setTemplateCaption(ResManager.loadKDString((String)"\u5b9a\u85aa\u4fe1\u606f # entryentity", (String)"AdjBillEntryImportStartEdit_4", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
        } else if (AdjAttributionType.ADJATTRTYPE.getCode().equals(this.salaryadjrsnType)) {
            this.importConfig.setModelName(ResManager.loadKDString((String)"\u8c03\u85aa\u7533\u8bf7", (String)"AdjBillEntryImportStartEdit_5", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
            this.importConfig.setTemplateFileName(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_\u8c03\u85aa\u6a21\u677f", (String)"AdjBillEntryImportStartEdit_6", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
            this.importConfig.setTemplateCaption(ResManager.loadKDString((String)"\u6279\u91cf\u5bfc\u5165\u8c03\u85aa\u6570\u636e #", (String)"AdjBillEntryImportStartEdit_7", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
        }
        String adjFieldCfgId = (String)this.getView().getFormShowParameter().getCustomParam("adjFieldCfgId");
        log.info("adjFieldCfgId is:{}", (Object)adjFieldCfgId);
        if (StringUtils.isNotBlank((String)adjFieldCfgId) && null != (mustInputSets = this.adjApprovalApplicationService.getAdjFdOfImportMustInput(Long.valueOf(adjFieldCfgId)))) {
            this.importConfig.setMustInputFields(mustInputSets.stream().map(mustInputField -> "dy_" + mustInputField).collect(Collectors.toSet()));
        }
        this.importConfig.setFieldAnnotation(this.getFieldAnnotation());
        this.importConfig.setHeadHeight(3);
    }

    public Map<String, String> getFieldAnnotation() {
        HashMap map = Maps.newHashMap();
        String unMustInputMsg = ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879", (String)"AdjBillEntryImportStartEdit_8", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
        map.put("calctype", ResManager.loadKDString((String)"\u82e5\u9009\u62e9\u6bd4\u4f8b\u5219\u5efa\u8bae\u8c03\u5e45\u3001\u5b9e\u9645\u8c03\u5e45\u586b\u5199\u6bd4\u4f8b\u5373\u53ef\uff0c\u91d1\u989d\u90e8\u5206\u5c06\u81ea\u52a8\u8ba1\u7b97\uff0c\u53cd\u4e4b\u540c\u7406\u3002", (String)"AdjBillEntryImportStartEdit_9", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
        map.put("suggestminrange", unMustInputMsg);
        map.put("suggestmaxrange", unMustInputMsg);
        map.put("suggestminamount", unMustInputMsg);
        map.put("suggestmaxamount", unMustInputMsg);
        map.put("actualrange", ResManager.loadKDString((String)"\u5fc5\u586b\u9879\uff0c\u82e5\u6bd4\u4f8b/\u91d1\u989d\u9009\u62e9\u6bd4\u4f8b\uff0c\u5219\u6b64\u9879\u5fc5\u586b", (String)"AdjBillEntryImportStartEdit_10", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
        map.put("actualamount", ResManager.loadKDString((String)"\u5fc5\u586b\u9879\uff0c\u82e5\u6bd4\u4f8b/\u91d1\u989d\u9009\u62e9\u91d1\u989d\uff0c\u5219\u6b64\u9879\u5fc5\u586b", (String)"AdjBillEntryImportStartEdit_11", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
        return map;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"ImportProcessCallBack")) {
            if (closedCallBackEvent.getReturnData() instanceof String) {
                this.getView().setReturnData((Object)"import_progress_page_close");
            }
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        IFormView parentView;
        super.beforeClosed(event);
        if (this.getView() != null && this.getView().getFormShowParameter().getCustomParam("cache_key_import_finish_mark") != null && (parentView = this.getView().getParentView()) != null) {
            parentView.getFormShowParameter().setCustomParam("cache_key_import_finish_mark", (Object)"import_progress_page_close");
        }
    }

    public void afterCreateNewData(EventObject e) {
        String showImportType;
        this.getView().setVisible(Boolean.FALSE, new String[]{FILEPANEL});
        this.getView().setEnable(Boolean.FALSE, new String[]{"keyfields"});
        Label title = (Label)this.getControl("title");
        String titleTips = ResManager.loadKDString((String)"\u5c06\u6570\u636e\u5bfc\u5165\u5230%1$s", (String)"DynamicEntryImportStartEdit_17", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
        String text = String.format(Locale.ROOT, titleTips, this.getEntryView().getModel().getDataEntityType().getDisplayName().toString());
        title.setText(text);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String hideImportType = (String)parameter.getCustomParam("hideImportType");
        if (SWCStringUtils.isNotEmpty((String)hideImportType)) {
            String[] hideImportTypeArray = hideImportType.split(",");
            this.getView().setVisible(Boolean.FALSE, hideImportTypeArray);
        }
        if (SWCStringUtils.isNotEmpty((String)(showImportType = (String)parameter.getCustomParam("showImportType")))) {
            String[] showImportTypeArray = showImportType.split(",");
            String defaultValue = showImportTypeArray[0];
            this.getModel().setValue("importtype", (Object)defaultValue);
        }
        if (SWCStringUtils.isEmpty((String)hideImportType) && SWCStringUtils.isEmpty((String)showImportType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"new", "override"});
        }
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            IFormView view = this.getView();
            String url = (String)urls[0];
            FileService service = FileServiceFactory.getAttachmentFileService();
            final ArrayList dataHead = Lists.newArrayListWithCapacity((int)this.importConfig.getHeadHeight());
            final AtomicInteger totalNum = new AtomicInteger();
            try (InputStream in = service.getInputStream(url);){
                new ExcelReader().read(in, new SheetHandler(){

                    public void handleRow(SheetHandler.ParsedRow row) {
                        if (row.getRowNum() < fixRemarkHeight) {
                            return;
                        }
                        if (row.getRowNum() < fixHeadHeight) {
                            dataHead.add(row.getData());
                        } else if (!row.isEmpty()) {
                            totalNum.incrementAndGet();
                        }
                    }
                });
            }
            catch (KDBizException e) {
                ErrorCode code = e.getErrorCode();
                if (code == null || !"ValidFile".equalsIgnoreCase(code.getCode())) {
                    view.showErrorNotification(e.getMessage());
                    return;
                }
            }
            catch (Throwable e) {
                log.error(e);
                view.showMessage(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u9519\u8bef\u3002", (String)"DynamicEntryImportStartEdit_15", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]), e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"DynamicEntryImportStartEdit_2", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]), MessageTypes.Default);
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4e0a\u4f20", "DynamicEntryImportStartEdit_12", SWC_HCDM_FORMPLUGIN);
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4e0a\u4f20\u5931\u8d25\uff0c\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u9519\u8bef\u3002", "DynamicEntryImportStartEdit_15", SWC_HCDM_FORMPLUGIN);
                SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"upload", (MultiLangEnumBridge)opName, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[0]);
                return;
            }
            if (!this.templateColValidate(dataHead)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u9519\u8bef\u3002", (String)"DynamicEntryImportStartEdit_15", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.put("uploadTotalNum", String.valueOf(totalNum.intValue()));
            if (totalNum.intValue() > this.importConfig.getMaxRowCount()) {
                String formatString = MessageFormat.format("{0}{1}\uff0c{2}", ResManager.loadKDString((String)"\u6700\u5927\u884c\u9650\u5236", (String)"DynamicEntryImportStartEdit_0", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]), this.importConfig.getMaxRowCount(), ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"DynamicEntryImportStartEdit_1", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
                view.showMessage(formatString);
                return;
            }
            if (totalNum.intValue() <= 0) {
                view.showMessage(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u672a\u89e3\u6790\u5230\u6709\u6548\u6570\u636e\u3002", (String)"DynamicEntryImportStartEdit_13", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6570\u636e\u540e\u518d\u8bd5\u3002", (String)"DynamicEntryImportStartEdit_16", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]), MessageTypes.Default);
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4e0a\u4f20", "DynamicEntryImportStartEdit_12", SWC_HCDM_FORMPLUGIN);
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4e0a\u4f20\u5931\u8d25\uff0c\u672a\u89e3\u6790\u5230\u6709\u6548\u6570\u636e\u3002", "DynamicEntryImportStartEdit_13", SWC_HCDM_FORMPLUGIN);
                SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"upload", (MultiLangEnumBridge)opName, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[0]);
                return;
            }
            view.setVisible(Boolean.TRUE, new String[]{FILEPANEL});
            view.setVisible(Boolean.FALSE, new String[]{"uploadpanel"});
            IDataModel model = this.getModel();
            model.setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
            model.setValue(FILEPATH, (Object)url);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                this.downloadTemplate();
                break;
            }
            case "btnresetfile": {
                this.getModel().setValue("filename", (Object)"");
                this.getModel().setValue(FILEPATH, (Object)"");
                this.getView().setVisible(Boolean.FALSE, new String[]{FILEPANEL});
                this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
                break;
            }
        }
    }

    private void downloadTemplate() {
        IFormView entryView = this.getView().getParentView();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String entryKey = (String)showParameter.getCustomParam("entrykey");
        EntryColumnWrapper wrapper = this.loadCustomDataSource();
        Set ignoreSet = SWCExportEntryHelper.getIgnoreColumnByFeatures((DataEntityPropertyCollection)entryView.getModel().getEntryEntity(entryKey).getDynamicObjectType().getProperties(), (boolean)true);
        SWCExportEntryHelper.removeIgnoreColumn((List)wrapper.getContainers(), (Set)ignoreSet);
        List containers = wrapper.getContainers();
        try {
            Map captions = SWCExportEntryHelper.getEntryFieldCaptions((List)containers);
            LocaleString caption = entryView.getModel().getProperty(entryKey).getDisplayName();
            String entryName = caption != null && StringUtils.isNotBlank((String)caption.toString()) ? caption.toString() : entryKey;
            EntityType entityType = (EntityType)this.getEntryView().getModel().getDataEntityType().getAllEntities().get(entryKey);
            ListTemplateExporter exporter = new ListTemplateExporter(containers, entityType, this.importConfig);
            this.invokeBeforeDownLoadTemplate(exporter.getWb());
            String templateFileName = this.importConfig.getTemplateFileName();
            String url = exporter.flush(entryView.getModel().getDataEntityType(), templateFileName, null);
            this.getView().download(UrlService.getAttachmentFullUrl((String)url));
            this.getView().sendFormAction(this.getView());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void importData() {
        SWCPermissionServiceHelper.checkCancelDataAndFunctionRightWithException((IFormView)this.getView().getParentView(), (boolean)true);
        String url = this.getModel().getDataEntity().getString(FILEPATH);
        if (StringUtils.isBlank((String)url)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"DynamicEntryImportStartEdit_8", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5f00\u59cb\u4e0a\u4f20", "DynamicEntryImportStartEdit_10", SWC_HCDM_FORMPLUGIN);
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4e0a\u4f20\u5931\u8d25\uff0c\u672a\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u3002", "DynamicEntryImportStartEdit_11", SWC_HCDM_FORMPLUGIN);
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"start upload", (MultiLangEnumBridge)opName, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[0]);
            return;
        }
        this.createBaskgroundTask(url);
    }

    private void createBaskgroundTask(String url) {
        String tplHeadStr = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_", (String)"AdjBillEntryImportStartEdit_0", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
        String name = FilenameUtils.getBaseName((String)url).replace(tplHeadStr, "");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("url", url);
        params.put("fixRemarkHeight", fixRemarkHeight);
        params.put("fixHeadHeight", fixHeadHeight);
        IPageCache pageCache = this.getView().getPageCache();
        params.put("uploadTotalNum", pageCache.get("uploadTotalNum"));
        Map customParam = this.getView().getFormShowParameter().getCustomParams();
        params.putAll(customParam);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        DataEntityPropertyCollection propertyCollection = ((EntryProp)parentView.getModel().getProperty("adjapprdetailentry")).getItemType().getProperties();
        params.put("property", SerializationUtils.serializeToBase64((Object)propertyCollection));
        String pageId = parentView.getPageId();
        String rootPageId = ObjectUtils.isEmpty((Object)parentView.getMainView()) ? pageId : parentView.getMainView().getPageId();
        String taskId = HRBackgroundTaskHelper.getInstance().createBaskgroundTask("swc_hcdm_adjentryimport", name, false, rootPageId, pageId, params);
        HRBackgroundTaskHelper.getInstance().showBaskgroundTask(taskId);
        customParam.put("taskId", taskId);
        AdjBillEntryImpHelper.showProgressForm((IFormView)this.getView(), (Map)customParam);
    }

    private IFormView getEntryView() {
        String entryViewPageId = (String)this.getView().getFormShowParameter().getCustomParam("entryview");
        return this.getView().getView(entryViewPageId);
    }

    private void invokeBeforeDownLoadTemplate(SXSSFWorkbook wb) {
        AdjBillEntryImpHelper.reDrawColProperty((SXSSFWorkbook)wb, (String)this.salaryadjrsnType);
    }

    private boolean templateColValidate(List<Map<Integer, String>> dataHead) {
        if (dataHead.size() > 0) {
            Map<Integer, String> map = dataHead.get(dataHead.size() - 1);
            for (Map.Entry<Integer, String> entry : map.entrySet()) {
                String value = entry.getValue();
                if (!value.contains("*")) continue;
                String trim = value.replaceFirst("\\*", "").trim();
                entry.setValue(trim);
            }
        }
        List columns = SWCExportEntryHelper.readRuntimeEntryColumn((IFormView)this.getView().getParentView(), (String)"adjapprdetailentry");
        Set ignoreSet = SWCExportEntryHelper.getIgnoreColumnByFeatures((DataEntityPropertyCollection)this.getView().getParentView().getModel().getEntryEntity("adjapprdetailentry").getDynamicObjectType().getProperties(), (boolean)true);
        List containers = SWCExportEntryHelper.getEntryColumnContainers((List)columns, (Set)ignoreSet);
        AdjBillEntryImpHelper.importTempleExcludeCol((String)this.salaryadjrsnType, (List)containers);
        int headHeight = SWCExportEntryHelper.calcSheetHeadHeight((List)containers);
        List dataHeadSource = SalaryStandardImportHelper.getSourceHeadData((List)containers, (int)headHeight, (IDataModel)this.getModel());
        boolean validateResult = true;
        if (dataHeadSource != null && dataHeadSource.size() >= 3) {
            dataHeadSource.remove(2);
        }
        if (dataHead != null && dataHead.size() >= 3) {
            dataHead.remove(2);
        }
        if (!SalaryStandardImportHelper.isEqualCollection((List)dataHeadSource, dataHead)) {
            validateResult = false;
        }
        return validateResult;
    }

    private EntryColumnWrapper loadCustomDataSource() {
        EntryColumnWrapper wrapper = SWCExportEntryHelper.readEntryColumnInfo((IFormView)this.getView().getParentView(), (String)"adjapprdetailentry");
        return wrapper;
    }
}

