/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprscm;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.utils.KDEncodeUtil;
import kd.swc.hcdm.business.adjapprbill.AdjApprovalLittleKHelper;
import kd.swc.hcdm.business.adjapprbill.adjconfirm.AdjConfirmHelper;
import kd.swc.hcdm.business.adjapprscm.AdjApprLittleKCfgTplHelper;

public class AdjApprLittleKCfgEdit
extends AbstractBasePlugIn
implements RowClickEventListener,
SelectRowsEventListener {
    private static Log logger = LogFactory.getLog(AdjApprLittleKCfgEdit.class);
    private static final String KEY_RIGHTTITLE = "righttitle";
    private static final String KEY_RIGHTPOSITIONTYPE = "rightpositiontype";
    private static final String KEY_RIGHTCONTENT = "rightcontent";

    public void initialize() {
        super.initialize();
        CardEntry entryGrid = (CardEntry)this.getControl("littlekentryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"littlekentryentity", (CharSequence)entryGrid.getKey())) {
            int row = evt.getRow();
            this.getView().getPageCache().put("rowIndex", String.valueOf(row));
            this.cutoverRightPanel(row);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs args) {
        EntryProp entryProp = args.getEntryProp();
        if (args.getRowDataEntities().length > 0 && "littlekentryentity".equals(entryProp.getName())) {
            this.checkoutShow(Boolean.FALSE);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs args) {
        EntryProp entryProp = args.getEntryProp();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("littlekentryentity");
        if (rows.size() == 0 && "littlekentryentity".equals(entryProp.getName())) {
            this.checkoutShow(Boolean.TRUE);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        BillShowParameter baseShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        BillOperationStatus billStatus = baseShowParameter.getBillStatus();
        if (BillOperationStatus.SUBMIT.equals((Object)billStatus) || BillOperationStatus.AUDIT.equals((Object)billStatus)) {
            return;
        }
        String name = args.getProperty().getName();
        IDataModel model = this.getModel();
        switch (name) {
            case "islittlek": {
                DynamicObjectCollection rows = this.getModel().getEntryEntity("littlekentryentity");
                Boolean islittlek = (Boolean)model.getValue("islittlek");
                this.getView().setVisible(islittlek, new String[]{"flexpanelap15"});
                if (!islittlek.booleanValue()) {
                    this.getModel().setValue(KEY_RIGHTTITLE, null);
                    this.getModel().setValue(KEY_RIGHTPOSITIONTYPE, null);
                    RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl(KEY_RIGHTCONTENT);
                    richTextEditor.setText(null);
                    this.getModel().deleteEntryData("littlekentryentity");
                    break;
                }
                if (rows.size() != 0) break;
                this.getView().invokeOperation("littlek_newentry");
                this.checkoutShow(Boolean.FALSE);
                break;
            }
            case "righttitle": {
                this.getModel().setValue("title", model.getValue(KEY_RIGHTTITLE), this.getCurrentRowIndex());
                break;
            }
            case "rightpositiontype": {
                if (this.getModel().getEntryRowCount("littlekentryentity") <= 0) break;
                this.getModel().setValue("positiontype", model.getValue(KEY_RIGHTPOSITIONTYPE), this.getCurrentRowIndex());
                break;
            }
            case "content": {
                ChangeData[] changeSet;
                for (ChangeData data : changeSet = args.getChangeSet()) {
                    int rowIndex = data.getRowIndex();
                    Object newValue = data.getNewValue();
                    String content = AdjApprovalLittleKHelper.transFieldKeyToCaption((String)((String)newValue), (boolean)false);
                    logger.info("trans field key to caption change ={}", (Object)content);
                    String displayValue = AdjApprLittleKCfgTplHelper.removeHtmlTag((String)content);
                    logger.info("content change ={}", (Object)displayValue);
                    this.getModel().setValue("displaytext", (Object)displayValue, rowIndex);
                }
                break;
            }
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Boolean islittlek = (Boolean)this.getModel().getValue("islittlek");
        this.getView().setVisible(islittlek, new String[]{"flexpanelap15"});
        DynamicObjectCollection rows = this.getModel().getEntryEntity("littlekentryentity");
        if (rows.size() > 0) {
            this.cutoverRightPanel(0);
        }
        this.checkoutShow(rows.size() == 0);
        TextEdit textEdit = (TextEdit)this.getControl(KEY_RIGHTTITLE);
        textEdit.setMustInput(true);
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_RIGHTPOSITIONTYPE);
        comboEdit.setMustInput(true);
        if (!islittlek.booleanValue()) {
            this.getModel().deleteEntryData("littlekentryentity");
        }
        for (DynamicObject row : rows) {
            String content = AdjApprovalLittleKHelper.transFieldKeyToCaption((String)row.getString("content"), (boolean)false);
            String displayValue = AdjApprLittleKCfgTplHelper.removeHtmlTag((String)content);
            logger.info("beforebind displayValue = {}", (Object)displayValue);
            row.set("displaytext", (Object)displayValue);
        }
    }

    private void checkoutShow(Boolean isShow) {
        this.getView().setVisible(Boolean.valueOf(isShow == false), new String[]{"mainflexpanelap", "varflexpanelap2", "richtextflex"});
    }

    public void customEvent(CustomEventArgs args) {
        super.customEvent(args);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection littlekEntryEntity = dataEntity.getDynamicObjectCollection("littlekentryentity");
        if (littlekEntryEntity.size() != 0) {
            logger.info("customEvent eventArgs = {}", (Object)args.getEventArgs());
            String eventArgs = KDEncodeUtil.kdDecoding((String)args.getEventArgs());
            String value = AdjApprovalLittleKHelper.transFieldKeyToCaption((String)eventArgs, (boolean)true);
            logger.info("customEvent displayValue = {}", (Object)value);
            int rowIndex = this.getCurrentRowIndex();
            this.getModel().setValue("content", (Object)value, rowIndex);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FlexPanelAp panelAp = AdjApprovalLittleKHelper.createTplVarFlexPlanAp();
        HashMap<String, String> mapHead = new HashMap<String, String>(2);
        mapHead.put("id", "varflexpanelap");
        mapHead.put("items", (String)panelAp.createControl().get("items"));
        args.getItems().add(mapHead);
    }

    public void onGetControl(OnGetControlArgs args) {
        String key = args.getKey();
        Map varParamMap = AdjApprLittleKCfgTplHelper.createVarParamMap();
        if (varParamMap.containsKey(key)) {
            Label label = new Label();
            label.setKey(key);
            label.setView(this.getView());
            label.addClickListener((ClickListener)this);
            args.setControl((Control)label);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "save": 
            case "submit": 
            case "changesave": {
                boolean littlekResult;
                boolean groupSortResult = this.isGroupSortByPositionType();
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("littlekentryentity");
                Boolean islittlek = (Boolean)this.getModel().getValue("islittlek");
                boolean bl = littlekResult = islittlek != false && entryEntity.size() == 0;
                if (littlekResult) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u8bbe\u7f6e\u5361\u7247\u3002", (String)"AdjApprLittleKCfgEdit_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                }
                if (groupSortResult && !littlekResult) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control sControl = (Control)evt.getSource();
        Map varParamMap = AdjApprLittleKCfgTplHelper.createVarParamMap();
        if (varParamMap.containsKey(sControl.getKey())) {
            AdjConfirmHelper.setArgToContent((IFormView)this.getView(), (String)((String)varParamMap.get(sControl.getKey())), (String)KEY_RIGHTCONTENT);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.itemClick((ItemClickEvent)evt);
        String operationKey = evt.getOperationKey();
        CardEntry entryGrid = (CardEntry)this.getControl("littlekentryentity");
        int[] rowIndexs = entryGrid.getSelectRows();
        switch (operationKey) {
            case "littlek_moveentryup": {
                if (rowIndexs.length <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2a\u5361\u7247\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdjApprLittleKCfgEdit_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    evt.setCancel(true);
                    return;
                }
                int minRow = Arrays.stream(rowIndexs).min().getAsInt();
                if (minRow > 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u4e3a\u9996\u4e2a\u5361\u7247\uff0c\u65e0\u6cd5\u4e0a\u79fb\u3002", (String)"AdjApprLittleKCfgEdit_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                evt.setCancel(true);
                return;
            }
            case "littlek_moveentrydown": {
                if (rowIndexs.length <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2a\u5361\u7247\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdjApprLittleKCfgEdit_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    evt.setCancel(true);
                    return;
                }
                int rowCount = this.getModel().getEntryRowCount("littlekentryentity");
                int maxRow = Arrays.stream(rowIndexs).max().getAsInt();
                if (maxRow < rowCount - 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u5361\u7247\u4e3a\u6700\u540e\u4e00\u4e2a\uff0c\u65e0\u6cd5\u4e0b\u79fb\u3002", (String)"AdjApprLittleKCfgEdit_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                evt.setCancel(true);
                return;
            }
        }
    }

    private int getCurrentRowIndex() {
        String rowIndex = this.getView().getPageCache().get("rowIndex");
        if (StringUtils.isBlank((CharSequence)rowIndex)) {
            return 0;
        }
        return Integer.parseInt(rowIndex);
    }

    private boolean isGroupSortByPositionType() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("littlekentryentity");
        Map<String, List<DynamicObject>> collect = rows.stream().collect(Collectors.groupingBy(dy -> dy.getString("positiontype")));
        for (Map.Entry<String, List<DynamicObject>> coll : collect.entrySet()) {
            List<DynamicObject> valueList = coll.getValue();
            for (int i = 0; i < valueList.size(); ++i) {
                int curSeq;
                int preSeq;
                if (i <= 0 || Math.abs((preSeq = valueList.get(i - 1).getInt("seq")) - (curSeq = valueList.get(i).getInt("seq"))) == 1) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76f8\u540c\u201c\u5b9a\u4f4d\u7c7b\u578b\u201d\u7684\u5361\u7247\u5fc5\u987b\u76f8\u90bb\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjApprLittleKCfgEdit_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void cutoverRightPanel(int row) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("littlekentryentity");
        DynamicObject data = (DynamicObject)rows.get(row);
        String title = data.getString("title");
        String positionType = data.getString("positiontype");
        String content = AdjApprovalLittleKHelper.transFieldKeyToCaption((String)data.getString("content"), (boolean)false);
        this.getModel().setValue(KEY_RIGHTTITLE, (Object)title);
        this.getModel().setValue(KEY_RIGHTPOSITIONTYPE, (Object)positionType);
        RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl(KEY_RIGHTCONTENT);
        richTextEditor.setText(content);
    }
}

