/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjapprscm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.swc.hcdm.business.adjapprbill.analysis.AxisDataConfigHelper;
import kd.swc.hcdm.business.adjapprbill.enums.AxisTypeEnum;
import kd.swc.hcdm.business.adjapprscm.AdjApprscmHelper;
import kd.swc.hcdm.business.country.CountryHelper;
import kd.swc.hcdm.business.country.CountryPolicy;
import kd.swc.hcdm.business.country.CountryRefChanged;
import kd.swc.hcdm.common.enums.HCDMErrInfoEnum;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class AdjApprScmEdit
extends AbstractBasePlugIn
implements TreeNodeClickListener,
BeforeF7SelectListener,
CountryRefChanged {
    private static final String AUDITCONFIRM_CHANGE = "auditconfirmchange";
    private static final String CALLBACKID_AUDITCONFIRM_CHANGET = "callbackid_auditconfirmchange";
    private static final String CALLBACKID_ADJDECISIONCFG = "callbackid_adjdecisioncfg";
    private static final String CACHE_SELECTED_NODE = "CACHE_SELECTED_NODE";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        TreeView decisiontreeap = (TreeView)this.getControl("decisiontreeap");
        decisiontreeap.addTreeNodeClickListener((TreeNodeClickListener)this);
        CountryHelper.registerListenerForBaseData((AbstractFormPlugin)this, Arrays.asList("adjdecisioncfg", "adjconfirmtpl", "country"));
    }

    private void constructorData(TreeView treeView) {
        Map<String, String> treeDataMap = this.getTreeDataMap();
        String waitSelectNodeId = this.getPageCache().get(CACHE_SELECTED_NODE);
        ArrayList nodes = Lists.newArrayListWithExpectedSize((int)treeDataMap.size());
        for (Map.Entry<String, String> map : treeDataMap.entrySet()) {
            TreeNode node = new TreeNode(null, map.getKey(), map.getValue());
            nodes.add(node);
            if (waitSelectNodeId != null) continue;
            waitSelectNodeId = node.getId();
        }
        treeView.deleteAllNodes();
        treeView.addNodes((List)nodes);
        this.getPageCache().put(CACHE_SELECTED_NODE, waitSelectNodeId);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        TreeView treeView = (TreeView)this.getView().getControl("decisiontreeap");
        this.constructorData(treeView);
        Boolean isAdjdecision = (Boolean)this.getModel().getValue("isadjdecision");
        this.getView().setEnable(isAdjdecision, new String[]{"adjdecisionap"});
        this.setFieldMustInput(isAdjdecision, "bizdatadate");
        this.setMustInputByEnableConfirmField();
        this.getView().setVisible(isAdjdecision, new String[]{"adjdecisionap"});
        CountryHelper.afterBindDataForCountry((AbstractFormPlugin)this);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Boolean isAdjdecision = (Boolean)this.getModel().getValue("isadjdecision");
        String nodeId = isAdjdecision != false ? this.getPageCache().get(CACHE_SELECTED_NODE) : null;
        this.setNodeFocus(nodeId);
        this.cacheCaptionNameToHrPageCache();
        Boolean isEnableconfirm = (Boolean)this.getModel().getValue("enableconfirm");
        Object datasyncondition = this.getModel().getValue("datasyncondition");
        if (isEnableconfirm.booleanValue() && ObjectUtils.isNotEmpty((Object)datasyncondition) && "2".equals(datasyncondition)) {
            this.getView().setVisible(isEnableconfirm, new String[]{"transcondition"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"transcondition"});
        }
        this.getView().setVisible(isEnableconfirm, new String[]{"adjconfirmtpl", "datasyncondition", "passwordtype"});
    }

    private void cacheCaptionNameToHrPageCache() {
        HRPageCache pageCache = new HRPageCache(this.getPageCache());
        String name = this.getModel().getDataEntity().getString("name");
        if (!SWCStringUtils.isEmpty((String)name)) {
            String format = ResManager.loadKDString((String)"\u8c03\u85aa\u65b9\u6848-%s\u7248\u672c", (String)"AdjApprScmEdit_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            HashMap customParamMap = Maps.newHashMap();
            customParamMap.put("caption", String.format(Locale.ROOT, format, name));
            pageCache.put("customParamMap", (Object)customParamMap);
        }
    }

    private void setNodeFocus(String nodeId) {
        TreeView treeView = (TreeView)this.getView().getControl("decisiontreeap");
        TreeNode focusNode = new TreeNode("", nodeId, null);
        treeView.focusNode(focusNode);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId;
        switch (nodeId = (String)evt.getNodeId()) {
            case "100001": {
                this.clickNineGrid();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        IDataEntityProperty property = args.getProperty();
        String name = property.getName();
        Object newValue = args.getChangeSet()[0].getNewValue();
        switch (name) {
            case "isadjdecision": {
                Boolean isAdjdecision = (Boolean)newValue;
                this.setFieldMustInput(isAdjdecision, "bizdatadate");
                this.setEntryFieldMustInput(isAdjdecision, "adjdecisioncfg");
                if (!isAdjdecision.booleanValue()) {
                    this.getModel().setValue("bizdatadatebegin", null);
                    this.getModel().setValue("bizdatadateend", null);
                    this.getModel().deleteEntryData("ninegrid");
                }
                String nodeId = isAdjdecision != false ? this.getPageCache().get(CACHE_SELECTED_NODE) : null;
                this.setNodeFocus(nodeId);
                this.getView().setEnable(isAdjdecision, new String[]{"adjdecisionap"});
                this.getView().setVisible(isAdjdecision, new String[]{"adjdecisionap"});
                break;
            }
            case "adjdecisioncfg": {
                DynamicObject adjdecisioncfg = (DynamicObject)newValue;
                DynamicObject[] axisData = AxisDataConfigHelper.queryAxisDataByCfgId((Long)((Long)adjdecisioncfg.getPkValue()));
                Map axisCategoryMap = AxisDataConfigHelper.getAxisBizitemCategoryMap((DynamicObject[])axisData);
                this.getModel().setValue("xtypeid", axisCategoryMap.get(AxisTypeEnum.XAXIS.getCode()), args.getChangeSet()[0].getRowIndex());
                this.getModel().setValue("ytypeid", axisCategoryMap.get(AxisTypeEnum.YAXIS.getCode()), args.getChangeSet()[0].getRowIndex());
                this.getView().updateView("ninegrid");
                break;
            }
            case "enableconfirm": {
                this.setMustInputByEnableConfirmField();
                Boolean isEnableconfirm = (Boolean)this.getModel().getValue("enableconfirm");
                if (isEnableconfirm.booleanValue()) {
                    this.getView().setVisible(isEnableconfirm, new String[]{"adjconfirmtpl", "datasyncondition", "passwordtype"});
                    break;
                }
                this.getModel().setValue("adjconfirmtpl", null);
                this.getModel().setValue("datasyncondition", null);
                this.getModel().setValue("transcondition", null);
                this.getModel().setValue("passwordtype", null);
                this.getView().setVisible(isEnableconfirm, new String[]{"adjconfirmtpl", "datasyncondition", "transcondition", "passwordtype"});
                break;
            }
            case "datasyncondition": {
                String datasyncondition = (String)this.getModel().getValue("datasyncondition");
                if ("2".equals(datasyncondition)) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"transcondition"});
                    break;
                }
                this.getModel().setValue("transcondition", null);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"transcondition"});
                break;
            }
        }
        CountryPolicy countryPolicy = CountryPolicy.createInstance().putErrorInfoEnum("country", HCDMErrInfoEnum.COMMON_CLEAR_COUNTRY_CONFIRM).delAfterConfirm(true).build();
        CountryHelper.propertyChangedForCountry((AbstractFormPlugin)this, (PropertyChangedArgs)args, (CountryPolicy)countryPolicy);
    }

    private void setMustInputByEnableConfirmField() {
        boolean enableConfirm = this.getModel().getDataEntity().getBoolean("enableconfirm");
        FieldEdit adjConfirmtpl = (FieldEdit)this.getControl("adjconfirmtpl");
        FieldEdit datasyncondition = (FieldEdit)this.getControl("datasyncondition");
        FieldEdit transcondition = (FieldEdit)this.getControl("transcondition");
        FieldEdit passwordType = (FieldEdit)this.getControl("passwordtype");
        adjConfirmtpl.setMustInput(enableConfirm);
        datasyncondition.setMustInput(enableConfirm);
        transcondition.setMustInput(enableConfirm);
        passwordType.setMustInput(enableConfirm);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String property;
        switch (property = beforeF7SelectEvent.getProperty().getName()) {
            case "apprwf": {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("entrabill", "=", (Object)"hcdm_adjapprbill"));
                break;
            }
            case "adjdecisioncfg": {
                if (CountryHelper.checkInvalidAndSetFilter((AbstractFormPlugin)this, (IMetadata)beforeF7SelectEvent.getProperty(), null, (List)beforeF7SelectEvent.getCustomQFilters(), (boolean)true)) {
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObjectCollection ninegridCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("ninegrid");
                List adjdecisioncfgIds = ninegridCol.stream().map(object -> object.getLong("adjdecisioncfg.id")).collect(Collectors.toList());
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACKID_ADJDECISIONCFG));
                showParameter.setSelectedRows(adjdecisioncfgIds.toArray());
                break;
            }
            case "adjconfirmtpl": {
                CountryHelper.beforeF7SelectForCountry((AbstractFormPlugin)this, (BeforeF7SelectEvent)beforeF7SelectEvent, Collections.singletonList("adjconfirmtpl"));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "newentry": {
                ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hcdm_adjdecisioncfg", (boolean)true);
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                List qFilters = listFilterParameter.getQFilters();
                if (CountryHelper.checkInvalidAndSetFilter((AbstractFormPlugin)this, null, (String)"hcdm_adjdecisioncfg", (List)qFilters, (boolean)true)) {
                    args.setCancel(true);
                    return;
                }
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACKID_ADJDECISIONCFG));
                DynamicObjectCollection ninegridCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("ninegrid");
                List adjdecisioncfgIds = ninegridCol.stream().map(object -> object.getLong("adjdecisioncfg.id")).collect(Collectors.toList());
                showParameter.setSelectedRows(adjdecisioncfgIds.toArray());
                Long orgId = this.getModel().getDataEntity().getLong("createorg.id");
                QFilter orgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_adjdecisioncfg", (Long)orgId);
                if (orgFilter != null) {
                    qFilters.add(orgFilter);
                }
                qFilters.add(new QFilter("enable", "=", (Object)"1"));
                qFilters.add(new QFilter("status", "=", (Object)"C"));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "auditconfirmchange": {
                this.confirmChange(args, formOperate);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        switch (args.getOperateKey()) {
            case "save": {
                OperationResult operationResult = args.getOperationResult();
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable", "bar_enable"});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "callbackid_auditconfirmchange": {
                this.confirmIsChange(event);
                break;
            }
            case "callbackid_adjdecisioncfg": {
                Object returnData = event.getReturnData();
                List<Long> adjDecisionCfgIds = new ArrayList(10);
                if (returnData instanceof ListSelectedRowCollection) {
                    ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
                    for (ListSelectedRow selectedRow : listSelectedRows) {
                        adjDecisionCfgIds.add((Long)selectedRow.getPrimaryKeyValue());
                    }
                } else if (returnData instanceof List) {
                    adjDecisionCfgIds = (List)returnData;
                }
                if (adjDecisionCfgIds == null || adjDecisionCfgIds.size() == 0) {
                    return;
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                Map axisDataByCfgIds = AxisDataConfigHelper.queryAxisDataByCfgIds(adjDecisionCfgIds);
                TableValueSetter values = new TableValueSetter(new String[0]);
                values.addField("adjdecisioncfg", new Object[0]);
                values.addField("xtypeid", new Object[0]);
                values.addField("ytypeid", new Object[0]);
                for (Long adjDecisionCfgId : adjDecisionCfgIds) {
                    long xtypeid = 0L;
                    long ytypeid = 0L;
                    if (axisDataByCfgIds != null) {
                        Map axisData = (Map)axisDataByCfgIds.get(adjDecisionCfgId);
                        xtypeid = axisData != null ? ((DynamicObject)axisData.get(AxisTypeEnum.XAXIS.getCode())).getLong("bizitemcategory.id") : 0L;
                        ytypeid = axisData != null ? ((DynamicObject)axisData.get(AxisTypeEnum.YAXIS.getCode())).getLong("bizitemcategory.id") : 0L;
                    }
                    values.addRow(new Object[]{adjDecisionCfgId, xtypeid, ytypeid});
                }
                model.beginInit();
                model.deleteEntryData("ninegrid");
                model.batchCreateNewEntryRow("ninegrid", values);
                model.endInit();
                this.getView().updateView("ninegrid");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        CountryPolicy countryPolicy = CountryPolicy.createInstance().putErrorInfoEnum("country", HCDMErrInfoEnum.COMMON_CLEAR_COUNTRY_CONFIRM).putClearPolicy("adjdecisioncfg", CountryPolicy.ClearDataPolicyEnum.COMMON_DELETE_ENTITY_REFERENCE, false).putClearPolicy("adjconfirmtpl", CountryPolicy.ClearDataPolicyEnum.DELETE_DATA_ONLY, false).build();
        CountryHelper.confirmCallBackForCountry((AbstractFormPlugin)this, (MessageBoxClosedEvent)messageBoxClosedEvent, (CountryPolicy)countryPolicy);
    }

    private void confirmIsChange(ClosedCallBackEvent event) {
        Boolean isChange;
        Object returnData = event.getReturnData();
        if (returnData instanceof Boolean && (isChange = (Boolean)returnData).booleanValue()) {
            OperateOption op = OperateOption.create();
            op.setVariableValue("flagConfirmChange", Boolean.TRUE.toString());
            this.getView().invokeOperation(AUDITCONFIRM_CHANGE, op);
        }
    }

    private void confirmChange(BeforeDoOperationEventArgs args, FormOperate formOperate) {
        OperateOption option = formOperate.getOption();
        Long beforeAdjScmId = (Long)this.getView().getFormShowParameter().getCustomParam("pkId");
        DynamicObjectCollection adjBills = AdjApprscmHelper.queryOnWayAdjBillByAdjScmId((Long)beforeAdjScmId);
        if (null == adjBills || adjBills.isEmpty()) {
            option.setVariableValue("flagConfirmChange", Boolean.TRUE.toString());
            return;
        }
        RefObject refObject = new RefObject();
        boolean hasFlag = option.tryGetVariableValue("flagConfirmChange", refObject);
        if (!hasFlag) {
            args.setCancel(true);
            this.showConfirmForm(adjBills);
        }
    }

    private void showConfirmForm(DynamicObjectCollection adjBills) {
        ArrayList allWorningMsg = Lists.newArrayListWithExpectedSize((int)adjBills.size());
        String title = ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u88ab\u5b9a\u8c03\u85aa\u7533\u8bf7\u5355\u5f15\u7528\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdjApprScmEdit_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        String billNoMessage = ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7\uff1a{0}", (String)"AdjApprScmEdit_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        for (DynamicObject adjBill : adjBills) {
            String billno = adjBill.getString("billno");
            String format = MessageFormat.format(billNoMessage, billno);
            allWorningMsg.add(format);
        }
        FormShowParameter operationConfirmParameter = SWCShowFormServiceHelper.getOperationConfirmParameter((CloseCallBack)new CloseCallBack((IFormPlugin)this, CALLBACKID_AUDITCONFIRM_CHANGET), (String)ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4", (String)"AdjApprScmEdit_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), (String)title, (List)allWorningMsg);
        this.getView().showForm(operationConfirmParameter);
    }

    private void clickNineGrid() {
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab("tabninegrid");
    }

    private void setFieldMustInput(Boolean tag, String ... keys) {
        for (String key : keys) {
            FieldEdit fieldEdit = (FieldEdit)this.getControl(key);
            fieldEdit.setMustInput(tag.booleanValue());
        }
    }

    private void setEntryFieldMustInput(Boolean tag, String ... keys) {
        EntryGrid entry = (EntryGrid)this.getControl("ninegrid");
        for (String key : keys) {
            entry.setMustInput(key, tag.booleanValue());
        }
    }

    private Map<String, String> getTreeDataMap() {
        LinkedHashMap<String, String> treeDataMap = new LinkedHashMap<String, String>(16);
        treeDataMap.put("100001", ResManager.loadKDString((String)"\u4e5d\u5bab\u683c", (String)"AdjApprScmEdit_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
        return treeDataMap;
    }

    public StringJoiner getChangedInfoOfRefField(boolean isGeneral) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long countryId = dataEntity.getLong("country.id");
        Map errMsgMap = CountryHelper.getSortLinkedMap(Arrays.asList(HCDMErrInfoEnum.COMMON_ADJ_DC_CFG, HCDMErrInfoEnum.COMMON_ADJ_CFM_TMPL));
        if (dataEntity.getBoolean("isadjdecision")) {
            DynamicObjectCollection nineGridDyColl = dataEntity.getDynamicObjectCollection("ninegrid");
            for (DynamicObject nineGridDy : nineGridDyColl) {
                CountryHelper.setErrMsgMap((long)countryId, (Map)errMsgMap, (DynamicObject)nineGridDy.getDynamicObject("adjdecisioncfg"), (boolean)false, (HCDMErrInfoEnum)HCDMErrInfoEnum.COMMON_ADJ_DC_CFG);
            }
        }
        if (dataEntity.getBoolean("enableconfirm")) {
            CountryHelper.setErrMsgMap((long)countryId, (Map)errMsgMap, (DynamicObject)dataEntity.getDynamicObject("adjconfirmtpl"), (boolean)false, (HCDMErrInfoEnum)HCDMErrInfoEnum.COMMON_ADJ_CFM_TMPL);
        }
        return CountryHelper.getErrMsg((Map)errMsgMap);
    }
}

