/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjfile;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.salaryadjfile.AdjFileCertCommonHelper;
import kd.swc.hcdm.business.salaryadjfile.AdjFileFormHelper;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.common.enums.EventTypeEnum;
import kd.swc.hcdm.formplugin.adjfile.imports.AdjFileBaseImportStartPlugin;
import kd.swc.hcdm.formplugin.adjfile.imports.AdjFileBatchImportPlugin;
import kd.swc.hcdm.formplugin.downloadtemplate.AdjFileDownloadTemplatePlugin;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class AdjFileList
extends SWCDataBaseList {
    public static final String ADJFILEIDLIST_KEY = "adjFileIdList";
    private static Log logger = LogFactory.getLog(AdjFileList.class);
    private static final String ACTION_ID_BSLEDCONFIRM = "actionId_bsledconfirm";
    private static final String ACTION_ID_AGAIN_EFFECTCONFIRM = "actionId_againeffectconfirm";
    private static final String CLOSECALLBACKID_ADDNEW = "closecallbackid_addnew";
    private static final String CLOSECALLBACKID_VIEW = "closecallbackid_view";
    private static final String OPPARAM_AFTERCONFIRM = AdjFileList.class.getSimpleName() + "afterconfirm";
    private static final String OPPARAM_AGAIN_EFFECT_AFTERCONFIRM = AdjFileList.class.getSimpleName() + "again_effect_afterconfirm";
    private AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
    private static final List<String> hiddenCloumnList = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u4eba\u5458.\u5de5\u53f7", (String)"AdjFileList_6", (String)"swc-hcdm-formplugin", (Object[])new Object[0])});

    public void initialize() {
        super.initialize();
        this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)"hcdm_adjfileinfo");
        this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
        this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)"adminorg");
    }

    public void registerListener(EventObject args) {
        super.registerListener(args);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        args.getFormShowParameter().setCustomParam("listPermProKey", (Object)"assoadminorg");
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"deletehisbtn", "confirmchange", "listoperatecol"});
        this.hideCol(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (ObjectUtils.isEmpty(customParams.get("isHistoryPage"))) {
            args.getListColumns().removeIf(item -> StringUtils.isNotEmpty((CharSequence)item.getListFieldKey()) && "hisversion".equals(item.getListFieldKey()));
            if (!this.isHisListView()) {
                args.getListColumns().removeIf(item -> StringUtils.isNotEmpty((CharSequence)item.getListFieldKey()) && "bsed".equals(item.getListFieldKey()));
                args.getListColumns().removeIf(item -> StringUtils.isNotEmpty((CharSequence)item.getListFieldKey()) && "datastatus".equals(item.getListFieldKey()));
                args.getListColumns().removeIf(item -> StringUtils.isNotEmpty((CharSequence)item.getListFieldKey()) && "bsled".equals(item.getListFieldKey()));
            }
        } else {
            args.getListColumns().removeIf(item -> StringUtils.isNotEmpty((CharSequence)item.getListFieldKey()) && "firstbsed".equals(item.getListFieldKey()));
        }
        this.createBillListHisBtnBar();
    }

    public void setFilter(SetFilterEvent event) {
        String addPersonFlag;
        super.setFilter(event);
        List qFilters = event.getQFilters();
        if (qFilters == null) {
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (ObjectUtils.isEmpty(customParams.get("isHistoryPage"))) {
            Iterator it = event.getQFilters().iterator();
            boolean hasAdminorg = false;
            while (it.hasNext()) {
                QFilter filter = (QFilter)it.next();
                if (filter != null && "assoadminorg".equals(filter.getProperty())) {
                    if (hasAdminorg) {
                        it.remove();
                        continue;
                    }
                    hasAdminorg = true;
                }
                if (filter == null || !"datastatus".equals(filter.getProperty())) continue;
                it.remove();
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(addPersonFlag = (String)this.getView().getFormShowParameter().getCustomParam("addPersonFlag")))) {
            long startTime = System.currentTimeMillis();
            Set adminOrgSet = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"47150e89000000ac", (String)"adminorg");
            logger.info("AdjFileList getAdminOrgSetByPermItem takes total {}ms.", (Object)(System.currentTimeMillis() - startTime));
            logger.info("AdjFileList adminOrgSet = {}", (Object)adminOrgSet);
            if (adminOrgSet != null) {
                QFilter qFilter = new QFilter("adminorg", "in", (Object)adminOrgSet);
                qFilters.add(qFilter);
            }
        }
        logger.info("AdjFileList qFilters is: {}", (Object)qFilters);
        if (ObjectUtils.isNotEmpty(customParams.get("isHistoryPage"))) {
            qFilters.removeIf(item -> item.getProperty() != null && "iscurrentversion".equals(item.getProperty()));
            QFilter qFilterStatus = new QFilter("status", "in", (Object)Lists.newArrayList((Object[])new String[]{"A", "B", "C", "D", "E"}));
            QFilter qFilterCurrentVersion = new QFilter("iscurrentversion", "!=", (Object)"1");
            qFilters.add(qFilterStatus);
            qFilters.add(qFilterCurrentVersion);
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            event.setOrderBy("employee.empnumber asc,number desc,hisversion desc");
        }
        if (this.isHisListView()) {
            event.setOrderBy("bsed desc,modifytime desc");
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        block8: {
            List commonFilterColumnList;
            block7: {
                super.filterContainerInit(args);
                ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
                if (listShowParameter.isLookUp()) {
                    return;
                }
                commonFilterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                if (!ObjectUtils.isNotEmpty(customParams.get("isHistoryPage"))) break block7;
                if (commonFilterColumnList == null) break block8;
                Iterator iterator = commonFilterColumnList.iterator();
                while (iterator.hasNext()) {
                    FilterColumn filterColumn2 = (FilterColumn)iterator.next();
                    if (filterColumn2 != null && !"datastatus".equals(filterColumn2.getFieldName())) {
                        iterator.remove();
                    }
                    if (filterColumn2 == null || !"datastatus".equals(filterColumn2.getFieldName())) continue;
                    List comboItems = ((CommonFilterColumn)filterColumn2).getComboItems();
                    comboItems.removeIf(item -> item.getValue().equals("-3"));
                    ArrayList<ComboItem> newComboItems = new ArrayList<ComboItem>();
                    ArrayList dataStatusList = Lists.newArrayList((Object[])new String[]{"0", "1", "2", "-2", "-1"});
                    for (String dataStatus : dataStatusList) {
                        for (ComboItem comboItem : comboItems) {
                            if (!dataStatus.equals(comboItem.getValue())) continue;
                            newComboItems.add(comboItem);
                        }
                    }
                    ((CommonFilterColumn)filterColumn2).setComboItems(newComboItems);
                    filterColumn2.setDefaultValues(new Object[]{"0", "1", "2"});
                }
                break block8;
            }
            if (commonFilterColumnList != null) {
                commonFilterColumnList.removeIf(filterColumn -> filterColumn != null && "datastatus".equals(filterColumn.getFieldName()));
                for (FilterColumn filterColumn3 : commonFilterColumnList) {
                    if (!"stdscm.name".equals(filterColumn3.getFieldName())) continue;
                    List comboItems = ((CommonFilterColumn)filterColumn3).getComboItems();
                    logger.info("stdscm items is {}", (Object)JSON.toJSONString((Object)comboItems));
                }
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        List filters = args.getQFilters();
        switch (fieldName) {
            case "empgroup.name": {
                QFilter empGroupFilter = new QFilter("id", "in", (Object)SWCPermissionServiceHelper.getEmpgroupByAppNumber((String)"hcdm"));
                filters.add(empGroupFilter);
                break;
            }
            case "stdscm.name": {
                HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"28", (String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"47150e89000000ac");
                this.addBaseOrgFilter(filters, permOrgs, "hcdm_stdscm");
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"28", (String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"47150e89000000ac");
        switch (fieldName) {
            case "empgroup.name": {
                QFilter empGroupFilter = new QFilter("id", "in", (Object)SWCPermissionServiceHelper.getEmpgroupByAppNumber((String)"hcdm"));
                filters.add(empGroupFilter);
                break;
            }
            case "stdscm.name": {
                this.addBaseOrgFilter(filters, permOrgs, "hcdm_stdscm");
                break;
            }
            case "job.name": {
                this.addBaseOrgFilter(filters, permOrgs, "hbjm_jobhr");
                break;
            }
            case "salaystructure.name": {
                this.addBaseOrgFilter(filters, permOrgs, "hcdm_salaystructure");
                break;
            }
            case "empposorgrel.company.name": {
                QFilter adminorgQFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"adminorg", (String)"47150e89000000ac");
                if (adminorgQFilter == null) break;
                logger.info("open company permQFilter is {}", (Object)JSON.toJSONString((Object)adminorgQFilter));
                filters.add(adminorgQFilter);
                break;
            }
        }
    }

    private void addBaseOrgFilter(List<QFilter> filters, HasPermOrgResult permOrgs, String entityName) {
        List baseOrgFilters;
        if (null != permOrgs && !permOrgs.hasAllOrgPerm() && null != (baseOrgFilters = SalaryAdjFileServiceHelper.getBaseOrgFilters((HasPermOrgResult)permOrgs, (String)entityName))) {
            filters.addAll(baseOrgFilters);
        }
    }

    private void hideCol(BeforeCreateListColumnsArgs args) {
        List columnList = args.getListColumns();
        Iterator it = columnList.iterator();
        while (it.hasNext()) {
            IListColumn col = (IListColumn)it.next();
            String fieldKey = col.getListFieldKey();
            if (!this.isHisListView() || !"hisversion".equals(fieldKey)) continue;
            it.remove();
        }
    }

    private boolean isHisListView() {
        return BaseDataHisHelper.isHisList((IFormView)this.getView());
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnok": {
                ListSelectedRowCollection selectedRows;
                List fileIds;
                String message;
                IFormView parentView = this.getView().getParentView();
                if (parentView == null || !SWCStringUtils.equals((String)"hcdm_adjapprbill", (String)parentView.getEntityId()) || (message = AdjFileCertCommonHelper.verifyExistFile(fileIds = (selectedRows = this.getSelectedRows()).stream().map(o1 -> (Long)o1.getPrimaryKeyValue()).collect(Collectors.toList()))) == null) break;
                evt.setCancel(true);
                this.getView().showErrorNotification(message);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        boolean isHisList = this.isFromHisList();
        ArrayList<String> hisOpList = new ArrayList<String>(4);
        hisOpList.add("exportlistbyselectfields");
        hisOpList.add("exportdetails");
        hisOpList.add("refresh");
        hisOpList.add("close");
        if (isHisList && !hisOpList.contains(operateKey) && !operateKey.contains("ext")) {
            args.setCancel(true);
            return;
        }
        switch (operateKey) {
            case "donothing_new_parttime": 
            case "donothing_new_primary": {
                break;
            }
            case "unable": {
                this.beforeUnable(args);
                break;
            }
            case "donothing_effect": {
                this.beforeAgainEffect(args);
                break;
            }
            case "abandon": {
                this.setUniqueKey(formOperate);
                OperateOption option = formOperate.getOption();
                if (option.tryGetVariableValue("abandonEventId", new RefObject())) break;
                String abandonEventId = this.adjFileApplicationService.beginEvent(EventTypeEnum.ADJFILE_ABANDON.getCode());
                formOperate.getOption().setVariableValue("abandonEventId", abandonEventId);
                break;
            }
            case "audit": {
                this.setUniqueKey(formOperate);
                break;
            }
            case "donothing_bar_import": {
                this.openAdjFileImportStart(formOperate);
                break;
            }
            case "record_importdata_hr": 
            case "show_record_importdata_hr": {
                Long userId = RequestContext.get().getCurrUserId();
                boolean superUser = SWCPermissionServiceHelper.isSuperUser();
                boolean hasPermByPermItemNum = SWCPermissionServiceHelper.hasPermByPermItemNum((long)userId, (String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"HRQXX2610");
                if (superUser || hasPermByPermItemNum) break;
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u5b9a\u8c03\u85aa\u4fe1\u606f\u201d\u7684\u201c\u5bfc\u5165\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdjFileList_11", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        FormOperate formOperate = (FormOperate)args.getSource();
        BillList list = (BillList)this.getControl("billlistap");
        switch (operateKey) {
            case "donothing_new_parttime": {
                this.openAddNewPage(false);
                break;
            }
            case "donothing_new_primary": {
                this.openAddNewPage(true);
                break;
            }
            case "unable": {
                this.clearCache(args, list);
                String unableEventId = formOperate.getOption().getVariableValue("unableEventId", null);
                if (!StringUtils.isNotEmpty((CharSequence)unableEventId)) break;
                this.adjFileApplicationService.endEvent((Collection)Lists.newArrayList((Object[])new String[]{unableEventId}));
                break;
            }
            case "abandon": {
                String abandonEventId = formOperate.getOption().getVariableValue("abandonEventId", null);
                if (StringUtils.isNotEmpty((CharSequence)abandonEventId)) {
                    this.adjFileApplicationService.endEvent((Collection)Lists.newArrayList((Object[])new String[]{abandonEventId}));
                }
                this.clearCache(args, list);
                break;
            }
            case "audit": {
                this.clearCache(args, list);
                OperationResult operationResult = args.getOperationResult();
                String message = operationResult.getMessage();
                if (!SWCStringUtils.isNotEmpty((String)message) || !message.contains("adjfilecertwarn")) break;
                ValidateResultCollection validateResult = args.getOperationResult().getValidateResult();
                if (validateResult.isSuccess()) {
                    operationResult.setShowMessage(false);
                }
                String result = message.replace("adjfilecertwarn", "");
                this.getView().showSuccessNotification(result);
                break;
            }
            case "donothing_effect": {
                list.refresh();
                break;
            }
            case "donothing_revisionrecord": {
                this.openRevisionRecordPage();
                break;
            }
        }
    }

    private void openRevisionRecordPage() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hcdm_revisionrecord");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("bos_list");
        ListSelectedRowCollection rows = this.getSelectedRows();
        List selectIds = rows.stream().map(o -> (Long)o.getPrimaryKeyValue()).collect(Collectors.toList());
        showParameter.setCustomParam(ADJFILEIDLIST_KEY, selectIds);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void clearCache(AfterDoOperationEventArgs args, BillList list) {
        String uniqueKey;
        list.refresh();
        FormOperate formOperate = (FormOperate)args.getSource();
        Map variables = formOperate.getOption().getVariables();
        if (!CollectionUtils.isEmpty((Map)variables) && (uniqueKey = (String)variables.get("uniqueKey")) != null && uniqueKey.trim().length() != 0) {
            SWCAppCache.get((String)uniqueKey).clear();
            variables.remove("uniqueKey");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String colKey;
        switch (colKey = args.getFieldName()) {
            case "number": {
                this.clickNumber(args);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "closecallbackid_addnew": {
                Object fileId = event.getReturnData();
                if (!(fileId instanceof Long) || fileId.equals(0L)) break;
                this.getView().invokeOperation("refresh");
                this.openSalaryAdjFile((Long)fileId);
                break;
            }
            case "actionId_bsledconfirm": {
                this.confirmToInvokeOp(event, ACTION_ID_BSLEDCONFIRM);
                break;
            }
            case "actionId_againeffectconfirm": {
                this.confirmToInvokeOp(event, ACTION_ID_AGAIN_EFFECTCONFIRM);
                break;
            }
            case "closecallbackid_view": {
                break;
            }
        }
    }

    private void confirmToInvokeOp(ClosedCallBackEvent event, String confirmName) {
        Object returnData = event.getReturnData();
        if (returnData instanceof Date) {
            Date date = (Date)returnData;
            String dateStr = "";
            if (null != date) {
                dateStr = SWCDateTimeUtils.formatDate((Date)date);
            }
            OperateOption op = OperateOption.create();
            if (StringUtils.equals((CharSequence)confirmName, (CharSequence)ACTION_ID_BSLEDCONFIRM)) {
                op.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
                if (StringUtils.isNotBlank((CharSequence)dateStr)) {
                    op.setVariableValue("var_bsled", dateStr);
                }
                this.getView().invokeOperation("unable", op);
            } else if (StringUtils.equals((CharSequence)confirmName, (CharSequence)ACTION_ID_AGAIN_EFFECTCONFIRM)) {
                op.setVariableValue(OPPARAM_AGAIN_EFFECT_AFTERCONFIRM, "true");
                if (StringUtils.isNotBlank((CharSequence)dateStr)) {
                    op.setVariableValue("var_bsed", dateStr);
                }
                this.getView().invokeOperation("donothing_effect", op);
            }
        }
    }

    private void beforeUnable(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        RefObject confirm = new RefObject();
        OperateOption option = formOperate.getOption();
        if (!option.tryGetVariableValue(OPPARAM_AFTERCONFIRM, confirm)) {
            args.setCancel(true);
            String caption = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u7ef4\u62a4\u5f39\u6846", (String)"AdjFileList_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f", (String)"AdjFileList_5", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            String title = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u7ef4\u62a4", (String)"AdjFileList_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f", (String)"AdjFileList_5", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            String dateCaption = ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f", (String)"AdjFileList_5", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            String content = ResManager.loadKDString((String)"\u6863\u6848\u5230\u5931\u6548\u65e5\u671f\u540e\uff0c\u5c06\u81ea\u52a8\u5931\u6548\u4e14\u4e0d\u518d\u4f7f\u7528\u8be5\u6863\u6848\u7684\u6570\u636e\u3002", (String)"AdjFileList_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            String minDate = "";
            FormShowParameter bsledConfirmFormShowParameter = SWCShowFormServiceHelper.getDateConfirmFormShowParameter((String)caption, (String)content, (boolean)true, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ACTION_ID_BSLEDCONFIRM), (String)title, (String)dateCaption, (String)minDate);
            this.getView().showForm(bsledConfirmFormShowParameter);
        } else {
            this.setUniqueKey(formOperate);
            if (!option.tryGetVariableValue("unableEventId", confirm)) {
                String unableEventId = this.adjFileApplicationService.beginEvent(EventTypeEnum.ADJFILE_UNABLE.getCode());
                formOperate.getOption().setVariableValue("unableEventId", unableEventId);
            }
        }
    }

    private void beforeAgainEffect(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        RefObject confirm = new RefObject();
        OperateOption option = formOperate.getOption();
        if (!option.tryGetVariableValue(OPPARAM_AGAIN_EFFECT_AFTERCONFIRM, confirm)) {
            args.setCancel(true);
            String caption = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u7ef4\u62a4\u5f39\u6846", (String)"AdjFileList_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"AdjFileList_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            String title = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u7ef4\u62a4", (String)"AdjFileList_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"AdjFileList_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            String dateCaption = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"AdjFileList_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            String content = ResManager.loadKDString((String)"\u6863\u6848\u5230\u751f\u6548\u65e5\u671f\u540e\uff0c\u5c06\u81ea\u52a8\u751f\u6548\u4e14\u53ef\u4f7f\u7528\u8be5\u6863\u6848\u7684\u6570\u636e\u3002", (String)"AdjFileList_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            String minDate = "";
            FormShowParameter bsledConfirmFormShowParameter = SWCShowFormServiceHelper.getDateConfirmFormShowParameter((String)caption, (String)content, (boolean)true, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ACTION_ID_AGAIN_EFFECTCONFIRM), (String)title, (String)dateCaption, (String)minDate);
            this.getView().showForm(bsledConfirmFormShowParameter);
        }
    }

    private void clickNumber(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        Long pkId = (Long)list.getFocusRowPkId();
        this.openSalaryAdjFile(pkId);
    }

    private void openSalaryAdjFile(Long pkId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hcdm_adjsalaryfileview");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("key_custom_param_fileid", (Object)String.valueOf(pkId));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (ObjectUtils.isNotEmpty(customParams.get("isHistoryPage"))) {
            showParameter.setCustomParam("isHistoryPage", customParams.get("isHistoryPage"));
        }
        String adjFileStatu = SalaryAdjFileServiceHelper.getAdjFileStatuByFileId((String)String.valueOf(pkId));
        showParameter.setCustomParam("status", (Object)adjFileStatu);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACKID_VIEW));
        showParameter.setPageId(this.getView().getPageId() + pkId);
        String adjFileCaption = AdjFileFormHelper.getAdjFileCaption((Long)pkId);
        if (SWCStringUtils.isNotEmpty((String)adjFileCaption)) {
            showParameter.setCaption(adjFileCaption);
        }
        this.getView().showForm(showParameter);
    }

    private void openAddNewPage(boolean isPrimary) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("hcdm_adjfileinfo");
        StyleCss css = new StyleCss();
        css.setWidth("890px");
        css.setHeight("422px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("key_custom_param_isprimary", (Object)isPrimary);
        showParameter.setPermissionItemId("47156aff000000ac");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACKID_ADDNEW));
        showParameter.setCustomParam("customHREntityNumber", (Object)"hcdm_adjfileinfo");
        showParameter.setCustomParam("customHRPermItemId", (Object)"47156aff000000ac");
        showParameter.setCustomParam("customStatus", (Object)OperationStatus.ADDNEW.name());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openAdjFileImportStart(FormOperate formOperate) {
        Long userId = RequestContext.get().getCurrUserId();
        boolean superUser = SWCPermissionServiceHelper.isSuperUser();
        boolean hasPermByPermItemNum = SWCPermissionServiceHelper.hasPermByPermItemNum((long)userId, (String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"QXX0020");
        if (superUser || hasPermByPermItemNum) {
            IFormView view = this.getView();
            FormShowParameter showParam = view.getFormShowParameter();
            HashMap<String, Object> params = new HashMap<String, Object>(6);
            params.put("ServiceAppId", showParam.getServiceAppId());
            params.put("CheckRightAppId", "hcdm");
            params.put("BillFormId", ((ListShowParameter)showParam).getBillFormId());
            params.put("ListName", showParam.getCaption());
            params.put("OperateKey", "donothing_bar_import");
            params.put("BillTypeId", ((ListShowParameter)showParam).getBillTypeId());
            params.put("ImportPlugin", AdjFileBatchImportPlugin.class.getName());
            params.put("CustPlugin", AdjFileDownloadTemplatePlugin.class.getName());
            params.put("PermissionItemId", formOperate.getPermissionItemId());
            String realPermissionEntityId = StringUtils.isNotBlank((CharSequence)formOperate.getPermissionEntityId()) ? formOperate.getPermissionEntityId() : formOperate.getEntityId();
            params.put("RealPermissionEntityId", realPermissionEntityId);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hcdm_adjfileimptstart");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParams(params);
            showParameter.setParentPageId(view.getFormShowParameter().getPageId());
            showParameter.addCustPlugin(AdjFileBaseImportStartPlugin.class.getName());
            this.getView().showForm(showParameter);
        }
    }

    private void setUniqueKey(FormOperate formOperate) {
        OperateOption operateOption = formOperate.getOption();
        String uniqueKey = this.getView().getPageId() + UUID.randomUUID().toString();
        operateOption.setVariableValue("uniqueKey", uniqueKey);
        Map variables = operateOption.getVariables();
        variables = variables == null ? new HashMap(0) : variables;
        logger.info("AdjFileList.setUniqueKey: the variables is {}", (Object)variables.toString());
        logger.info("AdjFileList.setUniqueKey: the blsed value is {}, and the uniqueKey is {}", variables.get("var_bsled"), variables.get("uniqueKey"));
    }

    public void afterExportFile(ExportFileEvent event) {
        File file = event.getFile();
        if (file != null) {
            try (FileInputStream fis = new FileInputStream(file);){
                XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);
                Sheet sheet = wb.getSheetAt(0);
                Row titleRow = sheet.getRow(0);
                int cellNum = titleRow.getLastCellNum();
                ArrayList<Integer> hiddenColumnList = new ArrayList<Integer>();
                for (int i = 0; i < cellNum; ++i) {
                    Cell cell = titleRow.getCell(i, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
                    String titleValue = cell.getStringCellValue();
                    Boolean isMatch = hiddenCloumnList.stream().allMatch(obj -> obj.equals(titleValue));
                    if (!isMatch.booleanValue()) continue;
                    hiddenColumnList.add(i);
                }
                for (Integer hiddenColumn : hiddenColumnList) {
                    sheet.setColumnHidden(hiddenColumn.intValue(), true);
                }
                FileOutputStream out = new FileOutputStream(file);
                wb.write((OutputStream)out);
                wb.close();
                out.close();
            }
            catch (Throwable ex) {
                logger.error(ex);
            }
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (ObjectUtils.isNotEmpty(customParams.get("isHistoryPage"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"schemefilterview"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew", "tblsubmit", "tblaudit", "bar_import", "tbldel", "baritemap2", "tblrefresh", "tblclose", "revisionrecord", "recordimport"});
        }
    }

    private boolean isFromHisList() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return ObjectUtils.isNotEmpty(customParams.get("isHistoryPage"));
    }

    private void createBillListHisBtnBar() {
        IFormView view = this.getView();
        boolean isHisList = this.isFromHisList();
        if (isHisList) {
            Container toolBar = (Container)view.getControl("toolbarap");
            if (toolBar == null) {
                return;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblrefreshhis", "tblclosehis"});
            toolBar.deleteControls(new String[]{"tblsubmit", "tblaudit", "tblrefreshhis", "tblclosehis", "export", "exportdetails", "baritemap_refresh", "tblclosehisnew"});
            ArrayList items = Lists.newArrayListWithExpectedSize((int)16);
            this.genExportBtn(items);
            this.genRefreshBtn(items);
            this.genCloseBtn(items);
            toolBar.addControls((List)items);
        }
    }

    private void genExportBtn(List<Map<String, Object>> items) {
        BarItemAp confirmChangeBtn = new BarItemAp();
        confirmChangeBtn.setKey("export");
        confirmChangeBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e", (String)"AdjFileList_12", (String)"swc-hcdm-formplugin", (Object[])new Object[0])));
        confirmChangeBtn.setOperationKey("exportlistbyselectfields");
        items.add(confirmChangeBtn.createControl());
        BarItemAp exportdetailsBtn = new BarItemAp();
        exportdetailsBtn.setKey("exportdetails");
        exportdetailsBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c", (String)"AdjFileList_13", (String)"swc-hcdm-formplugin", (Object[])new Object[0])));
        exportdetailsBtn.setOperationKey("exportdetails");
        items.add(exportdetailsBtn.createControl());
    }

    private void genRefreshBtn(List<Map<String, Object>> items) {
        BarItemAp insertDataBtn = new BarItemAp();
        insertDataBtn.setKey("baritemap_refresh");
        insertDataBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u5237\u65b0", (String)"AdjFileList_9", (String)"swc-hcdm-formplugin", (Object[])new Object[0])));
        insertDataBtn.setOperationKey("refresh");
        items.add(insertDataBtn.createControl());
    }

    private void genCloseBtn(List<Map<String, Object>> items) {
        BarItemAp closeBtn = new BarItemAp();
        closeBtn.setKey("tblclosehisnew");
        closeBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u9000\u51fa", (String)"AdjFileList_10", (String)"swc-hcdm-formplugin", (Object[])new Object[0])));
        closeBtn.setOperationKey("close");
        items.add(closeBtn.createControl());
    }
}

