/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.IBaseDataService;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.salaryadjfile.AdjFileCacheHelper;
import kd.swc.hcdm.business.salaryadjfile.SalaryAdjFileHelper;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.common.enums.AdjFileDataSourceEnum;
import kd.swc.hcdm.common.enums.AdjFileTypeEnum;
import kd.swc.hcdm.formplugin.adjfile.AbstractSalaryAdjFileBaseEdit;
import kd.swc.hsbp.business.datachanged.BizChangedHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCMServiceUtils;

public class SalaryAdjFileBaseInfoEdit
extends AbstractSalaryAdjFileBaseEdit
implements BeforeF7SelectListener,
Consumer<BeforeF7ViewDetailEvent> {
    private static final String EMPGROUP = "empgroup";
    private static final String ADMINORG = "assoadminorg";
    private static final String POSITION_PERSON = "personfield";
    private static final String SAVE_AFTERAUDIT = "saveafteraudit";
    private AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
    private static final String IS_CONTINUE_CLOSE = "is_continue_close";
    private static final String CALLBACKID_CONTINUE_UPDATEPERSON = "callbackid_continue_updateperson";
    private static Log logger = LogFactory.getLog(SalaryAdjFileBaseInfoEdit.class);
    private static final String IS_SET_OLD_VALUE = "isSetToOldValue";
    private static final String KEY_ADVYOOLBAR = "advtoolbar";

    public void registerListener(EventObject ex) {
        super.registerListener(ex);
        this.addClickListeners(new String[]{KEY_ADVYOOLBAR});
        ArrayList basedataEditList = Lists.newArrayList((Object[])new String[]{EMPGROUP, "salaystructure", "stdscm", "depempmodify", "position", "country"});
        this.registerBeforeF7ForBasedataEdit(basedataEditList);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        IDataEntityProperty property = event.getProperty();
        List qFilters = event.getCustomQFilters();
        switch (property.getName()) {
            case "empgroup": {
                List empgoupIds = (List)SWCMServiceUtils.invokeHRMPService((String)"hbss", (String)"IHBSSService", (String)"getEmpgroupByAppNumber", (Object[])new Object[]{"hcdm"});
                QFilter qFilter = new QFilter("id", "in", (Object)empgoupIds);
                if (qFilters == null) break;
                qFilters.add(qFilter);
                break;
            }
            case "salaystructure": {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                long countryId = dataEntity.getLong("country.id");
                if (countryId == 0L) {
                    event.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u3002", (String)"SalaryAdjFileAddNewPlugin_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                QFilter filter = new QFilter("country.id", "=", (Object)countryId);
                if (qFilters == null) break;
                qFilters.add(filter);
                break;
            }
            case "depempmodify": {
                QFilter qFilter1 = this.getPrimaryQFilter();
                Set assoadminorgSet = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"47156aff000000ac", (String)ADMINORG);
                if (null != assoadminorgSet) {
                    qFilter1.and(new QFilter("hrpi_empposorgrel.adminorg.id", "in", (Object)assoadminorgSet));
                }
                event.addCustomQFilter(qFilter1);
                break;
            }
            case "position": {
                Long employeeId = this.getModel().getDataEntity().getLong("employee.id");
                QFilter qFilter2 = new QFilter("employee.id", "=", (Object)employeeId);
                if (OperationStatus.ADDNEW.equals((Object)this.getOperationStatus())) {
                    qFilter2.and(this.getPrimaryQFilter());
                } else {
                    String isPrimary = this.getModel().getDataEntity().getBoolean("isprimary") ? "1" : "0";
                    qFilter2.and(new QFilter("hrpi_empposorgrel.isprimary", "=", (Object)isPrimary));
                }
                this.openDepartmentPerson(event, qFilter2, POSITION_PERSON);
                break;
            }
            case "stdscm": {
                this.addStdScmPermFilter(event);
                break;
            }
            case "country": {
                this.addCountryPermFilter(event);
                break;
            }
        }
    }

    private OperationStatus getOperationStatus() {
        return this.getView().getFormShowParameter().getStatus();
    }

    private QFilter getPrimaryQFilter() {
        return new QFilter("hrpi_empposorgrel.isprimary", "=", (Object)this.getIsPrimary());
    }

    private String getIsPrimary() {
        return this.isPrimary() ? "1" : "0";
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "formsave": 
            case "save": 
            case "saveafteraudit": {
                this.setOrRemoveAdjFileCache(Boolean.FALSE);
                break;
            }
            case "edit": {
                this.setOrRemoveAdjFileCache(Boolean.TRUE);
                break;
            }
            case "donothing_cancel": {
                this.setOrRemoveAdjFileCache(Boolean.FALSE);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        switch (operateKey) {
            case "edit": {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bsled"});
                break;
            }
            case "save": {
                if (null == operationResult || !operationResult.isSuccess()) break;
                String customStatus = (String)this.getView().getFormShowParameter().getCustomParam("customStatus");
                if ("ADDNEW".equals(customStatus)) {
                    this.getView().returnDataToParent((Object)this.getModel().getDataEntity().getLong("id"));
                    this.getView().getPageCache().put(IS_CONTINUE_CLOSE, "true");
                    this.getView().close();
                    break;
                }
                this.refreshSummaryPage();
                break;
            }
            case "saveafteraudit": {
                if (null == operationResult || !operationResult.isSuccess()) break;
                String currentPkId = source.getOption().getVariableValue("currentPkId", null);
                this.refreshCurrentPage(currentPkId);
                this.refreshSummaryPage();
                break;
            }
        }
    }

    private void refreshSummaryPage() {
        IFormView summaryView = this.getView().getParentView().getView(AdjFileCacheHelper.getSummaryPageCache());
        if (summaryView != null) {
            summaryView.invokeOperation("refresh");
            this.getView().sendFormAction(summaryView);
        }
    }

    private void refreshCurrentPage(Object newPkId) {
        if (newPkId == null) {
            return;
        }
        BaseView view = (BaseView)this.getView();
        BaseShowParameter showParameter = (BaseShowParameter)view.getFormShowParameter();
        showParameter.setPkId(newPkId);
        view.cacheFormShowParameter();
        view.load(newPkId);
    }

    private void setOrRemoveAdjFileCache(Boolean cacheFlag) {
        SWCPageCache pageCache = new SWCPageCache(this.getView().getParentView());
        if (cacheFlag.booleanValue()) {
            pageCache.put("hcdm_adjfileinfo", (Object)Boolean.TRUE);
        } else {
            pageCache.remove("hcdm_adjfileinfo");
        }
    }

    private void updatePersonInfo(Long depempId, Long personId, Long employeeId) {
        if (depempId == 0L) {
            this.clearPersonRelValue();
            return;
        }
        this.getModel().setValue("datasource", (Object)AdjFileDataSourceEnum.MANUAL.getCode());
        this.getModel().setValue("person", (Object)personId);
        this.getModel().setValue("employee", (Object)employeeId);
        this.getView().setEnable(Boolean.TRUE, new String[]{"position"});
        DynamicObject[] empPosOrgRels = SalaryAdjFileServiceHelper.queryJobByPersonalEmpposorgrel((Collection)Sets.newHashSet((Object[])new Long[]{depempId}), (boolean)true);
        if (empPosOrgRels.length > 0) {
            DynamicObject empPosOrgRel = empPosOrgRels[0];
            DynamicObject job = empPosOrgRel.getDynamicObject("job");
            DynamicObject adminorgDy = empPosOrgRel.getDynamicObject("adminorg");
            boolean isPrimary = empPosOrgRel.getBoolean("isprimary");
            this.getModel().setValue("job", (Object)job);
            this.getModel().setValue("empposorgrel", (Object)empPosOrgRel);
            this.getModel().setValue("biznumber", (Object)empPosOrgRel.getString("number"));
            this.getModel().setValue("position", (Object)empPosOrgRel.getDynamicObject("position"));
            this.getModel().setValue("depemp", (Object)depempId);
            this.getModel().setValue("adminorg", (Object)adminorgDy);
            this.getModel().setValue("bsed", (Object)empPosOrgRel.getDate("startdate"));
            this.getModel().setValue(ADMINORG, (Object)adminorgDy);
            this.getModel().setValue("isprimary", (Object)isPrimary);
            int adjType = AdjFileTypeEnum.getTypeByIsPrimary((boolean)isPrimary);
            this.getModel().setValue("type", (Object)adjType);
        } else {
            this.clearPersonRelValue();
        }
        this.getView().updateView("position");
        this.getView().updateView("adminorg");
        this.getView().updateView("bsed");
        this.getView().updateView(ADMINORG);
    }

    private void clearPersonRelValue() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"position"});
        this.getModel().setValue("job", null);
        this.getModel().setValue("empposorgrel", null);
        this.getModel().setValue("biznumber", null);
        this.getModel().setValue("position", null);
        this.getModel().setValue("depemp", null);
        this.getModel().setValue("adminorg", null);
        this.getModel().setValue("bsed", null);
        this.getModel().setValue(ADMINORG, null);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        super.propertyChanged(args);
        IDataEntityProperty property = args.getProperty();
        ChangeData changeData = args.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        IDataModel dataModel = this.getModel();
        switch (name = property.getName()) {
            case "assoadminorg": {
                this.changeEscrowStaff();
                break;
            }
            case "escrowstaff": {
                this.setAdminOrg();
                break;
            }
            case "salaystructure": {
                this.doSalaryStructure();
                break;
            }
            case "depempmodify": {
                if (oldValue == null) {
                    if (newValue instanceof DynamicObject) {
                        dataModel.beginInit();
                        this.getView().setEnable(Boolean.TRUE, new String[]{"position"});
                        Long depempId = ((DynamicObject)newValue).getLong("id");
                        Long newPersonId = ((DynamicObject)newValue).getLong("person.id");
                        Long newEmployeeId = ((DynamicObject)newValue).getLong("employee.id");
                        this.updatePersonInfo(depempId, newPersonId, newEmployeeId);
                        dataModel.endInit();
                    }
                    this.changeEscrowStaff();
                    break;
                }
                Long oldDepempId = this.getModel().getDataEntity().getLong("depemp.id");
                if (null != newValue && oldDepempId.equals(((DynamicObject)newValue).getLong("id"))) break;
                Long newDepempId = null == newValue ? 0L : ((DynamicObject)newValue).getLong("id");
                Long newPersonId = null == newValue ? 0L : ((DynamicObject)newValue).getLong("person.id");
                Long newEmployeeId = null == newValue ? 0L : ((DynamicObject)newValue).getLong("employee.id");
                this.showConfirm(oldDepempId, newDepempId, newPersonId, newEmployeeId);
                break;
            }
            case "personfield": {
                if (!(newValue instanceof DynamicObject)) break;
                DynamicObject newDepempDy = (DynamicObject)newValue;
                Long newDepempId = newDepempDy.getLong("id");
                Long newPersonId = ((DynamicObject)newValue).getLong("person.id");
                Long newEmployeeId = ((DynamicObject)newValue).getLong("employee.id");
                Long oldDepempId = this.getModel().getDataEntity().getLong("depemp.id");
                if (newDepempId.equals(oldDepempId)) break;
                this.showConfirm(oldDepempId, newDepempId, newPersonId, newEmployeeId);
                break;
            }
            case "country": {
                this.getModel().setValue("salaystructure", null);
                break;
            }
        }
    }

    private void showConfirm(Long oldDepempId, Long newDepempId, Long newPersonId, Long newEmployeeId) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("newPersonId", (Object)newPersonId);
        pageCache.put("newEmployeeId", (Object)newEmployeeId);
        pageCache.put("depempChangeId", (Object)newDepempId);
        pageCache.put("depempOldId", (Object)oldDepempId);
        String message = ResManager.loadKDString((String)"\u66f4\u6539\u4eba\u5458\uff0c\u4f1a\u5bf9\u5e94\u8c03\u6574\u4eba\u5458\u7684\u201c\u5c97\u4f4d\u201d\u3001\u201c\u884c\u653f\u7ec4\u7ec7\u201d\u3001\u201c\u6302\u9760\u884c\u653f\u7ec4\u7ec7\u201d\u548c\u201c\u751f\u6548\u65e5\u671f\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SalaryAdjFileAddNewPlugin_6", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACKID_CONTINUE_UPDATEPERSON, (IFormPlugin)this));
    }

    private void doSalaryStructure() {
        if (OperationStatus.ADDNEW.equals((Object)this.getOperationStatus())) {
            Long stdscmId = SalaryAdjFileHelper.changeSalaryStructure((long)this.getModel().getDataEntity().getLong("salaystructure.id"));
            this.getModel().setValue("stdscm", (Object)stdscmId);
        } else {
            this.changeSalaystructurer();
        }
    }

    private void changeEscrowStaff() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String belongAdminOrgNumber = dataEntity.getString("depemp.adminorg.number");
        Object adminOrgObj = this.getModel().getValue(ADMINORG);
        if (adminOrgObj != null && belongAdminOrgNumber != null) {
            DynamicObject adminOrg = (DynamicObject)adminOrgObj;
            String adminOrgNumber = adminOrg.getString("number");
            if (belongAdminOrgNumber.equals(adminOrgNumber)) {
                this.getModel().setValue("escrowstaff", (Object)Boolean.FALSE);
            } else {
                SWCPageCache pageCache = new SWCPageCache(this.getView());
                pageCache.put("selectAdminorgChangeEscrow", (Object)Boolean.TRUE);
                this.getModel().setValue("escrowstaff", (Object)Boolean.TRUE);
            }
        }
    }

    private void setAdminOrg() {
        Boolean escrowStaff = (Boolean)this.getModel().getValue("escrowstaff");
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        if (!escrowStaff.booleanValue()) {
            Long belongAdminOrg = this.getModel().getDataEntity().getLong("depemp.adminorg.id");
            this.getModel().setValue(ADMINORG, (Object)belongAdminOrg);
        } else {
            Boolean selectAdminorgChangeEscrow = (Boolean)pageCache.get("selectAdminorgChangeEscrow", Boolean.class);
            if (selectAdminorgChangeEscrow == null || selectAdminorgChangeEscrow != null && !selectAdminorgChangeEscrow.booleanValue()) {
                this.getModel().setValue(ADMINORG, null);
            }
            pageCache.remove("selectAdminorgChangeEscrow");
        }
    }

    private void changeSalaystructurer() {
        long stdscmId = this.getModel().getDataEntity().getLong("stdscm.id");
        if (0L == stdscmId) {
            return;
        }
        long salaryStructureId = this.getModel().getDataEntity().getLong("salaystructure.id");
        if (salaryStructureId == 0L) {
            return;
        }
        Map stdscmsMap = SalaryAdjFileHelper.getStdscmIdsBySalaryStructureIds((Set)Sets.newHashSet((Object[])new Long[]{salaryStructureId}));
        String msg = ResManager.loadKDString((String)"\u4fee\u6539\u540e\u7684\u85aa\u916c\u7ed3\u6784\u201c{0}\u201d\u6240\u5173\u8054\u7684\u85aa\u916c\u4f53\u7cfb\u5df2\u53d8\u66f4\uff0c\u9700\u521b\u5efa\u65b0\u7684\u6863\u6848\u3002\u4e0d\u53ef\u4fee\u6539\u539f\u6863\u6848\u3002", (String)"SalaryAdjFileBaseInfoEdit_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty((Map)stdscmsMap)) {
            String errorMsg = MessageFormat.format(msg, this.getModel().getDataEntity().getString("salaystructure.name"));
            this.getModel().beginInit();
            this.getModel().setValue("salaystructure", null);
            this.getModel().endInit();
            this.getView().updateView("salaystructure");
            this.getView().showErrorNotification(errorMsg);
        } else {
            Set stdscmIds = (Set)stdscmsMap.get(salaryStructureId);
            if (CollectionUtils.isEmpty((Collection)stdscmIds) || !stdscmIds.contains(stdscmId)) {
                String errorMsg = MessageFormat.format(msg, this.getModel().getDataEntity().getString("salaystructure.name"));
                this.getModel().beginInit();
                this.getModel().setValue("salaystructure", null);
                this.getModel().endInit();
                this.getView().showErrorNotification(errorMsg);
            }
        }
    }

    @Override
    public void accept(BeforeF7ViewDetailEvent beforeF7ViewDetailEvent) {
        BasedataEdit base = (BasedataEdit)beforeF7ViewDetailEvent.getSource();
        String key = base.getFieldKey();
        if ("stdscm".equals(key)) {
            beforeF7ViewDetailEvent.setCancel(true);
            DynamicObject adjfileDy = this.getModel().getDataEntity(true);
            Long stdScmId = adjfileDy.getLong("stdscm.id");
            Long adjfileId = adjfileDy.getLong("id");
            BasedataProp property = (BasedataProp)this.getModel().getProperty("stdscm");
            String baseEntityId = property.getBaseEntityId();
            BaseShowParameter parameter = new BaseShowParameter();
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)baseEntityId);
            LocaleString caption = formConfig.getCaption();
            parameter.setCaption(caption.toString());
            parameter.setParentFormId(this.getView().getFormShowParameter().getParentFormId());
            ((BillShowParameter)parameter).setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(formConfig.getViewShowType());
            if (formConfig.getViewShowType() != ShowType.Modal) {
                parameter.getOpenStyle().setTargetKey("tabap");
            }
            if (0L != adjfileId) {
                Set salaryStdVid = this.adjFileApplicationService.getSalaryStdVidByFileId(adjfileId);
                Map stdBOIdMap = BaseDataHisHelper.getCurrentOfVersion((String)"hcdm_salarystandard", (Collection)salaryStdVid);
                parameter.setCustomParam("stdTableId", stdBOIdMap.values());
            } else {
                parameter.setCustomParam("stdTableId", null);
            }
            parameter.setCustomParam("sourceSign", (Object)(this.getView().getFormShowParameter().getParentFormId() + "_stdscmhis"));
            parameter.setFormId(baseEntityId);
            ((BillShowParameter)parameter).setPkId((Object)stdScmId);
            ((BillShowParameter)parameter).setBillStatus(BillOperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void beforeBindData(EventObject eventObject) {
        this.opButtonControl();
        this.checkEmpposgrelAbandoned();
    }

    private void checkEmpposgrelAbandoned() {
        OperationStatus status = this.getOperationStatus();
        if (OperationStatus.VIEW.equals((Object)status)) {
            Long empposgrelId = this.getModel().getDataEntity().getLong("empposorgrel.id");
            Set abandonEmpposgrelIds = SalaryAdjFileServiceHelper.getAbandonIds((String)"hrpi_empposorgrel", (Collection)Sets.newHashSet((Object[])new Long[]{empposgrelId}));
            if (abandonEmpposgrelIds.contains(empposgrelId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6863\u6848\u5173\u8054\u5c97\u4f4d\u7684\u4efb\u804c\u5df2\u5e9f\u5f03\uff0c\u8bf7\u53ca\u65f6\u4fee\u6539\u3002", (String)"SalaryAdjFileBaseInfoEdit_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        List<String> allNeedShowFieldBorderList = Arrays.asList("employee", "empposorgrel", "job", "depemp", "biznumber", "person");
        BizChangedHelper.operateBizChangedSet((DynamicObject)this.getModel().getDataEntity(true), allNeedShowFieldBorderList, (BizChangedHelper.OperateEnum)BizChangedHelper.OperateEnum.DELETE);
        IFormView view = this.getView();
        SWCPageCache pageCache = new SWCPageCache(view);
        Boolean isContinueClose = (Boolean)pageCache.get(IS_CONTINUE_CLOSE, Boolean.class);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        switch (messageBoxClosedEvent.getCallBackId()) {
            case "callbackid_continue_updateperson": {
                SWCPageCache pageCache = new SWCPageCache(this.getView());
                if (messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel) {
                    this.getModel().beginInit();
                    this.getModel().setValue("depempmodify", pageCache.get("depempOldId", Long.class));
                    this.getModel().setValue(POSITION_PERSON, pageCache.get("depempOldId", Long.class));
                    this.getModel().endInit();
                    this.getView().updateView("depempmodify");
                    this.getView().updateView(POSITION_PERSON);
                    break;
                }
                Long newPersonId = Long.parseLong(this.getView().getPageCache().get("newPersonId"));
                Long newEmployeeId = Long.parseLong(this.getView().getPageCache().get("newEmployeeId"));
                Long depempId = Long.parseLong(this.getView().getPageCache().get("depempChangeId"));
                this.updatePersonInfo(depempId, newPersonId, newEmployeeId);
                this.changeEscrowStaff();
                break;
            }
        }
    }

    private void opButtonControl() {
        OperationStatus status = this.getOperationStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ADVYOOLBAR});
            this.initPage();
            HashMap<String, Object> advConApCtrl = new HashMap<String, Object>(16);
            advConApCtrl.put("text", "");
            advConApCtrl.put("collapsible", Boolean.FALSE);
            HashMap<String, String> margin = new HashMap<String, String>(16);
            margin.put("t", "-30px");
            HashMap<String, HashMap<String, String>> styleMargin = new HashMap<String, HashMap<String, String>>(16);
            styleMargin.put("m", margin);
            advConApCtrl.put("s", styleMargin);
            this.getView().updateControlMetadata("advconap", advConApCtrl);
            HashMap fieldPanelApCtrl = new HashMap(16);
            HashMap<String, String> padding = new HashMap<String, String>(16);
            padding.put("l", "50px");
            HashMap<String, HashMap<String, String>> style = new HashMap<String, HashMap<String, String>>(16);
            style.put("p", padding);
            fieldPanelApCtrl.put("s", style);
            this.getView().updateControlMetadata("fs_baseinfo", fieldPanelApCtrl);
            this.getModel().setDataChanged(false);
            BasedataEdit depempmodify = (BasedataEdit)this.getControl("depempmodify");
            depempmodify.setMustInput(true);
        }
    }

    private void initPage() {
        boolean isPrimary = this.isPrimary();
        this.setFieldsByIsPrimary(isPrimary);
        this.getView().setEnable(Boolean.FALSE, new String[]{"position"});
    }

    private boolean isPrimary() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Boolean isPrimary = (Boolean)formShowParameter.getCustomParam("key_custom_param_isprimary");
        if (isPrimary == null) {
            return false;
        }
        return isPrimary;
    }

    private void setFieldsByIsPrimary(boolean isPrimary) {
        int adjType = AdjFileTypeEnum.getTypeByIsPrimary((boolean)isPrimary);
        this.getModel().setValue("isprimary", (Object)isPrimary);
        this.getModel().setValue("type", (Object)adjType);
    }

    private void openDepartmentPerson(BeforeF7SelectEvent event, QFilter qFilter, String controlKey) {
        event.setCancel(true);
        BasedataEdit depemp = (BasedataEdit)this.getControl(controlKey);
        Set assoadminorgSet = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"47156aff000000ac", (String)ADMINORG);
        if (null != assoadminorgSet) {
            qFilter.and(new QFilter("hrpi_empposorgrel.adminorg.id", "in", (Object)assoadminorgSet));
        }
        depemp.setQFilter(qFilter);
        depemp.click();
    }

    private void addStdScmPermFilter(BeforeF7SelectEvent event) {
        long salaryStructureId;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long orgId = dataEntity.getLong("org.id");
        if (orgId != 0L) {
            IBaseDataService baseDataService = (IBaseDataService)this.getModel().getService(IBaseDataService.class);
            QFilter qFilter = baseDataService.getBaseDataFilter("hcdm_stdscm", Long.valueOf(orgId));
            event.getCustomQFilters().add(qFilter);
        }
        if (0L != (salaryStructureId = dataEntity.getLong("salaystructure.id"))) {
            Map stdscmsMap = SalaryAdjFileHelper.getStdscmIdsBySalaryStructureIds((Set)Sets.newHashSet((Object[])new Long[]{salaryStructureId}));
            if (CollectionUtils.isEmpty((Map)stdscmsMap)) {
                QFilter stdScmQFilter = new QFilter("id", "in", null);
                event.getCustomQFilters().add(stdScmQFilter);
            } else {
                QFilter stdScmQFilter = new QFilter("id", "in", stdscmsMap.get(salaryStructureId));
                event.getCustomQFilters().add(stdScmQFilter);
            }
        } else {
            Set stdScmSetByPermItem = SWCPermissionServiceHelper.getStdScmSetByPermItem((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"47150e89000000ac");
            if (stdScmSetByPermItem != null) {
                logger.info("add adjfile stdScmSetByPermItem = {}", (Object)stdScmSetByPermItem);
                QFilter stdScmQFilter = new QFilter("id", "in", (Object)stdScmSetByPermItem);
                event.getCustomQFilters().add(stdScmQFilter);
            }
        }
    }

    private void addCountryPermFilter(BeforeF7SelectEvent event) {
        Set countrySetByPermItem = SWCPermissionServiceHelper.getCountrySetByPermItem((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"47150e89000000ac");
        if (countrySetByPermItem != null) {
            logger.info("add adjfile countrySetByPermItem = {}", (Object)countrySetByPermItem);
            QFilter qFilter = new QFilter("id", "in", (Object)countrySetByPermItem);
            event.getCustomQFilters().add(qFilter);
        }
    }

    private void registerBeforeF7ForBasedataEdit(ArrayList<String> basedataEditList) {
        for (String editControl : basedataEditList) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(editControl);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }
}

