/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjfile;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.business.salaryadjfile.validator.helper.AdjValidatorHelper;
import kd.swc.hcdm.business.validator.ValidatorAdapter;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.business.validator.bean.ValidatorTree;
import kd.swc.hcdm.common.entity.adjfile.AdjFileInfo;
import kd.swc.hcdm.common.enums.SalaryAdjFilePartEnum;
import kd.swc.hcdm.formplugin.adjfile.SalaryAdjFileCommonEdit;

public class SalaryAdjFileControlEdit
extends SalaryAdjFileCommonEdit {
    public void beforeBindData(EventObject eventObject) {
        this.setButtonVisible();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "formsave": 
            case "save": {
                this.validateAdjfile(args);
                break;
            }
            case "saveafteraudit": {
                if (this.isFileStatusAbandoned()) {
                    args.setCancel(true);
                }
                this.validateAdjfile(args);
                break;
            }
            case "modifyafteraudit": {
                if (!this.isFileStatusAbandoned()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    private void validateAdjfile(BeforeDoOperationEventArgs args) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.validateNewAdjFile(args);
        } else {
            this.validate(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    private void validate(BeforeDoOperationEventArgs args) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fileIdStr = (String)formShowParameter.getCustomParam("key_custom_param_fileid");
        long fileId = Long.parseLong(fileIdStr);
        IDataModel model = this.getModel();
        Date bsed = (Date)model.getValue("bsed");
        Date bsled = (Date)model.getValue("bsled");
        AdjFileInfo data = new AdjFileInfo();
        data.setId(fileId);
        data.setBsed(bsed);
        data.setBsled(bsled);
        data.setBoId(model.getDataEntity().getLong("boid"));
        data.setDepempId(model.getDataEntity().getLong("depemp.id"));
        SalaryAdjFilePartEnum adjFilePart = SalaryAdjFilePartEnum.getEnumByEntityId((String)this.getView().getEntityId());
        data.setAdjFilePart(adjFilePart);
        ValidateContext validateContext = new ValidateContext((Object)data);
        ValidatorTree validatorTree = AdjValidatorHelper.getAdjFileCommonDateValidatorTree((ValidateContext)validateContext);
        ValidatorAdapter adpter = ValidatorAdapter.build((ValidateContext)validateContext, (ValidatorTree)validatorTree);
        adpter.validate();
        List results = validateContext.getResults();
        for (ValidateResult result : results) {
            if (result.isSuccess()) continue;
            List errorList = result.getErrorList();
            if (errorList.isEmpty()) {
                IFormView parentView = this.getView().getParentView();
                parentView.invokeOperation("donothing_refresh");
                this.getView().sendFormAction(parentView);
            }
            this.showErrorMsg(result);
            args.setCancel(true);
            break;
        }
    }

    private void showErrorMsg(ValidateResult result) {
        ErrorLevel level = result.getLevel();
        List errorList = result.getErrorList();
        if (ErrorLevel.FatalError.equals((Object)level)) {
            errorList.forEach(str -> this.getView().showErrorNotification(str));
        } else if (ErrorLevel.Error.equals((Object)level)) {
            errorList.forEach(str -> this.getView().showTipNotification(str));
        } else if (ErrorLevel.Info.equals((Object)level)) {
            errorList.forEach(str -> this.getView().showMessage(str));
        } else if (ErrorLevel.Warning.equals((Object)level)) {
            errorList.forEach(str -> this.getView().showTipNotification(str));
        }
    }

    private void validateNewAdjFile(BeforeDoOperationEventArgs args) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        long depempId = dataEntity.getLong("depemp.id");
        long orgId = dataEntity.getLong("org.id");
        long countryId = dataEntity.getLong("country.id");
        long stdscmId = dataEntity.getLong("stdscm.id");
        Date bsed = dataEntity.getDate("bsed");
        Date bsled = dataEntity.getDate("bsled");
        AdjFileInfo data = new AdjFileInfo(depempId, orgId, countryId, 0L, stdscmId, bsed, bsled);
        data.setDepempId(depempId);
        ValidateContext validateContext = new ValidateContext((Object)data);
        ValidatorTree validatorTree = AdjValidatorHelper.getSaveNewAdjFileValidatorTree((ValidateContext)validateContext);
        ValidatorAdapter adpter = ValidatorAdapter.build((ValidateContext)validateContext, (ValidatorTree)validatorTree);
        adpter.validate();
        List results = validateContext.getResults();
        for (ValidateResult result : results) {
            if (result.isSuccess()) continue;
            this.showErrorMsg(result);
            args.setCancel(true);
            break;
        }
    }

    private boolean isFileStatusAbandoned() {
        IFormView parentView;
        String fileId = this.getFileId();
        if (fileId == null) {
            return true;
        }
        String adjFileStatus = SalaryAdjFileServiceHelper.getAdjFileStatuByFileId((String)fileId);
        if (adjFileStatus.equals("E") && null != (parentView = this.getView().getParentView())) {
            parentView.invokeOperation("donothing_refresh");
            this.getView().sendFormAction(parentView);
            return true;
        }
        return false;
    }
}

