/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjfile;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.metadata.form.control.Hint;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.swc.hsbp.common.util.SWCMServiceUtils;

public class SalaryAdjFileExamplePlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(SalaryAdjFileExamplePlugin.class);
    private static Pattern PATTERN = Pattern.compile("<img\\b[^>]*\\bsrc\\b\\s*=\\s*('|\")?([^'\"\n\r\f>]+(\\.jpg|\\.bmp|\\.eps|\\.gif|\\.mif|\\.miff|\\.png|\\.tif|\\.tiff|\\.svg|\\.wmf|\\.jpe|\\.jpeg|\\.dib|\\.ico|\\.tga|\\.cut|\\.pic)\\b)[^>]*>", 2);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map promptMap = (Map)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptIdAndContent", (Object[])new Object[]{this.getView().getModel().getDataEntityType().getName(), "hintap", this.getView().getModel().getDataEntity()});
        LOG.info("\u4e2d\u53f0\u63d0\u793a\u8bed\u8fd4\u56de\u5185\u5bb9\uff1a{}", JSONObject.toJSON((Object)promptMap));
        for (Map.Entry entry : promptMap.entrySet()) {
            String value2 = (String)entry.getValue();
            if (StringUtils.isEmpty((CharSequence)value2)) {
                LOG.info("value is null.");
                continue;
            }
            List<String> imgUrls = this.getImageSrc(value2);
            for (String imgUrl : imgUrls) {
                String imageFullUrl = UrlService.getDomainContextUrl() + "/" + imgUrl;
                entry.setValue(value2.replace(imgUrl, imageFullUrl));
            }
        }
        LOG.info("\u66ff\u6362\u5185\u5bb9\uff1a{}", JSONObject.toJSON((Object)promptMap));
        Hint hintAp = (Hint)this.getControl("hintap");
        promptMap.forEach((key, value) -> hintAp.setContent(key, value));
    }

    private List<String> getImageSrc(String htmlCode) {
        ArrayList<String> imageSrcList = new ArrayList<String>();
        Matcher matcher = PATTERN.matcher(htmlCode);
        String quote = null;
        String src = null;
        while (matcher.find()) {
            quote = matcher.group(1);
            src = quote == null || quote.trim().length() == 0 ? matcher.group(2).split("\\s+")[0] : matcher.group(2);
            imageSrcList.add(src);
        }
        return imageSrcList;
    }
}

