/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjfile;

import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.swc.hcdm.business.decadjrecordrevision.DecAdjRecordRevisionHelper;
import kd.swc.hcdm.business.salaryadjfile.AdjFileCacheHelper;
import kd.swc.hcdm.business.salaryadjfile.AdjFileFormHelper;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.common.enums.SalaryAdjFilePartEnum;
import kd.swc.hcdm.common.enums.SalaryAdjFilePartViewEnum;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryAdjFilePlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(SalaryAdjFilePlugin.class);
    private final String AP_RIGHT_SIDEBAR = "sideap";
    private static final String CLOSECALLBACKID_VIEW = "closecallbackid_view";
    private static final String BAR_SUBMIT = "bar_submit";
    private static final String BAR_UNSUBMIT = "bar_unsubmit";
    private static final String BAR_AUDIT = "bar_audit";
    private static final String OP_SUBMIT = "donothing_submit";
    private static final String OP_UNSUBMIT = "donothing_unsubmit";
    private static final String OP_AUDIT = "donothing_effect";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        String fileId = this.getFileId();
        String adjFileStatu = SalaryAdjFileServiceHelper.getAdjFileStatuByFileId((String)fileId);
        if (adjFileStatu.equals("D") || adjFileStatu.equals("E")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SUBMIT, BAR_UNSUBMIT, BAR_AUDIT});
        }
        this.initToolBar();
        this.initSummaryPage();
        this.initAllPartOfAdjFilePage();
        this.initSideBar();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "donothing_cancel": {
                this.cancelAndRefresh(args);
                break;
            }
            case "donothing_addnew": {
                this.getView().showForm((FormShowParameter)DecAdjRecordRevisionHelper.partAddnew());
                break;
            }
            case "donothing_submit": {
                this.invokeFileOp("submit");
                break;
            }
            case "donothing_unsubmit": {
                this.invokeFileOp("unsubmit");
                break;
            }
            case "donothing_effect": {
                this.invokeFileOp("audit");
                break;
            }
            case "donothing_refresh": {
                this.refresh();
                break;
            }
        }
    }

    private void refresh() {
        String fileId = this.getFileId();
        String adjFileStatu = SalaryAdjFileServiceHelper.getAdjFileStatuByFileId((String)fileId);
        this.getView().getFormShowParameter().setCustomParam("status", (Object)adjFileStatu);
        if (adjFileStatu.equals("D") || adjFileStatu.equals("E")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SUBMIT, BAR_UNSUBMIT, BAR_AUDIT});
        }
        this.initToolBar();
        this.initSummaryPage();
        this.initAllPartOfAdjFilePage();
        this.initSideBar();
    }

    private void initToolBar() {
        String fileStatus;
        String fileId = this.getFileId();
        switch (fileStatus = SalaryAdjFileServiceHelper.getAdjFileStatuByFileId((String)fileId)) {
            case "A": {
                this.getView().setVisible(Boolean.TRUE, new String[]{BAR_SUBMIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_UNSUBMIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_AUDIT});
                break;
            }
            case "B": {
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SUBMIT});
                this.getView().setVisible(Boolean.TRUE, new String[]{BAR_UNSUBMIT});
                this.getView().setVisible(Boolean.TRUE, new String[]{BAR_AUDIT});
                break;
            }
            case "C": {
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SUBMIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_UNSUBMIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_AUDIT});
                break;
            }
            case "E": {
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SUBMIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_UNSUBMIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_AUDIT});
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeFileOp(String opName) {
        boolean isValidateSucess = true;
        try {
            String entityId = SalaryAdjFilePartEnum.baseInfo.getEntityId();
            String fileId = this.getFileId();
            Object[] ids = new Object[]{Long.valueOf(fileId)};
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)opName, (String)entityId, (Object[])ids, (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                isValidateSucess = false;
                this.getView().showOperationResult(operationResult);
                return;
            }
            String message = operationResult.getMessage();
            if (operationResult.isShowMessage() && message != null) {
                ValidateResultCollection validateResult;
                if (SWCStringUtils.isNotEmpty((String)message) && message.contains("adjfilecertwarn") && (validateResult = operationResult.getValidateResult()).isSuccess()) {
                    String result = message.replace("adjfilecertwarn", "");
                    operationResult.setMessage(result);
                }
                this.getView().showOperationResult(operationResult);
            }
        }
        catch (Exception e) {
            log.info("failure of submit file -> error message : {}", (Object)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002", (String)"SingleAddPersonFilePlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            isValidateSucess = false;
        }
        finally {
            if (isValidateSucess) {
                this.refresh();
            }
        }
    }

    private void cancelAndRefresh(AfterDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        OperateOption option = source.getOption();
        String entityId = option.getVariableValue("var_entityid");
        FormShowParameter formShowParameter = AdjFileFormHelper.getFormShowParameterByEntityId((String)entityId, (FormShowParameter)this.getView().getFormShowParameter());
        if (formShowParameter instanceof BaseShowParameter) {
            return;
        }
        SalaryAdjFilePartEnum salaryAdjFilePartEnum = SalaryAdjFilePartEnum.getEnumByEntityId((String)entityId);
        boolean visible = formShowParameter != null;
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{salaryAdjFilePartEnum.getTargetKey()});
        this.setCollapseAble(this.getView(), salaryAdjFilePartEnum.getTargetKey(), true, false);
        if (visible) {
            this.getView().showForm(formShowParameter);
        }
    }

    private String getFileId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return (String)formShowParameter.getCustomParam("key_custom_param_fileid");
    }

    private void initSideBar() {
        if (this.isShowSideBar()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"rightap"});
            this.showRightSideBar();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"rightap"});
        }
    }

    private boolean isShowSideBar() {
        String fileId = this.getFileId();
        String adjFileStatu = SalaryAdjFileServiceHelper.getAdjFileStatuByFileId((String)fileId);
        return SWCStringUtils.equals((String)adjFileStatu, (String)"C") || SWCStringUtils.equals((String)adjFileStatu, (String)"D");
    }

    private void showRightSideBar() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fileId = (String)formShowParameter.getCustomParam("key_custom_param_fileid");
        FormShowParameter right = new FormShowParameter();
        right.setFormId("hcdm_filerightpage");
        right.setCustomParam("key_custom_param_fileid", (Object)fileId);
        right.setCustomParam("hsbs_entitytype_id", (Object)"1020");
        right.setCustomParam("currentObjectPKId", (Object)fileId);
        right.setCustomParam("isHistoryPage", formShowParameter.getCustomParam("isHistoryPage"));
        OpenStyle openStyle = right.getOpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey("sideap");
        this.getView().showForm(right);
    }

    private void initSummaryPage() {
        FormShowParameter summaryFormShowParameter = AdjFileFormHelper.getSummaryFormShowParameter((FormShowParameter)this.getView().getFormShowParameter(), (String)"summary");
        AdjFileCacheHelper.putSummaryPageCache((String)summaryFormShowParameter.getPageId());
        this.getView().showForm(summaryFormShowParameter);
    }

    private void initAllPartOfAdjFilePage() {
        SalaryAdjFilePartViewEnum[] allParts;
        for (SalaryAdjFilePartViewEnum salaryAdjFilePartEnum : allParts = SalaryAdjFilePartViewEnum.values()) {
            FormShowParameter param = AdjFileFormHelper.buildSalaryAdjFilePage((SalaryAdjFilePartViewEnum)salaryAdjFilePartEnum, (FormShowParameter)this.getView().getFormShowParameter());
            boolean isCollapseAble = !(param instanceof BaseShowParameter);
            this.setCollapseAble(this.getView(), salaryAdjFilePartEnum.getTargetKey(), isCollapseAble, false);
            boolean visible = null != param;
            this.getView().setVisible(Boolean.valueOf(visible), new String[]{salaryAdjFilePartEnum.getTargetKey()});
            if (!visible) continue;
            AdjFileCacheHelper.putPageCache((IFormView)this.getView(), (SalaryAdjFilePartViewEnum)salaryAdjFilePartEnum, (FormShowParameter)param);
            this.getView().showForm(param);
        }
    }

    private void setCollapseAble(IFormView view, String targetKey, boolean isCollapseAble, boolean isCollapse) {
        Container container = (Container)view.getControl(targetKey);
        container.setCollapseable(isCollapseAble);
        container.setCollapse(isCollapse);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        String adjFileModifyCacheKey;
        SWCPageCache pageCache;
        Boolean adjFileModifyCache;
        super.beforeDoOperation(beforeDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)beforeDoOperationEventArgs.getSource();
        if (StringUtils.equals((CharSequence)OP_SUBMIT, (CharSequence)formOperate.getOperateKey()) && (adjFileModifyCache = Boolean.valueOf((pageCache = new SWCPageCache(this.getView())).get(adjFileModifyCacheKey = "hcdm_adjfileinfo", Boolean.class) != null)).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u6863\u6848\u57fa\u672c\u4fe1\u606f\u6ca1\u6709\u4fdd\u5b58\uff0c\u4e0d\u80fd\u8fdb\u884c\u63d0\u4ea4\u64cd\u4f5c\u3002", (String)"SalaryAdjFilePlugin_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            beforeDoOperationEventArgs.setCancel(true);
        }
    }
}

