/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjfile;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.adjapprbill.AdjApprovalGridHelper;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.common.enums.AdjFileTypeEnum;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.control.SWCLabelAp;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCImageUrlUtil;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang.StringUtils;

public class SalaryAdjFilePreviewPlugin
extends AbstractFormPlugin {
    private static final String[] NATIONALITY_FIELDS = new String[]{"COUNTRYNAME", "COUNTRYLOGO", "GENDER"};
    private static final String HEADSCULPTURE = "headsculpture";
    private static final String NAME = "name";
    private static final String GENDER = "gender";
    private static final String EMPNUMBER = "empnumber";
    private static final String COMPANY = "company";
    private static final String ADMINORG = "adminorg";
    private static final String JOB = "job";
    private static final String POSITION = "position";
    private static final String JOBLEVELADNGRADE = "joblevelandgrade";
    private static final String COUNTRYNAME = "countryname";
    private static final String COUNTRYLOGO = "countrylogo";
    private static final String PHONE = "phone";
    private static final String PEREMAIL = "peremail";
    private static final String IMAGEAP = "imageap";
    private static final String IMAGETXT = "imagetxt";
    private static final String PANELICON = "panelicon";
    private static final String ADJFILETYPE = "adjfiletype";
    private static final String LABORRELTYPE = "laborreltype";
    private static final String LABORRELSTATUS = "laborrelstatus";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        DynamicObject salaryAdjFileDyobj = this.getSalaryAdjFileInfo();
        Long personId = salaryAdjFileDyobj.getLong("person.id");
        Map pernontsprop = SalaryAdjFileServiceHelper.getPernontsprop((Long)personId, (String[])NATIONALITY_FIELDS);
        DynamicObject percontactDyobj = SalaryAdjFileServiceHelper.getPercontactDyobj((Long)personId);
        this.setFieldValue(salaryAdjFileDyobj, pernontsprop, percontactDyobj);
        this.setStatusImg(salaryAdjFileDyobj.getString("status"));
        this.setOrg();
    }

    private void setOrg() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fileId = (String)formShowParameter.getCustomParam("key_custom_param_fileid");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(fileId))};
        String selectProperties = "id, number, stdscm.id, person, isprimary, status, type, empposorgrel, depemp, job,org,country,empgroup";
        DynamicObject DynamicObject2 = helper.queryOne(selectProperties, qFilters);
        String orgName = DynamicObject2.getString("org.name");
        String countryName = DynamicObject2.getString("country.name");
        String empgroupName = DynamicObject2.getString("empgroup.name");
        Label orgNameLabel = (Label)this.getView().getControl("orgname");
        orgNameLabel.setText(orgName);
        Label countryNameLabel = (Label)this.getView().getControl("countryname1");
        countryNameLabel.setText(countryName);
        Label empgroupNameLabel = (Label)this.getView().getControl("empgroupname");
        empgroupNameLabel.setText(empgroupName);
    }

    private DynamicObject getSalaryAdjFileInfo() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fileId = (String)formShowParameter.getCustomParam("key_custom_param_fileid");
        return SalaryAdjFileServiceHelper.queryAdjFileInfoByFileId((Long)Long.parseLong(fileId));
    }

    private void setStatusImg(String status) {
        if (null != status) {
            switch (status) {
                case "A": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{PANELICON});
                    this.updateImgTxtMetaData("#276FF5", "#F2F9FF", "#85B8FF", ResManager.loadKDString((String)"\u6682\u5b58", (String)"SalaryAdjFilePreviewPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "B": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{PANELICON});
                    this.updateImgTxtMetaData("#1BA854", "#F2FFF5", "#6DD18E", ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"SalaryAdjFilePreviewPlugin_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "C": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{PANELICON});
                    this.updateImgTxtMetaData("#1BA854", "#F2FFF5", "#6DD18E", ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"SalaryAdjFilePreviewPlugin_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "D": {
                    this.updateImgTxtMetaData("#666666", "#F5F5F5", "#CCCCCC", ResManager.loadKDString((String)"\u5df2\u5931\u6548", (String)"SalaryAdjFilePreviewPlugin_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "E": {
                    this.updateImgTxtMetaData("#666666", "#F5F5F5", "#CCCCCC", ResManager.loadKDString((String)"\u5df2\u5e9f\u5f03", (String)"SalaryAdjFilePreviewPlugin_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                    break;
                }
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{PANELICON});
        }
    }

    private void updateImgTxtMetaData(String foreColor, String backColor, String borderColor, String content) {
        LabelAp imgLabel = new SWCLabelAp.Builder(IMAGETXT).setFontSize(12).setRadius("2px").build();
        Style style = new Style();
        Border border = new Border();
        border.setTop("1px solid " + borderColor);
        border.setBottom("1px solid " + borderColor);
        border.setRight("1px solid " + borderColor);
        border.setLeft("1px solid " + borderColor);
        style.setBorder(border);
        Padding padding = new Padding();
        padding.setTop("1px");
        padding.setBottom("1px");
        padding.setLeft("1px");
        padding.setRight("1px");
        style.setPadding(padding);
        imgLabel.setBackColor(backColor);
        imgLabel.setForeColor(foreColor);
        imgLabel.setName(new LocaleString(content));
        imgLabel.setStyle(style);
        this.getView().updateControlMetadata(imgLabel.getKey(), imgLabel.createControl());
    }

    private void setFieldValue(DynamicObject salaryAdjFileDyobj, Map<String, Object> pernontsprop, DynamicObject percontactDyobj) {
        if (!SWCBaseUtils.isEmpty((DynamicObject)salaryAdjFileDyobj)) {
            IFormView formView = this.getView();
            this.setGender(pernontsprop.size() == 0 || pernontsprop.get("GENDER") == null ? "" : pernontsprop.get("GENDER").toString(), formView);
            this.setLabelValue(COUNTRYNAME, pernontsprop.size() == 0 || pernontsprop.get("COUNTRYNAME") == null ? "" : pernontsprop.get("COUNTRYNAME").toString());
            this.setCountryLogo(pernontsprop.size() == 0 || pernontsprop.get("COUNTRYLOGO") == null ? "" : pernontsprop.get("COUNTRYLOGO").toString());
            DynamicObject personDyobj = salaryAdjFileDyobj.getDynamicObject("person");
            DynamicObject employeeDyobj = salaryAdjFileDyobj.getDynamicObject("employee");
            long employeeId = salaryAdjFileDyobj.getLong("depemp.employee.id");
            this.setPortrait(personDyobj == null ? null : personDyobj.getString(HEADSCULPTURE));
            this.setLabelValue(NAME, personDyobj == null ? "" : personDyobj.getString(NAME));
            this.setLabelValue(EMPNUMBER, employeeDyobj == null ? "" : employeeDyobj.getString(EMPNUMBER));
            String companyName = "";
            String jobName = "";
            DynamicObject empposorgrelDyobj = salaryAdjFileDyobj.getDynamicObject("empposorgrel");
            if (!SWCBaseUtils.isEmpty((DynamicObject)empposorgrelDyobj)) {
                companyName = empposorgrelDyobj.getString("company.name");
                jobName = empposorgrelDyobj.getString("job.name");
            }
            this.setLabelValue(COMPANY, companyName);
            if (SWCStringUtils.isEmpty((String)companyName)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{COMPANY});
                this.getView().setVisible(Boolean.FALSE, new String[]{"companyvec"});
            }
            this.setLabelValue(JOB, jobName);
            if (SWCStringUtils.isEmpty((String)jobName)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"jobvec"});
                this.getView().setVisible(Boolean.FALSE, new String[]{JOB});
            }
            String adminorgName = "";
            DynamicObject depempDyobj = salaryAdjFileDyobj.getDynamicObject("depemp");
            if (!SWCBaseUtils.isEmpty((DynamicObject)depempDyobj)) {
                adminorgName = depempDyobj.getString("adminorg.name");
            }
            this.setLabelValue(ADMINORG, adminorgName);
            if (SWCStringUtils.isEmpty((String)adminorgName)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"adminorgvec"});
                this.getView().setVisible(Boolean.FALSE, new String[]{ADMINORG});
            }
            if (empposorgrelDyobj != null) {
                String positionName = empposorgrelDyobj.getString("position.name");
                this.setLabelValue(POSITION, positionName);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"positionvec"});
                this.getView().setVisible(Boolean.FALSE, new String[]{POSITION});
            }
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hrpi_empjobrel");
            DynamicObject empjobrel = helper.queryOne("joblevel.name,jobgrade.name", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("employee", "=", (Object)employeeId), new QFilter("businessstatus", "=", (Object)"1")});
            if (empjobrel != null) {
                String jobLevelName = empjobrel.getString("joblevel.name");
                String jobGradeName = empjobrel.getString("jobgrade.name");
                this.setLabelValue("joblevel", jobLevelName);
                this.setLabelValue("jobgrade", jobGradeName);
                if (StringUtils.isEmpty((String)jobLevelName)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"joblevelvec"});
                }
                if (StringUtils.isEmpty((String)jobGradeName)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"jobgradevec"});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"joblevelvec", "jobgradevec", "joblevel", "jobgrade"});
            }
            this.setLabelValue(ADJFILETYPE, AdjFileTypeEnum.getNameByCode((int)salaryAdjFileDyobj.getInt("type")));
            HashMap laborRelTypeData = Maps.newHashMapWithExpectedSize((int)16);
            HashMap laborRelStatusData = Maps.newHashMapWithExpectedSize((int)16);
            AdjApprovalGridHelper.getLaborRelData((Set)Sets.newHashSet((Object[])new Long[]{employeeId}), (Map)laborRelTypeData, (Map)laborRelStatusData);
            if (!SWCObjectUtils.isEmpty((Object)laborRelTypeData) && !SWCObjectUtils.isEmpty(laborRelTypeData.get(employeeId))) {
                this.setLabelValue(LABORRELTYPE, ((DynamicObject)laborRelTypeData.get(employeeId)).getString(NAME));
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{LABORRELTYPE});
            }
            if (!SWCObjectUtils.isEmpty((Object)laborRelStatusData) && !SWCObjectUtils.isEmpty(laborRelTypeData.get(employeeId))) {
                this.setLabelValue(LABORRELSTATUS, ((DynamicObject)laborRelStatusData.get(employeeId)).getString(NAME));
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{LABORRELSTATUS});
            }
        }
    }

    private void setGender(String gender, IFormView formView) {
        Image genderImg = (Image)this.getControl(GENDER);
        if (null != gender) {
            switch (gender) {
                case "1": {
                    genderImg.setUrl("/icons/pc/label/male.png");
                    break;
                }
                case "2": {
                    genderImg.setUrl("/icons/pc/label/female_16_16.png");
                    break;
                }
                default: {
                    formView.setVisible(Boolean.FALSE, new String[]{GENDER});
                    break;
                }
            }
        } else {
            formView.setVisible(Boolean.FALSE, new String[]{GENDER});
        }
    }

    private void setPortrait(String portraitUrl) {
        Image portrait = (Image)this.getControl(HEADSCULPTURE);
        if (null != portraitUrl) {
            portrait.setUrl(SWCImageUrlUtil.getImageFullUrl((String)portraitUrl));
        } else {
            portrait.setUrl("/images/pc/emotion/default_person_82_82.png");
        }
    }

    private void setLabelValue(String fieldKey, String value) {
        Label label = (Label)this.getControl(fieldKey);
        if (SWCObjectUtils.isEmpty((Object)label)) {
            return;
        }
        if (!SWCStringUtils.isEmpty((String)value)) {
            label.setText(value);
        } else {
            label.setText("");
        }
    }

    private void setCountryLogo(String countryLogo) {
        Image portrait = (Image)this.getControl(COUNTRYLOGO);
        if (SWCObjectUtils.isEmpty((Object)portrait)) {
            return;
        }
        if (SWCStringUtils.isNotEmpty((String)countryLogo)) {
            portrait.setUrl(countryLogo);
        } else {
            portrait.setUrl("");
        }
    }
}

