/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjfile;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.orm.query.QFilter;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.swc.hcdm.business.adjapprbill.GradeAndRankNameHelper;
import kd.swc.hcdm.business.adjapprbill.enums.CalcType;
import kd.swc.hcdm.common.entity.adjapprbill.AmountStdRangeEntity;
import kd.swc.hcdm.common.entity.adjapprbill.GradeAndRankNameEntity;
import kd.swc.hcdm.common.enums.HCDMErrInfoEnum;
import kd.swc.hcdm.common.utils.GlobalParam;
import kd.swc.hcdm.formplugin.adjapprbill.AdjApprovalFormUtils;
import kd.swc.hcdm.formplugin.adjfile.sidebar.FileSideMulListPlugin;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class SalaryAdjFileQueryListPlugin
extends SWCDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(FileSideMulListPlugin.class);
    private static final Set<String> PERCENT_FORMAT_SET = new HashSet<String>();
    private static final Set<String> DECIMAL_FORMAT_SET = new HashSet<String>();

    public void setFilter(SetFilterEvent event) {
        event.setOrderBy("bsed desc,standarditem.id desc");
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        String bsed = (String)this.getView().getFormShowParameter().getCustomParam("bsed");
        Label stateLabel = (Label)this.getView().getControl("labelap");
        stateLabel.setText(bsed);
        Style style = new Style();
        Boolean lastFlex = (Boolean)this.getView().getFormShowParameter().getCustomParam("LAST_FLEX");
        if (null != lastFlex && lastFlex.booleanValue()) {
            Margin margin = new Margin();
            margin.setBottom("0px");
            margin.setLeft("20px");
            margin.setTop("8px");
            style.setMargin(margin);
            HashMap<String, Map> control = new HashMap<String, Map>();
            control.put("s", style.getStyle());
            this.getView().updateControlMetadata("flexpanelap2", control);
        }
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        DynamicObjectCollection rows = event.getPageData();
        if (this.isOpenSummaryOrPrivacy(rows)) {
            return;
        }
        Map rankStatusMap = (Map)this.getView().getFormShowParameter().getCustomParam("rankStatusMap");
        Map<Long, String> salaryRecordIdToGradeRankNameMap = SalaryAdjFileQueryListPlugin.getSalRecordIdToGradeRankNameMap(rows, rankStatusMap);
        LOGGER.info("setSalaryRecordShowParameter salaryRecordIdToGradeRankNameMap={}", (Object)JSON.toJSONString(salaryRecordIdToGradeRankNameMap));
        GlobalParam.set((String)"GRADE_AND_RANK_CACHE_KEY", salaryRecordIdToGradeRankNameMap);
    }

    public void packageData(PackageDataEvent event) {
        Map amountStdRangeMap;
        super.packageData(event);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if ("schooltype".equals(fieldKey)) {
            event.setFormatValue((Object)this.setSchoolTypeValue(event.getRowData()));
        }
        if (PERCENT_FORMAT_SET.contains(fieldKey)) {
            this.setGridScaleField(event, fieldKey);
        }
        if (DECIMAL_FORMAT_SET.contains(fieldKey)) {
            this.formatScale(event, fieldKey);
        }
        DynamicObject rowData = event.getRowData();
        if ("amountstdrange".equals(fieldKey) && (amountStdRangeMap = (Map)GlobalParam.get((String)"GRADE_AND_RANK_CACHE_KEY")) != null && amountStdRangeMap.size() > 0) {
            LOGGER.info("packageData amountstdrange is {}", (Object)JSON.toJSONString((Object)amountStdRangeMap));
            long salaryRecordId = rowData.getLong("id");
            event.setFormatValue(amountStdRangeMap.get(salaryRecordId));
        }
    }

    private void formatScale(PackageDataEvent event, String fieldKey) {
        Object valueFast = ((IDataEntityProperty)event.getRowData().getDataEntityType().getProperties().get((Object)fieldKey)).getValueFast((Object)event.getRowData());
        if (!(valueFast instanceof BigDecimal)) {
            return;
        }
        BigDecimal decimal = (BigDecimal)valueFast;
        StringBuilder format = new StringBuilder("#0.00");
        DecimalFormat myFormat = new DecimalFormat(format.toString());
        String value = myFormat.format(decimal);
        event.setFormatValue((Object)value);
    }

    private String setSchoolTypeValue(DynamicObject rowData) {
        Map schoolTypeParam = (Map)this.getView().getFormShowParameter().getCustomParam("schoolTypeMap");
        if (null == schoolTypeParam) {
            return null;
        }
        LOGGER.info("-----SalaryAdjFileQueryListPlugin.setSchoolTypeValue{}", schoolTypeParam.get(rowData.getLong("id")));
        return (String)schoolTypeParam.get(rowData.getLong("id"));
    }

    private void setGridScaleField(PackageDataEvent event, String fieldKey) {
        Object valueFast = ((IDataEntityProperty)event.getRowData().getDataEntityType().getProperties().get((Object)fieldKey)).getValueFast((Object)event.getRowData());
        if (!(valueFast instanceof BigDecimal)) {
            return;
        }
        BigDecimal decimal = (BigDecimal)valueFast;
        String formatValue = this.getScaleFormatValue(decimal);
        event.setFormatValue((Object)formatValue);
    }

    private String getScaleFormatValue(BigDecimal value) {
        StringBuilder format = new StringBuilder("0.00%");
        DecimalFormat myFormat = new DecimalFormat(format.toString());
        return myFormat.format(value);
    }

    public static Map<Long, String> getSalRecordIdToGradeRankNameMap(DynamicObjectCollection salaryRecordList, Map<Long, Boolean> rankStatusMap) {
        ArrayList<String> matchGradeRankRelList = new ArrayList<String>(10);
        ArrayList<String> amountStdRangeList = new ArrayList<String>(10);
        Set salaryRecordIdSet = salaryRecordList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        QFilter[] qFilter = new QFilter[]{new QFilter("id", "in", salaryRecordIdSet)};
        SWCDataServiceHelper adjRecordHelper = new SWCDataServiceHelper("hcdm_salaryadjrecord");
        DynamicObject[] adjRecordArray = adjRecordHelper.query("id, salargrel, amountstdrange, salaryadjrsn,datasource,bussinessid,initdatasource,initbatch", qFilter);
        Map<Long, String> idToLinkName = SalaryAdjFileQueryListPlugin.getDataSrcNumber(adjRecordArray);
        for (DynamicObject salaryRecord : adjRecordArray) {
            String amountStdRange;
            String matchGradeRankRel = salaryRecord.getString("salargrel");
            if (StringUtils.isNotEmpty((CharSequence)matchGradeRankRel)) {
                matchGradeRankRelList.add(matchGradeRankRel);
            }
            if (!StringUtils.isNotEmpty((CharSequence)(amountStdRange = salaryRecord.getString("amountstdrange")))) continue;
            amountStdRangeList.add(amountStdRange);
        }
        GradeAndRankNameEntity gradeAndRankNameEntity = GradeAndRankNameHelper.getGradeAndRankNameFromMatchGradeRankRel(matchGradeRankRelList);
        GradeAndRankNameEntity amountStdRangeGradeAndRankNameEntity = GradeAndRankNameHelper.getGradeAndRankNameFromAmountStdRange(amountStdRangeList);
        Map adjRecordMap = Arrays.stream(adjRecordArray).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity()));
        HashMap<Long, String> salaryRecordIdToGradeRankNameMap = new HashMap<Long, String>(16);
        for (DynamicObject salaryRecord : salaryRecordList) {
            DynamicObject adjSelRecord;
            String amountStdRange;
            Long salaryRecordId = salaryRecord.getLong("id");
            String attriButionType = salaryRecord.getString("salaryadjrsn.attributiontype");
            String calcType = salaryRecord.getString("calctype");
            if (AdjAttributionType.DECATTRTYPE.getCode().equals(attriButionType) || CalcType.GRADE_RANK.getCode().equals(calcType) && AdjAttributionType.ADJATTRTYPE.getCode().equals(attriButionType)) {
                String matchGradeRankRel;
                Boolean isUseRank = rankStatusMap.get(salaryRecordId);
                DynamicObject adjRecordDy = (DynamicObject)adjRecordMap.get(salaryRecordId);
                if (adjRecordDy != null && StringUtils.isNotEmpty((CharSequence)(matchGradeRankRel = adjRecordDy.getString("salargrel")))) {
                    AmountStdRangeEntity amountStdRangeEntity = GradeAndRankNameHelper.convertMatchGradeRankRelToAmountStdRange((String)matchGradeRankRel, (Boolean)isUseRank, (GradeAndRankNameEntity)gradeAndRankNameEntity);
                    String amountStdRangeName = GradeAndRankNameHelper.formatGradeAndRankRangeName((String)JSON.toJSONString((Object)amountStdRangeEntity), (GradeAndRankNameEntity)gradeAndRankNameEntity);
                    salaryRecordIdToGradeRankNameMap.put(salaryRecordId, amountStdRangeName);
                }
            } else if (AdjAttributionType.ADJATTRTYPE.getCode().equals(attriButionType) && StringUtils.isNotEmpty((CharSequence)(amountStdRange = salaryRecord.getString("amountstdrange")))) {
                String amountStdRangeName = GradeAndRankNameHelper.formatGradeAndRankRangeName((String)amountStdRange, (GradeAndRankNameEntity)amountStdRangeGradeAndRankNameEntity);
                salaryRecordIdToGradeRankNameMap.put(salaryRecordId, amountStdRangeName);
            }
            if (!MapUtils.isNotEmpty(idToLinkName) || !ObjectUtils.isNotEmpty((Object)(adjSelRecord = (DynamicObject)adjRecordMap.get(salaryRecord.getLong("id"))))) continue;
            Long key = adjSelRecord.getLong("bussinessid");
            if (adjSelRecord.getString("datasource").equals("1")) {
                key = adjSelRecord.getLong("initbatch");
            }
            salaryRecord.set("number", (Object)idToLinkName.get(key));
        }
        return salaryRecordIdToGradeRankNameMap;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if (StringUtils.isNotBlank((CharSequence)fieldName) && fieldName.equals("number")) {
            args.setCancel(true);
            Long pkId = (Long)((BillList)args.getHyperLinkClickEvent().getSource()).getFocusRowPkId();
            SWCDataServiceHelper adjRecordHelper = new SWCDataServiceHelper("hcdm_salaryadjrecord");
            DynamicObject adjRecord = adjRecordHelper.queryOne("id,datasource,bussinessid,salaryadjrsn,salaryadjrsn.attributiontype,initbatch", new QFilter[]{new QFilter("id", "=", (Object)pkId)});
            if (ObjectUtils.isEmpty((Object)adjRecord)) {
                return;
            }
            String datasource = adjRecord.getString("datasource");
            Long bussinessid = adjRecord.getLong("bussinessid");
            if (datasource.equals("1")) {
                if (!this.hasPerm("22/9TRQ536NA", "hric_inittaskform")) {
                    return;
                }
                FormShowParameter formShow = new FormShowParameter();
                formShow.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShow.setFormId("hric_inittaskform");
                formShow.setParentPageId(this.getView().getPageId());
                formShow.setCaption(ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u8bb0\u5f55\u6267\u884c", (String)"SalaryAdjFileQueryListPlugin_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                formShow.setCustomParam("id", (Object)adjRecord.getLong("initbatch"));
                formShow.setPageId(this.getView().getPageId() + pkId);
                this.getView().showForm(formShow);
            } else if (datasource.equals("2")) {
                if (!this.hasPerm("0VO5EV13=I9W", "hcdm_singlecandsetsalappl")) {
                    return;
                }
                BillShowParameter formShow = new BillShowParameter();
                formShow.setStatus(OperationStatus.VIEW);
                formShow.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShow.setParentPageId(this.getView().getPageId());
                formShow.setPageId(this.getView().getPageId() + pkId);
                formShow.setFormId("hcdm_singlecandsetsalappl");
                formShow.setPkId((Object)bussinessid);
                formShow.setCustomParam("datasource", (Object)"adjrecordview");
                this.getView().showForm((FormShowParameter)formShow);
            } else if (datasource.equals("3")) {
                if (!this.hasPerm("0VO5EV13=I9W", "hcdm_adjapprbill")) {
                    return;
                }
                BillShowParameter formShow = AdjApprovalFormUtils.createApprovalForm(this.getView(), bussinessid);
                this.getView().showForm((FormShowParameter)formShow);
            }
        }
    }

    private boolean hasPerm(String appId, String entity) {
        boolean hasViewPermssion = SWCPermissionServiceHelper.hasPerm((String)appId, (String)entity, (String)"47150e89000000ac");
        if (!hasViewPermssion) {
            String entityDescName = EntityMetadataCache.getDataEntityType((String)"hcdm_singlecandsetsalappl").getDisplayName().getLocaleValue();
            this.getView().showErrorNotification(HCDMErrInfoEnum.COMMON_WITHOUT_VIEW_PERMISSION.getMsg(new Object[]{entityDescName}));
            LOGGER.info("hasPerm is :", (Object)"false");
            return false;
        }
        LOGGER.info("hasPerm is :", (Object)"true");
        return true;
    }

    private static Map<Long, String> getDataSrcNumber(DynamicObject[] adjRecordArray) {
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        HashMap dsToRecordMap = new HashMap(16);
        if (ArrayUtils.isNotEmpty((Object[])adjRecordArray)) {
            Arrays.stream(adjRecordArray).filter(obj -> StringUtils.isNotBlank((CharSequence)obj.getString("datasource")) && "1,2,3".contains(obj.getString("datasource"))).forEach(obj -> {
                String datasource = obj.getString("datasource");
                List ids = dsToRecordMap.computeIfAbsent(datasource, key -> new ArrayList(10));
                if (datasource.equals("1")) {
                    ids.add(obj.getLong("initbatch"));
                } else {
                    ids.add(obj.getLong("bussinessid"));
                }
            });
        }
        for (Map.Entry subMap : dsToRecordMap.entrySet()) {
            String datasource = (String)subMap.getKey();
            List ids = (List)subMap.getValue();
            if (datasource.equals("1")) {
                SalaryAdjFileQueryListPlugin.getNumberById("name", "hric_inittask", ids, resultMap);
                continue;
            }
            if (datasource.equals("2")) {
                SalaryAdjFileQueryListPlugin.getNumberById("billno", "hcdm_singlecandsetsalappl", ids, resultMap);
                continue;
            }
            if (!datasource.equals("3")) continue;
            SalaryAdjFileQueryListPlugin.getNumberById("billno", "hcdm_adjapprbill", ids, resultMap);
        }
        return resultMap;
    }

    private static void getNumberById(String fileName, String entityType, List<Long> ids, Map<Long, String> resultMap) {
        SWCDataServiceHelper adjRecordHelper = new SWCDataServiceHelper(entityType);
        Object[] dynamicObjects = adjRecordHelper.query("id," + fileName, new QFilter[]{new QFilter("id", "in", ids)});
        if (ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            for (Object obj : dynamicObjects) {
                resultMap.put(obj.getLong("id"), obj.getString(fileName));
            }
        }
    }

    private boolean isOpenSummaryOrPrivacy(DynamicObjectCollection rows) {
        for (DynamicObject pageData : rows) {
            if (pageData.getDynamicObjectType().getProperties().tryGetValue("salaryadjrsn", new RefObject())) continue;
            return true;
        }
        return false;
    }

    static {
        PERCENT_FORMAT_SET.add("salarypercent");
        PERCENT_FORMAT_SET.add("salaryseeprate");
        DECIMAL_FORMAT_SET.add("suggestminrange");
        DECIMAL_FORMAT_SET.add("suggestmaxrange");
        DECIMAL_FORMAT_SET.add("actualrange");
    }
}

