/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjfile.imports;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.ImportStartData;
import kd.bos.lang.Lang;
import kd.bos.param.ParameterReader;
import org.apache.commons.collections.CollectionUtils;

public class AdjFileBaseImportStartPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject eventObject) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
        ImportStartData.getInstance((AbstractFormPlugin)this, importStartData -> {
            Label title = (Label)this.getControl("title");
            if (Lang.en_US == RequestContext.get().getLang()) {
                title.setText("&nbsp;&nbsp;" + importStartData.getCustomParamData().getListName());
            } else {
                title.setText(importStartData.getCustomParamData().getListName());
            }
            this.init((ImportStartData)importStartData);
        });
    }

    private void init(ImportStartData importStartData) {
        String keyfields;
        List keyfieldItems;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)importStartData.getCustomParamData().getBillFormId());
        String entityFormId = importStartData.getCustomParamData().getBillFormId();
        if (entityType instanceof QueryEntityType) {
            entityFormId = ((QueryEntityType)entityType).getEntityName();
        }
        if (CollectionUtils.isEmpty((Collection)(keyfieldItems = importStartData.getKeyfieldItems()))) {
            return;
        }
        if (!keyfieldItems.isEmpty()) {
            this.sortKeyfieldItems(keyfieldItems, entityType);
            ComboEdit combo = (ComboEdit)this.getControl("keyfields");
            combo.setComboItems(keyfieldItems);
        }
        if (importStartData.getImportTypeEnum() == ImportStartData.ImportStartTypeEnum.NEW && !importStartData.getLockKeys().contains("keyfields")) {
            importStartData.getLockKeys().add("keyfields");
        }
        if (!importStartData.isBusiPluginSetField() && StringUtils.isNotBlank((CharSequence)(keyfields = this.getBillUniqueKeys(entityFormId)))) {
            importStartData.setFieldControl(ImportStartData.ImportStartFieldControlEnum.FORM_BILLPARAM);
            importStartData.setKeyfieldsFromBillParam(keyfields);
        }
        this.getView().setEnable(Boolean.FALSE, importStartData.getLockKeys().toArray(new String[0]));
        this.getModel().setValue("importtype", (Object)importStartData.getImportTypeEnum().getType());
        if (importStartData.getImportTypeEnum() == ImportStartData.ImportStartTypeEnum.NEW) {
            this.getModel().setValue("keyfields", null);
        } else {
            StringBuilder allkeyfield = new StringBuilder();
            for (int i = 0; i < keyfieldItems.size(); ++i) {
                ComboItem keyfieldItem = (ComboItem)keyfieldItems.get(i);
                String keyfield = keyfieldItem.getValue();
                allkeyfield.append(keyfield);
                if (i == keyfieldItems.size() - 1) continue;
                allkeyfield.append(',');
            }
            this.getModel().setValue("keyfields", (Object)allkeyfield.toString());
        }
    }

    private void sortKeyfieldItems(List<ComboItem> keyfieldItems, MainEntityType entityType) {
        HashMap<String, Integer> sortMap = new HashMap<String, Integer>();
        String pk = entityType.getPrimaryKey().getName();
        sortMap.put(pk, 10);
        sortMap.put("billno", 8);
        if (entityType.getMainOrg() != null) {
            sortMap.put(entityType.getMainOrg(), 9);
        }
        Collections.sort(keyfieldItems, (o1, o2) -> {
            String v1 = o1.getValue();
            String v2 = o2.getValue();
            return sortMap.getOrDefault(v2, 0) - sortMap.getOrDefault(v1, 0);
        });
    }

    private String getBillUniqueKeys(String billFormId) {
        DynamicObject obj = ParameterReader.getBillParameter((String)billFormId);
        if (obj != null) {
            String billUniqueKeys = obj.getString("billuniquekeys");
            return billUniqueKeys;
        }
        return null;
    }
}

