/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjfile.imports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.common.model.MultiLangEnumBridge;
import kd.swc.hcdm.business.imports.DefaultImportDataLogger;
import kd.swc.hcdm.business.imports.IImportDataLogger;
import kd.swc.hcdm.business.imports.ImportDataConvertToDyObjHelper;
import kd.swc.hcdm.business.imports.ImportDataLoggerHelper;
import kd.swc.hcdm.business.imports.ImportDataOperation;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.common.entity.adjfile.AdjFileImportEntity;
import kd.swc.hcdm.common.entity.adjfile.ImportRowEntity;
import kd.swc.hcdm.common.enums.AdjFileDataSourceEnum;
import kd.swc.hcdm.common.enums.AdjFileTypeEnum;
import kd.swc.hcdm.common.utils.HCDMCollectionUtil;
import kd.swc.hcdm.formplugin.adjfile.imports.AdjFileImportDataValidator;
import kd.swc.hcdm.formplugin.imports.AbstractBatchImportBasePlugin;
import kd.swc.hcdm.formplugin.imports.validate.AbstractImportDataValidator;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class AdjFileBatchImportPlugin
extends AbstractBatchImportBasePlugin {
    private long totalSpendTime = 0L;
    private long totalImportCount = 0L;
    private static Log log = LogFactory.getLog(AdjFileBatchImportPlugin.class);
    public static final String BOS_ORG = "bos_org";
    private static String[] NON_EDITABLE_FIELDS = new String[]{"org", "country", "stdscm", "type"};
    private static final String IMPORT_TYPE_OVERRIDE_NEW = "overridenew";
    private static final int BATCH_IMPORT_SIZE = 1000;
    Set<AdjFileImportEntity> sameData = new HashSet<AdjFileImportEntity>();

    protected boolean isForceBatch() {
        return true;
    }

    @Override
    public IImportDataLogger getImportDataLogger() {
        return new DefaultImportDataLogger();
    }

    public String getDefaultImportType() {
        return IMPORT_TYPE_OVERRIDE_NEW;
    }

    protected int getBatchImportSize() {
        return 1000;
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(4);
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"AdjFileBatchImportPlugin_5", (String)"swc-hcdm-formplugin", (Object[])new Object[0])), "number"));
        return items;
    }

    public String getDefaultKeyFields() {
        return "number";
    }

    @Override
    public Map<String, String> getKeyFieldMap() {
        HashMap<String, String> keyFieldMap = new HashMap<String, String>(1);
        keyFieldMap.put("number", ResManager.loadKDString((String)"\u6570\u636e\u66ff\u6362\u89c4\u5219\u552f\u4e00\u503c\u5fc5\u987b\u9009\u62e9\u5b9a\u8c03\u85aa\u6863\u6848\u57fa\u672c\u4fe1\u606f", (String)"AdjFileBatchImportPlugin_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
        return keyFieldMap;
    }

    @Override
    public String validateBasedataMustCol(JSONObject jsonObject) {
        ArrayList<String> colNames = new ArrayList<String>(10);
        Set<Map.Entry<String, MultiLangEnumBridge>> entrySet = this.getMustColMapMap().entrySet();
        for (Map.Entry<String, MultiLangEnumBridge> entry : entrySet) {
            String field = entry.getKey();
            JSONObject jsonObject1 = jsonObject.getJSONObject(field);
            if (null != jsonObject1) continue;
            String loadKDString = entry.getValue().loadKDString();
            colNames.add(loadKDString);
        }
        if (colNames.size() > 0) {
            StringJoiner sj = new StringJoiner(",");
            colNames.forEach(action -> sj.add((CharSequence)action));
            return sj.toString();
        }
        return null;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        long start = System.currentTimeMillis();
        log.info("-----------beforeSave()-----------------begin");
        HashSet<String> adjFileNumbers = new HashSet<String>(billdatas.size());
        HashSet<String> personNumbers = new HashSet<String>(billdatas.size());
        HashSet<String> personNames = new HashSet<String>(billdatas.size());
        HashSet<String> biznumberSet = new HashSet<String>(billdatas.size());
        HashSet<String> countrySet = new HashSet<String>(billdatas.size());
        HashSet<String> countryNumberSet = new HashSet<String>(billdatas.size());
        HashSet<String> orgNameSet = new HashSet<String>(billdatas.size());
        HashSet<String> orgNumberSet = new HashSet<String>(billdatas.size());
        HashSet<String> stdScmNameSet = new HashSet<String>(billdatas.size());
        HashSet<String> stdScmNumberSet = new HashSet<String>(billdatas.size());
        for (ImportBillData rowData : billdatas) {
            if (rowData == null) {
                return;
            }
            JSONObject jsonObject = rowData.getData();
            JSONObject personJSONObject = jsonObject.getJSONObject("person");
            if (null != personJSONObject) {
                String personName;
                String personNumber = personJSONObject.getString("number");
                if (SWCStringUtils.isNotEmpty((String)personNumber)) {
                    personNumbers.add(personNumber);
                }
                if (SWCStringUtils.isNotEmpty((String)(personName = personJSONObject.getString("name")))) {
                    personNames.add(personName);
                }
            }
            String adjFileNumber = jsonObject.getString("number");
            adjFileNumbers.add(adjFileNumber);
            biznumberSet.add(jsonObject.getString("biznumber"));
            if (jsonObject.getJSONObject("country") != null) {
                String countryName = jsonObject.getJSONObject("country").getString("name");
                String countryNumber = jsonObject.getJSONObject("country").getString("number");
                if (SWCStringUtils.isNotEmpty((String)countryNumber)) {
                    countryNumberSet.add(countryNumber);
                }
                if (SWCStringUtils.isNotEmpty((String)countryName)) {
                    countrySet.add(countryName);
                }
            }
            if (jsonObject.getJSONObject("org") != null) {
                String orgName = jsonObject.getJSONObject("org").getString("name");
                String orgNumber = jsonObject.getJSONObject("org").getString("number");
                if (SWCStringUtils.isNotEmpty((String)orgName)) {
                    orgNameSet.add(orgName);
                }
                if (SWCStringUtils.isNotEmpty((String)orgNumber)) {
                    orgNumberSet.add(orgNumber);
                }
            }
            if (jsonObject.getJSONObject("stdscm") == null) continue;
            String stdscmName = jsonObject.getJSONObject("stdscm").getString("name");
            String stdscmNumber = jsonObject.getJSONObject("stdscm").getString("number");
            if (SWCStringUtils.isNotEmpty((String)stdscmName)) {
                stdScmNameSet.add(stdscmName);
            }
            if (!SWCStringUtils.isNotEmpty((String)stdscmNumber)) continue;
            stdScmNumberSet.add(stdscmNumber);
        }
        HashMap countryMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap countryIdMap = Maps.newHashMapWithExpectedSize((int)16);
        long start1 = System.currentTimeMillis();
        Map<String, List<DynamicObject>> countrysMap = this.queryCountryInfo(countrySet, countryNumberSet, countryIdMap, countryMap);
        long end1 = System.currentTimeMillis();
        log.info("AdjFileBatchImportPlugin #queryCountryInfo,currentDataSize is:{}, spend time is\uff1a{}", (Object)billdatas.size(), (Object)(end1 - start1));
        HashMap orgIdMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, String> orgMap = this.queryOrg(orgNumberSet, orgNameSet, orgIdMap);
        long end2 = System.currentTimeMillis();
        log.info("AdjFileBatchImportPlugin #queryOrgByNumber,currentDataSize is:{}, spend time is\uff1a{}", (Object)billdatas.size(), (Object)(end2 - end1));
        HashMap stdscmIdMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, String> stdScmMap = this.queryStdScm(stdScmNameSet, stdScmNumberSet, stdscmIdMap);
        long end3 = System.currentTimeMillis();
        log.info("AdjFileBatchImportPlugin #queryOrgByNumber,currentDataSize is:{}, spend time is\uff1a{}", (Object)billdatas.size(), (Object)(end3 - end2));
        Map<String, List<DynamicObject>> salayStructureMap = this.querySalayStructure(countrySet, countryNumberSet);
        long end4 = System.currentTimeMillis();
        log.info("AdjFileBatchImportPlugin #querySalayStructure,currentDataSize is:{}, spend time is\uff1a{}", (Object)billdatas.size(), (Object)(end4 - end3));
        HashMap personNameEmployeeMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, List<DynamicObject>> empnumberEmployDysMap = this.queryEmployeePerson(personNumbers, personNames, personNameEmployeeMap);
        log.info("AdjFileBatchImportPlugin beforeSave employPersonMap.keySet:{}", empnumberEmployDysMap.keySet());
        long end5 = System.currentTimeMillis();
        log.info("AdjFileBatchImportPlugin #queryEmployeePerson,currentDataSize is:{}, spend time is\uff1a{}", (Object)billdatas.size(), (Object)(end5 - end4));
        Set<Long> employeeIds = empnumberEmployDysMap.values().stream().flatMap(Collection::stream).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        Set<String> personNumberSets = empnumberEmployDysMap.keySet();
        DynamicObject[] depempDyObjs = this.queryDepemp(employeeIds);
        long end6 = System.currentTimeMillis();
        log.info("AdjFileBatchImportPlugin #queryDepemp,currentDataSize is:{}, spend time is\uff1a{}", (Object)billdatas.size(), (Object)(end6 - end5));
        HashMap biznumberMap = Maps.newHashMapWithExpectedSize((int)depempDyObjs.length);
        HashMap empnumberDepempMap = Maps.newHashMapWithExpectedSize((int)depempDyObjs.length);
        for (DynamicObject depempDy : depempDyObjs) {
            String empnumber = depempDy.getString("employee.empnumber");
            String number = depempDy.getString("number");
            HCDMCollectionUtil.putSetIntoMap((Map)biznumberMap, (Object)empnumber, (Object)number);
            empnumberDepempMap.put(AdjFileBatchImportPlugin.combineStrings(empnumber, number), depempDy);
        }
        log.info("\u67e5\u8be2\u4e1a\u52a1\u7f16\u7801\u96c6\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)biznumberMap));
        Map<String, List<DynamicObject>> keyAdjfilenumberMap = this.queryAdjFileByPersonIds(employeeIds);
        long end7 = System.currentTimeMillis();
        log.info("AdjFileBatchImportPlugin #queryAdjFileByPersonIds,currentDataSize is:{}, spend time is\uff1a{}", (Object)billdatas.size(), (Object)(end7 - end6));
        Map<String, DynamicObject> adjFileNumberMap = this.queryAdjFileByNumber(adjFileNumbers, null);
        long end8 = System.currentTimeMillis();
        log.info("AdjFileBatchImportPlugin #queryAdjFileByNumber,currentDataSize is{}, spend time is\uff1a{}", (Object)billdatas.size(), (Object)(end8 - end7));
        ArrayList<QFilter> qFilter = new ArrayList<QFilter>();
        List permissionFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"47150e89000000ac");
        if (permissionFilter != null) {
            log.info("adjfile import permissionFilter is: {}", (Object)permissionFilter);
            qFilter.addAll(permissionFilter);
        } else {
            qFilter.add(new QFilter("1", "!=", (Object)1));
            log.info("have no right filter to import adjfile info.");
        }
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"28", (String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"4730fc9f000003ae");
        if (!permOrgs.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            log.info("adjfile import permOrgs = {}", (Object)hasPermOrgs);
            qFilter.add(new QFilter("org", "in", (Object)hasPermOrgs));
        }
        long end9 = System.currentTimeMillis();
        Map<String, DynamicObject> adjFileNumberPermMap = this.queryAdjFileByNumber(adjFileNumbers, qFilter);
        long end10 = System.currentTimeMillis();
        log.info("AdjFileBatchImportPlugin #queryAdjFileByNumberWithPermQFiter,currentDataSize is:{}, spend time is\uff1a{}", (Object)billdatas.size(), (Object)(end10 - end9));
        DynamicObject[] empposorgrelDyObjs = SalaryAdjFileServiceHelper.queryJobByPersonalEmpposorgrel(employeeIds, biznumberSet, (boolean)true);
        long end11 = System.currentTimeMillis();
        log.info("AdjFileBatchImportPlugin #queryJobByPersonalEmpposorgrel,currentDataSize is:{}, spend time is\uff1a{}", (Object)billdatas.size(), (Object)(end11 - end10));
        HashMap empposorgrelMap = Maps.newHashMapWithExpectedSize((int)empposorgrelDyObjs.length);
        for (DynamicObject empposorgrelDy : empposorgrelDyObjs) {
            String empnumber = empposorgrelDy.getString("employee.empnumber");
            String number = empposorgrelDy.getString("number");
            empposorgrelMap.put(AdjFileBatchImportPlugin.combineStrings(empnumber, number), empposorgrelDy);
        }
        for (ImportBillData rowData : billdatas) {
            String errMsg;
            String errMsg2;
            String errMsg3;
            if (rowData == null) {
                return;
            }
            JSONObject jsonObject = rowData.getData();
            log.info("AdjFileBatchImportPlugin beforeSave jsonObject:{}", (Object)jsonObject);
            String mustColNames = this.validateBasedataMustCol(jsonObject);
            if (null != mustColNames) {
                String errMsg4 = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileImportDataLogger_2", (String)"swc-hcdm-business", (Object[])new Object[0]);
                this.log(rowData.getStartIndex(), mustColNames + errMsg4, logger);
                continue;
            }
            String personNumber = jsonObject.getJSONObject("person").getString("number");
            String personName = jsonObject.getJSONObject("person").getString("name");
            if (!personNumberSets.contains(personNumber) && !personNameEmployeeMap.containsKey(personName)) {
                String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u5de5\u53f7{0}\uff1a\u8be5\u4eba\u5458\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileBatchImportPlugin_13", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), personNumber);
                this.log(rowData.getStartIndex(), errorMsg, logger);
                continue;
            }
            if (SWCStringUtils.isEmpty((String)personNumber)) {
                personNumber = ((DynamicObject)personNameEmployeeMap.get(personName)).getString("empnumber");
                jsonObject.getJSONObject("person").put("number", (Object)personNumber);
            }
            if (this.checkParamRepeat(logger, empnumberEmployDysMap, rowData, personNumber)) continue;
            String countryName = jsonObject.getJSONObject("country").getString("name");
            String countryNumber = jsonObject.getJSONObject("country").getString("number");
            if (SWCStringUtils.isNotEmpty((String)countryNumber)) {
                countryName = (String)countryMap.get(countryNumber);
                jsonObject.getJSONObject("country").put("name", (Object)countryName);
            }
            if (!countryMap.containsKey(countryNumber) && !countrysMap.containsKey(countryName)) {
                this.log(rowData.getStartIndex(), ResManager.loadKDString((String)"\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileBatchImportPlugin_38", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), logger);
                continue;
            }
            List<DynamicObject> salayStructureDyObjs = salayStructureMap.get(countryName);
            if (!CollectionUtils.isEmpty(salayStructureDyObjs)) {
                String salaystructureName;
                List salaystructureNameList = salayStructureDyObjs.stream().map(object -> object.getString("name")).collect(Collectors.toList());
                String string = salaystructureName = jsonObject.getJSONObject("salaystructure") == null ? "" : jsonObject.getJSONObject("salaystructure").getString("name");
                if (StringUtils.isNotBlank((CharSequence)salaystructureName) && !salaystructureNameList.contains(salaystructureName)) {
                    String repeatMsg = ResManager.loadKDString((String)"\u5de5\u53f7{0}\uff1a{1}\u85aa\u916c\u7ed3\u6784\u6240\u5c5e\u56fd\u5bb6/\u5730\u533a\u4e0e\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u4e0d\u5339\u914d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileBatchImportPlugin_14", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                    String errMsg5 = MessageFormat.format(repeatMsg, personNumber, empnumberEmployDysMap.get(personNumber).get(0).getString("person.name"));
                    this.log(rowData.getStartIndex(), errMsg5, logger);
                    continue;
                }
            } else {
                String repeatMsg = ResManager.loadKDString((String)"\u5de5\u53f7{0}\uff1a{1}\u85aa\u916c\u7ed3\u6784\u6240\u5c5e\u56fd\u5bb6/\u5730\u533a\u4e0e\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u4e0d\u5339\u914d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileBatchImportPlugin_14", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                String errMsg6 = MessageFormat.format(repeatMsg, personNumber, empnumberEmployDysMap.get(personNumber).get(0).getString("person.name"));
                this.log(rowData.getStartIndex(), errMsg6, logger);
                continue;
            }
            String biznumber = jsonObject.getString("biznumber");
            DynamicObject empposorgrelDy = (DynamicObject)empposorgrelMap.get(AdjFileBatchImportPlugin.combineStrings(personNumber, biznumber));
            if (null == empposorgrelDy) {
                errMsg3 = MessageFormat.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7f16\u7801\u201c{0}\u201d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileBatchImportPlugin_20", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), biznumber);
                this.log(rowData.getStartIndex(), errMsg3, logger);
                continue;
            }
            if (SWCStringUtils.equals((String)"-1", (String)empposorgrelDy.getString("datastatus"))) {
                errMsg3 = ResManager.loadKDString((String)"\u586b\u5199\u7684\u4e1a\u52a1\u7f16\u7801\u5df2\u5e9f\u5f03\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AdjFileBatchImportPlugin_25", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                this.log(rowData.getStartIndex(), errMsg3, logger);
                continue;
            }
            String orgName = jsonObject.getJSONObject("org").getString("name");
            String orgNumber = jsonObject.getJSONObject("org").getString("number");
            if (!SWCStringUtils.isEmpty((String)orgNumber)) {
                orgName = orgMap.get(orgNumber);
            }
            String stdscmName = jsonObject.getJSONObject("stdscm").getString("name");
            String stdscmNumber = jsonObject.getJSONObject("stdscm").getString("number");
            if (!SWCStringUtils.isEmpty((String)stdscmNumber)) {
                stdscmName = stdScmMap.get(stdscmNumber);
            }
            String isprimary = empposorgrelDy.getString("isprimary").equals("1") ? "true" : "false";
            String importAdjFileNumber = jsonObject.getString("number");
            String employeeId = empposorgrelDy.getString("employee.id");
            String orgId = (String)orgIdMap.get(orgName);
            String countryId = (String)countryIdMap.get(countryName);
            String stdscmId = (String)stdscmIdMap.get(stdscmName);
            String combineKeyStr = AdjFileBatchImportPlugin.combineStrings(employeeId, orgId, countryId, stdscmId, isprimary);
            log.info("AdjFileBatchImportPlugin beforeSave combineKeyStr:{}", (Object)combineKeyStr);
            List<DynamicObject> keyAdjDyObjList = keyAdjfilenumberMap.get(combineKeyStr);
            if (!CollectionUtils.isEmpty(keyAdjDyObjList)) {
                String errMsg7;
                String msg;
                String keyPersonName = keyAdjDyObjList.get(0).getString("person.name");
                if (null == importAdjFileNumber) {
                    errMsg2 = MessageFormat.format(ResManager.loadKDString((String)"\u5de5\u53f7{0}\uff1a{1}\u7684\u5b9a\u8c03\u85aa\u6863\u6848\u5df2\u5b58\u5728\u7cfb\u7edf\u4e2d\uff0c\u82e5\u9700\u66f4\u65b0\uff0c\u8bf7\u586b\u5199\u6863\u6848\u7f16\u53f7\u3002", (String)"AdjFileBatchImportPlugin_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), personNumber, keyPersonName);
                    this.log(rowData.getStartIndex(), errMsg2, logger);
                    continue;
                }
                String keyEmpnumber = keyAdjDyObjList.get(0).getString("employee.empnumber");
                if (!adjFileNumberMap.containsKey(importAdjFileNumber)) {
                    errMsg = MessageFormat.format(ResManager.loadKDString((String)"\u5de5\u53f7{0}\uff1a{1}\u7684\u5b9a\u8c03\u85aa\u6863\u6848\u7f16\u53f7\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u8bf7\u786e\u8ba4\u5e76\u8c03\u6574\u3002", (String)"AdjFileBatchImportPlugin_19", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), personNumber, keyPersonName);
                    this.log(rowData.getStartIndex(), errMsg, logger);
                    continue;
                }
                if (!adjFileNumberPermMap.containsKey(importAdjFileNumber)) {
                    String msg2 = ResManager.loadKDString((String)"\u5de5\u53f7{0}\uff1a{1}\u7684\u5b9a\u8c03\u85aa\u6863\u6848\u4e0d\u5728\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u786e\u8ba4\u5e76\u8c03\u6574\u3002", (String)"AdjFileBatchImportPlugin_15", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                    String errMsg8 = MessageFormat.format(msg2, keyEmpnumber, keyPersonName);
                    this.log(rowData.getStartIndex(), errMsg8, logger);
                    continue;
                }
                DynamicObject keyAdjDyObj = keyAdjDyObjList.stream().filter(obj -> obj.getString("number").equals(importAdjFileNumber)).findFirst().orElse(null);
                String importFileStatus = adjFileNumberMap.get(importAdjFileNumber).getString("status");
                if (keyAdjDyObj == null) {
                    msg = ResManager.loadKDString((String)"\u5de5\u53f7{0}\uff1a{1}\u7684\u5b9a\u8c03\u85aa\u6863\u6848\u7f16\u53f7\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u8bf7\u786e\u8ba4\u5e76\u8c03\u6574\u3002", (String)"AdjFileBatchImportPlugin_8", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                    errMsg7 = MessageFormat.format(msg, keyEmpnumber, keyPersonName);
                    this.log(rowData.getStartIndex(), errMsg7, logger);
                    continue;
                }
                if (SWCStringUtils.equals((String)importFileStatus, (String)"B") || SWCStringUtils.equals((String)importFileStatus, (String)"D") || SWCStringUtils.equals((String)importFileStatus, (String)"E")) {
                    msg = ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u6863\u6848\u7f16\u53f7\uff1a{0}\u53ea\u6709\u5b9a\u8c03\u85aa\u6863\u6848\u72b6\u6001\u4e3a\u6682\u5b58\u3001\u5df2\u5ba1\u6838\u624d\u80fd\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdjFileBatchImportPlugin_6", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                    errMsg7 = MessageFormat.format(msg, importAdjFileNumber);
                    this.log(rowData.getStartIndex(), errMsg7, logger);
                    continue;
                }
                if (SWCStringUtils.equals((String)keyAdjDyObj.getString("enable"), (String)"0") || SWCStringUtils.equals((String)keyAdjDyObj.getString("status"), (String)"C")) {
                    this.setNeedFieldToTargetJson(jsonObject, empnumberDepempMap, empposorgrelMap, "saveafteraudit", keyAdjDyObj);
                    continue;
                }
                this.setNeedFieldToTargetJson(jsonObject, empnumberDepempMap, empposorgrelMap, "save", keyAdjDyObj);
                continue;
            }
            if (!permOrgs.hasAllOrgPerm()) {
                List hasPermOrgs = permOrgs.getHasPermOrgs();
                log.info("adjfile import permOrgs = {}", (Object)hasPermOrgs);
                if (orgId != null && !hasPermOrgs.contains(Long.valueOf(orgId))) {
                    String msg = ResManager.loadKDString((String)"\u5de5\u53f7{0}\uff1a{1}\u7684\u5b9a\u8c03\u85aa\u6863\u6848\u4e0d\u5728\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u786e\u8ba4\u5e76\u8c03\u6574\u3002", (String)"AdjFileBatchImportPlugin_15", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                    errMsg = MessageFormat.format(msg, personNumber, empnumberEmployDysMap.get(personNumber).get(0).getString("person.name"));
                    this.log(rowData.getStartIndex(), errMsg, logger);
                    continue;
                }
            }
            if (!((Set)biznumberMap.get(personNumber)).contains(biznumber)) {
                String msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u7f16\u7801\uff1a{0}\u975e{1}\uff08{2}\uff09\u7684\u4e1a\u52a1\u7f16\u7801\uff0c\u8bf7\u786e\u8ba4\u5e76\u8c03\u6574\u3002", (String)"AdjFileBatchImportPlugin_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                errMsg2 = MessageFormat.format(msg, biznumber, empnumberEmployDysMap.get(personNumber).get(0).getString("person.name"), personNumber);
                this.log(rowData.getStartIndex(), errMsg2, logger);
            }
            this.setNeedFieldToTargetJson(jsonObject, empnumberDepempMap, empposorgrelMap, "save", null);
        }
        long end = System.currentTimeMillis();
        log.info("AdjFileBatchImportPlugin #beforesave,currentDataSize is:{}, spend time is\uff1a{}", (Object)billdatas.size(), (Object)(end - start));
    }

    private boolean checkParamRepeat(ImportLogger logger, Map<String, List<DynamicObject>> empnumberEmployDysMap, ImportBillData rowData, String personNumber) {
        AdjFileImportEntity entity = this.assembleAdjFileImportEntity(rowData);
        if (this.sameData.contains(entity)) {
            String repeatMsg = ResManager.loadKDString((String)"\u5de5\u53f7{0}\uff1a{1}\u5df2\u5b58\u5728\u76f8\u540c\u201c\u4e1a\u52a1\u7f16\u7801\u201d\u3001\u201c\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u201d\u3001\u201c\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u201d\u3001\u201c\u5c5e\u5730\u5458\u5de5\u7c7b\u522b\u201d\u3001\u201c\u85aa\u916c\u4f53\u7cfb\u201d\u3001\u201c\u6302\u9760\u884c\u653f\u7ec4\u7ec7\u201d\u3001\u201c\u85aa\u916c\u7ba1\u7406\u4eba\u5458\u7ec4\u201d\u3001\u201c\u6863\u6848\u751f\u6548\u65e5\u671f\u201d\u7684\u5b9a\u8c03\u85aa\u6863\u6848\uff0c\u4e0d\u80fd\u91cd\u590d\u65b0\u589e\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileBatchImportPlugin_10", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            String errMsg = MessageFormat.format(repeatMsg, personNumber, empnumberEmployDysMap.get(personNumber).get(0).getString("person.name"));
            this.log(rowData.getStartIndex(), errMsg, logger);
            return true;
        }
        this.sameData.add(entity);
        return false;
    }

    private void setNeedFieldToTargetJson(JSONObject jsonObject, Map<String, DynamicObject> empnumberDepempMap, Map<String, DynamicObject> empposorgrelMap, String opType, DynamicObject keyAdjDyObj) {
        DynamicObject empposorgrel;
        JSONObject person = jsonObject.getJSONObject("person");
        String personNumber = person.getString("number");
        String biznumber = jsonObject.getString("biznumber");
        String combineStrings = AdjFileBatchImportPlugin.combineStrings(personNumber, biznumber);
        if (!SWCObjectUtils.isEmpty(empposorgrelMap) && !SWCObjectUtils.isEmpty((Object)(empposorgrel = empposorgrelMap.get(combineStrings)))) {
            String empposorgrelId = empposorgrel.getString("id");
            String employeeId = empposorgrel.getString("employee.id");
            String depempId = empposorgrel.getString("depemp.id");
            jsonObject.put("empposorgrel", (Object)this.buildJsonObjectWithProp(empposorgrelId, "id"));
            String jobId = empposorgrel.getString("job.id");
            if (SWCStringUtils.isNotEmpty((String)jobId) && !jobId.trim().equals("0")) {
                jsonObject.put("job", (Object)this.buildJsonObjectWithProp(jobId, "id"));
            }
            jsonObject.put("employee", (Object)this.buildJsonObjectWithProp(employeeId, "id"));
            jsonObject.put("depemp", (Object)this.buildJsonObjectWithProp(depempId, "id"));
            String personId = empposorgrel.getString("person.id");
            person.put("importprop", (Object)"id");
            person.put("id", (Object)personId);
            boolean isprimary = empposorgrel.getBoolean("isprimary");
            jsonObject.put("isprimary", (Object)isprimary);
            int adjType = AdjFileTypeEnum.getTypeByIsPrimary((boolean)isprimary);
            jsonObject.put("type", (Object)adjType);
            log.info("AdjFileBatchImportPlugin empposorgrel params\uff1apersonNumber is{}\u3001biznumber is{}\u3001empposorgrelId is:{}\u3001jobId is:{}\u3001employeeId is:{}\u3001depempId is:{}\u3001personId is:{}\u3001adjType is:{}", new Object[]{personNumber, biznumber, empposorgrelId, jobId, employeeId, depempId, personId, adjType});
            Date bsed = jsonObject.getDate("bsed");
            if (ObjectUtils.isEmpty((Object)bsed)) {
                jsonObject.put("bsed", (Object)empposorgrel.getDate("startdate"));
            }
            String positionIdStr = empposorgrel.getString("position.id");
            jsonObject.put("position", (Object)this.buildJsonObjectWithProp(positionIdStr, "id"));
            log.info("position id is:{}", (Object)positionIdStr);
            String adminorgNumber = empposorgrel.getString("adminorg.number");
            JSONObject assoadminorg = jsonObject.getJSONObject("assoadminorg");
            if (ObjectUtils.isEmpty((Object)assoadminorg)) {
                jsonObject.put("assoadminorg", (Object)this.buildJsonObjectWithProp(adminorgNumber, "number"));
            }
            jsonObject.put("adminorg", (Object)this.buildJsonObjectWithProp(adminorgNumber, "number"));
            log.info("adminorg number is:{}", (Object)adminorgNumber);
            String assoAdminorgNumber = jsonObject.getJSONObject("assoadminorg").getString("number");
            log.info(" assoadminorg number is: {}", (Object)assoAdminorgNumber);
            jsonObject.put("escrowstaff", (Object)Boolean.FALSE);
            if (StringUtils.isNotBlank((CharSequence)adminorgNumber) && StringUtils.isNotBlank((CharSequence)assoAdminorgNumber) && !adminorgNumber.equals(assoAdminorgNumber)) {
                jsonObject.put("escrowstaff", (Object)Boolean.TRUE);
            }
        }
        jsonObject.put("optype", (Object)opType);
        if (null == keyAdjDyObj && "save".equals(opType)) {
            jsonObject.put("number", (Object)" ");
        }
        jsonObject.put("datasource", (Object)AdjFileDataSourceEnum.BATCH.getCode());
        jsonObject.put("biznumber", (Object)biznumber);
        jsonObject.put("dynamicObject", (Object)keyAdjDyObj);
    }

    private JSONObject buildJsonObjectWithProp(String id, String prop) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(prop, (Object)id);
        jsonObject.put("importprop", (Object)prop);
        return jsonObject;
    }

    private Map<String, List<DynamicObject>> queryAdjFileByPersonIds(Set<Long> personIds) {
        String selectProperties = SWCHisBaseDataHelper.getSelectProperties((MainEntityType)this.mainEntityType);
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
        filter.and(new QFilter("status", "!=", (Object)"E"));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] adjfileinfos = this.queryBatchByLongs("hcdm_adjfileinfo", selectProperties, "employee.id", personIds, filter);
        Map<String, List<DynamicObject>> collectIds = Arrays.stream(adjfileinfos).collect(Collectors.groupingBy(object -> AdjFileBatchImportPlugin.combineStrings(object.getString("employee.id"), object.getString("org.id"), object.getString("country.id"), object.getString("stdscm.id"), object.getString("isprimary"))));
        log.info("AdjFileBatchImportPlugin queryAdjFileByPersonIds:{}", collectIds);
        return collectIds;
    }

    private DynamicObject[] queryDepemp(Set<Long> personIds) {
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
        return this.queryBatchByLongs("hrpi_depemp", "id,number,person,employee,adminorg", "employee.id", personIds, filter);
    }

    private AdjFileImportEntity assembleAdjFileImportEntity(ImportBillData billData) {
        JSONObject jsonObject = billData.getData();
        String personNumber = jsonObject.getJSONObject("person").getString("number");
        String orgName = jsonObject.getJSONObject("org").getString("name");
        String countryName = jsonObject.getJSONObject("country").getString("name");
        String stdscmName = jsonObject.getJSONObject("stdscm").getString("name");
        String biznumber = jsonObject.getString("biznumber");
        String depcytypeName = jsonObject.getJSONObject("depcytype").getString("name");
        String adminorgNumber = jsonObject.getJSONObject("assoadminorg") == null ? "" : jsonObject.getJSONObject("assoadminorg").getString("number");
        String empgroupName = jsonObject.getJSONObject("empgroup").getString("name");
        String bsed = jsonObject.getString("bsed");
        return new AdjFileImportEntity(personNumber, orgName, countryName, stdscmName, biznumber, depcytypeName, adminorgNumber, empgroupName, bsed);
    }

    private Map<String, List<DynamicObject>> queryEmployeePerson(Set<String> personNumbers, Set<String> personNames, Map<String, DynamicObject> employPersonMap) {
        if (personNumbers != null && personNumbers.size() > 0) {
            QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
            DynamicObject[] persons = this.queryBatch("hrpi_employee", "id,person,empnumber", "empnumber", personNumbers, filter);
            return Arrays.stream(persons).collect(Collectors.groupingBy(dy -> dy.getString("empnumber")));
        }
        if (personNames != null && personNames.size() > 0) {
            QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
            DynamicObject[] persons = this.queryBatch("hrpi_employee", "id,person,empnumber", "person.name", personNames, filter);
            employPersonMap.putAll(Arrays.stream(persons).collect(Collectors.toMap(object -> object.getString("person.name"), Function.identity(), (a1, b1) -> b1)));
            return Arrays.stream(persons).collect(Collectors.groupingBy(dy -> dy.getString("empnumber")));
        }
        return Maps.newHashMapWithExpectedSize((int)16);
    }

    private Map<String, List<DynamicObject>> querySalayStructure(Set<String> countrySet, Set<String> countryNumberSet) {
        if (countryNumberSet != null && countryNumberSet.size() > 0) {
            DynamicObject[] persons = this.queryBatch("hcdm_salaystructure", "id, country.name, name", "country.number", countryNumberSet, null);
            return Arrays.stream(persons).collect(Collectors.groupingBy(o1 -> o1.getString("country.name")));
        }
        if (countrySet != null && countrySet.size() > 0) {
            DynamicObject[] persons = this.queryBatch("hcdm_salaystructure", "id, country.name, name", "country.name", countrySet, null);
            return Arrays.stream(persons).collect(Collectors.groupingBy(o1 -> o1.getString("country.name")));
        }
        return Maps.newHashMapWithExpectedSize((int)16);
    }

    private String dataRepeatPropertyMsg(DynamicObjectType dynamicObjectType, String ... propertyNames) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            if (i != propertyNames.length - 1) {
                sb.append('\u201c').append(dynamicObjectType.getProperty(propertyName).getDisplayName()).append("\u201d\u3001");
                continue;
            }
            sb.append('\u201c').append(dynamicObjectType.getProperty(propertyName).getDisplayName()).append('\u201d');
        }
        return sb.toString();
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        long start = System.currentTimeMillis();
        log.info("-----------save()-----------------begin");
        ArrayList<ImportRowEntity> rowInfoList = new ArrayList<ImportRowEntity>(rowdatas.size());
        for (ImportBillData rowData : rowdatas) {
            Map logCache = logger.getLogCache();
            List logList = (List)logCache.get(rowData.getStartIndex());
            if (logList != null && logList.size() > 0) {
                logger.fail();
                continue;
            }
            rowInfoList.add(new ImportRowEntity(rowData.getStartIndex(), rowData.getEndIndex(), rowData.getData()));
        }
        MainEntityType mainEntityType = super.buildMainEntityType(null);
        if (rowInfoList.isEmpty()) {
            return null;
        }
        long start1 = System.currentTimeMillis();
        ImportDataConvertToDyObjHelper convertToDyObj = new ImportDataConvertToDyObjHelper(this.getImportDataLogger());
        convertToDyObj.assembleImportData(mainEntityType, rowInfoList, logger);
        long end1 = System.currentTimeMillis();
        log.info("AdjFileBatchImportPlugin #assembleImportData,currentDataSize is:{}, spend time is\uff1a{}", (Object)rowdatas.size(), (Object)(end1 - start1));
        rowInfoList = ImportDataLoggerHelper.filterImportableData((MainEntityType)mainEntityType, rowInfoList, (ImportLogger)logger);
        rowInfoList = this.verifyAddOrUpdateImport(rowInfoList, mainEntityType, logger);
        rowInfoList = this.validateImportData(mainEntityType.getName(), rowInfoList, logger);
        this.executeImport(rowInfoList, logger);
        this.dealLogger(rowdatas, logger);
        log.info("logger delRows size is: {}", (Object)logger.getDelRows().size());
        long end = System.currentTimeMillis();
        this.totalSpendTime += end - start;
        this.totalImportCount += (long)rowdatas.size();
        log.info("AdjFileBatchImportPlugin #save,totaldata is:{}, spend time is\uff1a{}", (Object)this.totalImportCount, (Object)this.totalSpendTime);
        log.info("-----------save()-----------------end");
        return null;
    }

    private void executeImport(List<ImportRowEntity> rowInfoList, ImportLogger logger) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("opType", "insert");
        operateOption.setVariableValue("coderule_billno_from_initAbstractCodeRule", "coderule_billno_from_init_value_of_operation");
        ImportDataOperation dataOperation = new ImportDataOperation(operateOption, "status");
        dataOperation.executeImportData(this.mainEntityType, rowInfoList, this.ctx, logger);
    }

    @Override
    public boolean validateStatus(ImportLogger logger, ImportRowEntity rowInfo, DynamicObject entityDyobj) {
        return true;
    }

    private List<ImportRowEntity> validateImportData(String entityId, List<ImportRowEntity> rowInfoList, ImportLogger logger) {
        AdjFileImportDataValidator importDataValidator = new AdjFileImportDataValidator(rowInfoList, entityId, logger, this.getImportDataLogger());
        ((AbstractImportDataValidator)importDataValidator).validate();
        return ImportDataLoggerHelper.filterImportableData((MainEntityType)this.mainEntityType, rowInfoList, (ImportLogger)logger);
    }

    private ValidateDataResults validateNewAdjFile(JSONObject jsonObject, long personId) {
        ValidateDataResults results = new ValidateDataResults();
        String orgName = jsonObject.getJSONObject("org").getString("name");
        long orgId = this.queryEntryId(BOS_ORG, "name", orgName);
        String countryName = jsonObject.getJSONObject("country").getString("name");
        long countryId = this.queryEntryId("bd_country", "name", countryName);
        String stdScmName = jsonObject.getJSONObject("stdscm").getString("name");
        long stdscmId = this.queryEntryId("hcdm_stdscm", "name", stdScmName);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        QFilter qFilter = new QFilter("person", "=", (Object)personId);
        qFilter.and(new QFilter("org", "=", (Object)orgId));
        qFilter.and(new QFilter("country", "=", (Object)countryId));
        qFilter.and(new QFilter("stdscm", "=", (Object)stdscmId));
        BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject[] dyObjs = helper.query("id, number, person, org, country, stdscm, type", qFilters);
        if (dyObjs.length == 0) {
            results.setSuccess(true);
        } else {
            results.setSuccess(false);
            results.setAdjFileInfoDyObj(dyObjs[0]);
        }
        return results;
    }

    private long queryEntryId(String EntryId, String propertie, String value) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(EntryId);
        QFilter qFilter = new QFilter(propertie, "=", (Object)value);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject dynamicObject = helper.queryOne(qFilters);
        if (dynamicObject == null) {
            return 0L;
        }
        return dynamicObject.getLong("id");
    }

    private DynamicObject queryOne(String entryId, String selectProperties, String fieldName, String value, QFilter filter) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entryId);
        QFilter qFilter = new QFilter(fieldName, "=", (Object)value);
        if (filter != null) {
            qFilter.and(filter);
        }
        QFilter[] qFilters = new QFilter[]{qFilter};
        return helper.queryOne(selectProperties, qFilters);
    }

    private DynamicObject[] queryBatchByLongs(String entryId, String selectProperties, String fieldName, Set<Long> longValues, QFilter filter) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entryId);
        QFilter qFilter = new QFilter(fieldName, "in", longValues);
        if (filter != null) {
            qFilter.and(filter);
        }
        QFilter[] qFilters = new QFilter[]{qFilter};
        return helper.query(selectProperties, qFilters);
    }

    private Map<String, List<DynamicObject>> queryCountryInfo(Set<String> countrySet, Set<String> countryNumberSet, Map<String, String> countryIdMap, Map<String, String> countryMap) {
        if (countryNumberSet != null && countryNumberSet.size() > 0) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("bd_country");
            QFilter filter = new QFilter("number", "in", countryNumberSet);
            Object[] countrys = helper.query("name,number", new QFilter[]{filter});
            if (ArrayUtils.isEmpty((Object[])countrys)) {
                return Maps.newHashMapWithExpectedSize((int)0);
            }
            countryMap.putAll(Arrays.stream(countrys).collect(Collectors.toMap(o1 -> o1.getString("number"), v1 -> v1.getString("name"))));
            countryIdMap.putAll(Arrays.stream(countrys).collect(Collectors.toMap(o1 -> o1.getString("name"), v1 -> v1.getString("id"))));
            return Arrays.stream(countrys).collect(Collectors.groupingBy(o1 -> o1.getString("number")));
        }
        if (countrySet != null && countrySet.size() > 0) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("bd_country");
            QFilter filter = new QFilter("name", "in", countrySet);
            Object[] countrys = helper.query("name", new QFilter[]{filter});
            if (ArrayUtils.isEmpty((Object[])countrys)) {
                return Maps.newHashMapWithExpectedSize((int)0);
            }
            countryMap.putAll(Arrays.stream(countrys).collect(Collectors.toMap(o1 -> o1.getString("number"), v1 -> v1.getString("name"))));
            countryIdMap.putAll(Arrays.stream(countrys).collect(Collectors.toMap(o1 -> o1.getString("name"), v1 -> v1.getString("id"))));
            return Arrays.stream(countrys).collect(Collectors.groupingBy(o1 -> o1.getString("name")));
        }
        return Maps.newHashMapWithExpectedSize((int)0);
    }

    private Map<String, String> queryStdScm(Set<String> stdScmNameSet, Set<String> stdScmNumberSet, Map<String, String> stdscmIdMap) {
        if (stdScmNumberSet != null && stdScmNumberSet.size() > 0) {
            SWCDataServiceHelper stdScmHelper = new SWCDataServiceHelper("hcdm_stdscm");
            QFilter filter = new QFilter("number", "in", stdScmNumberSet);
            filter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
            filter.and("enable", "=", (Object)"1");
            filter.and("status", "=", (Object)"C");
            Object[] stdScmDynamics = stdScmHelper.query("name,number", new QFilter[]{filter});
            if (ArrayUtils.isEmpty((Object[])stdScmDynamics)) {
                return Maps.newHashMapWithExpectedSize((int)0);
            }
            stdscmIdMap.putAll(Arrays.stream(stdScmDynamics).collect(Collectors.toMap(o1 -> o1.getString("name"), v1 -> v1.getString("id"))));
            return Arrays.stream(stdScmDynamics).collect(Collectors.toMap(o1 -> o1.getString("number"), v1 -> v1.getString("name")));
        }
        if (stdScmNameSet != null && stdScmNameSet.size() > 0) {
            SWCDataServiceHelper stdScmHelper = new SWCDataServiceHelper("hcdm_stdscm");
            QFilter filter = new QFilter("name", "in", stdScmNameSet);
            filter.and("enable", "=", (Object)"1");
            filter.and("status", "=", (Object)"C");
            filter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
            Object[] stdScmDynamics = stdScmHelper.query("name,number", new QFilter[]{filter});
            if (ArrayUtils.isEmpty((Object[])stdScmDynamics)) {
                return Maps.newHashMapWithExpectedSize((int)0);
            }
            stdscmIdMap.putAll(Arrays.stream(stdScmDynamics).collect(Collectors.toMap(o1 -> o1.getString("name"), v1 -> v1.getString("id"))));
            return Arrays.stream(stdScmDynamics).collect(Collectors.toMap(o1 -> o1.getString("number"), v1 -> v1.getString("name")));
        }
        return Maps.newHashMapWithExpectedSize((int)0);
    }

    private Map<String, String> queryOrgByNumber(Set<String> countrySet, Map<String, String> orgIdMap) {
        SWCDataServiceHelper orgHelper = new SWCDataServiceHelper(BOS_ORG);
        QFilter filter = new QFilter("number", "in", countrySet);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        DynamicObject[] orgDynamics = orgHelper.query("name,number", new QFilter[]{filter});
        orgIdMap.putAll(Arrays.stream(orgDynamics).collect(Collectors.toMap(k1 -> k1.getString("number"), v1 -> v1.getString("id"))));
        return Arrays.stream(orgDynamics).collect(Collectors.toMap(o1 -> o1.getString("number"), v1 -> v1.getString("name")));
    }

    private Map<String, String> queryOrg(Set<String> orgNumberSet, Set<String> orgNameSet, Map<String, String> orgIdMap) {
        if (orgNumberSet != null && orgNumberSet.size() > 0) {
            SWCDataServiceHelper orgHelper = new SWCDataServiceHelper(BOS_ORG);
            QFilter filter = new QFilter("number", "in", orgNumberSet);
            filter.and("enable", "=", (Object)"1");
            filter.and("status", "=", (Object)"C");
            Object[] orgDynamics = orgHelper.query("name,number", new QFilter[]{filter});
            if (ArrayUtils.isEmpty((Object[])orgDynamics)) {
                return Maps.newHashMapWithExpectedSize((int)0);
            }
            orgIdMap.putAll(Arrays.stream(orgDynamics).collect(Collectors.toMap(k1 -> k1.getString("name"), v1 -> v1.getString("id"), (v1, v2) -> v1)));
            return Arrays.stream(orgDynamics).collect(Collectors.toMap(o1 -> o1.getString("number"), v1 -> v1.getString("name")));
        }
        if (orgNameSet != null && orgNameSet.size() > 0) {
            SWCDataServiceHelper orgHelper = new SWCDataServiceHelper(BOS_ORG);
            QFilter filter = new QFilter("name", "in", orgNameSet);
            filter.and("enable", "=", (Object)"1");
            filter.and("status", "=", (Object)"C");
            Object[] orgDynamics = orgHelper.query("name,number", new QFilter[]{filter});
            if (ArrayUtils.isEmpty((Object[])orgDynamics)) {
                return Maps.newHashMapWithExpectedSize((int)0);
            }
            orgIdMap.putAll(Arrays.stream(orgDynamics).collect(Collectors.toMap(k1 -> k1.getString("name"), v1 -> v1.getString("id"), (v1, v2) -> v1)));
            return Arrays.stream(orgDynamics).collect(Collectors.toMap(o1 -> o1.getString("number"), v1 -> v1.getString("name")));
        }
        return Maps.newHashMapWithExpectedSize((int)0);
    }

    private Map<String, MultiLangEnumBridge> getMustColMapMap() {
        HashMap<String, MultiLangEnumBridge> mustColMap = new HashMap<String, MultiLangEnumBridge>(16);
        mustColMap.put("person", new MultiLangEnumBridge("\u4eba\u5458", "AdjFileBatchImportPlugin_26", "swc-hcdm-formplugin"));
        mustColMap.put("org", new MultiLangEnumBridge("\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7", "AdjFileBatchImportPlugin_27", "swc-hcdm-formplugin"));
        mustColMap.put("country", new MultiLangEnumBridge("\u85aa\u916c\u7ba1\u7406\u5c5e\u5730", "AdjFileBatchImportPlugin_28", "swc-hcdm-formplugin"));
        mustColMap.put("stdscm", new MultiLangEnumBridge("\u85aa\u916c\u4f53\u7cfb", "AdjFileBatchImportPlugin_29", "swc-hcdm-formplugin"));
        mustColMap.put("empgroup", new MultiLangEnumBridge("\u85aa\u916c\u7ba1\u7406\u4eba\u5458\u7ec4", "AdjFileBatchImportPlugin_30", "swc-hcdm-formplugin"));
        mustColMap.put("depcytype", new MultiLangEnumBridge("\u5c5e\u5730\u5458\u5de5\u7c7b\u522b", "AdjFileBatchImportPlugin_31", "swc-hcdm-formplugin"));
        return mustColMap;
    }

    static class ValidateDataResults {
        private boolean isSuccess = true;
        private DynamicObject adjFileInfoDyObj;

        ValidateDataResults() {
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public void setSuccess(boolean success) {
            this.isSuccess = success;
        }

        public DynamicObject getAdjFileInfoDyObj() {
            return this.adjFileInfoDyObj;
        }

        public void setAdjFileInfoDyObj(DynamicObject adjFileInfoDyObj) {
            this.adjFileInfoDyObj = adjFileInfoDyObj;
        }
    }
}

