/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjfile.imports;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hcdm.business.imports.IImportDataLogger;
import kd.swc.hcdm.business.imports.ImportDataConvertToDyObjHelper;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.common.entity.adjfile.ImportRowEntity;
import kd.swc.hcdm.formplugin.imports.validate.ImportDataValidator;

public class AdjFileImportDataValidator
extends ImportDataValidator {
    private static final Log log = LogFactory.getLog(AdjFileImportDataValidator.class);

    public AdjFileImportDataValidator(List<ImportRowEntity> importableRowInfos, String entityId, ImportLogger logger, IImportDataLogger iImportDataLogger) {
        super(importableRowInfos, entityId, logger, iImportDataLogger);
    }

    @Override
    public void validate() {
        super.validateTemplate();
        this.validateEmpgroup();
    }

    private void validateEmpgroup() {
        List ids = SalaryAdjFileServiceHelper.queryEmpGroup();
        if (CollectionUtils.isEmpty((Collection)ids)) {
            log.error("getEmpgroupByhcdm is null");
        }
        for (ImportRowEntity rowInfo : this.importableRowInfos) {
            int rowIndex = rowInfo.getRowIndex();
            JSONObject importJsonData = rowInfo.getData();
            DynamicObject dataEntity = rowInfo.getEntityDyobj(this.entityId);
            DynamicObjectType dataDyObjType = dataEntity.getDynamicObjectType();
            DynamicObject empGroupDyObj = dataEntity.getDynamicObject("empgroup");
            Long empGroupId = empGroupDyObj.getLong("id");
            log.error("empGroupId is\uff1a{}", (Object)empGroupId);
            if (ids.contains(empGroupId)) continue;
            DynamicProperty prop = dataDyObjType.getProperty("empgroup");
            JSONObject empGroupDataJson = importJsonData.getJSONObject("empgroup");
            String importPropKey = empGroupDataJson.getString("importprop");
            this.iImportDataLogger.logger(dataEntity, rowIndex, ImportDataConvertToDyObjHelper.getBasedNoMatchMsg((DynamicProperty)prop, (String)importPropKey), this.logger);
        }
    }
}

