/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjfile.sidebar;

import java.util.EventObject;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.salaryadjfile.AdjFileFormHelper;
import kd.swc.hsbp.business.relatepanel.RelatePageInfo;
import kd.swc.hsbp.business.relatepanel.SWCRelatePanelSetFactory;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCRelatePageRightDynamicPlugin;
import org.apache.commons.lang3.ObjectUtils;

public class AdjFileRelatePageRightDynamicPlugin
extends SWCRelatePageRightDynamicPlugin {
    private static final Log logger = LogFactory.getLog(AdjFileRelatePageRightDynamicPlugin.class);

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Label) {
            Label curClickLabel = (Label)evt.getSource();
            String labelName = curClickLabel.getKey();
            logger.info("adj file sidebar click: {}", (Object)labelName);
            this.checkRelatedPagePerm(labelName);
            this.showRelatedPage(labelName);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Container container = (Container)this.getControl("flexpanelrelateinfo");
        for (Control control : container.getItems()) {
            Container containerLabel = (Container)control;
            String entityId = ((Control)containerLabel.getItems().get(0)).getKey();
            String fileId = (String)this.getView().getFormShowParameter().getCustomParam("key_custom_param_fileid");
            String mainEntityId = entityId.split("viewhis")[0];
            logger.info("entityId is {}, entityId split after: {}", (Object)entityId, (Object)mainEntityId);
            if (AdjFileFormHelper.hasPerm((String)mainEntityId, (String)fileId)) continue;
            this.getView().setVisible(Boolean.FALSE, new String[]{control.getKey()});
        }
    }

    protected void showRelatedPage(String currentRelatePageName) {
        logger.info("show related page: {}", (Object)currentRelatePageName);
        String currentObjectPKId = null;
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        if (formShowParameter instanceof BaseShowParameter) {
            BaseShowParameter baseShowParameter = (BaseShowParameter)formShowParameter;
            currentObjectPKId = baseShowParameter.getPkId().toString();
        } else {
            currentObjectPKId = (String)formShowParameter.getCustomParam("currentObjectPKId");
        }
        String reateEntityTypeId = (String)formShowParameter.getCustomParam("hsbs_entitytype_id");
        String caption = (String)formShowParameter.getCustomParam("caption");
        Map pageIconMap = (Map)formShowParameter.getCustomParam("pageIcons");
        Map customVariablesMap = (Map)formShowParameter.getCustomParam("customvariables");
        Map customPKFilterMap = (Map)formShowParameter.getCustomParam("customPKFilter");
        Object isHistoryPage = formShowParameter.getCustomParam("isHistoryPage");
        FormShowParameter pageFormShowParameter = new FormShowParameter();
        pageFormShowParameter.setCustomParam("currentRelatePage", (Object)currentRelatePageName);
        pageFormShowParameter.setCustomParam("currentObjectPKId", (Object)currentObjectPKId);
        pageFormShowParameter.setCustomParam("hsbs_entitytype_id", (Object)reateEntityTypeId);
        pageFormShowParameter.setCustomParam("pageIcons", (Object)pageIconMap);
        pageFormShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        pageFormShowParameter.setCustomParam("customvariables", (Object)customVariablesMap);
        pageFormShowParameter.setCustomParam("customPKFilter", (Object)customPKFilterMap);
        if (ObjectUtils.isNotEmpty((Object)isHistoryPage)) {
            pageFormShowParameter.setCustomParam("isHistoryPage", isHistoryPage);
        }
        pageFormShowParameter.setCustomParam("isRelatedInfo", (Object)Boolean.TRUE);
        pageFormShowParameter.setCustomParam("key_custom_param_fileid", formShowParameter.getCustomParam("key_custom_param_fileid"));
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsbs_entitytype");
        QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(reateEntityTypeId));
        QFilter[] idFilterArray = new QFilter[]{idFilter};
        DynamicObject entityTypeDynamicObj = serviceHelper.queryOne("id,name,relatepageinfo", idFilterArray);
        String relatePageName = entityTypeDynamicObj.getDynamicObject("relatepageinfo").getString("number");
        pageFormShowParameter.setFormId(relatePageName);
        if (!SWCStringUtils.isEmpty((String)caption)) {
            pageFormShowParameter.setCaption(caption);
        }
        view.showForm(pageFormShowParameter);
    }

    private void checkRelatedPagePerm(String labelName) {
        RelatePageInfo relatePageInfo = this.getRelatePageInfo(labelName);
        if (null != relatePageInfo) {
            this.checkPermission("47150e89000000ac", ResManager.loadKDString((String)"\u67e5\u770b", (String)"AdjFileRelatePageRightDynamicPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), relatePageInfo);
        }
    }

    private void checkPermission(String permItemId, String opName, RelatePageInfo relatePageInfo) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        boolean hasPerm = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"0VO5EV13=I9W", (String)relatePageInfo.getPageNumber(), (String)permItemId);
        if (!hasPerm) {
            throw new KDBizException(SWCPermissionServiceHelper.getNoPermTips((String)opName));
        }
    }

    private RelatePageInfo getRelatePageInfo(String labelName) {
        String relateEntityTypeId = (String)this.getView().getFormShowParameter().getCustomParam("hsbs_entitytype_id");
        return SWCRelatePanelSetFactory.getRelatePageInfo((String)relateEntityTypeId, (String)labelName, (Long)0L);
    }
}

