/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjfile.sidebar;

import java.util.Collections;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class FileSideListViewPlugin
extends AbstractFormPlugin {
    private static final String FLEX_LIST = "flexlist";
    private static final String FLEX_EMPTY = "flexempty";
    private static final Log logger = LogFactory.getLog(FileSideListViewPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "tblrefresh": {
                Boolean isShowLogicdelete = (Boolean)this.getModel().getValue("isshowlogicdelete");
                this.showFormView(isShowLogicdelete);
                break;
            }
            case "tbldelete": {
                this.deleteHisList();
                break;
            }
        }
    }

    private void deleteHisList() {
        IFormView view = this.getView();
        SWCPageCache pageCache = new SWCPageCache(view);
        String flexListId = (String)pageCache.get(FLEX_LIST, String.class);
        if (SWCStringUtils.isEmpty((String)flexListId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"FileSideListViewPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            return;
        }
        IFormView listView = view.getView(flexListId);
        if (listView instanceof IListView) {
            listView.invokeOperation("donothing_delete");
            view.sendFormAction(listView);
        } else {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"FileSideListViewPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Boolean isShowLogicdelete = (Boolean)this.getModel().getValue("isshowlogicdelete");
        if (null != isShowLogicdelete) {
            this.showFormView(isShowLogicdelete);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        if (SWCStringUtils.equals((String)"isshowlogicdelete", (String)args.getProperty().getName())) {
            this.showFormView((Boolean)args.getChangeSet()[0].getNewValue());
        }
    }

    private void showFormView(boolean isShowLogicdelete) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageName = (String)formShowParameter.getCustomParam("currentRelatePage");
        logger.info("file side list view: {}", (Object)pageName);
        String boStr = (String)formShowParameter.getCustomParam("key_custom_param_fileid");
        Long bo = Long.valueOf(boStr);
        Object isHistoryPage = formShowParameter.getCustomParam("isHistoryPage");
        if (ObjectUtils.isNotEmpty((Object)isHistoryPage)) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjfileinfo");
            DynamicObject adjFileVersionDy = helper.queryOne((Object)bo);
            bo = adjFileVersionDy.getLong("boid");
        }
        IFormView view = this.getView();
        boolean isExists = this.dataIsExists(pageName, bo, isShowLogicdelete);
        if (isExists) {
            this.showTargetList(pageName, bo, isShowLogicdelete);
        } else {
            this.showEmptyPage();
        }
        view.setVisible(Boolean.valueOf(!isExists), new String[]{FLEX_EMPTY});
        view.setVisible(Boolean.valueOf(isExists), new String[]{FLEX_LIST});
    }

    private boolean dataIsExists(String pageName, Long bo, boolean isShowLogicdelete) {
        return new SWCDataServiceHelper(pageName).isExists(new QFilter[]{this.getListQFilter(pageName, bo, isShowLogicdelete)});
    }

    private void showEmptyPage() {
        IFormView view = this.getView();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hcdm_emptypage");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(FLEX_EMPTY);
        view.showForm(showParameter);
    }

    private void showTargetList(String pageName, Long bo, boolean isShowLogicdelete) {
        IFormView view = this.getView();
        if (!SWCStringUtils.isEmpty((String)pageName)) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(FLEX_LIST);
            showParameter.setFormId("hsbp_nosearch_list");
            showParameter.setBillFormId(pageName);
            showParameter.setLookUp(false);
            QFilter qFilter = this.getListQFilter(pageName, bo, isShowLogicdelete);
            if (null != qFilter) {
                ListFilterParameter filterParams = showParameter.getListFilterParameter();
                filterParams.setQFilters(Collections.singletonList(qFilter));
            }
            showParameter.setCustomParam("notOpenDefaultHyperLink", (Object)"number");
            showParameter.setCustomParam("removeHrDatastatusFilter", (Object)Boolean.TRUE);
            showParameter.setCustomParam("option", (Object)"showhisversion");
            showParameter.setCustomParam("hisinfolist", (Object)"hisinfolist");
            QFilter qFilter1 = new QFilter("boid", "=", (Object)bo);
            QFilter qFilter2 = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
            QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
            showParameter.getListFilterParameter().getQFilters().add(qFilter2);
            showParameter.getListFilterParameter().getQFilters().add(qFilter3);
            SWCPageCache pageCache = new SWCPageCache(view);
            pageCache.put(FLEX_LIST, (Object)showParameter.getPageId());
            view.showForm((FormShowParameter)showParameter);
        }
    }

    private QFilter getListQFilter(String pageName, Long bo, boolean isShowLogicdelete) {
        QFilter qFilter = new QFilter("boid", "=", (Object)bo);
        if (!isShowLogicdelete) {
            qFilter.and(new QFilter("datastatus", "!=", (Object)"-2"));
        }
        return qFilter;
    }
}

