/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjfile.sidebar;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.salaryadjfile.AdjFileFormHelper;
import kd.swc.hcdm.business.salaryadjfile.sidebar.FileSidebarService;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class FileSideMulListPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(FileSideMulListPlugin.class);
    private static final String FLEX_LIST = "flexlist";
    private static final String FLEX_EMPTY = "flexempty";
    private static final String HSBP_NOSRCH_TIMELINE_LIST = "hsbp_nosrch_timeline_list";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "donothing_refresh": {
                Boolean isShowLogicdelete = (Boolean)this.getModel().getValue("isshowlogicdelete");
                this.createAndEmbedList(isShowLogicdelete);
                break;
            }
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Boolean isShowLogicdelete = (Boolean)this.getModel().getValue("isshowlogicdelete");
        if (null != isShowLogicdelete) {
            this.createAndEmbedList(isShowLogicdelete);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        if (SWCStringUtils.equals((String)"isshowlogicdelete", (String)args.getProperty().getName())) {
            this.createAndEmbedList((Boolean)args.getChangeSet()[0].getNewValue());
        }
    }

    private void createAndEmbedList(boolean isShowLogicdelete) {
        IFormView view = this.getView();
        String pageName = (String)view.getFormShowParameter().getCustomParam("currentRelatePage");
        Object isHistoryPage = view.getFormShowParameter().getCustomParam("isHistoryPage");
        String fileId = (String)view.getFormShowParameter().getCustomParam("key_custom_param_fileid");
        AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
        List allDateVersion = adjFileApplicationService.getAllDateVersion(Long.valueOf(fileId), isShowLogicdelete, isHistoryPage);
        if (CollectionUtils.isEmpty((Collection)allDateVersion)) {
            LOGGER.info("FileSideMulListPlugin createAndEmbedList allDateVersion isEmpty");
            this.showEmptyPage(FLEX_LIST);
            return;
        }
        if (!SWCStringUtils.isEmpty((String)pageName)) {
            ISWCAppCache appCache = SWCAppCache.get((String)pageName);
            FlexPanelAp flexPanelAp = FileSidebarService.createFlexpanelApNoHis((List)allDateVersion, (ISWCAppCache)appCache, (String)pageName, (String)pageName, (String)FLEX_LIST);
            if (null != flexPanelAp) {
                view.updateControlMetadata(FLEX_LIST, flexPanelAp.createControl());
            }
            this.showEntryHisPage(allDateVersion, pageName, FLEX_LIST);
        }
    }

    public void showEntryHisPage(List<Map<Date, List<DynamicObject>>> allDateVersion, String cacheKey, String panelKey) {
        if (null != allDateVersion && allDateVersion.size() > 0) {
            ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
            for (Map<Date, List<DynamicObject>> dateListMap : allDateVersion) {
                dateListMap.forEach((key, value) -> list.addAll(value));
            }
            Map schoolTypeMap = AdjFileFormHelper.getSchoolType((List)list);
            Map rankStatusMap = AdjFileFormHelper.itemUseRankFlag((List)list);
            for (int i = 0; i < allDateVersion.size(); ++i) {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                listShowParameter.getOpenStyle().setTargetKey(panelKey + i);
                listShowParameter.setFormId(HSBP_NOSRCH_TIMELINE_LIST);
                listShowParameter.setBillFormId(cacheKey);
                listShowParameter.setCustomParam("schoolTypeMap", (Object)schoolTypeMap);
                listShowParameter.setCustomParam("rankStatusMap", (Object)rankStatusMap);
                listShowParameter.setCustomParam("LAST_FLEX", (Object)Boolean.FALSE);
                listShowParameter.setMultiSelect(false);
                if (i == allDateVersion.size() - 1) {
                    listShowParameter.setCustomParam("LAST_FLEX", (Object)Boolean.TRUE);
                }
                Map<Date, List<DynamicObject>> dateListMap = allDateVersion.get(i);
                HashSet ids = Sets.newHashSetWithExpectedSize((int)10);
                HashSet decadjrelpersonIds = Sets.newHashSetWithExpectedSize((int)10);
                HashSet adjFileIds = Sets.newHashSetWithExpectedSize((int)10);
                dateListMap.forEach((key, value) -> {
                    ids.addAll(value.stream().map(object -> object.getLong("id")).collect(Collectors.toSet()));
                    Set salaryadjFileIds = value.stream().map(object -> object.getLong("salaryadjfile.id")).filter(aLong -> aLong > 0L).collect(Collectors.toSet());
                    Set relPersonIds = value.stream().map(object -> object.getLong("relpersonid")).filter(aLong -> aLong > 0L).collect(Collectors.toSet());
                    if (!CollectionUtils.isEmpty(relPersonIds)) {
                        decadjrelpersonIds.addAll(relPersonIds);
                    }
                    if (!CollectionUtils.isEmpty(salaryadjFileIds)) {
                        adjFileIds.addAll(salaryadjFileIds);
                    }
                    listShowParameter.setCustomParam("bsed", (Object)I18nServiceHelper.dateFormat((Date)key));
                });
                QFilter filter = new QFilter("id", "in", (Object)ids);
                if (!CollectionUtils.isEmpty((Collection)decadjrelpersonIds)) {
                    filter.and("hcdm_decadjrelperson.id", "in", (Object)decadjrelpersonIds);
                    filter.and("relpersonid", "in", (Object)decadjrelpersonIds);
                }
                if (!CollectionUtils.isEmpty((Collection)adjFileIds)) {
                    filter.and("salaryadjfile.id", "in", (Object)adjFileIds);
                }
                ListFilterParameter filterParams = listShowParameter.getListFilterParameter();
                filterParams.setQFilters(Collections.singletonList(filter));
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_EMPTY});
            this.getView().setVisible(Boolean.TRUE, new String[]{panelKey});
        } else {
            LOGGER.info("FileSideMulListPlugin createAndEmbedList showEntryHisPage isEmpty");
            this.showEmptyPage(panelKey);
        }
    }

    private void showEmptyPage(String panelKey) {
        FileSidebarService.showEmptyPage((String)FLEX_EMPTY, (IFormView)this.getView());
        this.getView().setVisible(Boolean.FALSE, new String[]{panelKey});
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_EMPTY});
    }
}

