/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjsalsyn;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeExportFileEvent;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.ViewCommonUtil;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.swc.hcdm.business.SalaryStandardSerializationUtils;
import kd.swc.hcdm.business.salaryadjsync.AdjSalarySynHelper;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hcdm.common.enums.AdjSynDetailExportColumnEnum;
import kd.swc.hcdm.common.enums.AdjSynDetailOperationEnum;
import kd.swc.hcdm.formplugin.HCDMBaseFixedFieldListPlugin;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class AdjSalSynDetailListPlugin
extends HCDMBaseFixedFieldListPlugin {
    private static final String LEFT_PX = "0px";
    private static final String RIGHT_PX = "0px";
    private static final String TOP_PX = "0px";
    private static final String BOTTOM_PX = "0px";
    private static final String HEIGHT_PX = "400px";
    private static final String BORDER_LEFT_STYLE = "1px solid #e5e5e5";
    private static final String BORDER_RIGHT_STYLE = "1.5px solid #e5e5e5";
    private static final String BORDER_TOP_STYLE = "1px solid #e5e5e5";
    private static final String BORDER_BOTTOM_STYLE = "1.5px solid #e5e5e5";
    private static final String BILLLIST_AP = "flexpanelap1";
    private static final String TOOLBAR_AP = "toolbarap";
    private static final String CALLBACKID_CONFIRMGIVEUP = "callbackid_confirmgiveup";
    private static final String HRQXX0535 = "2NQ=8HI3ND3L";
    private static Log logger = LogFactory.getLog(AdjSalSynDetailListPlugin.class);
    private static final String FIELD_MAPPING_VALUE = "fieldMappingValue";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{TOOLBAR_AP});
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        Object obj = SWCSalaryParameterServiceHelper.getSalaryParam((String)"adjsalsyn", (String)"enablerange");
        if (obj == null || SWCStringUtils.equals((String)"3", (String)obj.toString())) {
            args.setCancelMessage(ResManager.loadKDString((String)"\u85aa\u916c\u57fa\u7840\u670d\u52a1\u672a\u542f\u7528\uff0c\u65e0\u6cd5\u6253\u5f00\u201c\u5b9a\u8c03\u85aa\u6570\u636e\u96c6\u6210\u201d\u9875\u9762\u3002", (String)"AdjSalSyn_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long primaryKeyValue = Long.parseLong(parameter.getCustomParam("pkid").toString());
        QFilter synIdFilter = new QFilter("adjsalsyn", "=", (Object)primaryKeyValue);
        List filters = event.getQFilters();
        filters.add(synIdFilter);
    }

    public void beforeBindData(EventObject eventObject) {
        this.updateAdjSalSynDetailListMetedatas();
        this.updateAdjSalSynDetailToolBarMetedatas();
        this.setUserDefaultSetting();
    }

    private void setUserDefaultSetting() {
        BillList billList = (BillList)this.getControl("billlistap");
        List listFieldsControlColumns = billList.getListFieldsControlColumns();
        ArrayList listColumns = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)listFieldsControlColumns)) {
            for (IListColumn listFieldsColumn : billList.getShowListColumns()) {
                HashMap<String, Object> listColumn = new HashMap<String, Object>();
                listColumn.put("class", listFieldsColumn.getClass().getName());
                listColumn.put("caption", listFieldsColumn.getCaption().getLocaleValue());
                listColumn.put("listFieldKey", listFieldsColumn.getListFieldKey());
                listColumn.put("textAlign", listFieldsColumn.getTextAlign());
                if (!Objects.equals(listFieldsColumn.getWidth(), "0")) {
                    listColumn.put("width", listFieldsColumn.getWidth());
                } else {
                    listColumn.put("width", "");
                }
                if (listFieldsColumn.getListFieldKey().equals("adjsalarysynset.synbizdatatmpl.name") || listFieldsColumn.getListFieldKey().equals("bizitem.number") || listFieldsColumn.getListFieldKey().equals("bizitem.name") || listFieldsColumn.getListFieldKey().equals("bizdatacode")) {
                    listColumn.put("visible", 0);
                } else {
                    listColumn.put("visible", 11);
                }
                listColumn.put("fixed", listFieldsColumn.isFixed());
                listColumn.put("seq", listFieldsColumn.getSeq() + 1);
                listColumns.add(listColumn);
            }
            UserConfigServiceHelper.setSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)billList.getBillFormId(), (String)SerializationUtils.toJsonString(listColumns));
        }
    }

    private void updateAdjSalSynDetailToolBarMetedatas() {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("0px");
        style.setMargin(margin);
        HashMap<String, Map> control = new HashMap<String, Map>();
        control.put("s", style.getStyle());
        this.getView().updateControlMetadata(TOOLBAR_AP, control);
    }

    private void updateAdjSalSynDetailListMetedatas() {
        Style style = new Style();
        Margin margin = this.buildMargin();
        style.setMargin(margin);
        Border border = this.buildBorder();
        style.setBorder(border);
        HashMap control = new HashMap();
        control.put("s", style.getStyle());
        control.put("h", this.buildHeight());
        this.getView().updateControlMetadata(BILLLIST_AP, control);
    }

    private LocaleString buildHeight() {
        LocaleString height = new LocaleString();
        height.setLocaleValue_zh_CN(HEIGHT_PX);
        return height;
    }

    private Border buildBorder() {
        Border border = new Border();
        border.setLeft("1px solid #e5e5e5");
        border.setRight("1.5px solid #e5e5e5");
        border.setTop("1px solid #e5e5e5");
        border.setBottom("1.5px solid #e5e5e5");
        return border;
    }

    private Margin buildMargin() {
        Margin margin = new Margin();
        margin.setLeft("0px");
        margin.setRight("0px");
        margin.setTop("0px");
        margin.setBottom("0px");
        return margin;
    }

    public void packageData(PackageDataEvent event) {
        ColumnDesc columnDesc = (ColumnDesc)event.getSource();
        if ("batchnumber".equals(columnDesc.getKey())) {
            boolean isHasSynDataPerm = SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"hcdm_adjsalsyn", (String)AdjSynDetailOperationEnum.OP_VIEWADJFILE.getPermission());
            if (isHasSynDataPerm) {
                event.setFormatValue((Object)SalaryStandardConstants.LOOKUP_DISPLAY());
            } else {
                event.setFormatValue(null);
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent event) {
        super.beforeShowBill(event);
        BillShowParameter parameter = event.getParameter();
        Long pkId = (Long)parameter.getPkId();
        HashSet longs = Sets.newHashSet((Object[])new Long[]{pkId});
        DynamicObject[] byDetailIds = AdjSalarySynHelper.querySynDetailByDetailIds((Set)longs, null);
        Long adjfileId = byDetailIds[0].getLong("adjfile.id");
        HashSet adjfileIds = Sets.newHashSet((Object[])new Long[]{adjfileId});
        DynamicObject[] adjfileDyObjs = this.queryAdjFileInfoByPermission(adjfileIds);
        MultiLangEnumBridge opName2 = new MultiLangEnumBridge("\u67e5\u770b", "SalaryStandardConstants_6", "swc-hcdm-common");
        if (null != adjfileDyObjs && adjfileDyObjs.length > 0) {
            HashMap customMap = Maps.newHashMapWithExpectedSize((int)16);
            customMap.put("pkid", ((ListView)event.getSource()).getFormShowParameter().getCustomParam("pkid"));
            parameter.setCustomParams((Map)customMap);
            event.getParameter().setStatus(OperationStatus.VIEW);
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"view", (MultiLangEnumBridge)opName2, (String)"", (MultiLangEnumBridge)opName2, (String[])new String[0]);
        } else {
            String errMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u5458\u5de5\u5b9a\u8c03\u85aa\u6570\u636e\u6743\u9650\u3002", (String)"AdjSalSynDetailListPlugin_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u60a8\u6ca1\u6709\u8be5\u5458\u5de5\u5b9a\u8c03\u85aa\u6570\u636e\u6743\u9650\u3002", "AdjSalSynDetailListPlugin_3", "swc-hcdm-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"view", (MultiLangEnumBridge)opName2, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[0]);
            event.setCancel(true);
        }
    }

    private DynamicObject[] queryAdjFileInfoByPermission(Set<Long> adjfileIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        QFilter filter = new QFilter("id", "in", adjfileIds);
        List permissionFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"47150e89000000ac");
        if (permissionFilter != null) {
            logger.info("detail list view permissionFilter: {}", (Object)permissionFilter);
            for (QFilter authFilter : permissionFilter) {
                filter.and(authFilter);
            }
        } else {
            filter.and(new QFilter("1", "!=", (Object)1));
            logger.info("have no right filter to query or export syn detail info.");
        }
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"28", (String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"47150e89000000ac");
        if (!permOrgs.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            logger.info("detail list view permOrgs = {}", (Object)hasPermOrgs);
            QFilter qFilter = new QFilter("org", "in", (Object)hasPermOrgs);
            filter.and(qFilter);
        }
        logger.info("detail list view allfilter = {}", (Object)filter);
        return helper.query("id,number", new QFilter[]{filter});
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent exportEvent) {
        String selectFields = exportEvent.getSelectFields();
        String[] split = StringUtils.split((String)selectFields, (String)",");
        LinkedHashSet temp = Sets.newLinkedHashSetWithExpectedSize((int)(split.length + 10));
        temp.addAll(Arrays.asList(split));
        temp.addAll(Arrays.asList("salaystructure", "amount", "frequency", "currency", "issend", "remark", "salaryadjrecord", "decadjrelperson", "joblevel", "jobgrade", "fieldmappingvalue"));
        exportEvent.setSelectFields(Joiner.on((char)',').join((Iterable)temp));
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent exportEvent) {
        super.afterQueryOfExport(exportEvent);
        DynamicObject[] dataCollection = exportEvent.getQueryValues();
        if (dataCollection == null || dataCollection.length == 0) {
            return;
        }
        Set<Long> adjfileIds = Arrays.stream(dataCollection).map(o1 -> o1.getLong("adjfile.id")).collect(Collectors.toSet());
        DynamicObject[] adjfileDyObjs = this.queryAdjFileInfoByPermission(adjfileIds);
        Set adjfileIdSets = Arrays.stream(adjfileDyObjs).map(o1 -> o1.getLong("id")).collect(Collectors.toSet());
        for (DynamicObject exportData : dataCollection) {
            long adfilId = exportData.getLong("adjfile.id");
            if (adjfileIdSets.contains(adfilId)) continue;
            exportData.set("salaystructure", null);
            exportData.set("amount", null);
            exportData.set("frequency", null);
            exportData.set("currency", null);
            exportData.set("issend", null);
            exportData.set("remark", null);
            exportData.set("salaryadjrecord", null);
            exportData.set("decadjrelperson", null);
            exportData.set("fieldmappingvalue", null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        SWCDataServiceHelper helper;
        Object[] hasPermIds;
        super.beforeDoOperation(args);
        Object obj = SWCSalaryParameterServiceHelper.getSalaryParam((String)"adjsalsyn", (String)"enablerange");
        if (obj == null || SWCStringUtils.equals((String)"3", (String)obj.toString())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u85aa\u916c\u57fa\u7840\u670d\u52a1>\u53c2\u6570\u914d\u7f6e\u201d\u4e2d\u7684\u201c\u5b9a\u8c03\u85aa\u6570\u636e\u96c6\u6210\u201d\u672a\u542f\u7528\u3002\u5f53\u524d\u9875\u9762\u4e0d\u53ef\u64cd\u4f5c\uff0c\u8bf7\u9000\u51fa\u3002", (String)"AdjSalSyn_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        Long primaryKeyValue = (Long)ObjectConverter.convert((Object)this.getView().getFormShowParameter().getCustomParam("pkid").toString(), Long.class, (boolean)false);
        QFilter filter = new QFilter("id", "=", (Object)primaryKeyValue);
        List permissionFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0VO5EV13=I9W", (String)"hcdm_adjsalsyn", (String)"47150e89000000ac");
        if (permissionFilter != null) {
            for (QFilter authFilter : permissionFilter) {
                filter.and(authFilter);
            }
        } else {
            filter.and(new QFilter("1", "!=", (Object)1));
        }
        HasPermOrgResult permOrgRes = SWCPermissionServiceHelper.getPermOrgs((String)"28", (String)"0VO5EV13=I9W", (String)"hcdm_adjsalsyn", (String)"47150e89000000ac");
        if (!permOrgRes.hasAllOrgPerm()) {
            List hasPermOrg = permOrgRes.getHasPermOrgs();
            QFilter qFilter = new QFilter("org", "in", (Object)hasPermOrg);
            filter.and(qFilter);
        }
        if (ArrayUtils.isEmpty((Object[])(hasPermIds = (helper = new SWCDataServiceHelper("hcdm_adjsalsyn")).queryOriginalArray("id", new QFilter[]{filter})))) {
            String msg = ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u64cd\u4f5c\u5f53\u524d\u540c\u6b65\u6279\u6b21\u7684\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AdjSalSynDetailListPlugin_5", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u60a8\u65e0\u6743\u64cd\u4f5c\u5f53\u524d\u540c\u6b65\u6279\u6b21\u7684\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", "AdjSalSynDetailListPlugin_5", "swc-hcdm-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)key, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[0]);
            return;
        }
        switch (key) {
            case "donothing_giveupsyn": {
                formOperate.getOption().setVariableValue("batchop_batchsize", String.valueOf(1000));
                String giveUpSynConfirmed = this.getView().getPageCache().get("giveUpSynConfirmed");
                if (StringUtils.isEmpty((Object)giveUpSynConfirmed)) {
                    this.checkIsFailedData();
                    args.setCancel(true);
                    break;
                }
                this.initRowIndex(formOperate);
                this.getView().getPageCache().put("giveUpSynConfirmed", "2");
                break;
            }
            case "donothing_syndata": {
                this.initRowIndex(formOperate);
                break;
            }
        }
    }

    private void initRowIndex(FormOperate formOperate) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        HashMap pkIdRowIndexMap = Maps.newHashMapWithExpectedSize((int)selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            Long pkId = (Long)row.getPrimaryKeyValue();
            int rowKey = row.getRowKey();
            pkIdRowIndexMap.put(String.valueOf(pkId), rowKey);
        }
        formOperate.getOption().setVariableValue("pkIdRowIndexString", SalaryStandardSerializationUtils.toJsonString((Object)pkIdRowIndexMap));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String key = formOperate.getOperateKey();
        IFormView parentView = this.getView().getParentView();
        switch (key) {
            case "donothing_syndata": {
                this.getView().invokeOperation("refresh");
                parentView.invokeOperation("donothing_refreshsynpage");
                this.getView().sendFormAction(parentView);
                break;
            }
            case "donothing_giveupsyn": {
                this.getView().getPageCache().remove("giveUpSynConfirmed");
                HashSet allErrorInfo = afterDoOperationEventArgs.getOperationResult().getValidateResult().getErrorDataIndexs();
                if (CollectionUtils.isEmpty((Collection)allErrorInfo)) {
                    if (parentView == null) break;
                    parentView.invokeOperation("refresh");
                    this.getView().sendFormAction(parentView);
                    break;
                }
                afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
                String operateName = formOperate.getOperateName().getLocaleValue();
                this.showCustomMessage(afterDoOperationEventArgs.getOperationResult(), operateName);
                break;
            }
        }
    }

    private void showCustomMessage(OperationResult operationResult, String operateName) {
        Map billNos;
        String billNo;
        List errorOrValidateInfos = operationResult.getAllErrorOrValidateInfo();
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("operateName", (Object)operateName);
        parameters.setCustomParam("operateName", (Object)operateName);
        Map pkNumbers = new HashMap();
        if (operationResult.getSuccessPkIds() != null && !operationResult.getSuccessPkIds().isEmpty()) {
            if (!operationResult.getBillNos().isEmpty()) {
                pkNumbers.putAll(operationResult.getBillNos());
            } else {
                pkNumbers = Maps.asMap((Set)Sets.newHashSet((Iterable)operationResult.getSuccessPkIds()), ele -> ele);
            }
        }
        parameters.setCustomParam("pkNumbers", pkNumbers);
        IPageCache pageCache = this.getView().getPageCache();
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        pageCache.put("operationresult", serialResult);
        ArrayList<String> list = new ArrayList<String>(5);
        int billCount = errorOrValidateInfos.size();
        for (int index = 0; index < 5 && index < billCount; ++index) {
            IOperateInfo errorInfo = (IOperateInfo)errorOrValidateInfos.get(index);
            list.add(errorInfo.getMessage());
        }
        parameters.setCustomParam("hasMore", (Object)(errorOrValidateInfos.size() > 5 ? 1 : 0));
        parameters.setCustomParam("errorMsg", list);
        String message = operationResult.getMessage();
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)message) && operationResult.getMessageType() == 1) {
            parameters.setCustomParam("message", (Object)operationResult.getMessage());
        }
        billCount = operationResult.getBillCount();
        int successCount = operationResult.getSuccessPkIds().size();
        int validError = billCount - successCount;
        String title = operationResult.getBillCount() == 1 && !operationResult.getBillNos().isEmpty() ? (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)(billNo = (String)(billNos = operationResult.getBillNos()).values().iterator().next())) ? String.format(Locale.ROOT, ResManager.loadKDString((String)"\u672c\u5355%1$s\u5931\u8d25", (String)"AbstractFormView_1", (String)"bos-form-metadata", (Object[])new Object[0]), kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)operateName) ? "" : operateName) : (validError > 0 ? String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d%2$s\u5931\u8d25", (String)"AbstractFormView_2", (String)"bos-form-metadata", (Object[])new Object[0]), billNo, kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)operateName) ? "" : operateName) : String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d%2$s\u6210\u529f", (String)"AbstractFormView_3", (String)"bos-form-metadata", (Object[])new Object[0]), billNo, kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)operateName) ? "" : operateName))) : (validError > 0 ? String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u5355\u636e\uff0c%2$s\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761", (String)"AbstractFormView_4", (String)"bos-form-metadata", (Object[])new Object[0]), billCount, kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)operateName) ? "" : operateName, successCount, validError) : String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u5355\u636e\uff0c%2$s\u6210\u529f%3$s\u6761", (String)"AbstractFormView_5", (String)"bos-form-metadata", (Object[])new Object[0]), billCount, kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)operateName) ? "" : operateName, successCount));
        parameters.setCustomParam("title", (Object)title);
        parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close_call_donothing_giveupsyn"));
        this.getView().showForm(parameters);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        switch (callBackId) {
            case "callbackid_confirmgiveup": {
                if (!MessageBoxResult.Yes.equals((Object)result) && !MessageBoxResult.OK.equals((Object)result)) break;
                if (!SWCPermissionServiceHelper.hasPerm((String)"0VO5EV13=I9W", (String)"hcdm_adjsalsyn", (String)HRQXX0535)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5b9a\u8c03\u85aa\u6570\u636e\u540c\u6b65\u201d\u7684\u201c\u653e\u5f03\u540c\u6b65\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdjSalSynDetailListPlugin_6", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().getPageCache().put("giveUpSynConfirmed", "1");
                this.getView().invokeOperation("donothing_giveupsyn");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        IFormView parentView;
        super.closedCallBack(closedCallBackEvent);
        if ("close_call_donothing_giveupsyn".equals(closedCallBackEvent.getActionId()) && (parentView = this.getView().getParentView()) != null) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }

    private void checkIsFailedData() {
        Set<Long> pkIdList = this.getSelectRowsPkId(this.getSelectedRows());
        boolean hasFailedFlag = AdjSalarySynHelper.checkIsSynFailedData(pkIdList);
        if (hasFailedFlag) {
            this.showConfirmForm(pkIdList);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u540c\u6b65\u5931\u8d25\u201d\u7684\u6570\u636e\u8fdb\u884c\u653e\u5f03\u540c\u6b65\u64cd\u4f5c\u3002", (String)"AdjSalSynDetailListPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void showConfirmForm(Set<Long> pkIdList) {
        this.getView().getPageCache().put("detailIds", SalaryStandardSerializationUtils.toJsonString(pkIdList));
        this.getView().getPageCache().put("parentView", this.getView().getParentView().getPageId());
        String confirmMsg = ResManager.loadKDString((String)"\u653e\u5f03\u540c\u6b65\u540e\u5c06\u4e0d\u518d\u540c\u6b65\u6240\u9009\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdjSalSynDetailListPlugin_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(confirmMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_CONFIRMGIVEUP));
    }

    private Set<Long> getSelectRowsPkId(ListSelectedRowCollection selectedRows) {
        HashSet pkIdList = Sets.newHashSetWithExpectedSize((int)selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            Long pkId = (Long)row.getPrimaryKeyValue();
            pkIdList.add(pkId);
        }
        return pkIdList;
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.getView().getParentView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
        this.getView().sendFormAction(this.getView().getParentView());
        boolean isHasGiveUpPerm = SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"hcdm_adjsalsyn", (String)AdjSynDetailOperationEnum.OP_GIVEUPSYN.getPermission());
        logger.info("detail list view permission giveupsyn = {}", (Object)isHasGiveUpPerm);
        if (!isHasGiveUpPerm) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_giveupsyn"});
        }
        boolean isHasExportPerm = SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"hcdm_adjsalsyn", (String)"4730fc9f000004ae");
        logger.info("detail list view permission export = {}", (Object)isHasExportPerm);
        if (!isHasExportPerm) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_export"});
        }
        boolean isHasSynDataPerm = SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"hcdm_adjsalsyn", (String)AdjSynDetailOperationEnum.OP_SYNDATA.getPermission());
        logger.info("detail list view permission syndata = {}", (Object)isHasSynDataPerm);
        if (!isHasSynDataPerm) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_syndata"});
        }
    }

    @Override
    protected List<String> getFixFieldList() {
        ArrayList<String> fieldList = new ArrayList<String>(4);
        fieldList.add("fseq");
        fieldList.add("adjfile.person.name");
        fieldList.add("employee.empnumber");
        return fieldList;
    }

    public void beforeExportFile(BeforeExportFileEvent event) {
        super.beforeExportFile(event);
        if (event instanceof ExportFileEvent) {
            Map headerMap = ((ExportFileEvent)event).getCustomHeaderMap();
            headerMap.put("fieldmappingvalue", FIELD_MAPPING_VALUE);
        }
    }

    public void afterExportFile(ExportFileEvent event) {
        DynamicObject adjSalarySynSetDy;
        File file = event.getFile();
        ListView listView = (ListView)event.getSource();
        Long pkId = (Long)listView.getFormShowParameter().getCustomParam("pkid");
        SWCDataServiceHelper adjSalSynHelper = new SWCDataServiceHelper("hcdm_adjsalsyn");
        DynamicObject dynamicObject = adjSalSynHelper.queryOne("adjsalarysynset,adjsalarysynset.salaryadjfield,adjsalarysynset.fieldentry.salaryadjfield,adjsalarysynset.fieldentry.bizitemprop", (Object)pkId);
        DynamicObjectCollection fieldEntry = null;
        if (!SWCObjectUtils.isEmpty((Object)dynamicObject) && !SWCObjectUtils.isEmpty((Object)(adjSalarySynSetDy = dynamicObject.getDynamicObject("adjsalarysynset")))) {
            fieldEntry = adjSalarySynSetDy.getDynamicObjectCollection("fieldentry");
            logger.info("AdjSalSynDetailListPlugin afterExportFile:{}", (Object)fieldEntry);
        }
        if (file != null) {
            try (FileInputStream fis = new FileInputStream(file);){
                Cell cell;
                XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);
                XSSFSheet sheet = wb.getSheetAt(0);
                XSSFRow titleRow = sheet.getRow(0);
                if (null == titleRow) {
                    return;
                }
                Map<String, Boolean> userListColumnsVisibleMap = this.getUserListColumnsVisibleMap();
                int cellNum = titleRow.getLastCellNum();
                ArrayList<Integer> hiddenColumnList = new ArrayList<Integer>();
                int fieldMappingValueIndex = 0;
                boolean isHasFieldMappingValue = false;
                Iterator cellIterator = titleRow.cellIterator();
                XSSFCellStyle cellStyle = wb.createCellStyle();
                while (cellIterator.hasNext()) {
                    Cell cell2 = (Cell)cellIterator.next();
                    String rowName = cell2.getStringCellValue();
                    if (!FIELD_MAPPING_VALUE.equals(rowName)) continue;
                    isHasFieldMappingValue = true;
                    fieldMappingValueIndex = cell2.getColumnIndex();
                    cellStyle = cell2.getCellStyle();
                    titleRow.removeCell(cell2);
                }
                HashMap map = Maps.newHashMapWithExpectedSize((int)16);
                ArrayList indexs = Lists.newArrayListWithExpectedSize((int)10);
                if (fieldEntry != null && !fieldEntry.isEmpty()) {
                    int index = titleRow.getLastCellNum();
                    for (DynamicObject fieldDy : fieldEntry) {
                        cell = titleRow.createCell(index);
                        cell.setCellStyle((CellStyle)cellStyle);
                        cell.setCellValue(fieldDy.getString("salaryadjfield.name"));
                        map.put(index, fieldDy.getLong("bizitemprop.id"));
                        indexs.add(index);
                        ++index;
                    }
                }
                int rowNum = sheet.getLastRowNum();
                if (isHasFieldMappingValue) {
                    for (int i = 1; i <= rowNum; ++i) {
                        HashMap extraValue;
                        XSSFRow row = sheet.getRow(i);
                        cell = row.getCell(fieldMappingValueIndex);
                        String fieldMappingValue = cell.getStringCellValue();
                        logger.info("AdjSalSynDetailListPlugin.afterExportFile \u7b2c{} \u884c\u5185\u5bb9\uff1a{}", (Object)i, (Object)fieldMappingValue);
                        if (SWCStringUtils.isEmpty((String)fieldMappingValue) || SWCObjectUtils.isEmpty((Object)(extraValue = (HashMap)SerializationUtils.fromJsonString((String)fieldMappingValue, HashMap.class)))) continue;
                        List propValues = (List)extraValue.get("propdatalist");
                        HashMap propValueMap = Maps.newHashMapWithExpectedSize((int)16);
                        if (!SWCListUtils.isEmpty((List)propValues)) {
                            for (Map propValue : propValues) {
                                propValueMap.put((Long)propValue.get("bizitempropid"), propValue.get("propvalue"));
                            }
                        }
                        for (int cellIndex = 0; cellIndex < indexs.size(); ++cellIndex) {
                            Cell rowCell = row.createCell(((Integer)indexs.get(cellIndex)).intValue());
                            if (SWCListUtils.isEmpty((List)propValues) || SWCObjectUtils.isEmpty(propValueMap.get(map.get(indexs.get(cellIndex))))) {
                                rowCell.setCellValue("");
                                continue;
                            }
                            rowCell.setCellValue(String.valueOf(propValueMap.get(map.get(indexs.get(cellIndex)))));
                        }
                    }
                }
                for (int index = 0; index < cellNum; ++index) {
                    Cell cell3 = titleRow.getCell(index, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
                    String titleValue = cell3.getStringCellValue();
                    List defaultHiddenAdjSynDetailExportColumnEnums = AdjSynDetailExportColumnEnum.getDefaultHiddenColumnEnum();
                    Set defaultColumnNameSet = defaultHiddenAdjSynDetailExportColumnEnums.stream().map(column -> column.getColumnName().getDescription()).collect(Collectors.toSet());
                    if (defaultColumnNameSet.contains(titleValue)) {
                        hiddenColumnList.add(index);
                    }
                    List adjSynDetailExportColumnEnums = AdjSynDetailExportColumnEnum.getAdjSynDetailExportColumnEnum();
                    for (AdjSynDetailExportColumnEnum adjSynDetailExportColumnEnum : adjSynDetailExportColumnEnums) {
                        String columnKey = adjSynDetailExportColumnEnum.getColumnKey();
                        String columnName = adjSynDetailExportColumnEnum.getColumnName().getDescription();
                        if (SWCObjectUtils.isEmpty((Object)userListColumnsVisibleMap.get(columnKey)) || userListColumnsVisibleMap.get(columnKey).booleanValue() || !columnName.equals(titleValue)) continue;
                        hiddenColumnList.add(index);
                    }
                }
                boolean isHasSynDataPerm = SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"hcdm_adjsalsyn", (String)AdjSynDetailOperationEnum.OP_VIEWADJFILE.getPermission());
                if (!isHasSynDataPerm) {
                    for (Integer hiddenColumn : hiddenColumnList) {
                        this.removeColumn((Sheet)sheet, hiddenColumn);
                        sheet.setColumnHidden(hiddenColumn.intValue(), true);
                    }
                }
                for (Integer dyColumn : map.keySet()) {
                    XSSFCellStyle cs = wb.createCellStyle();
                    cs.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
                    cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    sheet.getRow(0).getCell(dyColumn.intValue()).setCellStyle((CellStyle)cs);
                }
                FileOutputStream out = new FileOutputStream(file);
                wb.write((OutputStream)out);
                wb.close();
                out.close();
            }
            catch (Throwable ex) {
                logger.error(ex);
            }
        }
    }

    protected Map<String, Boolean> getUserListColumnsVisibleMap() {
        BillList billList = (BillList)this.getControl("billlistap");
        HashMap<String, Boolean> userListColumnsVisibleMap = new HashMap<String, Boolean>(16);
        for (Map listFieldsControlColumn : billList.getListFieldsControlColumns()) {
            int visibleValue = Integer.parseInt(listFieldsControlColumn.get("visible").toString());
            userListColumnsVisibleMap.put(listFieldsControlColumn.get("listFieldKey").toString(), ViewCommonUtil.getListColumnVisible((boolean)(this.getView().getFormShowParameter() instanceof ListShowParameter), (boolean)this.isLookUp(billList), (int)visibleValue));
        }
        return userListColumnsVisibleMap;
    }

    private boolean isLookUp(BillList billList) {
        return billList.getContext() != null ? billList.getContext().isLookup() : false;
    }

    private void removeColumn(Sheet sheet, int removeColumnNum) {
        for (XSSFRow row : sheet) {
            XSSFCell cell = row.getCell(removeColumnNum);
            if (cell == null) continue;
            row.removeCell((Cell)cell);
        }
    }
}

