/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjsalsyn;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.swc.hcdm.business.salaryadjsync.AdjSalarySynHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.control.SWCFlexPanelAp;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class AdjSalSynDetailPlugin
extends AbstractBasePlugIn {
    private static Log logger = LogFactory.getLog(AdjSalSynDetailPlugin.class);
    private static final String FIELD_PREFIX = "basisfield_";

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject adjSalarySynSet = (DynamicObject)dataEntity.get("adjsalarysynset");
        DynamicObject bizItem = (DynamicObject)dataEntity.get("bizitem");
        DynamicObject salaryStdItem = (DynamicObject)dataEntity.get("salarystditem");
        DynamicObject adjFile = (DynamicObject)dataEntity.get("adjfile");
        Date bsed = dataEntity.getDate("bsed");
        DynamicObject frequency = dataEntity.getDynamicObject("frequency");
        DynamicObject currency = dataEntity.getDynamicObject("currency");
        BigDecimal amount = dataEntity.getBigDecimal("amount");
        String isSend = dataEntity.getString("issend");
        String remark = dataEntity.getString("remark");
        String salaryType = adjFile.getString("salaystructure.name");
        DynamicObject adminOrg = dataEntity.getDynamicObject("depemp.adminorg");
        dataEntity.set("adminorg", (Object)adminOrg);
        this.getView().updateView("adminorg");
        DynamicObject salaryAdjRsn = dataEntity.getDynamicObject("salaryadjrecord.salaryadjrsn");
        dataEntity.set("salaryadjustrsn", (Object)salaryAdjRsn);
        this.getView().updateView("salaryadjustrsn");
        if (currency != null) {
            amount = AdjSalarySynHelper.formatByCurrency((int)currency.getInt("amtprecision"), (BigDecimal)amount);
        }
        this.setAdjSalSynDetailEntryInfo(adjSalarySynSet, bizItem, salaryStdItem, bsed, frequency, currency, amount, isSend, remark, salaryType);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        DynamicObjectCollection fieldEntry;
        super.loadCustomControlMetas(args);
        FormShowParameter formShowParam = (FormShowParameter)args.getSource();
        Long pkId = (Long)formShowParam.getCustomParam("pkid");
        SWCDataServiceHelper adjSalSynHelper = new SWCDataServiceHelper("hcdm_adjsalsyn");
        DynamicObject dynamicObject = adjSalSynHelper.queryOne("adjsalarysynset,adjsalarysynset.salaryadjfield,adjsalarysynset.fieldentry.salaryadjfield,adjsalarysynset.fieldentry.bizitemprop", (Object)pkId);
        if (SWCObjectUtils.isEmpty((Object)dynamicObject)) {
            return;
        }
        DynamicObject adjSalarySynSetDy = dynamicObject.getDynamicObject("adjsalarysynset");
        HashMap headMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!SWCObjectUtils.isEmpty((Object)adjSalarySynSetDy) && (fieldEntry = adjSalarySynSetDy.getDynamicObjectCollection("fieldentry")) != null && !fieldEntry.isEmpty()) {
            for (DynamicObject field : fieldEntry) {
                headMap.put(FIELD_PREFIX + field.getString("salaryadjfield.number"), new ArrayList<String>(Arrays.asList(field.getString("bizitemprop.id"), field.getString("salaryadjfield.name"))));
            }
        }
        HashMap<String, String> basisFieldHeadApMapHead = new HashMap<String, String>();
        FlexPanelAp headPanelAp = this.createDynamicBasisFieldAp(headMap);
        basisFieldHeadApMapHead.put("id", "valuepanelap");
        basisFieldHeadApMapHead.put("items", (String)headPanelAp.createControl().get("items"));
        args.getItems().add(basisFieldHeadApMapHead);
        formShowParam.setCustomParam("headMap", (Object)SerializationUtils.toJsonString((Object)headMap));
    }

    private FieldAp createDynamicBasisFieldAp(String id, String name) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setKey(id);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setFireUpdEvt(true);
        fieldAp.setLock("new,edit,view,submit,audit");
        TextField textField = new TextField();
        fieldAp.setField((Field)textField);
        return fieldAp;
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        super.getEntityType(args);
        MainEntityType oldMainType = args.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            logger.error("AdjSalSynDetailPlugin getEntityType clone failed", (Throwable)exp);
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        args.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        logger.info("onGetControl key\uff1a{}", (Object)key);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Map<String, List<String>> headMap = this.getHeadMap();
        FlexPanelAp headPanelAp = this.createDynamicBasisFieldAp(headMap);
        Container basisFieldPanel = (Container)this.getView().getControl("valuepanelap");
        basisFieldPanel.getItems().addAll(((Container)headPanelAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(basisFieldPanel.getItems());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object obj = SWCSalaryParameterServiceHelper.getSalaryParam((String)"adjsalsyn", (String)"enablerange");
        if (obj == null || SWCStringUtils.equals((String)"3", (String)obj.toString())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u85aa\u916c\u57fa\u7840\u670d\u52a1>\u53c2\u6570\u914d\u7f6e\u201d\u4e2d\u7684\u201c\u5b9a\u8c03\u85aa\u6570\u636e\u96c6\u6210\u201d\u672a\u542f\u7528\u3002\u5f53\u524d\u9875\u9762\u4e0d\u53ef\u64cd\u4f5c\uff0c\u8bf7\u9000\u51fa\u3002", (String)"AdjSalSyn_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private FlexPanelAp createDynamicBasisFieldAp(Map<String, List<String>> headMap) {
        FlexPanelAp headPanelAp = new SWCFlexPanelAp.Builder("basisFieldHeadAp").build();
        Map<String, Object> propValueMap = this.getPropValueMap();
        boolean iaAllNotData = true;
        for (Map.Entry<String, List<String>> entry : headMap.entrySet()) {
            FieldAp fieldAp = this.createDynamicBasisFieldAp(entry.getKey(), entry.getValue().get(1));
            if (this.getModel() != null) {
                logger.info("AdjSalSynDetailPlugin createDynamicBasisFieldAp");
                if (!SWCObjectUtils.isEmpty((Object)propValueMap.get(entry.getValue().get(0)))) {
                    logger.info("AdjSalSynDetailPlugin createDynamicBasisFieldAp Value \uff1a{}", propValueMap.get(entry.getValue().get(0)));
                    this.getModel().setValue(entry.getKey(), propValueMap.get(entry.getValue().get(0)));
                    headPanelAp.getItems().add(fieldAp);
                    iaAllNotData = false;
                    continue;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{entry.getKey()});
                this.getView().updateView(entry.getKey());
                continue;
            }
            headPanelAp.getItems().add(fieldAp);
        }
        if (this.getView() != null && iaAllNotData) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelap"});
        }
        return headPanelAp;
    }

    private Map<String, Object> getPropValueMap() {
        HashMap propValueMap = Maps.newHashMapWithExpectedSize((int)16);
        if (this.getModel() != null) {
            List propValues;
            HashMap extraValue;
            String fieldMappingValue = this.getModel().getDataEntity().getString("fieldmappingvalue");
            logger.info("AdjSalSynDetailPlugin.createDynamicBasisFieldAp \u5185\u5bb9\uff1a{}", (Object)fieldMappingValue);
            if (!(SWCStringUtils.isEmpty((String)fieldMappingValue) || SWCObjectUtils.isEmpty((Object)(extraValue = (HashMap)SerializationUtils.fromJsonString((String)fieldMappingValue, HashMap.class))) || SWCListUtils.isEmpty((List)(propValues = (List)extraValue.get("propdatalist"))))) {
                for (Map propValue : propValues) {
                    propValueMap.put(String.valueOf(propValue.get("bizitempropid")), propValue.get("propvalue"));
                }
            }
        }
        return propValueMap;
    }

    private void registDynamicProps(MainEntityType newMainType) {
        Map<String, List<String>> headMap = this.getHeadMap();
        if (headMap != null) {
            for (Map.Entry<String, List<String>> entry : headMap.entrySet()) {
                TextProp textProp = new TextProp();
                textProp.setName(entry.getKey());
                textProp.setDbIgnore(true);
                textProp.setAlias("");
                newMainType.registerSimpleProperty((DynamicSimpleProperty)textProp);
            }
        }
    }

    private Map<String, List<String>> getHeadMap() {
        String headMapStr = this.getView().getFormShowParameter().getCustomParam("headMap").toString();
        Map headMap = (Map)SerializationUtils.fromJsonString((String)headMapStr, Map.class);
        return headMap;
    }

    private void setAdjSalSynDetailEntryInfo(DynamicObject adjSalarySynSet, DynamicObject bizItem, DynamicObject salaryStdItem, Date bsed, DynamicObject frequency, DynamicObject currency, BigDecimal amount, String isSend, String remark, String salaryType) {
        String bizItemName = null == bizItem ? null : bizItem.getString("name");
        String bizItemNumber = null == bizItem ? null : bizItem.getString("number");
        String salaryStdItemNumber = null == salaryStdItem ? null : salaryStdItem.getString("number");
        String salaryStdItemName = null == salaryStdItem ? null : salaryStdItem.getString("name");
        String frequencyName = null == frequency ? null : frequency.getString("name");
        DynamicObjectCollection synDetailEntry = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        DynamicObject synDetailEntryObj = synDetailEntry.addNew();
        synDetailEntryObj.set("bizdatatmplnumber", (Object)bizItemNumber);
        synDetailEntryObj.set("bizdatatmplname", (Object)bizItemName);
        synDetailEntryObj.set("salarystditemnumber", (Object)salaryStdItemNumber);
        synDetailEntryObj.set("salarystditemname", (Object)salaryStdItemName);
        synDetailEntryObj.set("frequency_view", (Object)frequencyName);
        synDetailEntryObj.set("currency_view", (Object)currency);
        synDetailEntryObj.set("FINALAMOUNT", (Object)amount);
        synDetailEntryObj.set("effectivedate", (Object)bsed);
        synDetailEntryObj.set("salarytype", (Object)salaryType);
        synDetailEntryObj.set("issendentry", (Object)isSend);
        synDetailEntryObj.set("remarkentry", (Object)remark);
        this.getModel().updateEntryCache(synDetailEntry);
        this.getView().updateView("entryentity");
    }
}

