/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjsalsyn;

import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hcdm.business.salaryadjsync.AdjSalarySynHelper;
import kd.swc.hcdm.formplugin.adjapprbill.AdjApprovalFormUtils;
import kd.swc.hsbp.common.model.BaseResult;
import org.apache.commons.lang.StringUtils;

public class AdjSalSynPlugin
extends AbstractFormPlugin {
    public void initialize() {
        this.addClickListeners(new String[]{"syntimeslab", "srcbilllabelap"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((String)key, (String)"syntimeslab")) {
            this.openAdjSalSynTimesPage();
        } else if (StringUtils.equals((String)key, (String)"srcbilllabelap")) {
            this.openSrcBillPage();
        }
    }

    private void openSrcBillPage() {
        BaseResult hasPerm = AdjSalarySynHelper.hasBillPerm((Long)this.getModel().getDataEntity().getLong("id"));
        if (!hasPerm.isSuccess()) {
            this.getView().showTipNotification(hasPerm.getMsg());
            return;
        }
        DynamicObject adjAppBill = (DynamicObject)hasPerm.getData();
        FormShowParameter billShowParameter = AdjApprovalFormUtils.createApprovalFormX(this.getView(), adjAppBill);
        this.getView().showForm(billShowParameter);
    }

    private void openAdjSalSynTimesPage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setFormId("hcdm_adjsalsyntimes");
        formShowParameter.setHasRight(true);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        Long primaryKeyValue = this.getModel().getDataEntity().getLong("id");
        formShowParameter.setCustomParam("pkid", (Object)primaryKeyValue);
        this.getView().showForm(formShowParameter);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.setSynTimes();
    }

    private void setSynTimes() {
        Long synTimes = this.getModel().getDataEntity().getLong("syntimes");
        this.getModel().setValue("syntimesshow", (Object)synTimes);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "donothing_refreshsynpage": {
                this.getView().invokeOperation("refresh");
            }
        }
    }
}

