/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjsalsyn;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hcdm.business.salaryadjsync.AdjSalarySynHelper;
import kd.swc.hcdm.common.entity.adjsalsyn.MsgRecipientsEntity;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.beanutils.ConvertUtils;

public class AdjSalSynTmplSetMsgRecPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject eventObject) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String hideData = parameter.getCustomParam("hideData").toString();
        Map hideDataMap = (Map)JSON.parseObject((String)hideData, Map.class);
        this.renderSalSynMsgRecPage(hideDataMap);
    }

    private void renderSalSynMsgRecPage(Map<String, String> hideDataMap) {
        String personIds = hideDataMap.get("person");
        if (SWCStringUtils.isNotEmpty((String)personIds)) {
            this.getModel().setValue("byperson", (Object)Boolean.TRUE);
        }
        List<Long> depempIds = Arrays.asList((Long[])ConvertUtils.convert((String[])personIds.split(";"), Long.class));
        DynamicObject[] hrPersons = AdjSalarySynHelper.queryHrpiDepEmp(depempIds);
        DynamicObjectCollection personDyObjCol = (DynamicObjectCollection)this.getModel().getValue("person");
        for (DynamicObject dynamicObject : hrPersons) {
            DynamicObject personDyObj = personDyObjCol.addNew();
            personDyObj.set("fbasedataid", (Object)dynamicObject);
        }
        String roleIds = hideDataMap.get("role");
        if (SWCStringUtils.isNotEmpty((String)roleIds)) {
            this.getModel().setValue("byrole", (Object)Boolean.TRUE);
        }
        List<Long> workRoleIds = Arrays.asList((Long[])ConvertUtils.convert((String[])roleIds.split(";"), Long.class));
        DynamicObject[] workRoles = AdjSalarySynHelper.queryWorkRoles(workRoleIds);
        DynamicObjectCollection roleDyObjCol = (DynamicObjectCollection)this.getModel().getValue("role");
        for (DynamicObject dynamicObject : workRoles) {
            DynamicObject roleDyObj = roleDyObjCol.addNew();
            roleDyObj.set("fbasedataid", (Object)dynamicObject);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.returnDataToParent();
                break;
            }
        }
    }

    private void returnDataToParent() {
        ArrayList msgRecipientsEntityList = Lists.newArrayList();
        Boolean byPerson = (Boolean)this.getModel().getValue("byperson");
        DynamicObjectCollection personDyObjCol = (DynamicObjectCollection)this.getModel().getValue("person");
        if (byPerson.booleanValue() && SWCListUtils.isEmpty((List)personDyObjCol)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4eba\u5458", (String)"AdjSalSynTmplSetPlugin_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!byPerson.booleanValue() && !SWCListUtils.isEmpty((List)personDyObjCol)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4eba\u5458\u3002", (String)"AdjSalSynTmplSetPlugin_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (byPerson.booleanValue() && !SWCListUtils.isEmpty((List)personDyObjCol)) {
            List<MsgRecipientsEntity> personData = this.buildPersonAndRoleData(personDyObjCol, "person");
            msgRecipientsEntityList.addAll(personData);
        }
        Boolean byRole = (Boolean)this.getModel().getValue("byrole");
        DynamicObjectCollection roleDyObjCol = (DynamicObjectCollection)this.getModel().getValue("role");
        if (byRole.booleanValue() && SWCListUtils.isEmpty((List)roleDyObjCol)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u89d2\u8272", (String)"AdjSalSynTmplSetPlugin_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!byRole.booleanValue() && !SWCListUtils.isEmpty((List)roleDyObjCol)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u89d2\u8272\u3002", (String)"AdjSalSynTmplSetPlugin_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (byRole.booleanValue() && !SWCListUtils.isEmpty((List)roleDyObjCol)) {
            List<MsgRecipientsEntity> roleData = this.buildPersonAndRoleData(roleDyObjCol, "role");
            msgRecipientsEntityList.addAll(roleData);
        }
        IFormView view = this.getView();
        view.returnDataToParent((Object)JSON.toJSONString((Object)msgRecipientsEntityList));
        view.close();
    }

    private List<MsgRecipientsEntity> buildPersonAndRoleData(DynamicObjectCollection dyObjCol, String type) {
        ArrayList msgRecipientsEntityList = Lists.newArrayList();
        MsgRecipientsEntity msgRecipientsEntity = null;
        for (DynamicObject dyObj : dyObjCol) {
            Long id = dyObj.getDynamicObject("fbasedataid").getLong("id");
            String name = null;
            name = "person".equals(type) ? dyObj.getDynamicObject("fbasedataid").getString("person.name") : dyObj.getDynamicObject("fbasedataid").getString("name");
            msgRecipientsEntity = new MsgRecipientsEntity(id.longValue(), name, type);
            msgRecipientsEntityList.add(msgRecipientsEntity);
        }
        return msgRecipientsEntityList;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        Object newValue = args.getChangeSet()[0].getNewValue();
        switch (name) {
            case "byperson": {
                this.clearPersonOrRoleData(newValue, "person");
                break;
            }
            case "byrole": {
                this.clearPersonOrRoleData(newValue, "role");
                break;
            }
        }
    }

    private void clearPersonOrRoleData(Object newValue, String key) {
        if (newValue instanceof Boolean && !((Boolean)newValue).booleanValue()) {
            this.getModel().setValue(key, null);
        }
    }
}

