/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.adjsalsyn;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hcdm.business.extpoint.adjsalsyn.IAdjSalSynTmplSetExtService;
import kd.sdk.swc.hcdm.business.extpoint.adjsalsyn.event.AdjSalSynTmplSetEvent;
import kd.swc.hcdm.business.country.CountryHelper;
import kd.swc.hcdm.business.country.CountryPolicy;
import kd.swc.hcdm.business.country.CountryRefChanged;
import kd.swc.hcdm.business.salaryadjsync.AdjSalSynTmplSetExtService;
import kd.swc.hcdm.business.salaryadjsync.AdjSalarySynHelper;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjFieldFactory;
import kd.swc.hcdm.common.entity.adjsalsyn.MsgRecipientsEntity;
import kd.swc.hcdm.common.enums.HCDMErrInfoEnum;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class AdjSalSynTmplSetPlugin
extends SWCDataBaseEdit
implements BeforeF7SelectListener,
AfterF7SelectListener,
ICloseCallBack,
EntryGridBindDataListener,
CountryRefChanged {
    private static final Log logger = LogFactory.getLog(AdjSalSynTmplSetPlugin.class);
    private static final String CALLBACKID_CLOSE_RECIPIENTS = "callbackid_close_recipients";
    private static final String CALLBACKID_ADDBIZITEM = "callbackid_bizitem";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"msgrecipients"});
        CountryHelper.registerListenerForBaseData((AbstractFormPlugin)this, Arrays.asList("salarystditem", "msgnotifytmpl", "bizitem", "country", "bizitemprop"));
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        CountryHelper.afterBindDataForCountry((AbstractFormPlugin)this);
        Boolean isSendMsg = (Boolean)this.getModel().getValue("issendmsg");
        this.setControlIsMustInput(isSendMsg);
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (pkValue > 0L) {
            this.initMsgRecipients(pkValue);
        }
    }

    private void initMsgRecipients(Long pkValue) {
        DynamicObject[] workRoles;
        DynamicObject[] hrPersons;
        ArrayList msgRecipients = Lists.newArrayListWithExpectedSize((int)10);
        DynamicObject adjSalSynSet = AdjSalarySynHelper.queryAdjSalSynSet((Long)pkValue);
        DynamicObjectCollection personEntry = adjSalSynSet.getDynamicObjectCollection("adjsalsynsetperson");
        ArrayList depempIds = Lists.newArrayList();
        for (DynamicObject[] person : personEntry) {
            depempIds.add(person.getLong("personid"));
        }
        for (DynamicObject hrPerson : hrPersons = AdjSalarySynHelper.queryHrpiDepEmp((List)depempIds)) {
            DynamicObject person = hrPerson.getDynamicObject("person");
            String hrPersonName = person.getString("name");
            msgRecipients.add(hrPersonName);
        }
        DynamicObjectCollection roleEntry = adjSalSynSet.getDynamicObjectCollection("adjsalsynsetrole");
        ArrayList roleIds = Lists.newArrayList();
        for (DynamicObject[] role : roleEntry) {
            roleIds.add(role.getLong("roleid"));
        }
        for (DynamicObject workRole : workRoles = AdjSalarySynHelper.queryWorkRoles((List)roleIds)) {
            String workRoleName = workRole.getString("name");
            msgRecipients.add(workRoleName);
        }
        this.getModel().setValue("msgrecipients", (Object)SWCBaseUtils.join((List)msgRecipients, (String)";"));
        List newDepempIds = depempIds.stream().map(depempId -> String.valueOf(depempId)).collect(Collectors.toList());
        this.getModel().setValue("recpersonhide", (Object)SWCBaseUtils.join(newDepempIds, (String)";"));
        List newRoleIds = roleIds.stream().map(roleId -> String.valueOf(roleId)).collect(Collectors.toList());
        this.getModel().setValue("recrolehide", (Object)SWCBaseUtils.join(newRoleIds, (String)";"));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        Object newValue = args.getChangeSet()[0].getNewValue();
        switch (name) {
            case "issendmsg": {
                if (!(newValue instanceof Boolean)) break;
                Boolean isSendMsg = (Boolean)newValue;
                this.setControlIsMustInput(isSendMsg);
                break;
            }
        }
        CountryPolicy countryPolicy = CountryPolicy.createInstance().putErrorInfoEnum("areatype", HCDMErrInfoEnum.COMMON_CLEAR_AREA_TYPE_CONFIRM).putErrorInfoEnum("country", HCDMErrInfoEnum.COMMON_CLEAR_COUNTRY_CONFIRM).delAfterConfirm(true).build();
        CountryHelper.propertyChangedForCountry((AbstractFormPlugin)this, (PropertyChangedArgs)args, (CountryPolicy)countryPolicy);
    }

    private void setControlIsMustInput(Boolean isSendMsg) {
        BasedataEdit msgNotifyTmpl = (BasedataEdit)this.getView().getControl("msgnotifytmpl");
        TextEdit msgRecipients = (TextEdit)this.getView().getControl("msgrecipients");
        if (isSendMsg.booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"msgnotifytmpl", "msgrecipients"});
            msgNotifyTmpl.setMustInput(true);
            msgRecipients.setMustInput(true);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"msgnotifytmpl", "msgrecipients"});
            msgNotifyTmpl.setMustInput(false);
            msgRecipients.setMustInput(false);
            this.getModel().setValue("msgnotifytmpl", null);
            this.getModel().setValue("msgrecipients", null);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "msgrecipients": {
                this.showMsgRecipientsPage();
                break;
            }
        }
    }

    private void showMsgRecipientsPage() {
        String title = ResManager.loadKDString((String)"\u63a5\u6536\u4eba", (String)"AdjSalSynTmplSetPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("hcdm_adjsalsynsetrec");
        parameters.setShowTitle(true);
        parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACKID_CLOSE_RECIPIENTS));
        parameters.setCaption(title);
        parameters.setCustomParam("hideData", (Object)JSON.toJSONString(this.getHideData()));
        this.getView().showForm(parameters);
    }

    private Map<String, String> getHideData() {
        HashMap hideDataMap = Maps.newHashMapWithExpectedSize((int)16);
        String personIds = (String)this.getModel().getValue("recpersonhide");
        String roleIds = (String)this.getModel().getValue("recrolehide");
        hideDataMap.put("person", personIds);
        hideDataMap.put("role", roleIds);
        return hideDataMap;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        switch (closedCallBackEvent.getActionId()) {
            case "callbackid_close_recipients": {
                List msgRecipientsEntityList;
                if (closedCallBackEvent.getReturnData() == null || SWCListUtils.isEmpty((List)(msgRecipientsEntityList = JSON.parseArray((String)closedCallBackEvent.getReturnData().toString(), MsgRecipientsEntity.class)))) break;
                this.initPersonAndRole(msgRecipientsEntityList);
                break;
            }
            case "callbackid_bizitem": {
                Object returnData = closedCallBackEvent.getReturnData();
                List<Long> bizItemIds = new ArrayList(10);
                if (returnData instanceof ListSelectedRowCollection) {
                    ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
                    for (ListSelectedRow selectedRow : listSelectedRows) {
                        bizItemIds.add((Long)selectedRow.getPrimaryKeyValue());
                    }
                } else if (returnData instanceof List) {
                    bizItemIds = (List)returnData;
                }
                if (bizItemIds == null || bizItemIds.size() == 0) {
                    return;
                }
                TableValueSetter values = new TableValueSetter(new String[0]);
                values.addField("salarystditem", new Object[0]);
                for (Long fId : bizItemIds) {
                    values.addRow(new Object[]{fId});
                }
                model.beginInit();
                model.batchCreateNewEntryRow("entryentity", values);
                model.endInit();
                this.getView().updateView("entryentity");
                break;
            }
            case "callbackid_addfield": {
                Object returnField = closedCallBackEvent.getReturnData();
                List<Long> fieldIds = new ArrayList(10);
                if (returnField instanceof ListSelectedRowCollection) {
                    ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnField;
                    for (ListSelectedRow selectedRow : listSelectedRows) {
                        fieldIds.add((Long)selectedRow.getPrimaryKeyValue());
                    }
                } else if (returnField instanceof List) {
                    fieldIds = (List)returnField;
                }
                if (CollectionUtils.isEmpty(fieldIds)) {
                    return;
                }
                model.beginInit();
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("salaryadjfield", new Object[0]);
                for (Long fieldId : fieldIds) {
                    vs.addRow(new Object[]{fieldId});
                }
                model.batchCreateNewEntryRow("fieldentry", vs);
                model.endInit();
                this.getView().updateView("fieldentry");
                break;
            }
        }
    }

    private void initPersonAndRole(List<MsgRecipientsEntity> msgRecipientsEntityList) {
        DynamicObjectCollection personEntry = this.getModel().getDataEntity().getDynamicObjectCollection("adjsalsynsetperson");
        DynamicObjectCollection roleEntry = this.getModel().getDataEntity().getDynamicObjectCollection("adjsalsynsetrole");
        Map<String, List<MsgRecipientsEntity>> personEntryMap = msgRecipientsEntityList.stream().filter(entity -> "person".equals(entity.getType())).collect(Collectors.groupingBy(MsgRecipientsEntity::getType));
        Map<String, List<MsgRecipientsEntity>> roleEntryMap = msgRecipientsEntityList.stream().filter(entity -> "role".equals(entity.getType())).collect(Collectors.groupingBy(MsgRecipientsEntity::getType));
        List nameList = msgRecipientsEntityList.stream().map(MsgRecipientsEntity::getName).collect(Collectors.toList());
        this.getModel().setValue("msgrecipients", (Object)SWCBaseUtils.join(nameList, (String)";"));
        this.initPersonAndRoleEntry(personEntry, personEntryMap, "person");
        List personIdList = msgRecipientsEntityList.stream().filter(entity -> "person".equals(entity.getType())).map(entity -> String.valueOf(entity.getId())).collect(Collectors.toList());
        this.getModel().setValue("recpersonhide", (Object)SWCBaseUtils.join(personIdList, (String)";"));
        this.initPersonAndRoleEntry(roleEntry, roleEntryMap, "role");
        List roleIdList = msgRecipientsEntityList.stream().filter(entity -> "role".equals(entity.getType())).map(entity -> String.valueOf(entity.getId())).collect(Collectors.toList());
        this.getModel().setValue("recrolehide", (Object)SWCBaseUtils.join(roleIdList, (String)";"));
    }

    private void initPersonAndRoleEntry(DynamicObjectCollection entry, Map<String, List<MsgRecipientsEntity>> entryMap, String type) {
        DynamicObject entryObj = null;
        for (Map.Entry<String, List<MsgRecipientsEntity>> msgRecEntry : entryMap.entrySet()) {
            List<MsgRecipientsEntity> msgRecipientsEntities = msgRecEntry.getValue();
            for (MsgRecipientsEntity msgRecipientsEntity : msgRecipientsEntities) {
                Long id = msgRecipientsEntity.getId();
                entryObj = entry.addNew();
                if ("person".equals(type)) {
                    entryObj.set("personid", (Object)id);
                    continue;
                }
                entryObj.set("roleid", (Object)id);
            }
        }
        this.getModel().updateEntryCache(entry);
        if ("person".equals(type)) {
            this.getView().updateView("adjsalsynsetperson");
        } else {
            this.getView().updateView("adjsalsynsetrole");
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String property;
        switch (property = beforeF7SelectEvent.getProperty().getName()) {
            case "bizitem": {
                List qFilters = beforeF7SelectEvent.getCustomQFilters();
                if (CountryHelper.checkInvalidAndSetFilter((AbstractFormPlugin)this, null, (String)"hsbs_bizitem", (List)qFilters, (boolean)true)) {
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                List<Long> selectedEntryIds = this.fetchBizItemEntryIds();
                AdjSalSynTmplSetEvent event = new AdjSalSynTmplSetEvent((Object)this);
                event.setAdjSalSynTmplSetDy(this.getModel().getDataEntity());
                event.setRowIndex(beforeF7SelectEvent.getRow());
                HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)new AdjSalSynTmplSetExtService(), IAdjSalSynTmplSetExtService.class, (String)"kd.sdk.swc.hcdm.business.extpoint.adjsalsyn.IAdjSalSynTmplSetExtService#getF7BizItemFilter", null);
                pluginProxy.callReplaceIfPresent(plugin -> {
                    plugin.getF7BizItemFilter(event);
                    return null;
                });
                if (!SWCListUtils.isEmpty((List)event.getqFilters())) {
                    qFilters.addAll(event.getqFilters());
                }
                qFilters.add(new QFilter("id", "not in", selectedEntryIds));
                break;
            }
            case "msgnotifytmpl": {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("msgentity", "=", (Object)"hcdm_adjsalarysynset"));
                break;
            }
            case "bizitemprop": {
                this.addBizItemPropFilter(beforeF7SelectEvent);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        BillOperationStatus billStatus = ((BaseShowParameter)((BaseView)event.getSource()).getFormShowParameter()).getBillStatus();
        logger.info("before closed adjsynset page: {}", (Object)JSON.toJSONString((Object)billStatus));
        if (BillOperationStatus.VIEW.equals((Object)billStatus) || BillOperationStatus.AUDIT.equals((Object)billStatus) || BillOperationStatus.SUBMIT.equals((Object)billStatus)) {
            event.setCheckDataChange(false);
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        Object obj = SWCSalaryParameterServiceHelper.getSalaryParam((String)"adjsalsyn", (String)"enablerange");
        if (obj == null || SWCStringUtils.equals((String)"3", (String)obj.toString())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u85aa\u916c\u57fa\u7840\u670d\u52a1>\u53c2\u6570\u914d\u7f6e\u201d\u4e2d\u7684\u201c\u5b9a\u8c03\u85aa\u6570\u636e\u96c6\u6210\u201d\u672a\u542f\u7528\u3002\u5f53\u524d\u9875\u9762\u4e0d\u53ef\u64cd\u4f5c\uff0c\u8bf7\u9000\u51fa\u3002", (String)"AdjSalSyn_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        switch (key = formOperate.getOperateKey()) {
            case "donothing_addbizitem": {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
                if (CountryHelper.checkInvalidAndSetFilter((AbstractFormPlugin)this, null, (String)"hsbs_standarditem", qFilters, (boolean)true)) {
                    args.setCancel(true);
                    return;
                }
                ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsbs_standarditem", (boolean)true);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACKID_ADDBIZITEM));
                qFilters.addAll(this.bizItemFilter());
                showParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "donothing_addfield": {
                ListShowParameter itemPropF7ShowParameter = ShowFormHelper.createShowListForm((String)"hcdm_salaryadjfield", (boolean)true);
                itemPropF7ShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callbackid_addfield"));
                List<QFilter> itemPropFilters = this.salaryAdjFieldF7Filter();
                itemPropF7ShowParameter.setListFilterParameter(new ListFilterParameter(itemPropFilters, null));
                this.getView().showForm((FormShowParameter)itemPropF7ShowParameter);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        CountryPolicy countryPolicy = CountryPolicy.createInstance().putErrorInfoEnum("areatype", HCDMErrInfoEnum.COMMON_CLEAR_AREA_TYPE_CONFIRM).putErrorInfoEnum("country", HCDMErrInfoEnum.COMMON_CLEAR_COUNTRY_CONFIRM).putClearPolicy("salarystditem", CountryPolicy.ClearDataPolicyEnum.COMMON_DELETE_ENTITY_REFERENCE, false).putClearPolicy("bizitem", CountryPolicy.ClearDataPolicyEnum.DELETE_DATA_ONLY, false).build();
        CountryHelper.confirmCallBackForCountry((AbstractFormPlugin)this, (MessageBoxClosedEvent)messageBoxClosedEvent, (CountryPolicy)countryPolicy);
    }

    public StringJoiner getChangedInfoOfRefField(boolean isGeneral) {
        long countryId = isGeneral ? 0L : this.getModel().getDataEntity(true).getLong("country.id");
        Map errMsgMap = CountryHelper.getSortLinkedMap(Arrays.asList(HCDMErrInfoEnum.COMMON_SAL_ADJ_ITEM, HCDMErrInfoEnum.COMMON_BIZ_ITEM));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entity : entryEntity) {
            boolean refChanged = CountryHelper.setErrMsgMap((long)countryId, (Map)errMsgMap, (DynamicObject)entity.getDynamicObject("salarystditem"), (boolean)false, (HCDMErrInfoEnum)HCDMErrInfoEnum.COMMON_SAL_ADJ_ITEM);
            CountryHelper.setErrMsgMap((long)countryId, (Map)errMsgMap, (DynamicObject)entity.getDynamicObject("bizitem"), (boolean)refChanged, (HCDMErrInfoEnum)HCDMErrInfoEnum.COMMON_BIZ_ITEM);
        }
        return CountryHelper.getErrMsg((Map)errMsgMap);
    }

    private List<Long> fetchSalaryStdItemEntryIds() {
        ArrayList ids = Lists.newArrayList();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject row : rows) {
            DynamicObject dynamicObject = row.getDynamicObject("salarystditem");
            if (SWCBaseUtils.isEmpty((DynamicObject)dynamicObject)) continue;
            ids.add(dynamicObject.getLong("id"));
        }
        return ids;
    }

    private List<Long> fetchBizItemEntryIds() {
        ArrayList ids = Lists.newArrayList();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject row : rows) {
            DynamicObject dynamicObject = row.getDynamicObject("bizitem");
            if (SWCBaseUtils.isEmpty((DynamicObject)dynamicObject)) continue;
            ids.add(dynamicObject.getLong("id"));
        }
        return ids;
    }

    private List<QFilter> bizItemFilter() {
        List<Long> bizItemIds = this.fetchSalaryStdItemEntryIds();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!bizItemIds.isEmpty()) {
            QFilter idFilter = new QFilter("id", "not in", bizItemIds);
            filters.add(idFilter);
        }
        filters.add(new QFilter("biztype", "like", (Object)"%1%"));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("status", "=", (Object)"C"));
        return filters;
    }

    private List<QFilter> salaryAdjFieldF7Filter() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("status", "=", (Object)"C"));
        DynamicObjectCollection rows = this.getModel().getEntryEntity("fieldentry");
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return filters;
        }
        QFilter idFilter = new QFilter("id", "not in", rows.stream().map(object -> object.getLong("salaryadjfield.id")).collect(Collectors.toList()));
        filters.add(idFilter);
        return filters;
    }

    private void addBizItemPropFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        beforeF7SelectEvent.addCustomQFilter(new QFilter("usetype", "=", (Object)"1"));
        DynamicObjectCollection rows = this.getModel().getEntryEntity("fieldentry");
        beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "not in", rows.stream().map(object -> object.getLong("bizitemprop.id")).collect(Collectors.toList())));
        DynamicObject row = (DynamicObject)rows.get(beforeF7SelectEvent.getRow());
        String fieldNumber = row.getString("salaryadjfield.number");
        String fieldGroup = row.getString("salaryadjfield.group.number");
        List types = SalaryAdjFieldFactory.dataTypesOf((String)fieldGroup, (String)fieldNumber);
        beforeF7SelectEvent.addCustomQFilter(new QFilter("datatype.id", "in", (Object)types));
    }
}

