/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.candidate;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.common.util.SWCListUtils;

public class CandidateSalaryBillPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log log = LogFactory.getLog(CandidateSalaryBillPlugin.class);
    private static final String STANDARDITEM = "standarditem";
    private static final String FREQUENCY = "frequency";
    private static final String SALARYSTRUCTURE = "salarystructure";
    private static final String CURRENCYENT = "currencyent";
    private static final String CURRENCY = "currency";
    private static final String BIZTYPE = "biztype";
    private static final String AREATYPE = "areatype";
    private static final String COUNTRY = "country";
    private static final String COUNTRY_ID = "country.id";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addBeforeF7SelectListener(STANDARDITEM, FREQUENCY);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propertyName = args.getProperty().getName();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        switch (propertyName) {
            case "salarystructure": {
                rows.clear();
                DynamicObject structureEntObj = (DynamicObject)args.getChangeSet()[0].getNewValue();
                DynamicObjectCollection officeSlyItems = structureEntObj.getDynamicObjectCollection("entryentity");
                DynamicObject currencyObj = (DynamicObject)this.getModel().getDataEntity().get(CURRENCY);
                if (SWCListUtils.isEmpty((List)officeSlyItems)) break;
                for (int i = 0; i < officeSlyItems.size(); ++i) {
                    DynamicObject item = new DynamicObject(rows.getDynamicObjectType());
                    item.set(CURRENCYENT, (Object)currencyObj);
                    item.set(STANDARDITEM, ((DynamicObject)officeSlyItems.get(i)).get(STANDARDITEM));
                    rows.add((Object)item);
                }
                this.getModel().deleteEntryData("entryentity");
                this.getModel().updateEntryCache(rows);
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)STANDARDITEM)) {
            this.addCountryFilter(filters, "salarystructure.country.id");
            filters.add(new QFilter(BIZTYPE, "=", (Object)"%1%"));
            this.addRepeatFilter(filters, "standarditem.id");
            beforeF7SelectEvent.setCustomQFilters(filters);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)FREQUENCY)) {
            this.addCountryFilter(filters, "salarystructure.country.id");
            beforeF7SelectEvent.setCustomQFilters(filters);
        }
    }

    private void addBeforeF7SelectListener(String ... fields) {
        for (String filed : fields) {
            BasedataEdit control = (BasedataEdit)this.getView().getControl(filed);
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void addCountryFilter(List<QFilter> filters, String country) {
        Long countryId = this.getModel().getDataEntity().getLong(country);
        QFilter countryFilter = new QFilter(COUNTRY, "=", (Object)countryId);
        countryFilter.or(new QFilter(AREATYPE, "=", (Object)"1"));
        filters.add(countryFilter);
    }

    private void addRepeatFilter(List<QFilter> filters, String itemId) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
        List itemIds = collection.stream().map(o1 -> o1.getLong(itemId)).collect(Collectors.toList());
        if (itemIds.size() != 0) {
            QFilter idFilter = new QFilter("id", "not in", itemIds);
            filters.add(idFilter);
        }
    }
}

