/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.candidate;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.swc.hcdm.business.candidatesetsalaryappl.CandidateSetSalApplyHelper;
import kd.swc.hcdm.business.salarystandardscm.SalaryStandardScmHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CandidateSalaryOfferPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(CandidateSalaryOfferPlugin.class);
    private static final String CHANGE_ORG = "changeOrg";
    private static final String BTN_OK = "btnok";
    private static final String STANDARDITEM = "standarditem";
    private static final String STANDARDITEM_OFFER = "standarditemoffer";
    private static final String FREQUENCY = "frequency";
    private static final String APPID = "appId";
    private static final String RECRUITID = "recruitid";
    private static final String OFFERCODE = "offerCode";
    private static final String OFFERCID_PARAMS = "offerId";
    private static final String OFFER_ID = "offerid";
    private static final String OFFER_CODE = "offercode";
    private static final String CURRENCYENT = "currencyent";
    private static final String CURRENCY = "currency";
    private static final String BIZTYPE = "biztype";
    private static final String AREATYPE = "areatype";
    private static final String COUNTRY = "country";
    private static final String SALARY_OK = "salaryOk";
    private static final String IS_CONTINUE_CLOSE = "is_continue_close";
    private static final String SALARY_STRUCTURE = "salarystructure";
    private static final String SALARY_TYPE_NEW = "salarytypenew";
    private static final String SALARY_TYPE = "salarytype";
    private static final String ENTRYENTITYOFFER = "entryentityoffer";
    private static final String STDSCM = "stdscm";
    private static final String AMOUN_TLAB = "amountlab";
    private static final String SALARY_ADJ_ORG = "salaryadjorg";
    private static final String CONFIRMED_AMOUNT = "confirmedamount";
    private static final String SET_SALARY = "2W+L22GU4FRY";
    private static final String TSO_SOMK_WAITOFFERBASE = "tso_somk_waitofferbase";
    public static final List<String> ENTRYENTITY_LIST = Lists.newArrayList((Object[])new String[]{"frequency", "currencyent", "standarditem", "confirmedamount", "remark", "issend"});

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        if (null != parentView) {
            SWCPermissionServiceHelper.checkCancelDataAndFunctionRightWithException((IFormView)parentView, (boolean)true);
        }
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BTN_OK});
        this.addItemClickListeners(new String[]{FREQUENCY, CURRENCY});
        this.addBeforeF7SelectListener(STANDARDITEM, STANDARDITEM_OFFER, FREQUENCY, SALARY_ADJ_ORG, SALARY_STRUCTURE, SALARY_TYPE_NEW);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals("donothing_submit") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            pageCache.put(IS_CONTINUE_CLOSE, (Object)Boolean.TRUE);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs args) {
        this.setTotalAmount();
    }

    private void doNothingSubmit() {
    }

    private void InitOperationStatus() {
        OpenStyle openStyle;
        ShowType showType;
        FormShowParameter formParam = this.getView().getFormShowParameter();
        Map customParams = formParam.getCustomParams();
        Map params = formParam.getCustomParams();
        if (!SWCObjectUtils.isEmpty(params.get(APPID))) {
            Long appId = Long.valueOf(String.valueOf(params.get(APPID)));
            this.getModel().setValue(RECRUITID, (Object)appId);
        }
        if (!SWCObjectUtils.isEmpty(params.get(OFFERCODE))) {
            String offerCode = String.valueOf(params.get(OFFERCODE));
            this.getModel().setValue(OFFER_CODE, (Object)offerCode);
        }
        if (!SWCObjectUtils.isEmpty(params.get(OFFERCID_PARAMS))) {
            Long offerId = Long.valueOf(String.valueOf(params.get(OFFERCID_PARAMS)));
            this.getModel().setValue(OFFER_ID, (Object)offerId);
        }
        if (ShowType.InContainer.equals((Object)(showType = (openStyle = formParam.getOpenStyle()).getShowType()))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"operatepanel"});
        }
        LOGGER.info("params: {}", (Object)JSONObject.toJSONString((Object)params));
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.InitOperationStatus();
        this.initData();
        this.setTotalAmount();
    }

    private void initData() {
        String offerCode = this.getModel().getDataEntity(true).getString(OFFER_CODE);
        Long offerId = this.getModel().getDataEntity(true).getLong(OFFER_ID);
        Set salaryStructureIds = SWCPermissionServiceHelper.getSalayStructureSetByPermItem((String)"tsrsc", (String)"hcdm_candecidedpage", (String)"47150e89000000ac");
        Set salaryPayrollCdmIds = SWCPermissionServiceHelper.getPayrollCdmSetByPermItem((String)"tsrsc", (String)"hcdm_candecidedpage", (String)"47150e89000000ac");
        if (SWCStringUtils.isNotEmpty((String)offerCode)) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_candidatebill");
            QFilter qFilter = new QFilter(OFFER_CODE, "=", (Object)offerCode);
            QFilter offerIdFilter = new QFilter(OFFER_ID, "=", (Object)offerId);
            DynamicObject dynamicObject = helper.queryOne("id,salarytype,stdscm,salaryadjorg,currency,salarystructure,offerid,entryentity,entryentity.standarditem,entryentity.currencyent,entryentity.frequency,entryentity.confirmedamount,entryentity.issend,entryentity.remark,entryentityoffer,entryentityoffer.standarditemoffer,entryentityoffer.confirmedamountoffer", new QFilter[]{qFilter, offerIdFilter});
            if (!SWCObjectUtils.isEmpty((Object)dynamicObject)) {
                DynamicObject obj;
                int i;
                if (this.getRight(salaryStructureIds, salaryPayrollCdmIds, dynamicObject)) {
                    return;
                }
                this.getModel().setValue(SALARY_TYPE_NEW, dynamicObject.get(SALARY_TYPE));
                this.getModel().setValue(STDSCM, dynamicObject.get(STDSCM));
                this.getModel().setValue(SALARY_ADJ_ORG, dynamicObject.get(SALARY_ADJ_ORG));
                this.getModel().setValue(CURRENCY, dynamicObject.get(CURRENCY));
                this.getModel().setValue(SALARY_STRUCTURE, dynamicObject.get("salarystructure.id"));
                DynamicObjectCollection entryEntityCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                DynamicObjectCollection entryEntityOfferCollection = dynamicObject.getDynamicObjectCollection(ENTRYENTITYOFFER);
                if (!SWCListUtils.isEmpty((List)entryEntityCollection)) {
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                    for (i = 0; i < entryEntityCollection.size(); ++i) {
                        obj = new DynamicObject(entryEntity.getDynamicObjectType());
                        obj.set("seq", (Object)(i + 1));
                        obj.set(STANDARDITEM, ((DynamicObject)entryEntityCollection.get(i)).get(STANDARDITEM));
                        obj.set(CURRENCYENT, ((DynamicObject)entryEntityCollection.get(i)).get(CURRENCYENT));
                        obj.set(FREQUENCY, ((DynamicObject)entryEntityCollection.get(i)).get(FREQUENCY));
                        obj.set(CONFIRMED_AMOUNT, ((DynamicObject)entryEntityCollection.get(i)).get(CONFIRMED_AMOUNT));
                        obj.set("issend", ((DynamicObject)entryEntityCollection.get(i)).get("issend"));
                        obj.set("remark", ((DynamicObject)entryEntityCollection.get(i)).get("remark"));
                        entryEntity.add(i, obj);
                    }
                }
                if (!SWCListUtils.isEmpty((List)entryEntityOfferCollection) && !SWCListUtils.isEmpty((List)entryEntityCollection)) {
                    DynamicObjectCollection entryEntityOffer = this.getModel().getEntryEntity(ENTRYENTITYOFFER);
                    for (i = 0; i < entryEntityOfferCollection.size(); ++i) {
                        obj = new DynamicObject(entryEntityOffer.getDynamicObjectType());
                        obj.set("seq", (Object)(i + 1));
                        obj.set(STANDARDITEM_OFFER, ((DynamicObject)entryEntityOfferCollection.get(i)).get(STANDARDITEM_OFFER));
                        obj.set("confirmedamountoffer", ((DynamicObject)entryEntityOfferCollection.get(i)).get("confirmedamountoffer"));
                        entryEntityOffer.add(i, obj);
                    }
                }
            } else if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                this.getModel().setValue(SALARY_TYPE_NEW, null);
                this.getModel().setValue(CURRENCY, null);
            } else {
                this.setSalaryAdjOrgByPeAdminOrg();
            }
            HashMap advConApCtrl = new HashMap(16);
            HashMap<String, String> margin = new HashMap<String, String>(16);
            if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                margin.put("t", "-30px");
            } else {
                margin.put("t", "-8px");
            }
            HashMap<String, HashMap<String, String>> styleMargin = new HashMap<String, HashMap<String, String>>(16);
            styleMargin.put("m", margin);
            advConApCtrl.put("s", styleMargin);
            this.getView().updateControlMetadata("advconap", advConApCtrl);
        }
    }

    private void setSalaryAdjOrgByPeAdminOrg() {
        FormShowParameter formParam = this.getView().getFormShowParameter();
        Map params = formParam.getCustomParams();
        Object peadminorg = params.get("peadminorg");
        if (Objects.nonNull(peadminorg)) {
            Long businesstypeId = 1050L;
            Long peadminorgId = (Long)ObjectConverter.convert(peadminorg, Long.class, (boolean)true);
            LOGGER.info("SingleCandidateSetSalApplicationEdit IHRCSStrategyService.getHrbuFromManageEmpStrategy pram= {},{}", peadminorg, (Object)businesstypeId);
            Map result = (Map)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"getHrbuFromManageEmpStrategy", (Object[])new Object[]{peadminorgId, 0L, businesstypeId, 0L});
            LOGGER.info("SingleCandidateSetSalApplicationEdit IHRCSStrategyService.getHrbuFromManageEmpStrategy result= {}", (Object)result);
            if (!CollectionUtils.isEmpty((Map)result)) {
                DynamicObject createOrg = (DynamicObject)result.get("hrbu");
                this.getModel().setValue(SALARY_ADJ_ORG, (Object)createOrg);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propertyName = args.getProperty().getName();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        switch (propertyName) {
            case "salarystructure": {
                DynamicObject newDy = (DynamicObject)args.getChangeSet()[0].getNewValue();
                DynamicObject oldDy = (DynamicObject)args.getChangeSet()[0].getOldValue();
                if (null == newDy) {
                    this.clearEntity();
                    this.getModel().setValue(STDSCM, null);
                    return;
                }
                if (oldDy != null && oldDy.getLong("id") == newDy.getLong("id")) {
                    return;
                }
                this.setStdScm(newDy);
                rows.clear();
                this.setStandardItem(rows, newDy);
                this.setTotalAmount();
                break;
            }
            case "currency": {
                this.currencyChanged(args, rows);
                break;
            }
            case "salaryadjorg": {
                this.showOrgChangeConfirm(args);
                break;
            }
            case "confirmedamount": 
            case "frequency": 
            case "currencyent": {
                this.setTotalAmount();
                break;
            }
            case "standarditem": {
                this.setStandardItemChange(rows, args);
                break;
            }
        }
    }

    private void setStandardItemChange(DynamicObjectCollection rows, PropertyChangedArgs args) {
        DynamicObject newDy = (DynamicObject)args.getChangeSet()[0].getNewValue();
        if (null == newDy) {
            int rowIndex = args.getChangeSet()[0].getRowIndex();
            this.clearCurrentRow(newDy, rowIndex);
            return;
        }
        long stdscmId = this.getModel().getDataEntity().getLong("stdscm.id");
        if (0L == stdscmId) {
            this.clearEntity();
            return;
        }
        DynamicObject stdScmEntObj = this.getStdScm(stdscmId);
        DynamicObjectCollection officeSlyItems = stdScmEntObj.getDynamicObjectCollection("entryentity");
        DynamicObject currencyObj = (DynamicObject)this.getModel().getDataEntity().get(CURRENCY);
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        if (!SWCListUtils.isEmpty((List)officeSlyItems)) {
            for (DynamicObject officeSlyItem : officeSlyItems) {
                if (!SWCStringUtils.equals((String)officeSlyItem.getString("standarditem.enable"), (String)"1") || officeSlyItem.getLong("salstructurent.id") != this.getModel().getDataEntity().getLong("salarystructure.id") || officeSlyItem.getLong("standarditem.id") != newDy.getLong("id")) continue;
                this.getModel().setValue(STANDARDITEM, officeSlyItem.get(STANDARDITEM), rowIndex);
                if (null != officeSlyItem.get("salarystandard.currency")) {
                    this.getModel().setValue(CURRENCYENT, officeSlyItem.get("salarystandard.currency"), rowIndex);
                } else {
                    this.getModel().setValue(CURRENCYENT, (Object)currencyObj, rowIndex);
                }
                this.getModel().setValue(FREQUENCY, officeSlyItem.get("salarystandard.frequency"), rowIndex);
                break;
            }
            this.getView().updateView("entryentity");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)STANDARDITEM)) {
            Object salarystructure = this.getModel().getDataEntity().get(SALARY_STRUCTURE);
            if (null == salarystructure) {
                beforeF7SelectEvent.setCancel(true);
                String message = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u85aa\u916c\u7ed3\u6784\u3002", (String)"CandidateSalaryOfferPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                return;
            }
            this.addSelectFilter(filters, beforeF7SelectEvent);
            this.addRepeatFilter(filters, "standarditem.id", "entryentity");
            this.addStandardItemFilter(beforeF7SelectEvent, filters);
            beforeF7SelectEvent.setCustomQFilters(filters);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)STANDARDITEM_OFFER)) {
            filters.add(new QFilter(BIZTYPE, "like", (Object)"%3%"));
            this.addRepeatFilter(filters, "standarditemoffer.id", ENTRYENTITYOFFER);
            this.addStandardItemFilter(beforeF7SelectEvent, filters);
            beforeF7SelectEvent.setCustomQFilters(filters);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)FREQUENCY)) {
            this.addCountryFilter(filters, "salarystructure.country.id");
            beforeF7SelectEvent.setCustomQFilters(filters);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)SALARY_ADJ_ORG)) {
            // empty if block
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)SALARY_STRUCTURE)) {
            this.addStructtureFilter(beforeF7SelectEvent, filters);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)SALARY_TYPE_NEW)) {
            this.addSalaryAdjustrsnFilter(beforeF7SelectEvent, filters);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "continue_closed": {
                if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) break;
                SWCPageCache pageCache = new SWCPageCache(this.getView());
                pageCache.put(IS_CONTINUE_CLOSE, (Object)Boolean.TRUE);
                this.getView().invokeOperation("close");
                break;
            }
            case "changeOrg": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.cleanSalaryStructureAndRelatedField();
                    break;
                }
                this.setOldValue("oldorgdy", "", SALARY_ADJ_ORG);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        event.setCheckDataChange(false);
    }

    private void clearEntity() {
        this.getModel().deleteEntryData("entryentity");
        this.setTotalAmount();
    }

    private void currencyChanged(PropertyChangedArgs args, DynamicObjectCollection rows) {
        if (rows.size() > 0) {
            DynamicObject currency = (DynamicObject)args.getChangeSet()[0].getNewValue();
            for (DynamicObject row : rows) {
                row.set(CURRENCYENT, (Object)currency);
            }
            this.setTotalAmount();
            this.getModel().updateEntryCache(rows);
            this.getView().updateView("entryentity");
        }
    }

    private void setStandardItem(DynamicObjectCollection rows, DynamicObject newDy) {
        long stdscmId = this.getModel().getDataEntity().getLong("stdscm.id");
        if (0L == stdscmId) {
            this.clearEntity();
            return;
        }
        DynamicObject stdScmEntObj = this.getStdScm(stdscmId);
        DynamicObjectCollection officeSlyItems = stdScmEntObj.getDynamicObjectCollection("entryentity");
        DynamicObject currencyObj = (DynamicObject)this.getModel().getDataEntity().get(CURRENCY);
        this.getModel().deleteEntryData("entryentity");
        this.getModel().updateEntryCache(rows);
        if (!SWCListUtils.isEmpty((List)officeSlyItems)) {
            for (DynamicObject officeSlyItem : officeSlyItems) {
                if (!SWCStringUtils.equals((String)officeSlyItem.getString("standarditem.enable"), (String)"1") || officeSlyItem.getLong("salstructurent.id") != newDy.getLong("id")) continue;
                this.getModel().beginInit();
                int rowIndex = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue(STANDARDITEM, officeSlyItem.get(STANDARDITEM), rowIndex);
                if (null != officeSlyItem.get("salarystandard.currency")) {
                    this.getModel().setValue(CURRENCYENT, officeSlyItem.get("salarystandard.currency"), rowIndex);
                } else {
                    this.getModel().setValue(CURRENCYENT, (Object)currencyObj, rowIndex);
                }
                this.getModel().setValue(FREQUENCY, officeSlyItem.get("salarystandard.frequency"), rowIndex);
                this.getModel().endInit();
            }
            this.getView().updateView("entryentity");
        }
    }

    private void setStdScm(DynamicObject newDy) {
        long id = newDy.getLong("id");
        Map listMap = SalaryStandardScmHelper.queryStdScmMapByStructureIds((Set)Sets.newHashSet((Object[])new Long[]{id}));
        if (CollectionUtils.isEmpty((Map)listMap) || CollectionUtils.isEmpty((Collection)((Collection)listMap.get(id)))) {
            this.clearEntity();
            return;
        }
        List list = (List)listMap.get(id);
        Long stdScmVid = this.getStdScmVid(list);
        this.getModel().setValue(STDSCM, (Object)stdScmVid);
        if (null == stdScmVid) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u85aa\u916c\u7ed3\u6784\u5728\u5f53\u524d\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u5339\u914d\u7684\u5b9a\u8c03\u85aa\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u6216\u8005\u85aa\u916c\u7ed3\u6784\u3002", (String)"CandidateSalaryOfferPlugin_6", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().updateView(STDSCM);
    }

    private Long getStdScmVid(List<DynamicObject> list) {
        if (!CollectionUtils.isEmpty(list)) {
            if (list.size() == 1) {
                return list.get(0).getLong("sourcevid");
            }
            if (null == this.getModel().getDataEntity().get(SALARY_ADJ_ORG)) {
                return null;
            }
            for (DynamicObject stdScmDy : list) {
                if (stdScmDy.getLong("createorg.id") != this.getModel().getDataEntity().getLong("salaryadjorg.id")) continue;
                return stdScmDy.getLong("sourcevid");
            }
        }
        return null;
    }

    private void addStandardItemFilter(BeforeF7SelectEvent beforeF7SelectEvent, List<QFilter> filters) {
        if (Objects.isNull(this.getModel().getDataEntity().getDynamicObject(SALARY_ADJ_ORG))) {
            beforeF7SelectEvent.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"CandidateSalaryOfferPlugin_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        filters.add(qFilter);
        this.getBaseOrgFilters(filters, "hsbs_standarditem");
    }

    private void addStructtureFilter(BeforeF7SelectEvent beforeF7SelectEvent, List<QFilter> filters) {
        if (Objects.isNull(this.getModel().getDataEntity().getDynamicObject(SALARY_ADJ_ORG))) {
            beforeF7SelectEvent.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"CandidateSalaryOfferPlugin_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        filters.add(qFilter);
        this.getBaseOrgFilters(filters, "hcdm_salaystructure");
        beforeF7SelectEvent.setCustomQFilters(filters);
    }

    private void addSalaryAdjustrsnFilter(BeforeF7SelectEvent beforeF7SelectEvent, List<QFilter> filters) {
        if (Objects.isNull(this.getModel().getDataEntity().getDynamicObject(SALARY_ADJ_ORG))) {
            beforeF7SelectEvent.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"CandidateSalaryOfferPlugin_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("attributiontype", "=", (Object)AdjAttributionType.DECATTRTYPE.getCode()));
        filters.add(qFilter);
        this.getBaseOrgFilters(filters, "hsbs_salaryadjustrsn");
        beforeF7SelectEvent.setCustomQFilters(filters);
    }

    private void getBaseOrgFilters(List<QFilter> filters, String entityName) {
        QFilter baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)entityName, (Long)this.getModel().getDataEntity().getLong("salaryadjorg.id"));
        if (null != baseDataFilter) {
            filters.add(baseDataFilter);
        }
    }

    private void addSelectFilter(List<QFilter> filters, BeforeF7SelectEvent beforeF7SelectEvent) {
        Object stdScm = this.getModel().getDataEntity().get(STDSCM);
        if (null == stdScm) {
            filters.add(new QFilter("1", "!=", (Object)1));
            return;
        }
        DynamicObject stdScmEntObj = this.getStdScm(this.getModel().getDataEntity().getLong("stdscm.id"));
        DynamicObjectCollection officeSlyItems = stdScmEntObj.getDynamicObjectCollection("entryentity");
        ArrayList standardItemId = Lists.newArrayListWithExpectedSize((int)officeSlyItems.size());
        for (DynamicObject officeSlyItem : officeSlyItems) {
            if (!SWCStringUtils.equals((String)officeSlyItem.getString("standarditem.enable"), (String)"1") || officeSlyItem.getLong("salstructurent.id") != this.getModel().getDataEntity().getLong("salarystructure.id")) continue;
            standardItemId.add(officeSlyItem.getLong("standarditem.id"));
        }
        filters.add(new QFilter("id", "in", (Object)standardItemId));
    }

    private void addBeforeF7SelectListener(String ... fields) {
        for (String filed : fields) {
            Control control = this.getView().getControl(filed);
            if (control instanceof BasedataEdit) {
                BasedataEdit basedataEdit = (BasedataEdit)control;
                basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
            if (!(control instanceof TextEdit)) continue;
            TextEdit textEdit = (TextEdit)this.getView().getControl(filed);
            textEdit.addClickListener((ClickListener)this);
        }
    }

    private void addCountryFilter(List<QFilter> filters, String country) {
        Long countryId = this.getModel().getDataEntity().getLong(country);
        QFilter countryFilter = new QFilter(COUNTRY, "=", (Object)countryId);
        countryFilter.or(new QFilter(AREATYPE, "=", (Object)"1"));
        filters.add(countryFilter);
    }

    private void addRepeatFilter(List<QFilter> filters, String itemId, String entityName) {
        List itemIds;
        DynamicObjectCollection collection = this.getModel().getEntryEntity(entityName);
        if (collection.size() > 0 && (itemIds = collection.stream().map(o1 -> o1.getLong(itemId)).collect(Collectors.toList())).size() != 0) {
            QFilter idFilter = new QFilter("id", "not in", itemIds);
            filters.add(idFilter);
        }
    }

    private void cleanSalaryStructureAndRelatedField() {
        this.getModel().beginInit();
        this.getModel().setValue(SALARY_STRUCTURE, null);
        this.getModel().setValue(SALARY_TYPE_NEW, null);
        this.clearEntity();
        this.getModel().deleteEntryData(ENTRYENTITYOFFER);
        this.getModel().endInit();
        this.getView().updateView();
    }

    private void showOrgChangeConfirm(PropertyChangedArgs args) {
        ChangeData[] changeData = args.getChangeSet();
        DynamicObject oldDy = (DynamicObject)changeData[0].getOldValue();
        DynamicObject newDy = (DynamicObject)changeData[0].getNewValue();
        if (Objects.nonNull(oldDy) && Objects.nonNull(newDy) && oldDy.getLong("id") == newDy.getLong("id")) {
            return;
        }
        if (Objects.nonNull(oldDy)) {
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u7ec4\u7ec7\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"CandidateSalaryOfferPlugin_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            this.getPageCache().remove("oldorgdy");
            this.getPageCache().put("oldorgdy", SerializationUtils.serializeToBase64((Object)oldDy));
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CHANGE_ORG, (IFormPlugin)this));
        }
    }

    private void setTotalAmount() {
        List<String> result = this.getDifferentTotalAmountStrList(this.getModel().getEntryEntity("entryentity"));
        if (result.size() > 0) {
            this.setCalConfirmAmount(String.join((CharSequence)"+", result));
        } else {
            this.setCalConfirmAmount(" ");
            this.getView().updateView(AMOUN_TLAB);
        }
    }

    private void setCalConfirmAmount(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            Label tab = (Label)this.getControl(AMOUN_TLAB);
            tab.setText(str);
            this.getView().updateView(AMOUN_TLAB);
        }
    }

    private List<String> getDifferentTotalAmountStrList(DynamicObjectCollection entryEntities) {
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return ImmutableList.of();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)entryEntities.size());
        HashMap currencyMap = Maps.newHashMapWithExpectedSize((int)entryEntities.size());
        HashMap frequencyMap = Maps.newHashMapWithExpectedSize((int)entryEntities.size());
        HashMap currencyGroupMap = Maps.newHashMapWithExpectedSize((int)entryEntities.size());
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObject frequencyDy = entryEntity.getDynamicObject(FREQUENCY);
            DynamicObject currencyDy = entryEntity.getDynamicObject(CURRENCYENT);
            BigDecimal amount = entryEntity.getBigDecimal(CONFIRMED_AMOUNT);
            if (Objects.isNull(frequencyDy) || Objects.isNull(currencyDy) || Objects.isNull(amount)) continue;
            currencyMap.put(currencyDy.getLong("id"), currencyDy);
            frequencyMap.put(frequencyDy.getLong("id"), frequencyDy);
            Map frequencyGroupMap = currencyGroupMap.computeIfAbsent(currencyDy.getLong("id"), o1 -> Maps.newHashMap());
            List dataList = frequencyGroupMap.computeIfAbsent(frequencyDy.getLong("id"), o1 -> Lists.newArrayList());
            dataList.add(entryEntity);
            frequencyGroupMap.put(frequencyDy.getLong("id"), dataList);
            currencyGroupMap.put(currencyDy.getLong("id"), frequencyGroupMap);
        }
        for (Map.Entry currencyEntry : currencyGroupMap.entrySet()) {
            Map currencyEntryValue = (Map)currencyEntry.getValue();
            for (Map.Entry frequencyEntry : currencyEntryValue.entrySet()) {
                StringBuilder temp = new StringBuilder();
                List frequencyEntryValue = (List)frequencyEntry.getValue();
                BigDecimal confirmAmount = frequencyEntryValue.stream().map(o1 -> o1.getBigDecimal(CONFIRMED_AMOUNT)).reduce(BigDecimal.ZERO, BigDecimal::add);
                String sign = ((DynamicObject)currencyMap.get(currencyEntry.getKey())).getString("sign");
                String pricePrecision = ((DynamicObject)currencyMap.get(currencyEntry.getKey())).getString("amtprecision");
                String frequencyName = ((DynamicObject)frequencyMap.get(frequencyEntry.getKey())).getString("name");
                temp.append(sign).append(CandidateSetSalApplyHelper.fmtMicrometer((String)confirmAmount.setScale(Integer.parseInt(pricePrecision), 5).toString())).append('/').append(frequencyName);
                result.add(temp.toString());
            }
        }
        return result;
    }

    private DynamicObject getStdScm(long stdscmId) {
        SWCDataServiceHelper service = new SWCDataServiceHelper("hcdm_stdscm");
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and(new QFilter("id", "=", (Object)stdscmId));
        return service.queryOne("id, entryentity, entryentity.salstructurent, standarditem, entryentity.standarditem.enable, salarystandard.frequency, salarystandard.currency", new QFilter[]{qFilter});
    }

    private void setOldValue(String oldValueCacheKey, String newValueCacheKey, String key) {
        String oldDyStr = this.getPageCache().get(oldValueCacheKey);
        if (Strings.isNullOrEmpty((String)oldDyStr)) {
            return;
        }
        DynamicObject oldDy = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)oldDyStr);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        this.getModel().setValue(key, (Object)oldDy);
        model.endInit();
        this.getPageCache().remove(oldValueCacheKey);
        this.getPageCache().remove(newValueCacheKey);
        this.getView().updateView(key);
    }

    private void clearCurrentRow(DynamicObject currentRow, int rowIndex) {
        this.getModel().beginInit();
        for (String key : ENTRYENTITY_LIST) {
            this.getModel().setValue(key, null, rowIndex);
            this.getView().updateView(key, rowIndex);
        }
        this.setTotalAmount();
        this.getModel().endInit();
    }

    private boolean getRight(Set<Long> salaryStructureIds, Set<Long> salaryPayrollCdmIds, DynamicObject dynamicObject) {
        FormShowParameter formParam = this.getView().getFormShowParameter();
        Object hasRight = formParam.getCustomParams().get("hasRight");
        if (null != hasRight && "1".equals(hasRight)) {
            return false;
        }
        if (null != salaryStructureIds && !salaryStructureIds.contains(dynamicObject.get("salarystructure.id"))) {
            this.getModel().setValue(SALARY_TYPE_NEW, null);
            this.getModel().setValue(CURRENCY, null);
            if (!OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                this.getView().setStatus(OperationStatus.VIEW);
            }
            return true;
        }
        if (null != salaryPayrollCdmIds && !salaryPayrollCdmIds.contains(dynamicObject.get("salaryadjorg.id"))) {
            this.getModel().setValue(SALARY_TYPE_NEW, null);
            this.getModel().setValue(CURRENCY, null);
            if (!OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                this.getView().setStatus(OperationStatus.VIEW);
            }
            return true;
        }
        return false;
    }
}

