/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.candidate;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.country.CountryHelper;
import kd.swc.hcdm.business.country.CountryPolicy;
import kd.swc.hcdm.business.country.CountryRefChanged;
import kd.swc.hcdm.common.enums.HCDMErrInfoEnum;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCObjectUtils;

public class SalaryStructureEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener,
SelectRowsEventListener,
CountryRefChanged {
    private static final String STANDARDITEM = "standarditem";
    private static final String CLOSECALLBACK_ACTIONID_NEWENTRY = "closecallback_actionid_newentry";
    private static final String CONFIRMCALLBACK_ACTIONID_TIP = "confirmcallback_actionid_tip";
    private static final String CONFIRMCALLBACK_ACTION_OP = "confirmcallback_action_op";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addBeforeF7SelectListener(STANDARDITEM);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "newentry_base": {
                args.setCancel(true);
                this.newEntryBase(args);
                break;
            }
            case "save": 
            case "submit": {
                if (formOperate.getOption().tryGetVariableValue("isAfterConfirm", new RefObject()) || !this.checkReferenceByScm(operateKey)) break;
                args.setCancel(true);
                break;
            }
        }
    }

    private boolean checkReferenceByScm(String opKey) {
        long id = this.getModel().getDataEntity().getLong("id");
        if (id == 0L) {
            return false;
        }
        String sql = "SELECT COUNT(1) FCOUNTA FROM T_HCDM_STDSCMSTRUCTURE WHERE FBASEDATAID = ?";
        int countO = (Integer)SWCDbUtil.query((DBRoute)new DBRoute("hcdm"), (String)sql, (Object[])new Object[]{id}, rs -> {
            int count = 0;
            while (rs.next()) {
                count = rs.getInt("FCOUNTA");
            }
            return count;
        });
        if (countO <= 0) {
            return false;
        }
        String sql2 = "SELECT FSTANDARDITEMID FROM T_HCDM_SLYSTRUCTUREENT WHERE FID = ?";
        List itemIds = (List)SWCDbUtil.query((DBRoute)new DBRoute("hcdm"), (String)sql2, (Object[])new Object[]{id}, rs -> {
            ArrayList<Long> itemId = new ArrayList<Long>(16);
            while (rs.next()) {
                itemId.add(rs.getLong("FSTANDARDITEMID"));
            }
            return itemId;
        });
        boolean isModify = false;
        DynamicObjectCollection dyColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (dyColl.size() != itemIds.size()) {
            isModify = true;
        } else {
            for (DynamicObject dyObj : dyColl) {
                if (itemIds.contains(dyObj.getLong("standarditem.id"))) continue;
                isModify = true;
                break;
            }
        }
        if (!isModify) {
            return false;
        }
        String tips = ResManager.loadKDString((String)"\u5f53\u524d\u201c\u5b9a\u8c03\u85aa\u9879\u76ee\u201d\u8303\u56f4\u53d1\u751f\u53d8\u52a8\uff0c\u8bf7\u53ca\u65f6\u8c03\u6574\u85aa\u916c\u4f53\u7cfb\uff0c\u907f\u514d\u5f71\u54cd\u540e\u7eed\u5b9a\u8c03\u85aa\u4e1a\u52a1\u3002", (String)"SalaryStructureEdit_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        this.getView().getPageCache().put(CONFIRMCALLBACK_ACTION_OP, opKey);
        this.getView().showMessage(tips, MessageTypes.Default, new ConfirmCallBackListener(CONFIRMCALLBACK_ACTIONID_TIP));
        return true;
    }

    private void newEntryBase(BeforeDoOperationEventArgs args) {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsbs_standarditem", (boolean)true);
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        if (CountryHelper.checkInvalidAndSetFilter((AbstractFormPlugin)this, null, (String)"hsbs_standarditem", (List)qFilters, (boolean)true)) {
            args.setCancel(true);
            return;
        }
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        qFilters.add(new QFilter("biztype", "like", (Object)"%1%"));
        QFilter createOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_standarditem", (Long)this.getModel().getDataEntity().getLong("createorg.id"));
        qFilters.add(createOrgFilter);
        showParameter.setListFilterParameter(listFilterParameter);
        List itemIds = this.getModel().getEntryEntity("entryentity").stream().map(object -> object.getLong("standarditem.id")).collect(Collectors.toList());
        showParameter.setSelectedRows(itemIds.toArray());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_ACTIONID_NEWENTRY));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "closecallback_actionid_newentry": {
                this.confirmToSetItem(event);
                break;
            }
        }
    }

    private void confirmToSetItem(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        List<Long> salaryItemIds = new ArrayList(10);
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
            for (ListSelectedRow selectedRow : listSelectedRows) {
                salaryItemIds.add((Long)selectedRow.getPrimaryKeyValue());
            }
        } else if (returnData instanceof List) {
            salaryItemIds = (List)returnData;
        }
        if (salaryItemIds.size() > 0) {
            DynamicObjectCollection beforeDelEntryEntities = this.getModel().getEntryEntity("entryentity");
            int[] delRowIndex = this.getDelEntryAdjDecisionCfgIndexs(beforeDelEntryEntities);
            if (delRowIndex.length != 0) {
                this.getModel().deleteEntryRows("entryentity", delRowIndex);
            }
            this.batchCreateNewEntry(salaryItemIds);
        }
    }

    private void batchCreateNewEntry(List<Long> salaryItemIds) {
        int i;
        if (salaryItemIds.size() == 0) {
            return;
        }
        IDataModel dataModel = this.getModel();
        ArrayList indexs = Lists.newArrayList();
        DynamicObjectCollection salaryItemIdsCol = dataModel.getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (i = 0; i < salaryItemIdsCol.size(); ++i) {
            DynamicObject salaryItemId = (DynamicObject)salaryItemIdsCol.get(i);
            if (!SWCObjectUtils.isEmpty((Object)salaryItemId.get(STANDARDITEM))) continue;
            indexs.add(i);
        }
        if (indexs.size() < salaryItemIds.size()) {
            int currRowCnt;
            int size = salaryItemIds.size() - indexs.size();
            for (int row = currRowCnt = dataModel.getEntryRowCount("entryentity"); row < currRowCnt + size; ++row) {
                indexs.add(row);
            }
            dataModel.batchCreateNewEntryRow("entryentity", size);
        }
        for (i = 0; i < indexs.size() && i < salaryItemIds.size(); ++i) {
            Integer index = (Integer)indexs.get(i);
            Long salaryItemId = salaryItemIds.get(i);
            dataModel.setValue(STANDARDITEM, (Object)salaryItemId, index.intValue());
        }
        this.getView().updateView("entryentity");
    }

    private int[] getDelEntryAdjDecisionCfgIndexs(DynamicObjectCollection beforeDelEntryEntities) {
        HashSet deleteSalaryItemIdsIndexs = Sets.newHashSet();
        for (int index = 0; index < beforeDelEntryEntities.size(); ++index) {
            DynamicObject entryStandardItem = ((DynamicObject)beforeDelEntryEntities.get(index)).getDynamicObject(STANDARDITEM);
            if (entryStandardItem == null) continue;
            deleteSalaryItemIdsIndexs.add(index);
        }
        return Ints.toArray((Collection)deleteSalaryItemIdsIndexs);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName;
        super.propertyChanged(args);
        switch (propertyName = args.getProperty().getName()) {
            case "standarditem": {
                DynamicObjectCollection entryEntityRows = this.getModel().getEntryEntity("entryentity");
                entryEntityRows.stream().forEach(row -> {
                    String fixedItem = row.getString("standarditem.fixeditem");
                    row.set("fixeditem", (Object)fixedItem);
                });
                this.getView().updateView("entryentity");
                break;
            }
        }
        CountryPolicy countryPolicy = CountryPolicy.createInstance().putErrorInfoEnum("country", HCDMErrInfoEnum.COMMON_CLEAR_COUNTRY_CONFIRM).delAfterConfirm(true).build();
        CountryHelper.propertyChangedForCountry((AbstractFormPlugin)this, (PropertyChangedArgs)args, (CountryPolicy)countryPolicy);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        CountryPolicy countryPolicy = CountryPolicy.createInstance().putErrorInfoEnum("country", HCDMErrInfoEnum.COMMON_CLEAR_COUNTRY_CONFIRM).putClearPolicy(STANDARDITEM, CountryPolicy.ClearDataPolicyEnum.COMMON_DELETE_ENTITY_REFERENCE, false).build();
        CountryHelper.confirmCallBackForCountry((AbstractFormPlugin)this, (MessageBoxClosedEvent)evt, (CountryPolicy)countryPolicy);
        if (CONFIRMCALLBACK_ACTIONID_TIP.equals(evt.getCallBackId())) {
            String opKey = this.getView().getPageCache().get(CONFIRMCALLBACK_ACTION_OP);
            this.getView().getPageCache().remove(CONFIRMCALLBACK_ACTION_OP);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("isAfterConfirm", "true");
            if (StringUtils.isNotEmpty((CharSequence)opKey)) {
                this.getView().invokeOperation(opKey, operateOption);
            }
        }
    }

    public StringJoiner getChangedInfoOfRefField(boolean isGeneral) {
        long countryId = this.getModel().getDataEntity(true).getLong("country.id");
        Map errMsgMap = CountryHelper.getSortLinkedMap(Collections.singletonList(HCDMErrInfoEnum.COMMON_SAL_ADJ_ITEM));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entity : entryEntity) {
            CountryHelper.setErrMsgMap((long)countryId, (Map)errMsgMap, (DynamicObject)entity.getDynamicObject(STANDARDITEM), (boolean)false, (HCDMErrInfoEnum)HCDMErrInfoEnum.COMMON_SAL_ADJ_ITEM);
        }
        return CountryHelper.getErrMsg((Map)errMsgMap);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)STANDARDITEM)) {
            boolean isInvalid = CountryHelper.checkInvalidAndSetFilter((AbstractFormPlugin)this, (IMetadata)beforeF7SelectEvent.getProperty(), null, (List)beforeF7SelectEvent.getCustomQFilters(), (boolean)true);
            if (isInvalid) {
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            this.addRepeatFilter(filters, "standarditem.id");
            filters.add(new QFilter("biztype", "like", (Object)"%1%"));
            beforeF7SelectEvent.setCustomQFilters(filters);
        }
    }

    private void addRepeatFilter(List<QFilter> filters, String itemId) {
        List itemIds = this.getModel().getEntryEntity("entryentity").stream().map(object -> object.getLong(itemId)).collect(Collectors.toList());
        if (itemIds.size() != 0) {
            QFilter idFilter = new QFilter("id", "not in", itemIds);
            filters.add(idFilter);
        }
    }

    private void addBeforeF7SelectListener(String ... fields) {
        for (String filed : fields) {
            Control control = this.getView().getControl(filed);
            if (control instanceof BasedataEdit) {
                BasedataEdit basedataEdit = (BasedataEdit)control;
                basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
            if (!(control instanceof TextEdit)) continue;
            TextEdit textEdit = (TextEdit)this.getView().getControl(filed);
            textEdit.addClickListener((ClickListener)this);
        }
    }
}

