/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.candidatesetsalaryappl;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CandSetSalApplyRefreshListPlugin
extends AbstractListPlugin {
    private static final String CONFORM_REFRESH = "conform_refresh";
    private static final String PARA_AFTERCONFIRM = "afterconfirm";
    private static final String CLOSECALLBACK_REFRESH = "closecallback_refresh";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        OperateOption option = formOperate.getOption();
        String afterConfirm = option.getVariableValue(PARA_AFTERCONFIRM, "0");
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"refreshonbrd") && StringUtils.equals((CharSequence)afterConfirm, (CharSequence)"0")) {
            args.setCancel(true);
            this.showConfirmForRefresh();
        }
    }

    private void showConfirmForRefresh() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return;
        }
        String confirmMsg = ResManager.loadKDString((String)"\u5171\u9009\u4e2d%s\u6761\u8bb0\u5f55\uff0c\u66f4\u65b0\u540e\u5c06\u4f1a\u4f7f\u7528\u6700\u65b0\u7684\u5165\u804c\u4fe1\u606f\u5237\u65b0\u5bf9\u5e94\u7684\u5b9a\u85aa\u4fe1\u606f\uff0c\u786e\u5b9a\u66f4\u65b0\uff1f", (String)"CandSetSalApplyRefreshListPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        List ids = selectedRows.stream().map(obj -> (Long)obj.getPrimaryKeyValue()).collect(Collectors.toList());
        IFormView view = this.getView();
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("hcdm_comfirmandexport");
        parameter.setCustomParam("centerContent", (Object)String.format(Locale.ROOT, confirmMsg, selectedRows.size()));
        parameter.setCustomParam("isNeedExport", (Object)"1");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_REFRESH));
        String pageId = parameter.getPageId();
        PageCache pageCache = new PageCache(pageId);
        pageCache.put("ids", SerializationUtils.serializeToBase64(ids));
        view.showForm(parameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"refreshonbrd") && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (MessageBoxResult.Yes.equals((Object)event.getResult()) && CONFORM_REFRESH.equals(event.getCallBackId())) {
            this.invokeRefreshOnbrd();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        String actionId = event.getActionId();
        if (CLOSECALLBACK_REFRESH.equals(actionId) && (returnData = event.getReturnData()) != null && ((Boolean)returnData).booleanValue()) {
            this.invokeRefreshOnbrd();
        }
    }

    private void invokeRefreshOnbrd() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue(PARA_AFTERCONFIRM, "1");
        this.getView().invokeOperation("refreshonbrd", operateOption);
    }
}

