/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.candidatesetsalaryappl;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.swc.hcdm.business.candidatesetsalaryappl.CandidateSetSalApplyHelper;
import kd.swc.hcdm.business.candidatesetsalaryappl.CandidateSetSalApplyService;
import kd.swc.hcdm.business.salaryadjfile.AdjFileCertCommonHelper;
import kd.swc.hcdm.business.salaryadjfile.AdjFileFormHelper;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CandidateSetSalApplicationListPlugin
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(CandidateSetSalApplicationListPlugin.class);
    private static final String CALLBACK_SUBMITEFFECT = "call_submiteffect";
    private static final String CONFIRM_SUBMITEFFECT = "confirm_submiteffect";
    private static final String CALLBACK_SUBMITEFFECT_ENTRYCONFIRM = "call_submiteffect_entryconfirm";
    private static final String CALLBACK_SUBMIT_ENTRYCONFIRM = "call_submit_entryconfirm";
    private static final String CONFIRM_SUBMITEFFECT_ENTRYCONFIRM = "confirm_submiteffect_entryconfirm";

    public void initialize() {
        this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)"hcdm_singlecandsetsalappl");
        this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
        this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)"department");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String colKey;
        switch (colKey = args.getFieldName()) {
            case "salaryadjfile_number": {
                this.clickNumber(args);
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.itemClick((ItemClickEvent)evt);
        String itemKey = evt.getItemKey();
        String operationKey = evt.getOperationKey();
        LOGGER.info("CandidateSetSalApplicationListPlugin itemKey type is {}", (Object)itemKey);
        LOGGER.info("CandidateSetSalApplicationListPlugin operationKey is {}", (Object)operationKey);
        if ("exportlist".equals(operationKey)) {
            LOGGER.error("operation exportlist in list is forbidden");
            evt.setCancel(true);
            return;
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"28", (String)"0VO5EV13=I9W", (String)"hcdm_singlecandsetsalappl", (String)"47150e89000000ac");
        switch (fieldName) {
            case "salarystructure.name": {
                this.addBaseOrgFilter(filters, permOrgs, "hcdm_salaystructure");
                break;
            }
            case "stdscmvid.name": {
                this.addBaseOrgFilter(filters, permOrgs, "hcdm_stdscm");
                break;
            }
            case "adminorg.name": {
                if (permOrgs.hasAllOrgPerm()) break;
                QFilter dataRuleForBdProp = SWCPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"0VO5EV13=I9W", (String)"hcdm_singlecandsetsalappl", (String)"department", (String)"47150e89000000ac");
                filters.add(dataRuleForBdProp);
                break;
            }
            case "salaryadjrsn.name": {
                QFilter qFilter = new QFilter("status", "=", (Object)"C");
                qFilter.and(new QFilter("enable", "=", (Object)"1"));
                qFilter.and(new QFilter("attributiontype", "=", (Object)AdjAttributionType.DECATTRTYPE.getCode()));
                filters.add(qFilter);
                this.addBaseOrgFilter(filters, permOrgs, "hsbs_salaryadjustrsn");
                break;
            }
        }
    }

    private void addBaseOrgFilter(List<QFilter> filters, HasPermOrgResult permOrgs, String entityName) {
        List baseOrgFilters;
        if (null != permOrgs && !permOrgs.hasAllOrgPerm() && null != (baseOrgFilters = SalaryAdjFileServiceHelper.getBaseOrgFilters((HasPermOrgResult)permOrgs, (String)entityName))) {
            filters.addAll(baseOrgFilters);
        }
    }

    private void clickNumber(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        Long candPkId = (Long)list.getFocusRowPkId();
        this.openSalaryAdjFile(candPkId);
    }

    private void openSalaryAdjFile(Long candPkId) {
        DynamicObject personEntry;
        long adjFileId;
        DynamicObjectCollection personEntries;
        DynamicObject candSetSalApplDy = CandidateSetSalApplyHelper.getCandSetSalApplById((Long)candPkId);
        if (Objects.nonNull(candSetSalApplDy) && !CollectionUtils.isEmpty((Collection)(personEntries = candSetSalApplDy.getDynamicObjectCollection("candsetsalperson"))) && (adjFileId = (personEntry = (DynamicObject)personEntries.get(0)).getLong("salaryadjfile.id")) != 0L) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hcdm_adjsalaryfileview");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("key_custom_param_fileid", (Object)String.valueOf(adjFileId));
            showParameter.setPageId(this.getView().getPageId() + adjFileId);
            String adjFileCaption = AdjFileFormHelper.getAdjFileCaption((Long)adjFileId);
            if (SWCStringUtils.isNotEmpty((String)adjFileCaption)) {
                showParameter.setCaption(adjFileCaption);
            }
            this.getView().showForm(showParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "new": {
                if (AdjFileCertCommonHelper.verifyCertCount((IFormView)this.getView())) break;
                args.setCancel(true);
                break;
            }
            case "submiteffect": {
                String entryConfirmMsg = this.isNeedShowEntryConfirm(operateKey, source);
                if (!StringUtils.isEmpty((CharSequence)entryConfirmMsg)) {
                    args.setCancel(true);
                    this.getView().showConfirm(entryConfirmMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_SUBMITEFFECT_ENTRYCONFIRM));
                    break;
                }
                String confirmResult = source.getOption().getVariableValue(CONFIRM_SUBMITEFFECT, "0");
                if (!StringUtils.equals((CharSequence)confirmResult, (CharSequence)"0")) break;
                args.setCancel(true);
                String msg = ResManager.loadKDString((String)"\u70b9\u51fb\u540e\u5c06\u4f1a\u628a\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u76f4\u63a5\u63d0\u4ea4\u751f\u6548\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CandidateSetSalApplicationListPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_SUBMITEFFECT));
                break;
            }
            case "submit": {
                String entryMsg = this.isNeedShowEntryConfirm(operateKey, source);
                if (StringUtils.isEmpty((CharSequence)entryMsg)) break;
                args.setCancel(true);
                this.getView().showConfirm(entryMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_SUBMIT_ENTRYCONFIRM));
                return;
            }
        }
    }

    private String isNeedShowEntryConfirm(String operateKey, FormOperate source) {
        BillList billList;
        ListSelectedRowCollection selectedRows;
        Set applyIds;
        int count;
        String entryConfirm = source.getOption().getVariableValue(CONFIRM_SUBMITEFFECT_ENTRYCONFIRM, "0");
        if (StringUtils.equals((CharSequence)entryConfirm, (CharSequence)"0") && (count = CandidateSetSalApplyService.queryNotEntryNumByIds(applyIds = (selectedRows = (billList = (BillList)this.getControl("billlistap")).getSelectedRows()).stream().map(obj -> (Long)obj.getPrimaryKeyValue()).collect(Collectors.toSet()))) != 0) {
            return CandidateSetSalApplyService.getEntryConfirmMsg((String)operateKey, (int)count);
        }
        return null;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        IPageCache pageCache = this.getPageCache();
        switch (callBackId) {
            case "call_submiteffect": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue(CONFIRM_SUBMITEFFECT, "1");
                    pageCache.put(CONFIRM_SUBMITEFFECT, "1");
                    this.getView().invokeOperation("submiteffect", operateOption);
                    break;
                }
                pageCache.remove(CONFIRM_SUBMITEFFECT);
                break;
            }
            case "call_submiteffect_entryconfirm": 
            case "call_submit_entryconfirm": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue(CONFIRM_SUBMITEFFECT_ENTRYCONFIRM, "1");
                    operateOption.setVariableValue(CONFIRM_SUBMITEFFECT, pageCache.get(CONFIRM_SUBMITEFFECT));
                    this.getView().invokeOperation(CALLBACK_SUBMIT_ENTRYCONFIRM.equals(callBackId) ? "submit" : "submiteffect", operateOption);
                }
                pageCache.remove(CONFIRM_SUBMITEFFECT);
                break;
            }
        }
    }
}

