/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.coefficient;

import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.formplugin.web.newhismodel.impt.HisBatchImportPlugin;
import kd.swc.hcdm.business.coefficient.CoefficientTabServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class CoefficientBatchImportPlugin
extends HisBatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(CoefficientBatchImportPlugin.class);
    private static final String COEFFICIENTTAB = "coefficienttab";
    private static final int BATCH_IMPORT_SIZE = 500;
    private static final String COEFFICIENT_CACHE_KEY = "hcdm_coefficient_appcache";
    private static final String SWC_HCDM_FORMPLUGIN = "swc-hcdm-formplugin";

    public String getBillFormId() {
        return super.getBillFormId();
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return 500;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        long orgID = RequestContext.get().getOrgId();
        String userId = RequestContext.get().getUserId();
        String key = String.valueOf(orgID) + userId;
        ISWCAppCache appCache = SWCAppCache.get((String)COEFFICIENT_CACHE_KEY);
        String fiterString = (String)appCache.get(key, String.class);
        QFilter orgFilter = QFilter.fromSerializedString((String)fiterString);
        HashSet<String> coefTabNumbers = new HashSet<String>(16);
        for (ImportBillData rowData : billdatas) {
            JSONObject coefficientTab = rowData.getData().getJSONObject(COEFFICIENTTAB);
            String coefTabNumber = coefficientTab.getString("number");
            coefTabNumbers.add(coefTabNumber);
        }
        DynamicObjectCollection colls = CoefficientTabServiceHelper.queryCoefTabByNumbers(coefTabNumbers, (QFilter)orgFilter);
        Set rightCoefTabNumbers = colls.stream().map(dy -> dy.getString("number")).collect(Collectors.toSet());
        Map<String, String> numberMap = colls.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getString("dimension")));
        try {
            String errorAuthMsg = ResManager.loadKDString((String)"\u85aa\u916c\u6807\u51c6\u7cfb\u6570\u8868\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u65e0\u85aa\u916c\u6807\u51c6\u7cfb\u6570\u8868\u6743\u9650\u3002", (String)"CoefficientBatchImportPlugin_0", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
            String errorOrgMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u6216\u540d\u79f0\u3002", (String)"CoefficientBatchImportPlugin_1", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u884c\u653f\u533a\u5212\u7f16\u7801\u6216\u540d\u79f0\u3002", (String)"CoefficientBatchImportPlugin_2", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
            Iterator<ImportBillData> it = billdatas.iterator();
            while (it.hasNext()) {
                ImportBillData bill = it.next();
                if (bill.isEmpty()) continue;
                if (!rightCoefTabNumbers.contains(this.getCoefNumber(bill))) {
                    it.remove();
                    this.log(bill.getStartIndex(), errorAuthMsg, logger);
                    continue;
                }
                if ("1".equals(numberMap.get(this.getCoefNumber(bill))) && this.isImportPropNull("admindivision", bill)) {
                    it.remove();
                    this.log(bill.getStartIndex(), errorMsg, logger);
                }
                if (!"2".equals(numberMap.get(this.getCoefNumber(bill))) || !this.isImportPropNull("adminorg", bill)) continue;
                it.remove();
                this.log(bill.getStartIndex(), errorOrgMsg, logger);
            }
        }
        catch (Exception throwable) {
            LOGGER.error((Throwable)throwable);
            if (SystemParamServiceHelper.isShowStackTrace()) {
                logger.log(Integer.valueOf(billdatas.get(0).getStartIndex()), (Throwable)throwable);
            } else {
                logger.log(Integer.valueOf(billdatas.get(0).getStartIndex()), ResManager.loadKDString((String)"\u6570\u636e\u5305\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"CoefficientBatchImportPlugin_3", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
            }
            billdatas.clear();
        }
    }

    private boolean isImportPropNull(String param, ImportBillData bill) {
        boolean flag = false;
        JSONObject data = bill.getData().getJSONObject(param);
        if (null == data) {
            flag = true;
        }
        return flag;
    }

    private String getCoefNumber(ImportBillData bill) {
        JSONObject coefficienttab = bill.getData().getJSONObject(COEFFICIENTTAB);
        return coefficienttab.getString("number");
    }

    private void log(int rowIndex, String errorMsg, ImportLogger logger) {
        Map logCache = logger.getLogCache();
        if (logCache.get(rowIndex) != null) {
            ((List)logCache.get(rowIndex)).add(new ImportLogger.ImportLog(errorMsg));
            logger.setLogCache(logCache);
        } else {
            logger.log(Integer.valueOf(rowIndex), errorMsg).fail();
        }
    }
}

