/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.coefficient;

import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.swc.hcdm.business.coefficient.CoeffShowFormHelper;
import kd.swc.hcdm.business.coefficient.CoefficientTabServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CoefficientTabList
extends AbstractListPlugin {
    private static final String FIELD_LATESTCOEFNUM = "latestcoefnum";
    private static final String DONOTHING_ADDCOEFFICIENT = "donothing_addcoefficient";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addPackageDataListener(pkEvent -> {
            String status = pkEvent.getRowData().getString("status");
            if (pkEvent.getSource() instanceof ListOperationColumnDesc) {
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    if (!DONOTHING_ADDCOEFFICIENT.equalsIgnoreCase(operationColItem.getOperationKey())) continue;
                    operationColItem.setLocked(!SWCStringUtils.equals((String)status, (String)"C"));
                }
            }
        });
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        switch (fieldName = args.getHyperLinkClickEvent().getFieldName()) {
            case "latestcoefnum": {
                this.turnToCoefficientList(args);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "donothing_addcoefficient": {
                this.addCoefficiEnt(args);
                break;
            }
        }
    }

    private void addCoefficiEnt(BeforeDoOperationEventArgs args) {
        Long userId = RequestContext.get().getCurrUserId();
        boolean superUser = SWCPermissionServiceHelper.isSuperUser();
        boolean hasPermByPermItemNum = SWCPermissionServiceHelper.hasPermByPermItemNum((long)userId, (String)"0VO5EV13=I9W", (String)"hcdm_coefficient", (String)"QXX0465");
        if (superUser || hasPermByPermItemNum) {
            this.openCoefficiEnt(args);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u85aa\u916c\u7cfb\u6570\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"StdscmEdit_12", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void openCoefficiEnt(BeforeDoOperationEventArgs args) {
        String tableId = args.getListSelectedData().get(0).getPrimaryKeyValue().toString();
        BaseShowParameter form = new BaseShowParameter();
        form.setFormId("hcdm_coefficient");
        form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        form.setStatus(OperationStatus.ADDNEW);
        form.setBillStatus(BillOperationStatus.ADDNEW);
        form.setCustomParam("coefficientTabId", (Object)tableId);
        this.getView().showForm((FormShowParameter)form);
    }

    private void turnToCoefficientList(HyperLinkClickArgs args) {
        args.setCancel(true);
        IListView listView = (IListView)this.getView();
        Object pkId = listView.getFocusRowPkId();
        if (pkId != null) {
            String tableId = pkId.toString();
            String errMsg = CoefficientTabServiceHelper.getStatusErrorMsgByPkId((String)tableId);
            if (SWCStringUtils.isEmpty((String)errMsg)) {
                FormShowParameter coefficientList = CoeffShowFormHelper.getCoefficientList((String)tableId);
                listView.showForm(coefficientList);
            } else {
                this.getView().showErrorNotification(errMsg);
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map paramMap = (Map)this.getView().getFormShowParameter().getCustomParam("filterColumnParam");
        if (!SWCBaseUtils.isEmpty((Map)paramMap)) {
            List fastFilterColumns = args.getFastFilterColumns();
            for (FilterColumn filterColumn : fastFilterColumns) {
                if (!paramMap.containsKey(filterColumn.getFieldName())) continue;
                filterColumn.setDefaultValue(String.valueOf(paramMap.get(filterColumn.getFieldName())));
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (showParameter.isLookUp()) {
            IListColumn number = args.getListColumn("number");
            number.setHyperlink(false);
        }
    }
}

