/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.coefficient.treelist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;
import kd.swc.hcdm.business.coefficient.CoefficientTabServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.util.SWCTreeListUtils;

public class CoefficientTreeListPlugin
extends StandardTreeListPlugin
implements SearchEnterListener,
TreeNodeClickListener {
    private static final int CHILDREN_LEVEL = 10;
    private static final String SWC_HCDM_FORMPLUGIN = "swc-hcdm-formplugin";

    public void initializeTree(EventObject eventObject) {
        this.initTreeNode();
    }

    public void beforeShowBill(BeforeShowBillFormEvent event) {
        super.beforeShowBill(event);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        BillShowParameter parameter = event.getParameter();
        if (parameter.getBillStatus().equals((Object)BillOperationStatus.ADDNEW)) {
            parameter.setCustomParam("coefficientTabId", (Object)focusNodeId);
        }
    }

    public void initTreeNode() {
        TreeNode root = this.initRootNode();
        this.getTreeModel().setRoot(root);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addNode(root);
        this.loadChildNode();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String tableId = (String)showParameter.getCustomParam("params_defaulttable");
        TreeNode currNode = root.getTreeNode(tableId, 10);
        if (SWCStringUtils.isNotEmpty((String)tableId) && currNode != null) {
            treeView.expand(currNode.getParentid());
            treeView.focusNode(currNode);
            treeView.treeNodeClick(currNode.getParentid(), tableId);
        } else {
            treeView.focusNode(root);
            treeView.treeNodeClick(null, "100000");
        }
    }

    public void search(SearchEnterEvent evt) {
        List treeNodes;
        String searchText = evt.getText();
        TreeNode rootNode = this.getTreeModel().getRoot();
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if ((oldSearchText == null || oldSearchText.equals(searchText)) && !StringUtils.isBlank((CharSequence)matchNodesCache)) {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        } else {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, node -> this.loadChildNodes((TreeNode)node), 100);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        }
        if (treeNodes.isEmpty()) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, node -> this.loadChildNodes((TreeNode)node), 100);
        }
        if (treeNodes.isEmpty()) {
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"StandardTreeListPlugin_6", (String)"bos-form-core", (Object[])new Object[0]));
        } else {
            TreeView treeView = this.getTreeListView().getTreeView();
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache == treeNodes.size()) {
                    indexCache = 0;
                }
                this.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(indexCache));
                pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
            } else {
                this.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }

    private void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode) {
        this.expandParents(treeView, rootNode, treeNode);
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
    }

    private void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node) {
        String parentid = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentid)) {
            TreeNode treeNode = rootNode.getTreeNode(parentid);
            if (treeNode != null) {
                this.expandParents(treeView, rootNode, treeNode);
                treeView.expand(parentid);
                if (treeNode == rootNode) {
                    treeView.updateNode(node);
                }
            } else {
                treeView.updateNode(node);
            }
        } else {
            treeView.updateNode(node);
        }
    }

    public void beforeBindData(EventObject object) {
        super.beforeBindData(object);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.expand("100000");
    }

    public void refreshNode(RefreshNodeEvent event) {
        super.refreshNode(event);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.deleteAllNodes();
        this.initTreeNode();
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)event.getNodeId();
        TreeNode currNode = root.getTreeNode(currNodeId, 10);
        if (currNode != null && currNode.getChildren() != null && !currNode.getChildren().isEmpty()) {
            event.setChildNodes(currNode.getChildren());
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent event) {
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)event.getNodeId();
        TreeNode currNode = root.getTreeNode(currNodeId, 10);
        QFilter filter = this.buildQFilter(currNodeId);
        event.addQFilter(filter);
        event.setCancel(true);
        if (currNode != null) {
            IPageCache cache = this.getPageCache();
            if (SWCStringUtils.equals((String)currNode.getParentid(), (String)"100001") || SWCStringUtils.equals((String)currNode.getParentid(), (String)"100002")) {
                currNodeId = currNode.getParentid();
            }
            cache.put("orderId", currNodeId);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "new": {
                TreeView treeView = (TreeView)this.getView().getControl("treeview");
                String currNodeId = treeView.getTreeState().getFocusNodeId();
                TreeNode root = this.getTreeModel().getRoot();
                TreeNode currNode = root.getTreeNode(currNodeId, 10);
                if (SWCStringUtils.isEmpty((String)currNodeId) || SWCStringUtils.equals((String)currNodeId, (String)"100000")) {
                    FormShowParameter parameters = this.getOperationResultParameter(ResManager.loadKDString((String)"\u8bf7\u5728\u201c\u85aa\u916c\u6807\u51c6\u7cfb\u6570\u8868\u201d\u914d\u7f6e\u5b8c\u6210\u540e\uff0c\u518d\u5230\u201c\u85aa\u916c\u6807\u51c6\u7cfb\u6570\u201d\u5de6\u6811\u5904\u9009\u62e9\u76f8\u5e94\u7684\u5b50\u8282\u70b9\u8fdb\u884c\u65b0\u589e\u3002", (String)"CoefficientTreeListPlugin_5", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
                    this.getView().showForm(parameters);
                    args.setCancel(true);
                    break;
                }
                if (!SWCStringUtils.equals((String)currNodeId, (String)"100001") && !SWCStringUtils.equals((String)currNodeId, (String)"100002")) break;
                if (null != currNode.getChildren()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u5e94\u7684\u5b50\u8282\u70b9\u8fdb\u884c\u65b0\u589e\u3002", (String)"CoefficientTreeListPlugin_4", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u201c\u85aa\u916c\u6807\u51c6\u7cfb\u6570\u8868\u201d\u914d\u7f6e\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u65b0\u589e\u3002", (String)"CoefficientTreeListPlugin_3", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    private QFilter buildQFilter(String currNodeId) {
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode currNode = root.getTreeNode(currNodeId, 10);
        List childIds = SWCTreeListUtils.getLeafNodesId((TreeNode)currNode);
        HashSet<Long> ids = new HashSet<Long>(childIds.size());
        for (String childId : childIds) {
            ids.add(Long.valueOf(childId));
        }
        return new QFilter("coefficienttab.id", "in", ids);
    }

    private TreeNode initRootNode() {
        TreeNode root = new TreeNode();
        root.setId("100000");
        root.setText(ResManager.loadKDString((String)"\u85aa\u916c\u6807\u51c6\u7cfb\u6570\u8868", (String)"CoefficientTreeListPlugin_0", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
        root.setData((Object)"");
        root.setParentid("");
        root.setIsOpened(true);
        return root;
    }

    private void loadChildNode() {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        ITreeModel treeModel = this.getTreeModel();
        TreeNode divisionNode = new TreeNode("100000", "100001", ResManager.loadKDString((String)"\u884c\u653f\u533a\u5212\u7cfb\u6570", (String)"CoefficientTreeListPlugin_1", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
        List<TreeNode> nodeList = Collections.singletonList(divisionNode);
        treeModel.addNodes((Object)"100000", nodeList);
        treeView.addNodes(nodeList);
        long orgID = RequestContext.get().getOrgId();
        IBaseDataService baseDataService = (IBaseDataService)this.getModel().getService(IBaseDataService.class);
        DynamicObject[] divisionDyObj = CoefficientTabServiceHelper.getDataByDimension((String)"1", (QFilter)baseDataService.getBaseDataFilter("hcdm_coefficienttab", Long.valueOf(orgID)));
        ArrayList<TreeNode> leftNodeList = new ArrayList<TreeNode>(10);
        for (DynamicObject obj : divisionDyObj) {
            TreeNode node = new TreeNode("100001", obj.getString("id"), obj.getString("name"));
            leftNodeList.add(node);
        }
        treeModel.addNodes((Object)"100001", leftNodeList);
        treeView.addNodes(leftNodeList);
    }

    private FormShowParameter getOperationResultParameter(String message) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("hsbp_operationresult");
        parameters.setShowTitle(false);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%;font-size:16px;line-height:2;margin-top:20px'>");
        buf.append(message).append("<br/>");
        parameters.setCustomParam("hasMore", (Object)Boolean.FALSE);
        parameters.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        parameters.setCustomParam("failList", null);
        return parameters;
    }
}

