/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.decadjrecord;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorEnum;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hr.impt.common.plugin.AfterQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeInitValidatorEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.hr.impt.core.validate.AbstractValidateHandler;
import kd.swc.hcdm.business.adjapprbill.AdjBillEntryImpHelper;
import kd.swc.hcdm.business.decadjrecord.DecAdjRecordHRImportHelper;
import kd.swc.hcdm.business.matchprop.entity.MatchStdTableWithAdjFileParam;
import kd.swc.hcdm.formplugin.decadjrecord.DecAdjRecordHRImportValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DecAdjRecordHRImportPlugin
implements HRImportPlugin {
    private static final Log log = LogFactory.getLog(DecAdjRecordHRImportPlugin.class);
    private static int BATCH_SIZE = 50;

    public void beforeInitValidator(BeforeInitValidatorEventArgs args) {
        args.setValidator(ValidatorEnum.CUSTOM_VALIDATOR, (AbstractValidateHandler)new DecAdjRecordHRImportValidator(args.getCustomParams()));
        args.setValidator(ValidatorEnum.DATA_RULE_PERM_VALIDATOR, new AbstractValidateHandler(){

            public ValidatorOrderEnum setValidatorRole() {
                return ValidatorOrderEnum.IGNORE;
            }

            public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
            }
        });
    }

    public void afterQueryRefBd(AfterQueryRefBdEventArgs args) {
        List<Object> dataList;
        Map<String, List<DynamicObject>> groupData;
        Object[] dynamicObjects = args.getDatas();
        if ("hcdm_rankgradeentrytodb,hcdm_salarygradeentrytodb,hsbs_calfrequency,hbjm_joblevelhr,hbjm_jobgradehr".contains(args.getBaseDataName()) && ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            groupData = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(obj -> obj.getString("name")));
            dataList = new ArrayList(groupData.size());
            for (Map.Entry<String, List<DynamicObject>> submap : groupData.entrySet()) {
                dataList.add(submap.getValue().get(0));
            }
            args.setDatas(dataList.toArray(new DynamicObject[0]));
        }
        if (args.getBaseDataName().equals("hrpi_employee") && ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            groupData = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(obj -> obj.getString("empnumber")));
            dataList = groupData.values().stream().filter(list -> CollectionUtils.isNotEmpty((Collection)list)).map(list -> (DynamicObject)list.get(0)).collect(Collectors.toList());
            args.setDatas(dataList.toArray(new DynamicObject[0]));
        }
    }

    public void beforeCallOperation(BeforeCallOperationEventArgs args) {
        args.setSubmitOPs(this.getSaveOp());
        Long startTime = System.currentTimeMillis();
        this.groupByBatchNo(args);
        log.info("groupByBatchNo use time:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private void groupByBatchNo(BeforeCallOperationEventArgs args) {
        Object[] salarySrn;
        ConcurrentHashMap concurrentHashMap = args.getCustomParams();
        List importBillData = args.getImportBillDatas();
        Object[] objects = args.getDynamicObjects();
        Map<String, List<ImportBillData>> groupBillData = importBillData.stream().collect(Collectors.groupingBy(billData -> billData.getData().getJSONObject("hcdm_adjfileinfo").getString("basedatajson")));
        log.info("importBillData size:{},objects size:{},groupBillData size:{}", new Object[]{importBillData.size(), objects.length, groupBillData.size()});
        HashMap<Long, String> recordIdToBatchNoMap = new HashMap<Long, String>(importBillData.size());
        HashMap rowIndexToFileIdMap = new HashMap(importBillData.size());
        for (Map.Entry<String, List<ImportBillData>> subMap : groupBillData.entrySet()) {
            String batchNo = subMap.getKey();
            if (StringUtils.isBlank((CharSequence)batchNo) || ObjectUtils.isEmpty(concurrentHashMap.get(batchNo))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u586b\u5145\u57fa\u7840\u8d44\u6599\u6570\u636e\u83b7\u53d6concurrentHashMap\u4e3a\u7a7a\u3002", (String)"DecAdjRecordHRImportHelper_17", (String)"swc-hcdm-business", (Object[])new Object[0]));
            }
            Map baseDataMap = (Map)concurrentHashMap.get(batchNo);
            String fileStr = (String)baseDataMap.get("salaryadjfile.number");
            Map deterFileMap = (Map)SerializationUtils.deSerializeFromBase64((String)fileStr);
            List<ImportBillData> subList = subMap.getValue();
            for (ImportBillData billData2 : subList) {
                JSONArray jsonRecord = billData2.getData().getJSONArray("hcdm_salaryadjrecord");
                jsonRecord.stream().forEach(rec -> {
                    JSONObject record = (JSONObject)rec;
                    Integer rowIndex = record.getInteger("$excelIndex");
                    Object value = deterFileMap.get(rowIndex);
                    if (value != null) {
                        rowIndexToFileIdMap.put(rowIndex, value);
                        deterFileMap.remove(rowIndex, value);
                    }
                    recordIdToBatchNoMap.put(record.getLong("id"), batchNo);
                });
            }
        }
        HashSet salaryadjrsnIds = Sets.newHashSetWithExpectedSize((int)16);
        Map selectFileMap = DecAdjRecordHRImportHelper.queryAdjFileByIds(rowIndexToFileIdMap);
        HashSet matchParams = Sets.newHashSetWithExpectedSize((int)16);
        importBillData.stream().forEach(billData -> {
            JSONArray jsonRecord = billData.getData().getJSONArray("hcdm_salaryadjrecord");
            jsonRecord.stream().forEach(rec -> {
                JSONObject salaryadjrsn;
                JSONObject record = (JSONObject)rec;
                JSONObject standarditem = record.getJSONObject("standarditem");
                Integer rowIndex = record.getInteger("$excelIndex");
                if (MapUtils.isNotEmpty((Map)selectFileMap) && ObjectUtils.isNotEmpty(selectFileMap.get(rowIndex))) {
                    DynamicObject file = (DynamicObject)selectFileMap.get(rowIndex);
                    Long fileId = file.getLong("id");
                    Long itemId = standarditem.getLong("id");
                    Date bsed = record.getDate("bsed");
                    if (ObjectUtils.isNotEmpty((Object)bsed)) {
                        MatchStdTableWithAdjFileParam param = new MatchStdTableWithAdjFileParam();
                        param.setAdjFileId(fileId);
                        param.setStdItemId(itemId);
                        param.setBsed(bsed);
                        matchParams.add(param);
                    }
                }
                if (ObjectUtils.isNotEmpty((Object)record.get((Object)"salaryadjrsn")) && (salaryadjrsn = record.getJSONObject("salaryadjrsn")).containsKey((Object)"id")) {
                    salaryadjrsnIds.add(salaryadjrsn.getLong("id"));
                }
            });
        });
        HashMap salaryadjrsnToType = new HashMap(salaryadjrsnIds.size());
        if (CollectionUtils.isNotEmpty((Collection)salaryadjrsnIds) && ArrayUtils.isNotEmpty((Object[])(salarySrn = DecAdjRecordHRImportHelper.querySalaryadjustrsn((Set)salaryadjrsnIds)))) {
            Arrays.stream(salarySrn).forEach(obj -> salaryadjrsnToType.put(obj.getLong("id"), obj.getString("attributiontype")));
        }
        Map resultMap = AdjBillEntryImpHelper.getMatchStdResult((List)Lists.newArrayList((Iterable)matchParams));
        HashMap<String, List> groupDynamicObj = new HashMap<String, List>(objects.length);
        for (Object obj2 : objects) {
            DynamicObjectCollection recordCollection = (DynamicObjectCollection)((HashMap)obj2).get("hcdm_salaryadjrecord");
            String batchNo = this.getBatchNo(recordIdToBatchNoMap, recordCollection);
            log.info("getBatchNo is:{}", (Object)batchNo);
            if (batchNo != null) {
                List subList = groupDynamicObj.computeIfAbsent(batchNo, va -> new ArrayList(10));
                subList.add(obj2);
                continue;
            }
            log.info(" groupByBatchNo match batachno is null, recordCollection size is:{}", (Object)recordCollection.size());
        }
        for (Map.Entry entry : groupBillData.entrySet()) {
            String batchNo = (String)entry.getKey();
            List subList = (List)entry.getValue();
            List subObj = (List)groupDynamicObj.get(batchNo);
            Map baseDataMap = (Map)concurrentHashMap.get(batchNo);
            if (StringUtils.isBlank((CharSequence)batchNo) || ObjectUtils.isEmpty(concurrentHashMap.get(batchNo))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u586b\u5145\u57fa\u7840\u8d44\u6599\u6570\u636e\u83b7\u53d6concurrentHashMap\u4e3a\u7a7a\u3002", (String)"DecAdjRecordHRImportHelper_17", (String)"swc-hcdm-business", (Object[])new Object[0]));
            }
            long startTime = System.currentTimeMillis();
            DecAdjRecordHRImportHelper.packBaseDataForDynamicObject((Map)baseDataMap, (List)subList, (Object[])subObj.toArray(new Object[0]), (Map)selectFileMap, (Map)resultMap);
            log.info("packBaseDataForDynamicObject use time:{},subObj size:{},subList size:{}", new Object[]{System.currentTimeMillis() - startTime, subObj.size(), subList.size()});
            startTime = System.currentTimeMillis();
            ListUtils.partition((List)subObj, (int)BATCH_SIZE).forEach(list -> DecAdjRecordHRImportHelper.recordVersionSlice((Map)salaryadjrsnToType, (Object[])list.toArray(new Object[0])));
            log.info("recordVersionSlice use time:{},subObj size:{}", (Object)(System.currentTimeMillis() - startTime), (Object)subObj.size());
        }
    }

    private String getBatchNo(Map<Long, String> recordIdToBatchNoMap, DynamicObjectCollection recordCollection) {
        for (DynamicObject record : recordCollection) {
            String batchNo = recordIdToBatchNoMap.get(record.getLong("id"));
            if (!StringUtils.isNotBlank((CharSequence)batchNo)) continue;
            return batchNo;
        }
        return null;
    }

    private Map<String, String> getSaveOp() {
        HashMap<String, String> opMap = new HashMap<String, String>(16);
        opMap.put("hcdm_adjfileinfo", "hr_decadjrecordimportsave");
        opMap.put("hcdm_decadjrelperson", "hr_decadjrecordimportsave");
        opMap.put("hcdm_salaryadjrecord", "hr_decadjrecordimportsave");
        return opMap;
    }
}

