/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.decadjrecord;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hr.impt.core.validate.AbstractValidateHandler;
import kd.swc.hcdm.business.decadjrecord.DecAdjRecordHRImportHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class DecAdjRecordHRImportValidator
extends AbstractValidateHandler {
    private static final Log log = LogFactory.getLog(DecAdjRecordHRImportValidator.class);
    ConcurrentHashMap<String, Object> customParams;

    public DecAdjRecordHRImportValidator(ConcurrentHashMap<String, Object> customParams) {
        this.customParams = customParams;
    }

    public ValidatorOrderEnum setValidatorRole() {
        return null;
    }

    public void validate(List<ImportBillData> list, ImportLog importLog) {
        String batchNo = "batchNo_" + System.currentTimeMillis();
        log.info("batchNo:{},validate size:{}", (Object)batchNo, (Object)list.size());
        HashMap baseDataMap = new HashMap(16);
        HashSet<String> employeeNumbers = new HashSet<String>(10);
        HashSet<String> adjFileNum = new HashSet<String>(10);
        int totalNum = 0;
        ArrayList<ImportBillData> validateList = new ArrayList<ImportBillData>(list.size());
        for (ImportBillData billData : list) {
            JSONObject jsonObject = billData.getData();
            JSONObject jsonFile = jsonObject.getJSONObject("hcdm_adjfileinfo");
            employeeNumbers.add(jsonFile.getJSONObject("employee").getString("empnumber"));
            JSONArray jsonRecord = jsonObject.getJSONArray("hcdm_salaryadjrecord");
            if (ObjectUtils.isEmpty((Object)jsonRecord)) {
                Integer rowIndex = jsonFile.getInteger("$excelIndex");
                DecAdjRecordHRImportHelper.writeErrorLog((String)ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u4fe1\u606f\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DecAdjRecordHRImportHelper_55", (String)"swc-hcdm-business", (Object[])new Object[0]), (Integer)rowIndex, (ImportLog)importLog, (ImportBillData)billData);
                continue;
            }
            for (Object obj : jsonRecord) {
                JSONObject recObj = (JSONObject)obj;
                if (ObjectUtils.isNotEmpty((Object)recObj.get((Object)"salaryadjfile"))) {
                    adjFileNum.add(((JSONObject)recObj.get((Object)"salaryadjfile")).getString("number"));
                }
                ++totalNum;
            }
            jsonFile.put("basedatajson", (Object)batchNo);
            validateList.add(billData);
        }
        long startTime = System.currentTimeMillis();
        if (CollectionUtils.isNotEmpty(validateList)) {
            DecAdjRecordHRImportHelper.dataValidate(employeeNumbers, (ImportLog)importLog, adjFileNum, validateList, baseDataMap);
            this.customParams.put(batchNo, baseDataMap);
        }
        log.info("DecAdjRecordHRImportHelper.dataValidate use time:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    public ConcurrentHashMap<String, Object> getCustomParams() {
        return this.customParams;
    }

    public void setCustomParams(ConcurrentHashMap<String, Object> customParams) {
        this.customParams = customParams;
    }
}

