/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.decadjrecordrevision;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeSetItemValueEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.DomainFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.sdk.swc.hcdm.common.Pair;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropResult;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdMatchResultNew;
import kd.sdk.swc.hcdm.common.stdtab.StdAmountAndSalaryCountQueryResult;
import kd.swc.hcdm.business.adjapprbill.enums.CalcType;
import kd.swc.hcdm.business.adjapprbill.enums.ExcessControlEnum;
import kd.swc.hcdm.business.adjapprbill.enums.OverStandardTypeEnum;
import kd.swc.hcdm.business.adjapprbill.enums.YesOrNoEnum;
import kd.swc.hcdm.business.decadjrecordrevision.DecAdjRecordRevisionHelper;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hcdm.common.enums.EventTypeEnum;
import kd.swc.hcdm.formplugin.decadjrecordrevision.DecAdjRecordRevisionFormPluginHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DecAdjRecordRevisionFormPlugin
extends AbstractFormPlugin
implements EntryGridBindDataListener,
HyperLinkClickListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(DecAdjRecordRevisionFormPlugin.class);
    private static final String CALLBACK_INVOKE_CURRENCY = "callback_invoke_currency";
    private static final String CALLBACK_INVOKE_OVERSTANDARD = "callback_invoke_overstandard";
    private static final String REVISION_OP_CACHEKEY = "revision_op_cachekey";
    private static final String OP_SAVE = "donothing_save";
    private static final String CALLBACKID_NOEXCESSCONTROL = "callbackid_noexcesscontrol";
    private final Map<Integer, Map<String, AtomicBoolean>> entryFieldChangeBitMap = Maps.newConcurrentMap();
    private final String[] saveBoidFieldArr = new String[]{"company_p"};
    private final String[] saveVidFieldArr = new String[]{"adminorg_p", "assoadminorg_p", "job_p", "position_p", "stdposition_p", "jobseq_p", "jobfamily_p", "jobclass_p", "projectteam_p"};
    private final String[] cells = new String[]{"standarditem_r", "frequency_r", "grade_r", "rank_r", "amountstdrange_r", "amountstdrangedisplay", "calctype_r", "currency_r", "suggestminrange_r", "suggestmaxrange_r", "suggestminamount_r", "suggestmaxamount_r", "actualrange_r", "actualamount_r", "amount_r", "overstandardtype_r", "issend_r", "salarypercent_r", "salaryseeprate_r", "org_p", "country_p", "empgroup_p", "depcytype_p", "company_p", "adminorg_p", "assoadminorg_p", "job_p", "position_p", "stdposition_p", "joblevel_p", "jobgrade_p", "laborreltype_p", "laborrelstatus_p", "contrworkloc_p", "baselocation_r", "entrydate_p", "realregulardate_p", "jobscm_p", "jobseq_p", "jobfamily_p", "jobclass_p", "projectteam_p", "postype_p", "departmenttype_p", "admindivision_p", "workplace_p", "industrytype_p", "operationequal_p", "eocpquallevel_p", "protitle_p", "protitlelevel_p", "protitletype_p", "pocpquallevel_p", "ocpqual_p", "schooltype_p", "diploma_p", "religion_p", "nationality_p", "hiscompanyname_p", "hisadminorgname_p", "hisjobname_p", "isprobation_r", "probationtime_r", "perprobationtime_r", "bsed_r", "bsled_r", "datastatus_r", "reason_r", "remark_r", "revreason", "needpush_r", "empnumber_p", "personname_p"};
    private final String[] defaultHiddenColumns = new String[]{"salaystructure_p", "amountstdrangedisplay", "suggestminrange_r", "suggestmaxrange_r", "suggestminamount_r", "suggestmaxamount_r", "overstandardtype_r", "issend_r", "salarypercent_r", "salaryseeprate_r", "groupap2", "isprobation_r", "probationtime_r", "perprobationtime_r", "reason_r", "remark_r", "datasource_r", "creator_r", "createtime_r", "modifier_r", "modifytime_r", "initbatch_r", "initstatus_r", "initdatasource_r", "hiscompanyname_p", "hisadminorgname_p", "hisjobname_p", "needpush_r", "empnumber_p", "personname_p"};
    private final String[] alwaysHiddenColumns = new String[]{"needpush_r", "empnumber_p", "personname_p", "salarystd_r", "coefficient_r", "intervalmin_r", "intervalmax_r", "salargrel_r", "amountstdrange_r", "salaryadjfile_r", "salaryadjfilevid_r", "stdscm_p", "bussinessid_r", "depemp_p", "amountlogic", "stdcurrency", "stdmiddlevalue", "excesscontrol", "ismatchgraderank", "matchstrategy", "lastrecord", "amountlast", "thisrecord", "thisperson"};
    private final String[] adjShowColumns = new String[]{"calctype_r", "actualrange_r", "actualamount_r"};
    private final String[] addNewPageMustHiddenColumns = new String[]{"revreason", "initbatch_r", "initstatus_r", "initdatasource_r", "hiscompanyname_p", "hisadminorgname_p", "hisjobname_p"};
    private AtomicBoolean isPropertyChanged = new AtomicBoolean();

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl("revisionentry");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
        this.getView().getPageCache().put("BOS.setRowDataByNumberDisable", "true");
        this.initTips();
    }

    private void initTips() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Boolean tipsVisible = (Boolean)formShowParameter.getCustomParam("tipsvisible");
        String fieldKey = "";
        if (this.isAddNew()) {
            this.getView().setVisible(tipsVisible, new String[]{"hintap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"hintap"});
            fieldKey = "hintap1";
        } else if (this.isRevise()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"hintap1"});
            this.getView().setVisible(tipsVisible, new String[]{"hintap"});
            fieldKey = "hintap";
        }
        if (tipsVisible.booleanValue()) {
            String[] split;
            String tipsContent = (String)formShowParameter.getCustomParam("tipscontent");
            String tipsNo = (String)formShowParameter.getCustomParam("tipsno");
            if ("hintap".equals(fieldKey) && Lang.en_US.equals((Object)RequestContext.get().getLang()) && tipsContent != null && (split = tipsContent.split("#")) != null && split.length == 3 && split[0].length() > 2) {
                tipsContent = split[0].substring(0, split[0].length() - 1) + split[2];
            }
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            map.put("no", tipsNo);
            map.put("content", tipsContent);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).setFieldProperty(fieldKey, "v", (Object)map);
        }
    }

    public void registerListener(EventObject eventObject) {
        this.registerF7ListenerForEntry("revisionentry");
        Toolbar toolbar = (Toolbar)this.getControl("advcontoolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
        if (this.isRevise()) {
            this.initRevisedData();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs afterAddRowEventArgs) {
        RowDataEntity[] rowDataEntities = afterAddRowEventArgs.getRowDataEntities();
        DynamicObjectCollection revisionEntry = this.getModel().getEntryEntity("revisionentry");
        int parentRowIndex = rowDataEntities[0].getRowIndex();
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        String operateKey = (String)swcPageCache.get(REVISION_OP_CACHEKEY, String.class);
        for (RowDataEntity dataEntity : rowDataEntities) {
            int rowIndex = dataEntity.getRowIndex();
            if ("newentry".equals(operateKey)) continue;
            this.initEntryValue(rowIndex);
            DynamicObject entry = (DynamicObject)revisionEntry.get(parentRowIndex - 1);
            this.getModel().setValue("salaryadjrsn_r", entry.get("salaryadjrsn_r"), rowIndex);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent event) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("revisionentry");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        int[] adjTypeIsNullRowIndexArray = entryEntity.stream().filter(entry -> entry.getDynamicObject("salaryadjrsn_r") == null).mapToInt(entry -> entry.getInt("seq") - 1).toArray();
        int[] adjTypeIsNotNullRowIndexArray = entryEntity.stream().filter(entry -> entry.getDynamicObject("salaryadjrsn_r") != null).mapToInt(entry -> entry.getInt("seq") - 1).toArray();
        this.initCellLock(adjTypeIsNullRowIndexArray);
        this.setEntryRowStyleForRowIndexes(adjTypeIsNotNullRowIndexArray);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        if (this.isRevise()) {
            int[] rowIndexes = this.getModel().getEntryEntity("revisionentry").stream().mapToInt(dy -> dy.getInt("seq") - 1).toArray();
            this.setEntryRowStyleForRowIndexes(rowIndexes);
        }
        if (this.isAddNew()) {
            HashMap<String, String> text = new HashMap<String, String>();
            HashMap<String, HashMap<String, String>> text1 = new HashMap<String, HashMap<String, String>>();
            text.put("zh_CN", ResManager.loadKDString((String)"\u65b0\u589e\u5b9a\u8c03\u85aa\u6570\u636e", (String)"DecAdjRecordRevisionFormPlugin_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            text.put("en_US", ResManager.loadKDString((String)"\u65b0\u589e\u5b9a\u8c03\u85aa\u6570\u636e", (String)"DecAdjRecordRevisionFormPlugin_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            text.put("zh_TW", ResManager.loadKDString((String)"\u65b0\u589e\u5b9a\u8c03\u85aa\u6570\u636e", (String)"DecAdjRecordRevisionFormPlugin_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            text1.put("text", text);
            this.getView().updateControlMetadata("advconap", text1);
        }
        if (this.isRevise()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"newentry", "deleteentry", "moveup", "movedown"});
        } else {
            this.getView().setVisible(Boolean.FALSE, this.addNewPageMustHiddenColumns);
        }
        this.getView().setVisible(Boolean.FALSE, this.defaultHiddenColumns);
        this.getView().setVisible(Boolean.FALSE, this.alwaysHiddenColumns);
        this.hiddenAdjShowColumns();
    }

    private void setEntryRowStyleForRowIndexes(int[] rowIndexes) {
        Map<Integer, Map<String, Boolean>> fieldKeyLockStatusMap0 = this.changeEntryStyle(rowIndexes);
        logger.info("changeEntryStyle fieldKeyLockStatusMap0 is {}", fieldKeyLockStatusMap0);
        Map<Integer, Map<String, Boolean>> fieldKeyLockStatusMap1 = DecAdjRecordRevisionFormPluginHelper.setAllEntryRowGradeAndRankColumnLock(rowIndexes, this.getView(), this.getModel());
        logger.info("changeEntryStyle fieldKeyLockStatusMap1 is {}", fieldKeyLockStatusMap1);
        Map<Integer, Map<String, Boolean>> fieldKeyLockStatusMap2 = DecAdjRecordRevisionFormPluginHelper.setFrequencyEntryColumnLock(rowIndexes, this.getView(), this.getModel());
        logger.info("changeEntryStyle fieldKeyLockStatusMap2 is {}", fieldKeyLockStatusMap2);
        this.setEnableByFieldKeyLockStatusMap(Lists.newArrayList((Object[])new Map[]{fieldKeyLockStatusMap0, fieldKeyLockStatusMap1, fieldKeyLockStatusMap2}));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("showallcolumns".equals(itemKey)) {
            this.getView().setVisible(Boolean.TRUE, this.defaultHiddenColumns);
            this.getView().setVisible(Boolean.FALSE, this.alwaysHiddenColumns);
            this.hiddenAdjShowColumns();
            if (this.isAddNew()) {
                this.getView().setVisible(Boolean.FALSE, this.addNewPageMustHiddenColumns);
            }
            this.getView().updateView("revisionentry");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate fo = (FormOperate)args.getSource();
        String operateKey = fo.getOperateKey();
        if (SWCPermissionServiceHelper.checkCancelDataAndFunctionRight((IFormView)this.getView(), (boolean)false)) {
            args.setCancel(true);
            return;
        }
        if ("newentry".equals(operateKey)) {
            SWCPageCache swcPageCache = new SWCPageCache(this.getView());
            swcPageCache.put(REVISION_OP_CACHEKEY, (Object)operateKey);
        }
        if (OP_SAVE.equals(operateKey)) {
            DynamicObjectCollection revisionEntry = this.getModel().getEntryEntity("revisionentry");
            if (CollectionUtils.isEmpty((Collection)revisionEntry)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u5b9a\u8c03\u85aa\u6570\u636e\u3002", (String)"DecAdjRecordRevisionFormPlugin_14", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.saveHisDataToVersion();
            if (this.isAddNew()) {
                fo.getOption().setVariableValue("type", "addnew");
            } else if (this.isRevise()) {
                fo.getOption().setVariableValue("type", "revise");
            }
            if (!this.validateCurrency(args, fo, revisionEntry)) {
                this.validateIsOverStandard(args, fo, revisionEntry);
            }
        }
    }

    private boolean validateCurrency(BeforeDoOperationEventArgs args, FormOperate fo, DynamicObjectCollection revisionEntry) {
        RefObject refObject;
        OperateOption option = fo.getOption();
        boolean hasFlag = option.tryGetVariableValue(CALLBACK_INVOKE_CURRENCY, refObject = new RefObject());
        if (!hasFlag) {
            for (DynamicObject entry : revisionEntry) {
                long currencyId = entry.getLong("currency_r.id");
                long salaryStdCurrencyId = entry.getLong("salarystd_r.currency.id");
                String attributionType = entry.getString("salaryadjrsn_r.attributiontype");
                if (salaryStdCurrencyId == 0L || currencyId == salaryStdCurrencyId) continue;
                args.setCancel(true);
                String msg = ResManager.loadKDString((String)"\u85aa\u916c\u6807\u51c6\u8868\u5e01\u79cd\u4e0e{0}\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u91d1\u989d\u5c06\u6309\u85aa\u916c\u6807\u51c6\u8868\u5e01\u79cd\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"DecAdjRecordRevisionFormPlugin_15", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                String flag = "";
                if (SWCObjectUtils.isEmpty((Object)attributionType)) {
                    msg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5b9a\u8c03\u85aa\u7c7b\u578b\u201d\u3002", (String)"DecAdjRecordRevisionFormPlugin_7", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                } else if (AdjAttributionType.ADJATTRTYPE.getCode().equals(attributionType)) {
                    flag = ResManager.loadKDString((String)"\u8c03\u85aa", (String)"DecAdjRecordRevisionFormPlugin_6", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                    msg = MessageFormat.format(msg, flag);
                } else if (AdjAttributionType.DECATTRTYPE.getCode().equals(attributionType)) {
                    flag = ResManager.loadKDString((String)"\u5b9a\u85aa", (String)"DecAdjRecordRevisionFormPlugin_5", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                    msg = MessageFormat.format(msg, flag);
                }
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("save", (IFormPlugin)this));
                return args.isCancel();
            }
        }
        return args.isCancel();
    }

    private void validateIsOverStandard(BeforeDoOperationEventArgs args, FormOperate fo, DynamicObjectCollection revisionEntry) {
        RefObject refObject;
        OperateOption option;
        boolean hasFlag;
        ArrayList excErrorMsgList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList noExcErrorMsgList = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject entryDy : revisionEntry) {
            String errorMsg;
            String excessControl = entryDy.getString("excesscontrol");
            String overStandardType = entryDy.getString("overstandardtype_r");
            DynamicObject standardItemDyObj = entryDy.getDynamicObject("standarditem_r");
            if (standardItemDyObj == null) continue;
            String standardItemName = standardItemDyObj.getString("name");
            String name = entryDy.getString("personname_p");
            String number = entryDy.getString("empnumber_p");
            if (ExcessControlEnum.CANNOT_EXCCONTROL.getCode().equals(excessControl) && (OverStandardTypeEnum.BELOW_LIMIT.getCode().equals(overStandardType) || OverStandardTypeEnum.UPPER_LIMIT.getCode().equals(overStandardType))) {
                errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\uff1a%3$s\u7684\u91d1\u989d\u8d85\u6807\u51c6\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjRecordRevisionFormPlugin_8", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), name, number, standardItemName);
                excErrorMsgList.add(errorMsg);
                continue;
            }
            if (!ExcessControlEnum.CAN_EXCCONTROL.getCode().equals(excessControl) || !OverStandardTypeEnum.BELOW_LIMIT.getCode().equals(overStandardType) && !OverStandardTypeEnum.UPPER_LIMIT.getCode().equals(overStandardType)) continue;
            errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\uff1a%3$s\u7684\u91d1\u989d\u8d85\u6807\u51c6\u3002", (String)"DecAdjRecordRevisionFormPlugin_9", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), name, number, standardItemName);
            noExcErrorMsgList.add(errorMsg);
        }
        if (excErrorMsgList.size() == 1) {
            this.getView().showErrorNotification((String)excErrorMsgList.get(0));
            args.setCancel(true);
        } else if (excErrorMsgList.size() > 1) {
            String content = ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u9879\u76ee\u5df2\u8d85\u6807\u51c6\u3002", (String)"DecAdjRecordRevisionFormPlugin_10", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)fo.getOperateName().getLocaleValue(), (String)content, (List)excErrorMsgList);
            this.getView().showForm(parameters);
            args.setCancel(true);
        } else if (noExcErrorMsgList.size() >= 1 && !(hasFlag = (option = fo.getOption()).tryGetVariableValue(CALLBACK_INVOKE_OVERSTANDARD, refObject = new RefObject()))) {
            args.setCancel(true);
            String title = ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u9879\u76ee\u5df2\u8d85\u6807\u51c6\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DecAdjRecordRevisionFormPlugin_11", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(title, StringUtils.join((Object[])noExcErrorMsgList.toArray(), (String)"\r\n"), MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(CALLBACKID_NOEXCESSCONTROL));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "deleteentry": {
                this.hiddenAdjShowColumns();
                break;
            }
            case "newentry": {
                DynamicObjectCollection revisionEntry = this.getModel().getEntryEntity("revisionentry");
                int newEntry = revisionEntry.size() - 1;
                this.initEntryValue(newEntry);
                this.initCellLock(new int[]{newEntry});
                SWCPageCache swcPageCache = new SWCPageCache(this.getView());
                swcPageCache.remove(REVISION_OP_CACHEKEY);
                break;
            }
            case "donothing_save": {
                OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
                if (operationResult.isSuccess()) {
                    this.getView().getParentView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DecAdjRecordRevisionFormPlugin_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                    this.getView().sendFormAction(this.getView().getParentView().getParentView());
                    this.getView().invokeOperation("close");
                    break;
                }
                operationResult.setShowMessage(false);
                List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                List errorMessageList = allErrorOrValidateInfo.stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
                logger.info("DecAdjRecordRevisionFormPlugin origin errorMessageList is {}", errorMessageList);
                logger.info("DecAdjRecordRevisionFormPlugin operationResult.getMessage() is {}", (Object)operationResult.getMessage());
                errorMessageList = errorMessageList.stream().distinct().collect(Collectors.toList());
                if (errorMessageList.size() > 1) {
                    String title = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"DecAdjRecordRevisionFormPlugin_13", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                    FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
                    LocaleString operateName = formOperate.getOperateName();
                    FormShowParameter resultParameter = SWCShowFormServiceHelper.getOperationResultParameter((String)operateName.getLocaleValue(), (String)title, errorMessageList);
                    this.getView().showForm(resultParameter);
                    this.getView().sendFormAction(this.getView().getParentView());
                    break;
                }
                if (errorMessageList.size() == 1) {
                    this.getView().getParentView().showErrorNotification((String)errorMessageList.get(0));
                    this.getView().sendFormAction(this.getView().getParentView());
                    break;
                }
                this.getView().getParentView().showErrorNotification(operationResult.getMessage());
                this.getView().sendFormAction(this.getView().getParentView());
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        MessageBoxResult result = event.getResult();
        IPageCache pageCache = this.getPageCache();
        switch (callBackId = event.getCallBackId()) {
            case "CHANGE_SALARYADJRSN": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    String newSalaryAdjRsnStr = pageCache.get("newSalaryAdjRsn");
                    String rowIndexesStr = pageCache.get("rowIndexes");
                    pageCache.remove("newSalaryAdjRsn");
                    pageCache.remove("oldSalaryAdjRsn");
                    pageCache.remove("rowIndexes");
                    DynamicObject newSalaryAdjRsnDy = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)newSalaryAdjRsnStr);
                    List rowIndexesList = (List)SerializationUtils.deSerializeFromBase64((String)rowIndexesStr);
                    int[] rowIndexes = rowIndexesList.stream().mapToInt(Integer::intValue).toArray();
                    this.setNewSalaryAdjRsn(rowIndexes, newSalaryAdjRsnDy);
                } else {
                    String oldDyStr = pageCache.get("oldSalaryAdjRsn");
                    String rowIndexesStr = pageCache.get("rowIndexes");
                    if (Strings.isNullOrEmpty((String)oldDyStr)) {
                        return;
                    }
                    DynamicObject oldDy = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)oldDyStr);
                    List rowIndexesList = (List)SerializationUtils.deSerializeFromBase64((String)rowIndexesStr);
                    AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                    model.beginInit();
                    for (Integer rowIndex : rowIndexesList) {
                        this.getModel().setValue("salaryadjrsn_r", (Object)oldDy, rowIndex.intValue());
                        this.getView().updateView("salaryadjrsn_r", rowIndex.intValue());
                    }
                    model.endInit();
                    pageCache.remove("newSalaryAdjRsn");
                    pageCache.remove("oldSalaryAdjRsn");
                    pageCache.remove("rowIndexes");
                }
                this.hiddenAdjShowColumns();
                break;
            }
            case "save": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                OperateOption option = OperateOption.create();
                option.setVariableValue(CALLBACK_INVOKE_CURRENCY, Boolean.TRUE.toString());
                this.setCurrency();
                this.getView().invokeOperation(OP_SAVE, option);
                break;
            }
            case "callbackid_noexcesscontrol": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(CALLBACK_INVOKE_OVERSTANDARD, Boolean.TRUE.toString());
                operateOption.setVariableValue(CALLBACK_INVOKE_CURRENCY, Boolean.TRUE.toString());
                this.getView().invokeOperation(OP_SAVE, operateOption);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        int[] rowIndexes = new int[]{rowIndex};
        if ("salaryadjrsn_r".equals(propertyName)) {
            if (this.isPropertyChanged.compareAndSet(false, true)) {
                IDataModel model = this.getModel();
                DynamicObjectCollection itemEntry = model.getEntryEntity("revisionentry");
                String msg = DecAdjRecordRevisionHelper.validateAttributionType((DynamicObjectCollection)itemEntry);
                if (!StringUtils.isEmpty((CharSequence)msg)) {
                    this.getView().showErrorNotification(msg);
                    model.beginInit();
                    model.setValue("salaryadjrsn_r", changeSet[0].getOldValue(), rowIndex);
                    model.endInit();
                    this.getView().updateView("salaryadjrsn_r", rowIndex);
                } else {
                    this.showChangeSalaryAdjRsnConfirm(args);
                }
            }
            return;
        }
        if (AdjAttributionType.DECATTRTYPE.getCode().equals(DecAdjRecordRevisionFormPluginHelper.getAttributionType(rowIndexes[0], this.getModel()))) {
            this.calDataAfterDecChange(propertyName, rowIndexes);
        } else {
            this.calDataAfterAdjChange(propertyName, rowIndexes);
        }
        if ("bsed_r".equals(propertyName) || "bsled_r".equals(propertyName)) {
            // empty if block
        }
        if ("salarystd_r".equals(propertyName)) {
            // empty if block
        }
    }

    public void beforeSetItemValue(BeforeSetItemValueEventArgs beforeSetItemValueEventArgs) {
        IDataEntityProperty property = beforeSetItemValueEventArgs.getProperty();
        String propertyName = property.getName();
        if ("grade_r".equals(propertyName) || "rank_r".equals(propertyName)) {
            DecAdjRecordRevisionFormPluginHelper.addFilterWhenCopyAndPasteGradeAndRank(beforeSetItemValueEventArgs);
        }
        if ("standarditem_r".equals(propertyName)) {
            DecAdjRecordRevisionFormPluginHelper.addFilterWhenCopyAndPasteStandardItem(beforeSetItemValueEventArgs);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        if ("standarditem_r".equals(fieldKey)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String fileId = (String)formShowParameter.getCustomParam("key_custom_param_fileid");
            Long adjFileId = Long.valueOf(fileId);
            DynamicObject adjFileObj = SalaryAdjFileServiceHelper.queryAdjFileInfoByFileId((Long)adjFileId);
            SWCDataServiceHelper stdscmHelper = new SWCDataServiceHelper("hcdm_stdscm");
            QFilter qFilter = new QFilter("id", "in", (Object)adjFileObj.getLong("stdscm.id"));
            DynamicObject stdscmDyObj = stdscmHelper.queryOne("id,name,boid,salaystructure,sourcevid,entryentity,entryentity.salstructurent,entryentity.salstructurent,entryentity.standarditem,entryentity.salarystandard,entryentity.coefficienttabent", new QFilter[]{qFilter});
            DecAdjRecordRevisionFormPluginHelper.showStandardItemF7Select(evt, this.getView(), this.isRevise(), stdscmDyObj);
            return;
        }
        if ("grade_r".equals(fieldKey)) {
            DecAdjRecordRevisionFormPluginHelper.beforeF7SelectEntryGrade(evt, this.getView());
            return;
        }
        if ("rank_r".equals(fieldKey)) {
            DecAdjRecordRevisionFormPluginHelper.beforeF7SelectEntryRank(evt, this.getView());
            return;
        }
        if ("org_p".equals(fieldKey)) {
            DecAdjRecordRevisionFormPluginHelper.beforeF7SelectOrg(evt);
            return;
        }
        if ("empgroup_p".equals(fieldKey)) {
            DecAdjRecordRevisionFormPluginHelper.beforeF7SelectEmpGroup(evt);
            return;
        }
        int rowIndex = evt.getRow();
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("revisionentry", rowIndex);
        long salaryStdId = rowEntity.getLong("salarystd_r.id");
        if (salaryStdId != 0L) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("revisionentry");
            Map<Long, List<ContrastPropResult>> contrastPropMap = this.getContrastPropResult(entryEntity);
            List<ContrastPropResult> contrastPropResults = contrastPropMap.get(salaryStdId);
            Map fieldContrastMap = DecAdjRecordRevisionHelper.getFieldContrastMap();
            if (!CollectionUtils.isEmpty(contrastPropResults)) {
                Map<Long, ContrastPropResult> contrastProMap = contrastPropResults.stream().collect(Collectors.toMap(con -> con.getPropConfigEntity().getId(), con -> con, (o1, o2) -> o2));
                for (Map.Entry entry : fieldContrastMap.entrySet()) {
                    Long contrastPropId;
                    ContrastPropResult contrastPropResult;
                    if (!((String)((Pair)entry.getValue()).getKey()).equals(fieldKey) || ((Boolean)((Pair)entry.getValue()).getValue()).booleanValue() || (contrastPropResult = contrastProMap.get(contrastPropId = (Long)entry.getKey())) == null) continue;
                    List propValueList = contrastPropResult.getPropValueList();
                    ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
                    QFilter depFilter = new QFilter("id", "in", (Object)propValueList);
                    listShowParameter.getListFilterParameter().setFilter(depFilter);
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        super.beforeClosed(beforeClosedEvent);
        DecAdjRecordRevisionFormPluginHelper.refreshRecordQueryView(this.getView(), false);
    }

    public void pageRelease(EventObject eventObject) {
        super.pageRelease(eventObject);
        DecAdjRecordRevisionFormPluginHelper.releaseMutex(this.getView());
    }

    private void showChangeSalaryAdjRsnConfirm(PropertyChangedArgs args) {
        int[] rowIndexes = new int[]{args.getChangeSet()[0].getRowIndex()};
        ChangeData[] changeData = args.getChangeSet();
        DynamicObject oldDy = (DynamicObject)changeData[0].getOldValue();
        DynamicObject newDy = (DynamicObject)changeData[0].getNewValue();
        if (Objects.nonNull(oldDy) && Objects.nonNull(newDy) && oldDy.getString("attributiontype").equals(newDy.getString("attributiontype"))) {
            return;
        }
        String setNewValue = this.getPageCache().get("setnewvalue");
        if (Objects.nonNull(oldDy) && Strings.isNullOrEmpty((String)setNewValue)) {
            String msg = ResManager.loadKDString((String)"\u4fee\u6539\u5b9a\u8c03\u85aa\u7c7b\u578b\uff0c\u4ee5\u4e0b\u6570\u636e\u5b58\u5728\u5173\u8054\u5173\u7cfb\uff0c\u5c06\u88ab\u6e05\u7a7a\u3002", (String)"DecAdjRecordRevisionFormPlugin_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            String detailMsg = null;
            detailMsg = AdjAttributionType.DECATTRTYPE.getCode().equals(oldDy.getString("attributiontype")) ? ResManager.loadKDString((String)"\u4fee\u6b63\u4fe1\u606f\uff1a\u5217\u8868\u4e2d\u6240\u9009\u62e9\u7684\u5b9a\u85aa\u6570\u636e\u3002", (String)"DecAdjRecordRevisionFormPlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fee\u6b63\u4fe1\u606f\uff1a\u5217\u8868\u4e2d\u6240\u9009\u62e9\u7684\u8c03\u85aa\u6570\u636e\u3002", (String)"DecAdjRecordRevisionFormPlugin_12", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            this.getPageCache().remove("oldSalaryAdjRsn");
            this.getPageCache().remove("newSalaryAdjRsn");
            this.getPageCache().remove("rowIndexes");
            this.getPageCache().put("oldSalaryAdjRsn", SerializationUtils.serializeToBase64((Object)oldDy));
            this.getPageCache().put("newSalaryAdjRsn", SerializationUtils.serializeToBase64((Object)newDy));
            this.getPageCache().put("rowIndexes", SerializationUtils.serializeToBase64(Arrays.stream(rowIndexes).boxed().collect(Collectors.toList())));
            this.getView().showConfirm(msg, detailMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("CHANGE_SALARYADJRSN", (IFormPlugin)this));
        } else {
            this.getPageCache().remove("setnewvalue");
            this.setNewSalaryAdjRsn(rowIndexes, newDy);
            this.hiddenAdjShowColumns();
        }
    }

    private void setNewSalaryAdjRsn(int[] rowIndexes, DynamicObject newSalaryAdjRsnDy) {
        this.changeEntryDataAfterTypeChange(rowIndexes);
        if (ObjectUtils.isEmpty((Object)newSalaryAdjRsnDy)) {
            this.initCellLock(rowIndexes);
        } else {
            this.setEntryRowStyleForRowIndexes(rowIndexes);
        }
        this.setCalcTypeWhenAdjRsnChange(rowIndexes);
    }

    private void initRevisedData() {
        this.initData();
        this.initAmountStdRangeDisplay();
        this.initRevisedDataForAdjType();
        this.initLogicPanelValue();
        this.initPersonNameAndNumber();
        this.initStdCurrency();
    }

    private void initStdCurrency() {
        DecAdjRecordRevisionFormPluginHelper.initStdCurrency(this.getView());
    }

    private void initPersonNameAndNumber() {
        DecAdjRecordRevisionFormPluginHelper.setPersonNameAndNumber(this.getView());
    }

    private void initAmountStdRangeDisplay() {
        int[] rowIndexes = this.getModel().getEntryEntity("revisionentry").stream().mapToInt(dy -> dy.getInt("seq") - 1).toArray();
        DecAdjRecordRevisionFormPluginHelper.setAmountStdRangeDisplay(rowIndexes, this.getView());
    }

    private void initLogicPanelValue() {
        DecAdjRecordRevisionFormPluginHelper.setLogicPanelValues(this.getView());
    }

    private void initRevisedDataForAdjType() {
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        int[] rowIndexes = this.getModel().getEntryEntity("revisionentry").stream().mapToInt(dy -> dy.getInt("seq") - 1).toArray();
        DecAdjRecordRevisionFormPluginHelper.setLastAdjInfo(rowIndexes, this.getView(), type);
    }

    private void initData() {
        List ids = (List)this.getView().getFormShowParameter().getCustomParam("ids");
        if (Objects.nonNull(ids)) {
            Map result = DecAdjRecordRevisionHelper.getRevisionDyByIds((Object[])ids.toArray());
            for (int i = 0; i < ids.size(); ++i) {
                Long id = (Long)ids.get(i);
                Map dyMap = (Map)result.get(id);
                DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("revisionentry");
                DynamicObjectType dynamicObjectType = dynamicObjects.getDynamicObjectType();
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectType.createInstance();
                dynamicObject.set("id", (Object)id);
                dynamicObject.set("seq", (Object)(i + 1));
                DynamicObject recordDy = (DynamicObject)dyMap.get("hcdm_salaryadjrecord");
                DynamicObject personDy = (DynamicObject)dyMap.get("hcdm_decadjrelperson");
                Map fields = ((EntryType)dynamicObjectType).getFields();
                for (Map.Entry entry : fields.entrySet()) {
                    DynamicProperty property;
                    String key = (String)entry.getKey();
                    if (key.endsWith("_p")) {
                        String keyOfPersonDy = DecAdjRecordRevisionHelper.getKeyOfEntityFromDB((String)key, (String)"_p");
                        property = personDy.getDynamicObjectType().getProperty(keyOfPersonDy);
                        if (property != null) {
                            if (property instanceof MulBasedataProp) {
                                DecAdjRecordRevisionFormPlugin.setMulBaseData(dynamicObject, personDy, key, keyOfPersonDy);
                            } else {
                                dynamicObject.set(key, personDy.get(keyOfPersonDy));
                            }
                        }
                    }
                    if (!key.endsWith("_r")) continue;
                    String keyOfRecordDy = DecAdjRecordRevisionHelper.getKeyOfEntityFromDB((String)key, (String)"_r");
                    property = recordDy.getDynamicObjectType().getProperty(keyOfRecordDy);
                    if (property == null) continue;
                    if (property instanceof MulBasedataProp) {
                        DecAdjRecordRevisionFormPlugin.setMulBaseData(dynamicObject, recordDy, key, keyOfRecordDy);
                        continue;
                    }
                    dynamicObject.set(key, recordDy.get(keyOfRecordDy));
                }
                dynamicObject.set("thisrecord", (Object)recordDy);
                dynamicObject.set("thisperson", (Object)personDy);
                dynamicObject.set("needpush_r", (Object)YesOrNoEnum.YES.getCode());
                dynamicObjects.add((Object)dynamicObject);
            }
        }
    }

    private static void setMulBaseData(DynamicObject dynamicObject, DynamicObject originDy, String key, String keyOfOriginDy) {
        DynamicObjectCollection oldMulBaseDataCol = originDy.getDynamicObjectCollection(keyOfOriginDy);
        if (!CollectionUtils.isEmpty((Collection)oldMulBaseDataCol)) {
            DynamicObjectCollection newMulBaseDataCol = new DynamicObjectCollection();
            for (DynamicObject oldObject : oldMulBaseDataCol) {
                DynamicObject tempDy = new DynamicObject(oldObject.getDynamicObjectType());
                tempDy.set("fbasedataid", (Object)oldObject.getDynamicObject("fbasedataid"));
                newMulBaseDataCol.add((Object)tempDy);
            }
            dynamicObject.set(key, (Object)newMulBaseDataCol);
        }
    }

    private void lockContrastProp(DynamicObject revisionDy, List<ContrastPropResult> contrastPropResults, Map<Long, Pair<String, Boolean>> fieldContrastMap, Map<String, Boolean> fieldKeyLockStatusMap) {
        ArrayList lockFields = Lists.newArrayListWithExpectedSize((int)fieldContrastMap.size());
        if (!CollectionUtils.isEmpty(contrastPropResults)) {
            Set contrastPropIds = contrastPropResults.stream().map(con -> con.getPropConfigEntity().getId()).collect(Collectors.toSet());
            for (Map.Entry<Long, Pair<String, Boolean>> entry : fieldContrastMap.entrySet()) {
                if (contrastPropIds.contains(entry.getKey()) || ((Boolean)entry.getValue().getValue()).booleanValue()) continue;
                lockFields.add(entry.getValue().getKey());
            }
        } else {
            for (Map.Entry<Long, Pair<String, Boolean>> entry : fieldContrastMap.entrySet()) {
                long stdTableId = revisionDy.getLong("salarystd_r.id");
                if (stdTableId != 0L || ((Boolean)entry.getValue().getValue()).booleanValue()) continue;
                lockFields.add(entry.getValue().getKey());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)lockFields)) {
            lockFields.forEach(str -> fieldKeyLockStatusMap.put((String)str, Boolean.FALSE));
        }
    }

    private Map<Long, List<ContrastPropResult>> getContrastPropResult(DynamicObjectCollection entryEntity) {
        List stdTableIdList = entryEntity.stream().map(dy -> dy.getLong("salarystd_r.id")).collect(Collectors.toList());
        SalaryStdApplicationService salaryStdApplicationService = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
        return salaryStdApplicationService.getContrastProp(stdTableIdList);
    }

    private Map<String, DynamicObject> getFieldMapDysMapByType(DynamicObjectCollection entryEntity) {
        List typeList = entryEntity.stream().map(dy -> dy.getString("salaryadjrsn_r.attributiontype")).collect(Collectors.toList());
        return DecAdjRecordRevisionHelper.getFieldMapByType(typeList);
    }

    private Map<String, DynamicObject> getReviseFieldDysMapBySource() {
        return DecAdjRecordRevisionHelper.getReviseFieldMapByDataSource();
    }

    private void lockKeyFields(DynamicObject fieldMap, Map<String, Boolean> fieldKeyLockStatusMap) {
        if (Objects.nonNull(fieldMap)) {
            DynamicObjectCollection entryDys = fieldMap.getDynamicObjectCollection("entryentity");
            List<String> lockFieldKeyList = entryDys.stream().filter(dy -> dy.getBoolean("isenable")).map(dy -> dy.getString("fieldkey")).collect(Collectors.toList());
            lockFieldKeyList.forEach(str -> fieldKeyLockStatusMap.put((String)str, Boolean.FALSE));
        }
    }

    private void resetFieldLockStyle(DynamicObject reviseFieldMap, Map<String, Boolean> fieldKeyLockStatusMap) {
        if (Objects.nonNull(reviseFieldMap)) {
            DynamicObjectCollection entryDys = reviseFieldMap.getDynamicObjectCollection("entryentity");
            List<String> allFieldKeyList = entryDys.stream().map(dy -> dy.getString("fieldkey")).collect(Collectors.toList());
            allFieldKeyList.forEach(str -> fieldKeyLockStatusMap.put((String)str, Boolean.TRUE));
        }
    }

    private void lockUnReviseFields(DynamicObject reviseFieldMap, Map<String, Boolean> fieldKeyLockStatusMap) {
        if (Objects.nonNull(reviseFieldMap)) {
            DynamicObjectCollection entryDys = reviseFieldMap.getDynamicObjectCollection("entryentity");
            List<String> unReviseFieldKeyList = entryDys.stream().filter(dy -> !dy.getBoolean("isrevised")).map(dy -> dy.getString("fieldkey")).collect(Collectors.toList());
            unReviseFieldKeyList.forEach(str -> fieldKeyLockStatusMap.put((String)str, Boolean.FALSE));
        }
    }

    private void lockUnReviseFieldsForAddNew(DynamicObject reviseFieldMap, Map<String, Boolean> fieldKeyLockStatusMap) {
        if (Objects.nonNull(reviseFieldMap)) {
            DynamicObjectCollection entryDys = reviseFieldMap.getDynamicObjectCollection("entryentity");
            List<String> unReviseFieldKeyList = entryDys.stream().filter(dy -> !dy.getBoolean("isnewisrevised")).map(dy -> dy.getString("fieldkey")).collect(Collectors.toList());
            unReviseFieldKeyList.forEach(str -> fieldKeyLockStatusMap.put((String)str, Boolean.FALSE));
        }
    }

    private boolean isRevise() {
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        return "revise".equals(type);
    }

    private boolean isAddNew() {
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        return "addnew".equals(type);
    }

    private void changeEntryDataAfterTypeChange(int[] rowIndexes) {
        if (this.isAddNew() || this.isRevise()) {
            for (int rowIndex : rowIndexes) {
                this.getModel().setValue("standarditem_r", null, rowIndex);
                this.getModel().setValue("frequency_r", null, rowIndex);
                this.getModel().setValue("grade_r", null, rowIndex);
                this.getModel().setValue("rank_r", null, rowIndex);
                this.getModel().setValue("amountstdrange_r", null, rowIndex);
                this.getModel().setValue("amountstdrangedisplay", null, rowIndex);
                this.getModel().setValue("calctype_r", null, rowIndex);
                this.getModel().setValue("currency_r", null, rowIndex);
                this.getModel().setValue("suggestminrange_r", null, rowIndex);
                this.getModel().setValue("suggestmaxrange_r", null, rowIndex);
                this.getModel().setValue("suggestminamount_r", null, rowIndex);
                this.getModel().setValue("suggestmaxamount_r", null, rowIndex);
                this.getModel().setValue("actualrange_r", null, rowIndex);
                this.getModel().setValue("actualamount_r", null, rowIndex);
                this.getModel().setValue("amount_r", null, rowIndex);
                this.getModel().setValue("overstandardtype_r", null, rowIndex);
                this.getModel().setValue("issend_r", null, rowIndex);
                this.getModel().setValue("salarypercent_r", null, rowIndex);
                this.getModel().setValue("salaryseeprate_r", null, rowIndex);
                this.getModel().setValue("bsed_r", null, rowIndex);
                this.getModel().setValue("bsled_r", null, rowIndex);
                this.getModel().setValue("reason_r", null, rowIndex);
                this.getModel().setValue("bsled_r", (Object)SWCDateTimeUtils.getMaxBsled(), rowIndex);
                this.getModel().setValue("bsed_r", (Object)HRDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd"), rowIndex);
            }
        }
    }

    private void setCalcTypeWhenAdjRsnChange(int[] rowIndexes) {
        DecAdjRecordRevisionFormPluginHelper.setCalcTypeWhenAdjRsnChange(rowIndexes, this.getView(), this.getModel());
    }

    private void calDataAfterAdjChange(String propertyName, int[] rowIndexes) {
        boolean firstChange;
        DynamicObject billEntryRow = this.getModel().getEntryRowEntity("revisionentry", rowIndexes[0]);
        if ("standarditem_r".equals(propertyName)) {
            String calType;
            DecAdjRecordRevisionFormPluginHelper.clearItemRelateInfo(rowIndexes, this.getModel());
            if (billEntryRow.getDynamicObject("standarditem_r") == null) {
                return;
            }
            DecAdjRecordRevisionFormPluginHelper.updateStdScmAndFileVid(rowIndexes, this.getModel());
            if (this.isRevise()) {
                DecAdjRecordRevisionFormPluginHelper.updateDataSource(rowIndexes, this.getModel());
            }
            if (StringUtils.isEmpty((CharSequence)(calType = billEntryRow.getString("calctype_r")))) {
                calType = CalcType.GRADE_RANK.getCode();
                DecAdjRecordRevisionFormPluginHelper.modelSetValueIfExist(this.getModel(), "calctype_r", calType, rowIndexes[0]);
            }
            String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
            DecAdjRecordRevisionFormPluginHelper.setLastAdjInfo(rowIndexes, this.getView(), type);
            Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult = DecAdjRecordRevisionFormPluginHelper.getMatchStdResult(rowIndexes, this.getModel());
            logger.info("calDataAfterAdjChange matchStdResult ={} ", (Object)JSON.toJSONString(matchStdResult));
            DecAdjRecordRevisionFormPluginHelper.setStdRelationInfo(rowIndexes, this.getModel(), matchStdResult);
            DecAdjRecordRevisionFormPluginHelper.setStdScmEntryInfo(rowIndexes, this.getView(), this.getModel());
            DecAdjRecordRevisionFormPluginHelper.setAdjStdGradeRankInfo(rowIndexes, this.getModel(), matchStdResult);
            if (CalcType.GRADE_RANK.getCode().equals(calType)) {
                this.setEntryRowDataIfCalTypeIsGradeRank(rowIndexes, matchStdResult);
            }
            DecAdjRecordRevisionFormPluginHelper.setEntryBaseInfo(rowIndexes, this.getModel(), matchStdResult);
            DecAdjRecordRevisionFormPluginHelper.setStdCurrencyIfStdCurrencyIsNull(rowIndexes, this.getView(), this.getModel());
            this.setEntryRowStyleForRowIndexes(rowIndexes);
            this.getView().updateView("revisionentry", rowIndexes[0]);
        }
        if ("suggestminrange_r".equals(propertyName)) {
            DecAdjRecordRevisionFormPluginHelper.calcAdjAmountWithChangeData("calcWithSuggestRange", rowIndexes, this.getModel());
        }
        if ("suggestmaxrange_r".equals(propertyName)) {
            DecAdjRecordRevisionFormPluginHelper.calcAdjAmountWithChangeData("calcWithSuggestRange", rowIndexes, this.getModel());
        }
        if ("suggestminamount_r".equals(propertyName)) {
            DecAdjRecordRevisionFormPluginHelper.calcAdjAmountWithChangeData("calcWithSuggestAmount", rowIndexes, this.getModel());
        }
        if ("suggestmaxamount_r".equals(propertyName)) {
            DecAdjRecordRevisionFormPluginHelper.calcAdjAmountWithChangeData("calcWithSuggestAmount", rowIndexes, this.getModel());
        }
        if ("actualamount_r".equals(propertyName) && (firstChange = this.setChangeFlagToTrue(rowIndexes, "actualamount_r"))) {
            DecAdjRecordRevisionFormPluginHelper.calcAdjAmountWithChangeData("calcWithActualAmount", rowIndexes, this.getModel());
        }
        if ("actualrange_r".equals(propertyName) && (firstChange = this.setChangeFlagToTrue(rowIndexes, "actualrange_r"))) {
            BigDecimal preSalary = DecAdjRecordRevisionFormPluginHelper.getPreSalary(billEntryRow);
            if (preSalary != null) {
                DecAdjRecordRevisionFormPluginHelper.calcAdjAmountWithChangeData("calcWithActualRange", rowIndexes, this.getModel());
            } else {
                String calcType = billEntryRow.getString("calctype_r");
                if (CalcType.RATIO.getCode().equals(calcType)) {
                    BigDecimal amount = billEntryRow.getBigDecimal("amount_r");
                    DecAdjRecordRevisionFormPluginHelper.modelSetValueIfExist(this.getModel(), "actualamount_r", amount, rowIndexes[0]);
                }
            }
        }
        if ("amount_r".equals(propertyName) && (firstChange = this.setChangeFlagToTrue(rowIndexes, "amount_r"))) {
            String calType = billEntryRow.getString("calctype_r");
            if (CalcType.GRADE_RANK.getCode().equals(calType)) {
                DecAdjRecordRevisionFormPluginHelper.setLogicAmount(rowIndexes, this.getModel());
                DecAdjRecordRevisionFormPluginHelper.setCalcFieldAfter(rowIndexes, this.getModel());
                boolean actualChangeHasChanged = this.getChangeFlag(rowIndexes, "actualrange_r");
                boolean actualAmountHasChanged = this.getChangeFlag(rowIndexes, "actualamount_r");
                if (!actualChangeHasChanged || !actualAmountHasChanged) {
                    this.setChangeFlagToTrue(rowIndexes, "actualrange_r");
                    this.setChangeFlagToTrue(rowIndexes, "actualamount_r");
                    DecAdjRecordRevisionFormPluginHelper.calcAdjAmountWithChangeData("calcWithAmount", rowIndexes, this.getModel());
                }
                DecAdjRecordRevisionFormPluginHelper.setOverStandardType(rowIndexes, this.getView(), this.getModel());
                DecAdjRecordRevisionFormPluginHelper.updateCellFmt(rowIndexes, this.getView(), Lists.newArrayList((Object[])new String[]{"amount_r"}));
                return;
            }
            DecAdjRecordRevisionFormPluginHelper.setAdjCalcFieldAfter(rowIndexes, this.getModel());
            boolean actualChangeHasChanged = this.getChangeFlag(rowIndexes, "actualrange_r");
            boolean actualAmountHasChanged = this.getChangeFlag(rowIndexes, "actualamount_r");
            if (!actualChangeHasChanged || !actualAmountHasChanged) {
                this.setChangeFlagToTrue(rowIndexes, "actualrange_r");
                this.setChangeFlagToTrue(rowIndexes, "actualamount_r");
                DecAdjRecordRevisionFormPluginHelper.calcAdjAmountWithChangeData("calcWithAmount", rowIndexes, this.getModel());
            }
            DecAdjRecordRevisionFormPluginHelper.setLogicAmount(rowIndexes, this.getModel());
            DecAdjRecordRevisionFormPluginHelper.setOverStandardType(rowIndexes, this.getView(), this.getModel());
        }
        if ("calctype_r".equals(propertyName)) {
            String calType = billEntryRow.getString("calctype_r");
            if (!CalcType.GRADE_RANK.getCode().equals(calType)) {
                DecAdjRecordRevisionFormPluginHelper.calDataWhenAdjCurrencyChange(rowIndexes, this.getView(), this.getModel());
            }
            if (CalcType.GRADE_RANK.getCode().equals(calType)) {
                Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult = DecAdjRecordRevisionFormPluginHelper.getMatchStdResult(rowIndexes, this.getModel());
                logger.info("revision adj entry calctype change match std result={}", (Object)JSON.toJSONString(matchStdResult));
                DecAdjRecordRevisionFormPluginHelper.setStdRelationInfo(rowIndexes, this.getModel(), matchStdResult);
                this.setEntryRowDataIfCalTypeIsGradeRank(rowIndexes, matchStdResult);
            }
            DecAdjRecordRevisionFormPluginHelper.setCurrencySign(rowIndexes, this.getView(), "currency_r");
            DecAdjRecordRevisionFormPluginHelper.updateCellFmt(rowIndexes, this.getView(), Lists.newArrayList((Object[])new String[]{"suggestminamount_r", "suggestmaxamount_r", "amount_r", "actualamount_r"}));
            this.setEntryRowStyleForRowIndexes(rowIndexes);
        }
        if ("currency_r".equals(propertyName)) {
            DecAdjRecordRevisionFormPluginHelper.setStdCurrencyIfStdCurrencyIsNull(rowIndexes, this.getView(), this.getModel());
            String calType = billEntryRow.getString("calctype_r");
            if (!CalcType.GRADE_RANK.getCode().equals(calType)) {
                DecAdjRecordRevisionFormPluginHelper.calDataWhenAdjCurrencyChange(rowIndexes, this.getView(), this.getModel());
            }
            if (CalcType.GRADE_RANK.getCode().equals(calType)) {
                DecAdjRecordRevisionFormPluginHelper.calcDecAdjFinalAmount(rowIndexes, this.getModel());
                DecAdjRecordRevisionFormPluginHelper.setCalcFieldAfter(rowIndexes, this.getModel());
                DecAdjRecordRevisionFormPluginHelper.calcAdjAmountWithChangeData("calcWithAmount", rowIndexes, this.getModel());
                DecAdjRecordRevisionFormPluginHelper.setOverStandardType(rowIndexes, this.getView(), this.getModel());
                DecAdjRecordRevisionFormPluginHelper.setAmountStdRangeIfCalTypeIsGradeRank(rowIndexes, this.getView());
            }
            DecAdjRecordRevisionFormPluginHelper.setCurrencySign(rowIndexes, this.getView(), "currency_r");
            DecAdjRecordRevisionFormPluginHelper.updateCellFmt(rowIndexes, this.getView(), Lists.newArrayList((Object[])new String[]{"suggestminamount_r", "suggestmaxamount_r", "amount_r", "actualamount_r"}));
            this.setEntryRowStyleForRowIndexes(rowIndexes);
        }
        if ("grade_r".equals(propertyName)) {
            String calType = billEntryRow.getString("calctype_r");
            if (CalcType.GRADE_RANK.getCode().equals(calType)) {
                Map<Long, Map<Long, Boolean>> itemUseRankFlag = DecAdjRecordRevisionFormPluginHelper.getItemUseRankFlag(rowIndexes, this.getModel());
                boolean firstChange2 = this.setChangeFlagToTrue(rowIndexes, "grade_r");
                if (firstChange2) {
                    DecAdjRecordRevisionFormPluginHelper.calcDataWhenGradeChange(rowIndexes, this.getModel());
                    Map<Integer, Boolean> itemUseRankMap = DecAdjRecordRevisionFormPluginHelper.checkItemUseRank(rowIndexes, this.getModel(), itemUseRankFlag);
                    Boolean rankIsUserSetFlag = itemUseRankMap.get(rowIndexes[0]);
                    if (!rankIsUserSetFlag.booleanValue()) {
                        List<StdAmountAndSalaryCountQueryResult> salaryStdAmountQueryResult = DecAdjRecordRevisionFormPluginHelper.getStdAmountQueryResult(rowIndexes, this.getModel());
                        logger.info("revision adj entry grade change salary amount query result={}", (Object)JSON.toJSONString(salaryStdAmountQueryResult));
                        DecAdjRecordRevisionFormPluginHelper.calcAmountByGradeOrRank(rowIndexes, this.getModel(), itemUseRankMap, salaryStdAmountQueryResult);
                        DecAdjRecordRevisionFormPluginHelper.calcDecAdjFinalAmount(rowIndexes, this.getModel());
                    }
                }
            }
        }
        if ("rank_r".equals(propertyName)) {
            boolean firstChange3;
            String calType = billEntryRow.getString("calctype_r");
            if (CalcType.GRADE_RANK.getCode().equals(calType) && (firstChange3 = this.setChangeFlagToTrue(rowIndexes, "rank_r"))) {
                HashMap<Integer, Boolean> itemUseRankMap = new HashMap<Integer, Boolean>(1);
                itemUseRankMap.put(rowIndexes[0], true);
                List<StdAmountAndSalaryCountQueryResult> salaryStdAmountQueryResult = DecAdjRecordRevisionFormPluginHelper.getStdAmountQueryResult(rowIndexes, this.getModel());
                logger.info("revision adj entry rank change salary amount query result={}", (Object)JSON.toJSONString(salaryStdAmountQueryResult));
                DecAdjRecordRevisionFormPluginHelper.calcAmountByGradeOrRank(rowIndexes, this.getModel(), itemUseRankMap, salaryStdAmountQueryResult);
                DecAdjRecordRevisionFormPluginHelper.calcDecAdjFinalAmount(rowIndexes, this.getModel());
            }
        }
        if ("bsed_r".equals(propertyName)) {
            String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
            DecAdjRecordRevisionFormPluginHelper.setLastAdjInfo(rowIndexes, this.getView(), type);
            if (billEntryRow.getDate("bsed_r") != null || billEntryRow.getDynamicObject("standarditem_r") != null) {
                Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult = DecAdjRecordRevisionFormPluginHelper.getMatchStdResult(rowIndexes, this.getModel());
                logger.info("calDataAfterDecChange matchStdResult ={} ", (Object)JSON.toJSONString(matchStdResult));
                DecAdjRecordRevisionFormPluginHelper.setStdScmRelationInfoFromMatchResult(rowIndexes, this.getView(), this.getModel(), matchStdResult);
                int[] changeRows = DecAdjRecordRevisionFormPluginHelper.clearStdTabRelateInfoWhenTableIdChanged(rowIndexes, this.getModel(), matchStdResult);
                DecAdjRecordRevisionFormPluginHelper.clearCoefficientRelateInfoWhenCoefficientChanged(rowIndexes, this.getModel(), matchStdResult);
                DecAdjRecordRevisionFormPluginHelper.setStdRelationInfo(changeRows, this.getModel(), matchStdResult);
                DecAdjRecordRevisionFormPluginHelper.setStdGradeRankInfo(changeRows, this.getModel(), matchStdResult);
                String calType = billEntryRow.getString("calctype_r");
                if (CalcType.GRADE_RANK.getCode().equals(calType)) {
                    this.setEntryRowDataIfCalTypeIsGradeRank(changeRows, matchStdResult);
                }
                DecAdjRecordRevisionFormPluginHelper.setStdCurrencyIfStdCurrencyIsNull(changeRows, this.getView(), this.getModel());
            }
            String calType = billEntryRow.getString("calctype_r");
            if (CalcType.GRADE_RANK.getCode().equals(calType)) {
                DecAdjRecordRevisionFormPluginHelper.setCalcFieldAfter(rowIndexes, this.getModel());
            } else {
                DecAdjRecordRevisionFormPluginHelper.setAdjCalcFieldAfter(rowIndexes, this.getModel());
                if (CalcType.AMOUNT.getCode().equals(calType)) {
                    DecAdjRecordRevisionFormPluginHelper.calcAdjAmountWithChangeData("calcWithSuggestAmount", rowIndexes, this.getModel());
                }
                if (CalcType.RATIO.getCode().equals(calType)) {
                    DecAdjRecordRevisionFormPluginHelper.calcAdjAmountWithChangeData("calcWithSuggestRange", rowIndexes, this.getModel());
                }
            }
            boolean actualChangeHasChanged = this.getChangeFlag(rowIndexes, "actualrange_r");
            boolean actualAmountHasChanged = this.getChangeFlag(rowIndexes, "actualamount_r");
            if (!actualChangeHasChanged || !actualAmountHasChanged) {
                this.setChangeFlagToTrue(rowIndexes, "actualrange_r");
                this.setChangeFlagToTrue(rowIndexes, "actualamount_r");
                DecAdjRecordRevisionFormPluginHelper.calcAdjAmountWithChangeData("calcWithAmount", rowIndexes, this.getModel());
            }
            DecAdjRecordRevisionFormPluginHelper.setOverStandardType(rowIndexes, this.getView(), this.getModel());
            this.setEntryRowStyleForRowIndexes(rowIndexes);
        }
    }

    private void calDataAfterDecChange(String propertyName, int[] rowIndexes) {
        boolean firstChange;
        if ("standarditem_r".equals(propertyName)) {
            DecAdjRecordRevisionFormPluginHelper.clearItemRelateInfo(rowIndexes, this.getModel());
            DynamicObject billEntryRow = this.getModel().getEntryRowEntity("revisionentry", rowIndexes[0]);
            if (billEntryRow.getDynamicObject("standarditem_r") == null) {
                return;
            }
            if (this.isRevise()) {
                DecAdjRecordRevisionFormPluginHelper.updateDataSource(rowIndexes, this.getModel());
            }
            Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult = DecAdjRecordRevisionFormPluginHelper.getMatchStdResult(rowIndexes, this.getModel());
            logger.info("calDataAfterDecChange matchStdResult ={} ", (Object)JSON.toJSONString(matchStdResult));
            DecAdjRecordRevisionFormPluginHelper.setStdRelationInfo(rowIndexes, this.getModel(), matchStdResult);
            DecAdjRecordRevisionFormPluginHelper.setStdScmEntryInfo(rowIndexes, this.getView(), this.getModel());
            DecAdjRecordRevisionFormPluginHelper.setStdGradeRankInfo(rowIndexes, this.getModel(), matchStdResult);
            DecAdjRecordRevisionFormPluginHelper.setAmountStdRangeDisplay(rowIndexes, this.getView());
            DecAdjRecordRevisionFormPluginHelper.setIsMatchStdGradeRankInfo(rowIndexes, this.getModel(), matchStdResult);
            DecAdjRecordRevisionFormPluginHelper.setEntryBaseInfo(rowIndexes, this.getModel(), matchStdResult);
            DecAdjRecordRevisionFormPluginHelper.setStdCurrencyIfStdCurrencyIsNull(rowIndexes, this.getView(), this.getModel());
            this.setEntryRowStyleForRowIndexes(rowIndexes);
            this.getView().updateView("revisionentry", rowIndexes[0]);
        }
        if ("amount_r".equals(propertyName) && (firstChange = this.setChangeFlagToTrue(rowIndexes, "amount_r"))) {
            DecAdjRecordRevisionFormPluginHelper.setLogicAmount(rowIndexes, this.getModel());
            DecAdjRecordRevisionFormPluginHelper.setCalcFieldAfter(rowIndexes, this.getModel());
            DecAdjRecordRevisionFormPluginHelper.setOverStandardType(rowIndexes, this.getView(), this.getModel());
            DecAdjRecordRevisionFormPluginHelper.updateCellFmt(rowIndexes, this.getView(), Lists.newArrayList((Object[])new String[]{"amount_r"}));
        }
        if ("grade_r".equals(propertyName)) {
            Map<Long, Map<Long, Boolean>> itemUseRankFlag = DecAdjRecordRevisionFormPluginHelper.getItemUseRankFlag(rowIndexes, this.getModel());
            boolean firstChange2 = this.setChangeFlagToTrue(rowIndexes, "grade_r");
            if (firstChange2) {
                DecAdjRecordRevisionFormPluginHelper.calcDataWhenGradeChange(rowIndexes, this.getModel());
                Map<Integer, Boolean> itemUseRankMap = DecAdjRecordRevisionFormPluginHelper.checkItemUseRank(rowIndexes, this.getModel(), itemUseRankFlag);
                Boolean rankIsUserSetFlag = itemUseRankMap.get(rowIndexes[0]);
                if (!rankIsUserSetFlag.booleanValue()) {
                    List<StdAmountAndSalaryCountQueryResult> salaryStdAmountQueryResult = DecAdjRecordRevisionFormPluginHelper.getStdAmountQueryResult(rowIndexes, this.getModel());
                    logger.info("revision dec entry grade change salary amount query result={}", (Object)JSON.toJSONString(salaryStdAmountQueryResult));
                    DecAdjRecordRevisionFormPluginHelper.calcAmountByGradeOrRank(rowIndexes, this.getModel(), itemUseRankMap, salaryStdAmountQueryResult);
                    DecAdjRecordRevisionFormPluginHelper.calcDecAdjFinalAmount(rowIndexes, this.getModel());
                }
            }
        }
        if ("rank_r".equals(propertyName) && (firstChange = this.setChangeFlagToTrue(rowIndexes, "rank_r"))) {
            HashMap<Integer, Boolean> itemUseRankMap = new HashMap<Integer, Boolean>(1);
            itemUseRankMap.put(rowIndexes[0], true);
            List<StdAmountAndSalaryCountQueryResult> salaryStdAmountQueryResult = DecAdjRecordRevisionFormPluginHelper.getStdAmountQueryResult(rowIndexes, this.getModel());
            logger.info("revision dec entry rank change salary amount query result={}", (Object)JSON.toJSONString(salaryStdAmountQueryResult));
            DecAdjRecordRevisionFormPluginHelper.calcAmountByGradeOrRank(rowIndexes, this.getModel(), itemUseRankMap, salaryStdAmountQueryResult);
            DecAdjRecordRevisionFormPluginHelper.calcDecAdjFinalAmount(rowIndexes, this.getModel());
        }
        if ("bsed_r".equals(propertyName) && (firstChange = this.setChangeFlagToTrue(rowIndexes, "bsed_r"))) {
            DynamicObject billEntryRow = this.getModel().getEntryRowEntity("revisionentry", rowIndexes[0]);
            if (billEntryRow.getDate("bsed_r") == null || billEntryRow.getDynamicObject("standarditem_r") == null) {
                return;
            }
            Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult = DecAdjRecordRevisionFormPluginHelper.getMatchStdResult(rowIndexes, this.getModel());
            logger.info("calDataAfterDecChange matchStdResult ={} ", (Object)JSON.toJSONString(matchStdResult));
            DecAdjRecordRevisionFormPluginHelper.setStdScmRelationInfoFromMatchResult(rowIndexes, this.getView(), this.getModel(), matchStdResult);
            int[] changeRows = DecAdjRecordRevisionFormPluginHelper.clearStdTabRelateInfoWhenTableIdChanged(rowIndexes, this.getModel(), matchStdResult);
            DecAdjRecordRevisionFormPluginHelper.clearCoefficientRelateInfoWhenCoefficientChanged(rowIndexes, this.getModel(), matchStdResult);
            DecAdjRecordRevisionFormPluginHelper.setStdRelationInfo(changeRows, this.getModel(), matchStdResult);
            DecAdjRecordRevisionFormPluginHelper.setStdGradeRankInfo(changeRows, this.getModel(), matchStdResult);
            Map<Long, Map<Long, Boolean>> itemUseRankFlag = DecAdjRecordRevisionFormPluginHelper.getItemUseRankFlag(changeRows, this.getModel());
            Map<Integer, Boolean> itemUseRankMap = DecAdjRecordRevisionFormPluginHelper.checkItemUseRank(changeRows, this.getModel(), itemUseRankFlag);
            List<StdAmountAndSalaryCountQueryResult> salaryStdAmountQueryResult = DecAdjRecordRevisionFormPluginHelper.getStdAmountQueryResult(changeRows, this.getModel());
            logger.info("revision dec entry grade change salary amount query result={}", (Object)JSON.toJSONString(salaryStdAmountQueryResult));
            DecAdjRecordRevisionFormPluginHelper.calcAmountByGradeOrRank(changeRows, this.getModel(), itemUseRankMap, salaryStdAmountQueryResult);
            DecAdjRecordRevisionFormPluginHelper.calcDecAdjFinalAmount(changeRows, this.getModel());
            DecAdjRecordRevisionFormPluginHelper.setStdCurrencyIfStdCurrencyIsNull(changeRows, this.getView(), this.getModel());
            this.setEntryRowStyleForRowIndexes(changeRows);
        }
        if ("currency_r".equals(propertyName)) {
            DecAdjRecordRevisionFormPluginHelper.setStdCurrencyIfStdCurrencyIsNull(rowIndexes, this.getView(), this.getModel());
            DecAdjRecordRevisionFormPluginHelper.calDataWhenDecCurrencyChange(rowIndexes, this.getView(), this.getModel());
            DecAdjRecordRevisionFormPluginHelper.updateCellFmt(rowIndexes, this.getView(), Lists.newArrayList((Object[])new String[]{"amount_r"}));
        }
    }

    private void setEntryRowDataIfCalTypeIsGradeRank(int[] rowIndexes, Map<Long, Map<Long, SalaryStdMatchResultNew>> matchStdResult) {
        DecAdjRecordRevisionFormPluginHelper.setStdGradeRankInfo(rowIndexes, this.getModel(), matchStdResult);
        List<StdAmountAndSalaryCountQueryResult> salaryStdAmountQueryResult = DecAdjRecordRevisionFormPluginHelper.getStdAmountQueryResult(rowIndexes, this.getModel());
        Map<Long, Map<Long, Boolean>> itemUseRankFlag = DecAdjRecordRevisionFormPluginHelper.getItemUseRankFlag(rowIndexes, this.getModel());
        Map<Integer, Boolean> itemUseRankMap = DecAdjRecordRevisionFormPluginHelper.checkItemUseRank(rowIndexes, this.getModel(), itemUseRankFlag);
        DecAdjRecordRevisionFormPluginHelper.calcAmountByGradeOrRank(rowIndexes, this.getModel(), itemUseRankMap, salaryStdAmountQueryResult);
        DecAdjRecordRevisionFormPluginHelper.calcDecAdjFinalAmount(rowIndexes, this.getModel());
        DecAdjRecordRevisionFormPluginHelper.setCalcFieldAfter(rowIndexes, this.getModel());
        DecAdjRecordRevisionFormPluginHelper.calcAdjAmountWithChangeData("calcWithAmount", rowIndexes, this.getModel());
        DecAdjRecordRevisionFormPluginHelper.setIsMatchStdGradeRankInfo(rowIndexes, this.getModel(), matchStdResult);
        DecAdjRecordRevisionFormPluginHelper.setOverStandardType(rowIndexes, this.getView(), this.getModel());
        DecAdjRecordRevisionFormPluginHelper.setAmountStdRangeIfCalTypeIsGradeRank(rowIndexes, this.getView());
    }

    private Map<Integer, Map<String, Boolean>> changeEntryStyle(int[] rowIndexes) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("revisionentry");
        HashMap fieldKeyLockStatusMap = Maps.newHashMapWithExpectedSize((int)16);
        if (entryEntity.size() > 0) {
            Map<String, DynamicObject> reviseFieldDysMap = this.getReviseFieldDysMapBySource();
            Map<String, DynamicObject> fieldMapDysMap = this.getFieldMapDysMapByType(entryEntity);
            Map<Long, List<ContrastPropResult>> contrastPropMap = this.getContrastPropResult(entryEntity);
            Map fieldContrastMap = DecAdjRecordRevisionHelper.getFieldContrastMap();
            for (int index : rowIndexes) {
                HashMap rowFieldKeyLockStatusMap = Maps.newHashMapWithExpectedSize((int)16);
                DynamicObject revisionDy = (DynamicObject)entryEntity.get(index);
                String dataSource = revisionDy.getString("datasource_r");
                DynamicObject reviseFieldMap = reviseFieldDysMap.get(dataSource);
                if (reviseFieldMap == null) {
                    reviseFieldMap = reviseFieldDysMap.get(EventTypeEnum.SALARYADJRECORD_REVISION.getCode());
                }
                this.resetFieldLockStyle(reviseFieldMap, rowFieldKeyLockStatusMap);
                if (EventTypeEnum.SALARYADJRECORD_REVISION_ADDNEW.getCode().equals(dataSource)) {
                    if (this.isAddNew()) {
                        this.lockUnReviseFieldsForAddNew(reviseFieldMap, rowFieldKeyLockStatusMap);
                    } else {
                        this.lockUnReviseFields(reviseFieldMap, rowFieldKeyLockStatusMap);
                    }
                } else {
                    this.lockUnReviseFields(reviseFieldMap, rowFieldKeyLockStatusMap);
                }
                String type = revisionDy.getString("salaryadjrsn_r.attributiontype");
                DynamicObject fieldMap = fieldMapDysMap.get(type);
                this.lockKeyFields(fieldMap, rowFieldKeyLockStatusMap);
                Long stdTableId = revisionDy.getLong("salarystd_r.id");
                List<ContrastPropResult> contrastPropResults = contrastPropMap.get(stdTableId);
                if (!EventTypeEnum.INIT.getCode().equals(dataSource)) {
                    this.lockContrastProp(revisionDy, contrastPropResults, fieldContrastMap, rowFieldKeyLockStatusMap);
                }
                fieldKeyLockStatusMap.put(index, rowFieldKeyLockStatusMap);
            }
            return fieldKeyLockStatusMap;
        }
        return fieldKeyLockStatusMap;
    }

    private void setEnableByFieldKeyLockStatusMap(List<Map<Integer, Map<String, Boolean>>> fieldKeyLockStatusMapList) {
        if (CollectionUtils.isEmpty(fieldKeyLockStatusMapList)) {
            return;
        }
        HashMap allFieldKeyLockStatusMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map<Integer, Map<String, Boolean>> map : fieldKeyLockStatusMapList) {
            for (Map.Entry<Integer, Map<String, Boolean>> entry : map.entrySet()) {
                Integer rowIndex = entry.getKey();
                Map<String, Boolean> rowFieldLockMap = entry.getValue();
                Map childMap = allFieldKeyLockStatusMap.computeIfAbsent(rowIndex, value -> Maps.newHashMapWithExpectedSize((int)16));
                childMap.putAll(rowFieldLockMap);
            }
        }
        logger.info("setEnableByFieldKeyLockStatusMap allFieldKeyLockStatusMap is {}", (Object)allFieldKeyLockStatusMap);
        if (MapUtils.isNotEmpty((Map)allFieldKeyLockStatusMap)) {
            for (Map.Entry entry : allFieldKeyLockStatusMap.entrySet()) {
                Integer rowIndex = (Integer)entry.getKey();
                Map rowFieldLockMap = (Map)entry.getValue();
                logger.info("setEnableByFieldKeyLockStatusMap rowIndex is {} ,rowFieldLockMap is {}", (Object)rowIndex, (Object)rowFieldLockMap);
                ArrayList lockFieldsList = Lists.newArrayListWithExpectedSize((int)rowFieldLockMap.size());
                ArrayList unLockFieldsList = Lists.newArrayListWithExpectedSize((int)rowFieldLockMap.size());
                for (Map.Entry rowFieldLockMapEntry : rowFieldLockMap.entrySet()) {
                    if (((Boolean)rowFieldLockMapEntry.getValue()).booleanValue()) {
                        unLockFieldsList.add(rowFieldLockMapEntry.getKey());
                        continue;
                    }
                    lockFieldsList.add(rowFieldLockMapEntry.getKey());
                }
                if (!CollectionUtils.isEmpty((Collection)unLockFieldsList)) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex.intValue(), unLockFieldsList.toArray(new String[0]));
                }
                if (CollectionUtils.isEmpty((Collection)lockFieldsList)) continue;
                this.getView().setEnable(Boolean.FALSE, rowIndex.intValue(), lockFieldsList.toArray(new String[0]));
            }
        }
    }

    private boolean setChangeFlagToTrue(int[] rowIndexArr, String key) {
        boolean setSuccess = false;
        for (int rowIndex : rowIndexArr) {
            Map rowBitMap = this.entryFieldChangeBitMap.computeIfAbsent(rowIndex, v1 -> Maps.newHashMap());
            AtomicBoolean atomicBoolean = rowBitMap.computeIfAbsent(key, v1 -> new AtomicBoolean());
            boolean changed = atomicBoolean.get();
            if (changed) continue;
            atomicBoolean.getAndSet(true);
            setSuccess = true;
        }
        return setSuccess;
    }

    private boolean getChangeFlag(int[] rowIndexArr, String key) {
        boolean changed = false;
        for (int rowIndex : rowIndexArr) {
            Map rowBitMap = this.entryFieldChangeBitMap.computeIfAbsent(rowIndex, v1 -> Maps.newHashMap());
            AtomicBoolean atomicBoolean = rowBitMap.computeIfAbsent(key, v1 -> new AtomicBoolean());
            if (!atomicBoolean.get()) continue;
            changed = true;
        }
        return changed;
    }

    private void registerF7ListenerForEntry(String entryKey) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        List controlList = entryGrid.getControls();
        if (!CollectionUtils.isEmpty((Collection)controlList)) {
            for (Control control : controlList) {
                if (!(control instanceof BasedataEdit)) continue;
                BasedataEdit basedataEdit = (BasedataEdit)control;
                basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
        }
    }

    private void initEntryValue(int insertRow) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fileId = (String)formShowParameter.getCustomParam("key_custom_param_fileid");
        Long adjFileId = Long.valueOf(fileId);
        DynamicObject adjFileObj = SalaryAdjFileServiceHelper.queryAdjFileInfoByFileId((Long)adjFileId);
        this.getModel().setValue("salaryadjfile_r", (Object)adjFileObj.getLong("boid"), insertRow);
        this.getModel().setValue("salaryadjfilevid_r", ((DynamicObject)this.getModel().getValue("salaryadjfile_r", insertRow)).get("sourcevid"), insertRow);
        long salayStructureId = adjFileObj.getLong("salaystructure.id");
        this.getModel().setValue("salaystructure_p", (Object)salayStructureId, insertRow);
        long stdscmSourcevId = adjFileObj.getLong("stdscm.sourcevid");
        this.getModel().setValue("stdscm_p", (Object)stdscmSourcevId, insertRow);
        long depempId = adjFileObj.getLong("depemp.id");
        this.getModel().setValue("depemp_p", (Object)depempId, insertRow);
        long orgId = adjFileObj.getLong("org.id");
        this.getModel().setValue("org_p", (Object)orgId, insertRow);
        long countryId = adjFileObj.getLong("country.id");
        this.getModel().setValue("country_p", (Object)countryId, insertRow);
        long empgroupId = adjFileObj.getLong("empgroup.id");
        this.getModel().setValue("empgroup_p", (Object)empgroupId, insertRow);
        long depcyTypeId = adjFileObj.getLong("depcytype.id");
        this.getModel().setValue("depcytype_p", (Object)depcyTypeId, insertRow);
        long companyId = adjFileObj.getLong("empposorgrel.company.id");
        this.getModel().setValue("company_p", (Object)companyId, insertRow);
        long adminorgId = adjFileObj.getLong("adminorg.sourcevid");
        this.getModel().setValue("adminorg_p", (Object)adminorgId, insertRow);
        long assoadminorgId = adjFileObj.getLong("assoadminorg.sourcevid");
        this.getModel().setValue("assoadminorg_p", (Object)assoadminorgId, insertRow);
        this.getModel().setValue("datasource_r", (Object)EventTypeEnum.SALARYADJRECORD_REVISION_ADDNEW.getCode(), insertRow);
        this.getModel().setValue("bsled_r", (Object)SWCDateTimeUtils.getMaxBsled(), insertRow);
        this.getModel().setValue("bsed_r", (Object)HRDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd"), insertRow);
        this.setPersonNameAndNumber(insertRow);
    }

    private void setPersonNameAndNumber(int row) {
        DecAdjRecordRevisionFormPluginHelper.setPersonNameAndNumber(this.getView(), row);
    }

    private void initCellLock(int[] rowIndexes) {
        for (int rowIndex : rowIndexes) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, this.cells);
        }
    }

    private void saveHisDataToVersion() {
        DynamicObjectCollection entryDys = this.getModel().getEntryEntity("revisionentry");
        HashSet saveBoidFieldSet = Sets.newHashSet((Object[])this.saveBoidFieldArr);
        HashSet saveVidFieldSet = Sets.newHashSet((Object[])this.saveVidFieldArr);
        for (int i = 0; i < entryDys.size(); ++i) {
            DynamicObject entryDy = (DynamicObject)entryDys.get(i);
            DynamicObjectType dynamicObjectType = entryDy.getDynamicObjectType();
            Map fields = ((EntryType)dynamicObjectType).getFields();
            for (Map.Entry entry : fields.entrySet()) {
                DynamicObject hisDy;
                Object dy;
                String key = (String)entry.getKey();
                if (saveBoidFieldSet.contains(key)) {
                    this.getModel().setValue(key, (Object)entryDy.getLong(key + ".boid"), i);
                }
                if (!saveVidFieldSet.contains(key) || !((dy = this.getModel().getValue(key, i)) instanceof DynamicObject) || !(hisDy = (DynamicObject)dy).getBoolean("iscurrentversion")) continue;
                this.getModel().setValue(key, (Object)entryDy.getLong(key + ".sourcevid"), i);
            }
        }
    }

    private void setCurrency() {
        DynamicObjectCollection entryDys = this.getModel().getEntryEntity("revisionentry");
        for (int index = 0; index < entryDys.size(); ++index) {
            DynamicObject entryDy = (DynamicObject)entryDys.get(index);
            DynamicObject salaryStd = entryDy.getDynamicObject("salarystd_r");
            if (SWCObjectUtils.isEmpty((Object)salaryStd)) continue;
            this.getModel().setValue("currency_r", salaryStd.get("currency"), index);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    private void hiddenAdjShowColumns() {
        IDataModel model = this.getModel();
        DynamicObjectCollection revisionEntry = model.getDataEntity(true).getDynamicObjectCollection("revisionentry");
        if (revisionEntry == null || revisionEntry.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, this.adjShowColumns);
            return;
        }
        model.beginInit();
        boolean isAdjSal = false;
        for (DynamicObject entry : revisionEntry) {
            String attributionType = entry.getString("salaryadjrsn_r.attributiontype");
            if (StringUtils.equals((CharSequence)attributionType, (CharSequence)"2")) {
                isAdjSal = true;
                continue;
            }
            for (String column : this.adjShowColumns) {
                int rowIndex = entry.getInt("seq") - 1;
                model.setValue(column, null, rowIndex);
            }
        }
        model.endInit();
        if (isAdjSal) {
            this.getView().setVisible(Boolean.TRUE, this.adjShowColumns);
        } else {
            this.getView().setVisible(Boolean.FALSE, this.adjShowColumns);
        }
    }
}

