/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.decadjrecordrevision;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.swc.hcdm.business.adjapprbill.GradeAndRankNameHelper;
import kd.swc.hcdm.business.adjapprbill.enums.CalcType;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hcdm.common.entity.adjapprbill.AmountStdRangeEntity;
import kd.swc.hcdm.common.entity.adjapprbill.GradeAndRankNameEntity;
import kd.swc.hcdm.common.utils.GlobalParam;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;

public class DecAdjRevisionRecordListPlugin
extends AbstractListPlugin {
    private static final String ADJSALARYFILENUM_KEY = "salaryadjfile.number";
    public static final String ADJFILEIDLIST_KEY = "adjFileIdList";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        FilterColumn numberFilterColumn = args.getFilterColumn(ADJSALARYFILENUM_KEY);
        List adjFileIdList = (List)formShowParameter.getCustomParam(ADJFILEIDLIST_KEY);
        if (adjFileIdList != null && adjFileIdList.size() > 0) {
            numberFilterColumn.setDefaultValues(this.getAdjFileNums(adjFileIdList));
        }
    }

    public void setFilter(SetFilterEvent event) {
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"0VO5EV13=I9W", (String)"hcdm_revisionrecord");
        if (!permOrgs.hasAllOrgPerm()) {
            event.addCustomQFilter(new QFilter("salaryadjfile.org.id", "in", (Object)permOrgs.getHasPermOrgs()));
        }
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        DynamicObjectCollection pageData = event.getPageData();
        Map<Long, Map<String, String>> revisionRecordIdToGradeRankNameMap = DecAdjRevisionRecordListPlugin.setAmountStdRangeDisplay(pageData);
        GlobalParam.set((String)"GRADE_AND_RANK_CACHE_KEY", revisionRecordIdToGradeRankNameMap);
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        String fieldKey = columnDesc.getFieldKey();
        DynamicObject rowData = event.getRowData();
        Map amountStdRangeMapResult = (Map)GlobalParam.get((String)"GRADE_AND_RANK_CACHE_KEY");
        if (ObjectUtils.isEmpty((Object)amountStdRangeMapResult)) {
            return;
        }
        long recordId = rowData.getLong("id");
        Map amountStdRangeMap = (Map)amountStdRangeMapResult.get(recordId);
        if (amountStdRangeMap != null && amountStdRangeMap.size() > 0) {
            if ("amountstdrangeshow".equals(fieldKey)) {
                event.setFormatValue(amountStdRangeMap.get("beforeRevision"));
            } else if ("amountstdrangeshowafter".equals(fieldKey)) {
                event.setFormatValue(amountStdRangeMap.get("afterRevision"));
            }
        }
    }

    public static Map<Long, Map<String, String>> setAmountStdRangeDisplay(DynamicObjectCollection pageData) {
        HashMap<Long, Map<String, String>> revisionRecordIdToGradeRankNameMap = new HashMap<Long, Map<String, String>>(16);
        DynamicObject[] coll = DecAdjRevisionRecordListPlugin.getRevisionRecord(pageData);
        ArrayList<String> amountStdRangeList = new ArrayList<String>(10);
        ArrayList<String> matchGradeRankRelList = new ArrayList<String>(10);
        HashMap stdItemMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap recordMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList<String> amountStdRangeAfterList = new ArrayList<String>(10);
        ArrayList<String> matchGradeRankRelAfterList = new ArrayList<String>(10);
        HashMap stdItemAfterMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject rowData : coll) {
            String amountStdRangeAfter;
            String amountStdRange;
            String matchGradeRankRel = rowData.getString("salargrel");
            if (!Strings.isNullOrEmpty((String)matchGradeRankRel)) {
                matchGradeRankRelList.add(matchGradeRankRel);
            }
            if (!Strings.isNullOrEmpty((String)(amountStdRange = rowData.getString("amountstdrange")))) {
                amountStdRangeList.add(amountStdRange);
            }
            long salaryStdId = rowData.getLong("salarystd.id");
            List itemIds = stdItemMap.computeIfAbsent(salaryStdId, v1 -> Lists.newArrayList());
            itemIds.add(rowData.getLong("standarditem.id"));
            recordMap.put(rowData.getLong("id"), rowData);
            String matchGradeRankRelAfter = rowData.getString("entryentity.salargrelafter");
            if (!Strings.isNullOrEmpty((String)matchGradeRankRel)) {
                matchGradeRankRelAfterList.add(matchGradeRankRelAfter);
            }
            if (!Strings.isNullOrEmpty((String)(amountStdRangeAfter = rowData.getString("entryentity.amountstdrangeafter")))) {
                amountStdRangeAfterList.add(amountStdRangeAfter);
            }
            long salaryStdAfterId = rowData.getLong("entryentity.salarystdafter.id");
            List itemAfterIds = stdItemAfterMap.computeIfAbsent(salaryStdAfterId, v1 -> Lists.newArrayList());
            itemAfterIds.add(rowData.getLong("entryentity.standarditemafter.id"));
        }
        GradeAndRankNameEntity gradeAndRankNameEntity = GradeAndRankNameHelper.getGradeAndRankNameFromMatchGradeRankRel(matchGradeRankRelList);
        GradeAndRankNameEntity gradeAndRankNameEntityAfter = GradeAndRankNameHelper.getGradeAndRankNameFromMatchGradeRankRel(matchGradeRankRelAfterList);
        GradeAndRankNameEntity amountStdRangeGradeAndRankNameEntity = GradeAndRankNameHelper.getGradeAndRankNameFromAmountStdRange(amountStdRangeList);
        GradeAndRankNameEntity amountStdRangeGradeAndRankNameEntityAfter = GradeAndRankNameHelper.getGradeAndRankNameFromAmountStdRange(amountStdRangeAfterList);
        SalaryStdApplicationService service = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
        Map useRankMap = service.getSalaryItemUseRankFlag((Map)stdItemMap);
        Map useRankAfterMap = service.getSalaryItemUseRankFlag((Map)stdItemAfterMap);
        for (DynamicObject row : pageData) {
            String amountStdRange;
            String amountStdRange2;
            long revisionRecordId = row.getLong("id");
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            DynamicObject collObj = (DynamicObject)recordMap.get(revisionRecordId);
            String attributionType = collObj.getString("salaryadjrsn.attributiontype");
            String calcType = collObj.getString("calctype");
            if (AdjAttributionType.DECATTRTYPE.getCode().equals(attributionType) || CalcType.GRADE_RANK.getCode().equals(calcType) && AdjAttributionType.ADJATTRTYPE.getCode().equals(attributionType)) {
                long salaryStdId = collObj.getLong("salarystd.id");
                long standardItemId = collObj.getLong("standarditem.id");
                String matchGradeRankRel = collObj.getString("salargrel");
                Map rankMap = (Map)useRankMap.get(salaryStdId);
                if (!Strings.isNullOrEmpty((String)matchGradeRankRel) && !ObjectUtils.isEmpty((Object)rankMap)) {
                    Boolean isUseRank = (Boolean)rankMap.get(standardItemId);
                    AmountStdRangeEntity amountStdRangeEntity = GradeAndRankNameHelper.convertMatchGradeRankRelToAmountStdRange((String)matchGradeRankRel, (Boolean)isUseRank, (GradeAndRankNameEntity)gradeAndRankNameEntity);
                    String amountStdRangeName = GradeAndRankNameHelper.formatGradeAndRankRangeName((String)JSON.toJSONString((Object)amountStdRangeEntity), (GradeAndRankNameEntity)gradeAndRankNameEntity);
                    map.put("beforeRevision", amountStdRangeName);
                }
            } else if (AdjAttributionType.ADJATTRTYPE.getCode().equals(attributionType) && !Strings.isNullOrEmpty((String)(amountStdRange2 = collObj.getString("amountstdrange")))) {
                String amountStdRangeName = GradeAndRankNameHelper.formatGradeAndRankRangeName((String)amountStdRange2, (GradeAndRankNameEntity)amountStdRangeGradeAndRankNameEntity);
                map.put("beforeRevision", amountStdRangeName);
            }
            String attributionTypeAfter = collObj.getString("entryentity.salaryadjrsnafter.attributiontype");
            String calcTypeAfter = collObj.getString("entryentity.calctypeafter");
            if (AdjAttributionType.DECATTRTYPE.getCode().equals(attributionTypeAfter) || CalcType.GRADE_RANK.getCode().equals(calcTypeAfter) && AdjAttributionType.ADJATTRTYPE.getCode().equals(attributionTypeAfter)) {
                long salaryStdId = collObj.getLong("entryentity.salarystdafter.id");
                long standardItemId = collObj.getLong("entryentity.standarditemafter.id");
                String matchGradeRankRel = collObj.getString("entryentity.salargrelafter");
                Map rankMap = (Map)useRankAfterMap.get(salaryStdId);
                if (!Strings.isNullOrEmpty((String)matchGradeRankRel) && !ObjectUtils.isEmpty((Object)rankMap)) {
                    Boolean isUseRank = (Boolean)rankMap.get(standardItemId);
                    AmountStdRangeEntity amountStdRangeEntity = GradeAndRankNameHelper.convertMatchGradeRankRelToAmountStdRange((String)matchGradeRankRel, (Boolean)isUseRank, (GradeAndRankNameEntity)gradeAndRankNameEntity);
                    String amountStdRangeName = GradeAndRankNameHelper.formatGradeAndRankRangeName((String)JSON.toJSONString((Object)amountStdRangeEntity), (GradeAndRankNameEntity)gradeAndRankNameEntityAfter);
                    map.put("afterRevision", amountStdRangeName);
                }
            } else if (AdjAttributionType.ADJATTRTYPE.getCode().equals(attributionTypeAfter) && !Strings.isNullOrEmpty((String)(amountStdRange = collObj.getString("entryentity.amountstdrangeafter")))) {
                String amountStdRangeName = GradeAndRankNameHelper.formatGradeAndRankRangeName((String)amountStdRange, (GradeAndRankNameEntity)amountStdRangeGradeAndRankNameEntityAfter);
                map.put("afterRevision", amountStdRangeName);
            }
            revisionRecordIdToGradeRankNameMap.put(revisionRecordId, map);
        }
        return revisionRecordIdToGradeRankNameMap;
    }

    private static DynamicObject[] getRevisionRecord(DynamicObjectCollection pageData) {
        ArrayList recordIdList = Lists.newArrayListWithExpectedSize((int)10);
        pageData.forEach(data -> recordIdList.add(data.getLong("id")));
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_revisionrecord");
        return helper.queryOriginalArray("id, salargrel, calctype, amountstdrange, salarystd.id, salaryadjrsn.attributiontype,standarditem.id,entryentity.salargrelafter,entryentity.amountstdrangeafter, entryentity.calctypeafter, entryentity.salarystdafter.id,entryentity.salaryadjrsnafter.attributiontype,entryentity.standarditemafter.id", new QFilter[]{new QFilter("id", "in", (Object)recordIdList)});
    }

    private List<Object> getAdjFileNums(List<Long> adjFileIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        QFilter filter = new QFilter("id", "in", adjFileIdList);
        DynamicObjectCollection resultsColl = helper.queryOriginalCollection("number", new QFilter[]{filter});
        ArrayList<Object> results = new ArrayList<Object>(10);
        if (resultsColl == null || resultsColl.size() == 0) {
            return results;
        }
        for (DynamicObject dynamicObject : resultsColl) {
            results.add(dynamicObject.getString("number"));
        }
        return results;
    }
}

