/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.downloadtemplate;

import java.time.LocalDate;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.DownloadTemplatePlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public abstract class AbstractDownloadTemplatePlugin
extends DownloadTemplatePlugin {
    private static Log log = LogFactory.getLog(AbstractDownloadTemplatePlugin.class);
    private static final String BTN_OK = "btnok";
    private static final String BTN_NEWTEMPLATE = "newtemplate";

    public void initialize() {
        super.initialize();
        IFormView view = this.getView();
        FormViewPluginProxy service = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        List plugIns = service.getPlugIns();
        Iterator iterator = plugIns.iterator();
        while (iterator.hasNext()) {
            IFormPlugin plugIn = (IFormPlugin)iterator.next();
            if (plugIn.getPluginName().indexOf("bos") < 0) continue;
            iterator.remove();
        }
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.pushTempalte();
                break;
            }
            case "newtemplate": {
                BillList list = (BillList)this.getControl("billlistap");
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(list.getEntityId());
                parameter.setCustomParam("bindEntityId", this.getView().getFormShowParameter().getCustomParam("BillFormId"));
                parameter.setStatus(OperationStatus.ADDNEW);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_NEWTEMPLATE));
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
        }
    }

    private void pushTempalte() {
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam("BillFormId");
        String importPlugin = (String)this.getView().getFormShowParameter().getCustomParam("ImportPlugin");
        String extendData = (String)this.getView().getFormShowParameter().getCustomParam("ExtendData");
        BillList billList = (BillList)this.getView().getControl("billlistap");
        Object[] templates = billList.getSelectedRows().getPrimaryKeyValues();
        if (templates == null || templates.length == 0) {
            templates = new Object[]{0L};
        }
        if (!StringUtils.isBlank((CharSequence)billFormId)) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billFormId);
            LocalDate now = LocalDate.now();
            for (Object template : templates) {
                String fileName = this.buildFileName(mainEntityType, template, now);
                String url = this.export(template.toString(), this.getView().getFormShowParameter().getServiceAppId(), billFormId, StringUtils.isBlank((CharSequence)importPlugin) ? "" : importPlugin, extendData, fileName);
                log.info("export template ,url is : {}", (Object)url);
                this.getView().download(UrlService.getAttachmentFullUrl((String)url));
                this.getView().sendFormAction(this.getView());
            }
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b", (String)"AbstractDownloadTemplatePlugin_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
        }
    }

    private String buildFileName(MainEntityType mainEntityType, Object template, LocalDate now) {
        DynamicObject templateData = null;
        if ((Long)template > 0L) {
            templateData = BusinessDataServiceHelper.loadSingle((Object)template, (String)"bos_importtemplate");
        }
        String fileName = ResManager.loadKDString((String)"\u6a21\u677f\u6570\u636e", (String)"AbstractDownloadTemplatePlugin_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]).concat("_");
        fileName = templateData != null ? fileName + templateData.getString("name") : fileName + mainEntityType.getDisplayName();
        fileName = fileName.replaceAll(" ", "_");
        return fileName + "_" + String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
    }

    public abstract String export(String var1, String var2, String var3, String var4, String var5, String var6);

    public void addXSSFComment(SXSSFCell cell, String title, String value) {
        value = SWCStringUtils.isNotEmpty((String)value) ? value.replaceAll("\\\\r\\\\n", "\r\n") : value;
        Comment comments = cell.getCellComment();
        XSSFRichTextString xssfRichTextString = new XSSFRichTextString();
        if (SWCStringUtils.isNotEmpty((String)title)) {
            XSSFFont font = new XSSFFont();
            font.setBold(true);
            xssfRichTextString.append(title, font);
        }
        xssfRichTextString.append(value);
        comments.setString((RichTextString)xssfRichTextString);
        cell.setCellComment(comments);
    }
}

