/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.imports;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.newhismodel.impt.HisBatchImportPlugin;
import kd.swc.hcdm.business.imports.DefaultImportDataLogger;
import kd.swc.hcdm.business.imports.IImportDataLogger;
import kd.swc.hcdm.business.imports.ImportDataLoggerHelper;
import kd.swc.hcdm.common.entity.adjfile.ImportRowEntity;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractBatchImportBasePlugin
extends HisBatchImportPlugin {
    private static final String KEYFIELDS = "KeyFields";
    private static final String IMPORTTYPE = "importtype";
    protected static final String OP_FORMSAVE = "save";
    protected static final String OP_SAVEAFTERAUDIT = "saveafteraudit";
    private static final String IMPORT_TYPE_OVERRIDE_NEW = "overridenew";

    public abstract Map<String, String> getKeyFieldMap();

    public IImportDataLogger getImportDataLogger() {
        return new DefaultImportDataLogger();
    }

    public String getKeyProperty() {
        return "number";
    }

    public abstract String validateBasedataMustCol(JSONObject var1);

    public boolean verifyKeyFields(DynamicObject entityDyobj, int rowIndex, String keyFields, ImportLogger logger) {
        Map<String, String> keyFieldMap = this.getKeyFieldMap();
        Set<String> keyFieldSet = keyFieldMap.keySet();
        if (keyFields == null) {
            String errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractBatchImportBasePlugin_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            this.getImportDataLogger().logger(entityDyobj, rowIndex, errorMsg, logger);
            return true;
        }
        StringBuilder errorMsg = new StringBuilder();
        HashSet<String> selKeyFieldSet = new HashSet<String>();
        String[] selKeyFields = keyFields.split(",");
        for (String selKeyField : selKeyFields) {
            if (!StringUtils.isNotBlank((CharSequence)selKeyField)) continue;
            selKeyFieldSet.add(selKeyField);
        }
        for (String keyField : keyFieldSet) {
            if (selKeyFieldSet.contains(keyField)) continue;
            for (Map.Entry<String, String> map : keyFieldMap.entrySet()) {
                errorMsg.append(map.getValue());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg.toString())) {
            this.getImportDataLogger().logger(entityDyobj, rowIndex, errorMsg.toString(), logger);
        }
        return false;
    }

    public List<ImportRowEntity> verifyAddOrUpdateImport(List<ImportRowEntity> rowInfos, MainEntityType mainEntityType, ImportLogger logger) {
        String importType = (String)this.ctx.getOption().get(IMPORTTYPE);
        String keyFields = (String)this.ctx.getOption().get(KEYFIELDS);
        switch (importType) {
            case "overridenew": {
                return this.verifyUpdateNewAddImport(rowInfos, mainEntityType, logger, keyFields);
            }
        }
        return rowInfos;
    }

    private List<ImportRowEntity> verifyUpdateNewAddImport(List<ImportRowEntity> rowInfos, MainEntityType mainEntityType, ImportLogger logger, String keyFields) {
        String entityId = mainEntityType.getName();
        ArrayList<Object> numbers = new ArrayList<Object>(rowInfos.size());
        for (ImportRowEntity rowInfo : rowInfos) {
            DynamicObject entityDyobj = rowInfo.getEntityDyobj(entityId);
            if (this.verifyKeyFields(entityDyobj, rowInfo.getRowIndex(), keyFields, logger) || !this.validateStatus(logger, rowInfo, entityDyobj)) continue;
            if ("hcdm_adjfileinfo".equals(entityId)) {
                JSONObject jsonObject = rowInfo.getData();
                String optype = (String)jsonObject.get((Object)"optype");
                DynamicObject dynamicObject = (DynamicObject)jsonObject.get((Object)"dynamicObject");
                rowInfo.setOperation(optype);
                if (null != dynamicObject && SWCStringUtils.equals((String)OP_SAVEAFTERAUDIT, (String)optype)) {
                    entityDyobj.set("boid", dynamicObject.get("boid"));
                    entityDyobj.set("status", (Object)dynamicObject.getString("status"));
                }
                if (null == dynamicObject || !SWCStringUtils.equals((String)OP_FORMSAVE, (String)optype)) continue;
                HashSet<String> keySet = new HashSet<String>(3);
                keySet.add("id");
                keySet.add("status");
                keySet.add("sourcevid");
                SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)entityDyobj, (DynamicObject)dynamicObject, keySet, null);
                rowInfo.putEntityDyobj(entityId, dynamicObject);
                continue;
            }
            Object fileNumber = entityDyobj.get(this.getKeyProperty());
            if (fileNumber == null) continue;
            numbers.add(fileNumber);
        }
        rowInfos = ImportDataLoggerHelper.filterImportableData((MainEntityType)mainEntityType, rowInfos, (ImportLogger)logger);
        if ("hcdm_adjfileinfo".equals(entityId)) {
            return rowInfos;
        }
        Map<String, DynamicObject> adjfileDyMap = this.queryDynamicObjectByNumber(numbers, "number", "hcdm_adjfileinfo");
        Map<String, DynamicObject> decideSalDyMap = this.queryDynamicObjectByNumber(numbers, this.getKeyProperty(), entityId);
        for (ImportRowEntity rowInfo : rowInfos) {
            DynamicObject entityDyobj = rowInfo.getEntityDyobj(entityId);
            String keyValue = entityDyobj.getString(this.getKeyProperty());
            DynamicObject dbAdjfileDy = adjfileDyMap.get(keyValue);
            DynamicObject dbDecideSaldy = decideSalDyMap.get(keyValue);
            String adjfileStatus = dbAdjfileDy.getString("status");
            if (SWCStringUtils.equals((String)adjfileStatus, (String)"A")) {
                if (null != dbDecideSaldy) {
                    HashSet<String> keySet = new HashSet<String>(3);
                    keySet.add("id");
                    keySet.add("status");
                    keySet.add("sourcevid");
                    SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)entityDyobj, (DynamicObject)dbDecideSaldy, keySet, null);
                    rowInfo.putEntityDyobj(entityId, dbDecideSaldy);
                    rowInfo.putStoreMap("status", (Object)"A");
                }
                rowInfo.setOperation(OP_FORMSAVE);
                continue;
            }
            if (!SWCStringUtils.equals((String)adjfileStatus, (String)"C")) continue;
            if (dbDecideSaldy == null) {
                rowInfo.setOperation(OP_FORMSAVE);
                rowInfo.putStoreMap("status", (Object)"C");
                continue;
            }
            entityDyobj.set("boid", dbDecideSaldy.get("boid"));
            entityDyobj.set("status", (Object)adjfileStatus);
            rowInfo.setOperation(OP_SAVEAFTERAUDIT);
        }
        return ImportDataLoggerHelper.filterImportableData((MainEntityType)mainEntityType, (List)rowInfos, (ImportLogger)logger);
    }

    public abstract boolean validateStatus(ImportLogger var1, ImportRowEntity var2, DynamicObject var3);

    private Map<String, DynamicObject> queryDynamicObjectByNumber(List<Object> numbers, String number, String entityId) {
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(16);
        if (numbers.size() == 0) {
            return result;
        }
        String selectProperties = SWCHisBaseDataHelper.getSelectProperties((String)entityId);
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityId);
        QFilter filter = new QFilter(number, "in", numbers);
        DynamicObject[] dys = helper.query(selectProperties, new QFilter[]{filter});
        if (dys != null) {
            for (DynamicObject dynamicObj : dys) {
                result.put(dynamicObj.getString(number), dynamicObj);
            }
        }
        return result;
    }

    protected Map<String, DynamicObject> queryAdjFileByNumber(Set<String> adjFileNumbers, List<QFilter> permissionFilter) {
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
        if (CollectionUtils.isNotEmpty(permissionFilter)) {
            permissionFilter.stream().forEach(perFilter -> filter.and(perFilter));
        }
        DynamicObject[] persons = this.queryBatch("hcdm_adjfileinfo", "id,number,person,employee,stdscm,status", "number", adjFileNumbers, filter);
        return Arrays.stream(persons).collect(Collectors.toMap(obj -> obj.getString("number"), Function.identity()));
    }

    protected DynamicObject[] queryBatch(String entryId, String selectProperties, String fieldName, Set<String> values, QFilter filter) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entryId);
        QFilter qFilter = new QFilter(fieldName, "in", values);
        if (filter != null) {
            qFilter.and(filter);
        }
        QFilter[] qFilters = new QFilter[]{qFilter};
        return helper.query(selectProperties, qFilters);
    }

    protected void log(int rowIndex, String errorMsg, ImportLogger logger) {
        Map logCache = logger.getLogCache();
        if (logCache.get(rowIndex) != null) {
            ((List)logCache.get(rowIndex)).add(new ImportLogger.ImportLog(errorMsg));
            logger.setLogCache(logCache);
        } else {
            logger.log(Integer.valueOf(rowIndex), errorMsg);
        }
    }

    public static String combineStrings(String ... fields) {
        StringJoiner sj = new StringJoiner("_");
        for (String field : fields) {
            sj.add(field);
        }
        return sj.toString();
    }

    protected ImportLogger dealLogger(List<ImportBillData> rowdatas, ImportLogger logger) {
        Map logCache = logger.getLogCache();
        for (Map.Entry paramList : logCache.entrySet()) {
            ((List)paramList.getValue()).stream().forEach(param -> {
                if (param.msg.contains(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"AdjFileBatchImportPlugin_22", (String)"swc-hcdm-formplugin", (Object[])new Object[0]))) {
                    param.msg = param.msg.replace(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"AdjFileBatchImportPlugin_22", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), "");
                }
                if (param.msg.contains(ResManager.loadKDString((String)";\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"AdjFileBatchImportPlugin_17", (String)"swc-hcdm-formplugin", (Object[])new Object[0]))) {
                    param.msg = param.msg.replace(ResManager.loadKDString((String)";\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"AdjFileBatchImportPlugin_17", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), "");
                }
                if (param.msg.contains(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AdjFileBatchImportPlugin_21", (String)"swc-hcdm-formplugin", (Object[])new Object[0]))) {
                    param.msg = param.msg.replace(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AdjFileBatchImportPlugin_21", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), "");
                }
                if (param.msg.contains(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5b9a\u8c03\u85aa\u6863\u6848\u201c\u65b0\u589e\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdjFileBatchImportPlugin_24", (String)"swc-hcdm-formplugin", (Object[])new Object[0]))) {
                    param.msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5b9a\u8c03\u85aa\u6863\u6848\u201c\u65b0\u589e\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdjFileBatchImportPlugin_24", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                }
            });
        }
        for (ImportBillData rowData : rowdatas) {
            int endIndex = rowData.getEndIndex();
            int startIndex = rowData.getStartIndex();
            logger.signTotalRow(endIndex - startIndex + 1);
        }
        return logger;
    }
}

