/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.imports;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.dto.ImportPermissionParam;
import kd.bos.form.plugin.ImportStartPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.swc.hcdm.business.imports.CommonExcelWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ImportStartCommonPlugin
extends ImportStartPlugin {
    private static Log log = LogFactory.getLog(ImportStartCommonPlugin.class);

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndownload", "btnresetfile"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
    }

    public void afterBindData(EventObject eventObject) {
        FormShowParameter currShowParameter = this.getView().getFormShowParameter();
        JSONArray visibleFields = (JSONArray)currShowParameter.getCustomParam("VisibleField");
        if (visibleFields == null) {
            return;
        }
        for (Object visibleField : visibleFields) {
            this.getView().setVisible(Boolean.FALSE, new String[]{visibleField.toString()});
        }
    }

    public void click(EventObject evt) {
        FormShowParameter currShowParameter = this.getView().getFormShowParameter();
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                OperationResult result = new OperationResult();
                String orgIdsStr = (String)currShowParameter.getCustomParam("MainOrgIds");
                if (this.isFail(currShowParameter, orgIdsStr, result)) {
                    this.doFailCheckRight(result);
                    return;
                }
                this.importFileData();
                break;
            }
            case "btndownload": {
                this.download(currShowParameter);
                break;
            }
            case "btnresetfile": {
                this.getModel().setValue("filename", (Object)"");
                this.getModel().setValue("filepath", (Object)"");
                this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
                break;
            }
        }
    }

    private void download(FormShowParameter currShowParameter) {
        String billFormId = (String)currShowParameter.getCustomParam("BillFormId");
        if (StringUtils.isBlank((CharSequence)billFormId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b", (String)"ImportStartCommonPlugin_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showDownloadTemplateForm(currShowParameter);
    }

    private void showDownloadTemplateForm(FormShowParameter currShowParameter) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_downloadtemplate");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("BillFormId", currShowParameter.getCustomParam("BillFormId"));
        showParameter.setCustomParam("BillTypeId", currShowParameter.getCustomParam("BillTypeId"));
        showParameter.setCustomParam("ImportPlugin", (Object)this.getImportDataPlugin(currShowParameter));
        showParameter.setCustomParam("TemplateType", (Object)"IMPT");
        showParameter.addCustPlugin((String)currShowParameter.getCustomParam("CustPlugin"));
        this.getView().showForm(showParameter);
    }

    private boolean isFail(FormShowParameter currShowParameter, String orgIdsStr, OperationResult result) {
        String bizAppId = (String)currShowParameter.getCustomParam("CheckRightAppId");
        List mainOrgIds = StringUtils.isNotBlank((CharSequence)orgIdsStr) ? JSONObject.parseArray((String)orgIdsStr, Long.class) : new ArrayList(0);
        String realPermissionEntityId = (String)currShowParameter.getCustomParam("RealPermissionEntityId");
        String entityId = (String)currShowParameter.getCustomParam("BillFormId");
        String operateName = currShowParameter.getCustomParam("OperateName") == null ? ResManager.loadKDString((String)"\u5bfc\u5165", (String)"ImportStartCommonPlugin_7", (String)"swc-hcdm-formplugin", (Object[])new Object[0]) : (String)currShowParameter.getCustomParam("OperateName");
        String permissionItemId = (String)currShowParameter.getCustomParam("PermissionItemId");
        ImportPermissionParam permissionParam = new ImportPermissionParam.Buidler().setBizAppId(bizAppId).setMainOrgIds(mainOrgIds).setRealEntityId(realPermissionEntityId).setCurrentEntityId(entityId).setOperateName(operateName).setPermissionItemId(permissionItemId).setResult(result).build();
        return !this.validatePermission(permissionParam);
    }

    private void importFileData() {
        String url = (String)this.getModel().getValue("filepath");
        if (StringUtils.isBlank((CharSequence)url)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u4e0a\u4f20\u7684\u6587\u4ef6\u540e\u518d\u8fdb\u884c\u5bfc\u5165", (String)"ImportStartCommonPlugin_6", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!"new".equals(this.getModel().getValue("importtype")) && StringUtils.isBlank((CharSequence)((CharSequence)this.getModel().getValue("keyfields")))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c\u3002", (String)"ImportStartCommonPlugin_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            return;
        }
        log.info("oldUrl : {}", (Object)UrlService.getAttachmentFullUrl((String)url));
        url = this.deleteSheet(url);
        String result = UrlService.getAttachmentFullUrl((String)url);
        log.info("newUrl : {}", (Object)result);
        this.importFileData(url);
    }

    private void importFileData(String url) {
        IFormView view = this.getView();
        FormShowParameter showParam = view.getFormShowParameter();
        String billFormId = (String)showParam.getCustomParam("BillFormId");
        String listName = (String)showParam.getCustomParam("ListName");
        String serviceAppId = view.getFormShowParameter().getServiceAppId();
        String checkRightAppId = (String)showParam.getCustomParam("CheckRightAppId");
        Operations ops = EntityMetadataCache.getDataEntityOperations((String)FormMetadataCache.getFormConfig((String)billFormId).getEntityTypeId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_importing");
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String importType = (String)this.getModel().getValue("importtype");
        params.put("Type", importType);
        if (!"new".equals(importType)) {
            params.put("KeyFields", this.getModel().getValue("keyfields"));
            if ("override".equals(importType)) {
                params.put("ForUpdateMultiLangFields", view.getPageCache().get("ForUpdateMultiLangFields"));
            }
            params.put("OverrideEntry", view.getPageCache().get("OverrideEntry"));
        }
        params.put("ServiceAppId", serviceAppId);
        params.put("CheckRightAppId", checkRightAppId);
        params.put("BillFormId", billFormId);
        params.put("ListName", listName);
        params.put("OpSave", ops.getSave());
        params.put("Url", url);
        params.put("imgZipUrl", (String)this.getModel().getValue("filepathimgzip"));
        params.put("attZipUrl", (String)this.getModel().getValue("filepathattzip"));
        params.put("ImportPlugin", this.getImportDataPlugin(showParam));
        params.put("OperateKey", showParam.getCustomParam("OperateKey"));
        showParameter.setCustomParams(params);
        showParameter.setParentPageId(view.getFormShowParameter().getParentPageId());
        showParameter.setCloseCallBack(view.getFormShowParameter().getCloseCallBack());
        showParameter.setCustomParam("PermissionItemId", showParam.getCustomParam("PermissionItemId"));
        showParameter.setCustomParam("RealPermissionEntityId", showParam.getCustomParam("RealPermissionEntityId"));
        view.showForm(showParameter);
    }

    private String getImportDataPlugin(FormShowParameter showParam) {
        List plugins;
        String pluginName = (String)showParam.getCustomParam("ImportPlugin");
        if (StringUtils.isBlank((CharSequence)pluginName) && (plugins = (List)showParam.getCustomParam("plugins")) != null) {
            for (Map map : plugins) {
                if (!Boolean.TRUE.equals(map.get("Enabled"))) continue;
                return (String)map.get("ClassName");
            }
        }
        return pluginName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String deleteSheet(String sourceUrl) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        InputStream in = service.getInputStream(sourceUrl);
        File tempFile = null;
        String url = "";
        XSSFWorkbook xssfWorkbook = null;
        FileInputStream fis = null;
        try {
            tempFile = File.createTempFile(UUID.randomUUID().toString(), "xlsx");
            FileUtils.copyInputStreamToFile((InputStream)in, (File)tempFile);
            fis = new FileInputStream(tempFile);
            xssfWorkbook = new XSSFWorkbook((InputStream)fis);
            Iterator sheetIterator = xssfWorkbook.sheetIterator();
            ArrayList sheetList = Lists.newArrayList((Iterator)sheetIterator);
            if (sheetList.size() > 2) {
                for (int i = 2; i < sheetList.size(); ++i) {
                    Sheet sheet = (Sheet)sheetList.get(i);
                    xssfWorkbook.removeSheetAt(xssfWorkbook.getSheetIndex(sheet));
                }
            }
            this.fileWrite(tempFile, xssfWorkbook);
            SXSSFWorkbook wb = new SXSSFWorkbook(xssfWorkbook);
            CommonExcelWriter excelWriter = new CommonExcelWriter(wb);
            String fileName = sourceUrl.substring(sourceUrl.lastIndexOf(47) + 1, sourceUrl.lastIndexOf(46));
            url = excelWriter.flush(this.getView().getModel().getDataEntityType(), fileName);
            fis.close();
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        finally {
            if (tempFile != null && tempFile.exists() && !tempFile.delete()) {
                log.info("delete failed");
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.info(e.getMessage());
                }
            }
            if (xssfWorkbook != null) {
                try {
                    xssfWorkbook.close();
                }
                catch (IOException e) {
                    log.info(e.getMessage());
                }
            }
        }
        return url;
    }

    public void fileWrite(File targetFile, XSSFWorkbook wb) throws Exception {
        try (FileOutputStream fileOut = new FileOutputStream(targetFile);){
            wb.write((OutputStream)fileOut);
            fileOut.flush();
        }
    }
}

