/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.swc.hcdm.business.adjapprbill.GradeAndRankNameHelper;
import kd.swc.hcdm.business.report.AdjDetailRptHelper;
import kd.swc.hcdm.business.salaryadjfile.AdjFileCertCommonHelper;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hcdm.common.entity.adjapprbill.AmountStdRangeEntity;
import kd.swc.hcdm.common.entity.adjapprbill.GradeAndRankNameEntity;
import kd.swc.hcdm.formplugin.report.AdjRptFormPlugin;
import kd.swc.hcdm.formplugin.report.control.AdjDetailRptList;
import kd.swc.hsbp.business.report.RptShowNodeHelper;
import kd.swc.hsbp.business.report.RptShowNodeVo;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class AdjDetailFormRpt
extends AdjRptFormPlugin {
    private static final Log logger = LogFactory.getLog(AdjDetailFormRpt.class);
    private static final String PAGE_QUERY = "hcdm_adjrecordrptqentity";
    private static final DBRoute ROUETE_HCDM = new DBRoute("hcdm");
    private static final String ALGO_KEY = "QueryServiceHelper.";
    private static final String FORM_ID = "hcdm_adjdetailreport";

    public boolean verifyQuery(ReportQueryParam queryParam) {
        if (!AdjFileCertCommonHelper.verifyCertCount((IFormView)this.getView())) {
            return false;
        }
        boolean originalVerify = this.originalVerify(queryParam);
        if (!originalVerify) {
            return false;
        }
        SWCPageCache pageCache = new SWCPageCache((IFormView)this.getView());
        String isExporting = (String)pageCache.get("isExporting", String.class);
        if (SWCStringUtils.equals((String)isExporting, (String)"1")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u5bfc\u51fa\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"AdjDetailFormRpt_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        switch (args.getKey()) {
            case "reportlistap": {
                AdjDetailRptList report = this.buildCustomerReport();
                args.setControl((Control)report);
                break;
            }
        }
    }

    @Override
    public void initialize() {
        this.getView().addCustomControls(new String[]{"reportlistap"});
        EntityMetadataCache.removeDataEntityTypeLocalCache((String)FORM_ID);
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.setEntityNumber(PAGE_QUERY);
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.setHasSettingRow(false);
        this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)PAGE_QUERY);
        this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
        this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)"hcdm_decadjrelperson.adminorg");
    }

    @Override
    protected void formatFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        List rptShowNodeVos = RptShowNodeHelper.getMoreFilterNodes((String)FORM_ID);
        List fieldColumns = filterGrid.getFilterColumns();
        Map<Object, Object> moreFilterMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!SWCListUtils.isEmpty((List)rptShowNodeVos)) {
            moreFilterMap = rptShowNodeVos.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getQueryField())).collect(Collectors.toMap(RptShowNodeVo::getQueryField, val -> StringUtils.isEmpty((CharSequence)val.getMoreFilterName()) ? val.getName() : val.getMoreFilterName()));
        }
        Iterator iterator = fieldColumns.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            String fieldName = (String)map.get("fieldName");
            if (!moreFilterMap.containsKey(fieldName)) {
                iterator.remove();
                continue;
            }
            map.put("fieldCaption", moreFilterMap.get(fieldName));
        }
        DynamicObject[] dynamicObjects = RptShowNodeHelper.queryRptShowNodeDyns((String)FORM_ID);
        List<String> orderResult = Arrays.stream(dynamicObjects).filter(rptShowNode -> rptShowNode.getBoolean("ismorefilter")).sorted(Comparator.comparingInt(rptShowNode -> rptShowNode.getInt("morefilterindex"))).map(rptShowNode -> rptShowNode.getString("queryfield")).collect(Collectors.toList());
        AdjDetailFormRpt.sort(orderResult, fieldColumns);
    }

    public static void sort(List<String> sortList, List<Map<String, Object>> targetList) {
        targetList.sort((o1, o2) -> {
            int io1 = sortList.indexOf(o1.get("fieldName"));
            int io2 = sortList.indexOf(o2.get("fieldName"));
            if (io1 != -1) {
                io1 = targetList.size() - io1;
            }
            if (io2 != -1) {
                io2 = targetList.size() - io2;
            }
            return io2 - io1;
        });
    }

    @Override
    protected FormShowParameter getScmFormShowParameter() {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("hcdm_detaildisplay");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObject schemeObj = (DynamicObject)this.getModel().getValue("displayscheme");
        if (!Objects.isNull(schemeObj)) {
            showParameter.setPkId((Object)schemeObj.getLong("id"));
        }
        return showParameter;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowDatas, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowDatas, queryParam);
        Map<Object, Object> itemUseRankFlagMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap schoolTypeMap = Maps.newHashMapWithExpectedSize((int)16);
        GradeAndRankNameEntity gradeAndRankNameEntity = new GradeAndRankNameEntity();
        GradeAndRankNameEntity decGradeAndRankNameEntity = new GradeAndRankNameEntity();
        if (!SWCListUtils.isEmpty((List)rowDatas) && rowDatas.get(0) != null) {
            long start;
            DynamicObject rowData = (DynamicObject)rowDatas.get(0);
            if (rowData.containsProperty("hcdm_decadjrelperson.schooltype.name")) {
                start = System.currentTimeMillis();
                this.schoolType(schoolTypeMap);
                logger.info("processRowData::{}", (Object)schoolTypeMap);
                long cost = System.currentTimeMillis() - start;
                logger.info("AdjDetailFormRpt schooltype cost:{}", (Object)cost);
            }
            if (rowData.containsProperty("amountstdrange")) {
                start = System.currentTimeMillis();
                List amountStdRangeList = rowDatas.stream().filter(object -> SWCStringUtils.isNotEmpty((String)object.getString("amountstdrange"))).map(row -> row.getString("amountstdrange")).collect(Collectors.toList());
                logger.info("processRowData amountStdRangeList:{}", amountStdRangeList);
                gradeAndRankNameEntity = GradeAndRankNameHelper.getGradeAndRankNameFromAmountStdRange(amountStdRangeList);
                List salargrelList = rowDatas.stream().filter(object -> SWCStringUtils.isNotEmpty((String)object.getString("salargrel"))).map(row -> row.getString("salargrel")).collect(Collectors.toList());
                logger.info("processRowData salargrelList:{}", salargrelList);
                decGradeAndRankNameEntity = GradeAndRankNameHelper.getGradeAndRankNameFromMatchGradeRankRel(salargrelList);
                itemUseRankFlagMap = this.itemUseRankFlag(rowDatas);
                long cost = System.currentTimeMillis() - start;
                logger.info("AdjDetailFormRpt amountstdrange cost:{}", (Object)cost);
            }
        }
        logger.info("processRowData itemUseRankFlagMap:{}", (Object)JSONObject.toJSONString((Object)itemUseRankFlagMap));
        long start = System.currentTimeMillis();
        for (DynamicObject row2 : rowDatas) {
            if (row2.containsProperty("hcdm_decadjrelperson.schooltype.name")) {
                this.schooltypeToRow(row2, schoolTypeMap);
            }
            if (!row2.containsProperty("amountstdrange")) continue;
            this.reGradeAndRankName(row2, gradeAndRankNameEntity, decGradeAndRankNameEntity, itemUseRankFlagMap);
        }
        long cost = System.currentTimeMillis() - start;
        logger.info("AdjDetailFormRpt amountstdrange  cost :{}", (Object)cost);
    }

    private boolean rankToRow(DynamicObject row, Map<Long, Map<Long, Boolean>> itemUseRankFlagMap) {
        Long salaryStdId = row.getLong("salarystd.id");
        Long standardItemId = row.getLong("standarditem.id");
        Map<Long, Boolean> itemUseRankMap = itemUseRankFlagMap.get(salaryStdId);
        if (!SWCObjectUtils.isEmpty(itemUseRankMap) && !SWCObjectUtils.isEmpty((Object)itemUseRankMap.get(standardItemId))) {
            return itemUseRankMap.get(standardItemId);
        }
        return false;
    }

    private void reGradeAndRankName(DynamicObject row, GradeAndRankNameEntity gradeAndRankNameEntity, GradeAndRankNameEntity decGradeAndRankNameEntity, Map<Long, Map<Long, Boolean>> itemUseRankFlagMap) {
        String amountstdrange = row.getString("amountstdrange");
        String salargrel = row.getString("salargrel");
        String salaryadjrsnType = row.getString("salaryadjrsn.attributiontype");
        logger.info("processRowData salargrel\uff1a{}", (Object)salargrel);
        logger.info("processRowData amountstdrange\uff1a{}", (Object)amountstdrange);
        logger.info("processRowData salaryadjrsnType\uff1a{}", (Object)salaryadjrsnType);
        try {
            if (AdjAttributionType.DECATTRTYPE.getCode().equals(salaryadjrsnType)) {
                logger.info("processRowData DECATTRTYPE");
                AmountStdRangeEntity amountStdRangeEntity = GradeAndRankNameHelper.convertMatchGradeRankRelToAmountStdRange((String)salargrel, (Boolean)this.rankToRow(row, itemUseRankFlagMap), (GradeAndRankNameEntity)decGradeAndRankNameEntity);
                String amountStdRangeName = GradeAndRankNameHelper.formatGradeAndRankRangeName((String)JSON.toJSONString((Object)amountStdRangeEntity), (GradeAndRankNameEntity)decGradeAndRankNameEntity);
                row.set("amountstdrange", (Object)amountStdRangeName);
            } else if (AdjAttributionType.ADJATTRTYPE.getCode().equals(salaryadjrsnType)) {
                logger.info("processRowData ADJATTRTYPE");
                String amountStdRangeName = GradeAndRankNameHelper.formatGradeAndRankRangeName((String)amountstdrange, (GradeAndRankNameEntity)gradeAndRankNameEntity);
                row.set("amountstdrange", (Object)amountStdRangeName);
            }
        }
        catch (Exception exc) {
            logger.error("AdjDetailFormRpt error", (Throwable)exc);
        }
    }

    private void schooltypeToRow(DynamicObject row, Map<Long, List<String>> schoolTypeMap) {
        String name;
        List<String> names = schoolTypeMap.get(row.getLong("relpersonid"));
        if (!SWCListUtils.isEmpty(names) && SWCStringUtils.isNotEmpty((String)(name = StringUtils.join(names, (String)",")))) {
            row.set("hcdm_decadjrelperson.schooltype.name", (Object)name);
        }
        if (row.containsProperty("hcdm_decadjrelperson.schooltype.name") && SWCStringUtils.equals((String)"[]", (String)row.getString("hcdm_decadjrelperson.schooltype.name"))) {
            row.set("hcdm_decadjrelperson.schooltype.name", (Object)" ");
        }
    }

    private Map<Long, Map<Long, Boolean>> itemUseRankFlag(DynamicObjectCollection rowDatas) {
        HashMap stdItemMap = Maps.newHashMapWithExpectedSize((int)16);
        SalaryStdApplicationService service = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
        for (DynamicObject rowdy : rowDatas) {
            Long salaryStdId = rowdy.getLong("salarystd.id");
            Long standardItemId = rowdy.getLong("standarditem.id");
            List standardItemIds = (List)stdItemMap.get(salaryStdId);
            if (SWCListUtils.isEmpty((List)standardItemIds)) {
                stdItemMap.put(salaryStdId, Lists.newArrayList((Object[])new Long[]{standardItemId}));
                continue;
            }
            standardItemIds.add(standardItemId);
        }
        return service.getSalaryItemUseRankFlag((Map)stdItemMap);
    }

    private void schoolType(Map<Long, List<String>> schoolTypeMap) {
        String sql = "SELECT schooltype.fid as id, schooltype.fbasedataid as fbasedataid FROM t_hcdm_salschooltype schooltype";
        String[] strs = new String[]{"id", "fbasedataid"};
        try (DataSet rows = SWCDbUtil.queryDataSet((String)ALGO_KEY, (DBRoute)ROUETE_HCDM, (String)sql, (Object[])new Object[0]);){
            String queryEmployeeSQL = "SELECT t.fid as id,t.fnumber as number,t.fname as name FROM t_hbss_schooltype t where t.fenable ='1' and t.fstatus = 'C'";
            String[] personStr = new String[]{"number", "name"};
            try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryEmployeeSQL", (DBRoute)DBRoute.of((String)"hmp"), (String)queryEmployeeSQL, (Object[])new Object[0]);){
                try (DataSet joinDataSet = rows.leftJoin(dateSet).on("fbasedataid", "id").select(strs, personStr).finish();){
                    while (joinDataSet.hasNext()) {
                        List<Object> names;
                        Row row = joinDataSet.next();
                        long id = row.getLong("id");
                        if (SWCStringUtils.isEmpty((String)row.getString("name"))) continue;
                        if (SWCObjectUtils.isEmpty(schoolTypeMap.get(id))) {
                            names = Lists.newArrayListWithExpectedSize((int)10);
                            names.add(row.getString("name"));
                            schoolTypeMap.put(id, names);
                            continue;
                        }
                        names = schoolTypeMap.get(id);
                        names.add(row.getString("name"));
                    }
                }
                catch (Exception e) {
                    logger.error("AdjDetailFormRpt joinDataSet error", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error("AdjDetailFormRpt dateSet error", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("AdjDetailFormRpt rows error", (Throwable)e);
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        ReportView view = (ReportView)this.getView();
        Map customParam = queryParam.getCustomParam();
        customParam.put("pageid", view.getPageId());
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        if (packageDataEvent.getSource() instanceof ReportColumn) {
            Object field;
            ReportColumn reportColumn = (ReportColumn)packageDataEvent.getSource();
            String fieldKey = reportColumn.getFieldKey();
            if (Sets.newHashSet((Object[])new String[]{"salarypercent", "salaryseeprate"}).contains(fieldKey) && reportColumn.getFieldProperty() instanceof DecimalProp) {
                DecimalProp decimalProp = (DecimalProp)reportColumn.getFieldProperty();
                AdjDetailRptHelper.updateDecimalProp((DecimalProp)decimalProp);
                field = packageDataEvent.getRowData().get(fieldKey);
                if (!SWCObjectUtils.isEmpty((Object)field)) {
                    NumberFormat num = NumberFormat.getPercentInstance();
                    num.setMinimumFractionDigits(2);
                    packageDataEvent.setFormatValue((Object)num.format(field));
                } else {
                    packageDataEvent.setFormatValue(null);
                }
            }
            if (Sets.newHashSet((Object[])new String[]{"suggestminrange", "suggestmaxrange", "actualrange"}).contains(fieldKey) && reportColumn.getFieldProperty() instanceof DecimalProp) {
                DecimalProp decimal = (DecimalProp)reportColumn.getFieldProperty();
                AdjDetailRptHelper.updateDecimalProp((DecimalProp)decimal);
                StringBuilder format = new StringBuilder("#0.00");
                DecimalFormat myFormat = new DecimalFormat(format.toString());
                Object field2 = packageDataEvent.getRowData().get(fieldKey);
                if (field2 != null) {
                    String value = myFormat.format(field2);
                    packageDataEvent.setFormatValue((Object)value);
                } else {
                    packageDataEvent.setFormatValue(null);
                }
            }
            if (Sets.newHashSet((Object[])new String[]{"amount", "suggestminamount", "suggestmaxamount", "actualamount"}).contains(fieldKey) && reportColumn.getFieldProperty() instanceof AmountProp) {
                AmountProp amountProp = (AmountProp)reportColumn.getFieldProperty();
                amountProp.setDefaultValue(null);
                amountProp.setEnableNull(true);
                amountProp.setZeroShow(true);
                field = packageDataEvent.getRowData().get(fieldKey);
                if (SWCObjectUtils.isEmpty((Object)field)) {
                    packageDataEvent.setFormatValue(null);
                }
            }
        }
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        String displaySchemeName = this.getModel().getDataEntity().getString("displayscheme.name");
        String formatedFilterString = evt.getFormatedFilterString();
        if (SWCStringUtils.isEmpty((String)displaySchemeName)) {
            displaySchemeName = " ";
        }
        String msg = ResManager.loadKDString((String)"\u663e\u793a\u65b9\u6848\uff1a{0}\uff1b{1}", (String)"AdjDetailFormRpt_1", (String)"swc-hcdm-formplugin", (Object[])new Object[]{displaySchemeName, formatedFilterString});
        evt.setFormatedFilterString(msg);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        Boolean updateFlag = SWCPermissionServiceHelper.checkCancelDataAndFunctionRight((IFormView)this.getView(), (boolean)true);
        if (updateFlag.booleanValue()) {
            args.setCancel(true);
            logger.info("kd.swc.hcdm.formplugin.report.AdjDetailFormRpt.beforeDoOperation1");
            return;
        }
        Boolean updateListFlag = SWCPermissionServiceHelper.checkCancelDataAndFunctionRight((IFormView)this.getControl("reportlistap").getView(), (boolean)true);
        if (updateListFlag.booleanValue()) {
            args.setCancel(true);
            logger.info("kd.swc.hcdm.formplugin.report.AdjDetailFormRpt.beforeDoOperation2");
            return;
        }
        if ("exportexcel".equals(key)) {
            SWCPageCache pageCache = new SWCPageCache((IFormView)this.getView());
            String isExporting = (String)pageCache.get("isExporting", String.class);
            if (SWCStringUtils.equals((String)isExporting, (String)"1")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u5bfc\u51fa\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"AdjDetailFormRpt_5", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            long userId = RequestContext.get().getCurrUserId();
            boolean superUser = SWCPermissionServiceHelper.isSuperUser();
            boolean hasPermByPermItemNum = SWCPermissionServiceHelper.hasPermByPermItemNum((long)userId, (String)"0VO5EV13=I9W", (String)FORM_ID, (String)"QXX0021");
            if (superUser || hasPermByPermItemNum) {
                args.setCancel(false);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5b9a\u8c03\u85aa\u660e\u7ec6\u8868\u201d\u7684\u201c\u5bfc\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdjDetailFormRpt_6", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }
}

