/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.report;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.events.ReportExportInitializeEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.report.plugin.ReportViewPluginProxy;
import kd.swc.hcdm.business.report.AdjDetailReportDisplayHelper;
import kd.swc.hcdm.business.validator.ValidatorAdapter;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.business.validator.bean.ValidatorTree;
import kd.swc.hcdm.common.entity.report.AdjFileReportEntity;
import kd.swc.hcdm.formplugin.report.control.AdjDetailRptList;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;

public abstract class AdjRptFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
BeforeFilterF7SelectListener {
    private static final Log logger = LogFactory.getLog(AdjRptFormPlugin.class);
    protected static final String CALL_BACK_SHEME = "close_call_back_actionid_sheme";
    protected static final String entityNumber = "hcdm_adjrecordrptqentity";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"reportlistap"});
    }

    public void exportInitialize(ReportExportInitializeEvent event) {
        super.exportInitialize(event);
    }

    public void preProcessExportData(List<AbstractReportColumn> exportColumns, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider) {
        super.preProcessExportData(exportColumns, data, numberFormatProvider);
    }

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{"lbl_display", "imgdisplay"});
        this.setF7SelectListener();
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void afterBindData(EventObject eventObject) {
        this.formatFilterGrid();
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
    }

    protected AdjDetailRptList buildCustomerReport() {
        AdjDetailRptList reportList = new AdjDetailRptList();
        reportList.setShowSeq(true);
        reportList.setView((IFormView)this.getView());
        reportList.setKey("reportlistap");
        FormRoot rootControl = (FormRoot)this.getView().getRootControl();
        List items = rootControl.getItems();
        for (Control item : items) {
            if (!"reportlistap".equals(item.getKey())) continue;
            ReportList oldReport = (ReportList)item;
            reportList.setHasSettingRow(false);
            reportList.setReportPluginClassName(oldReport.getReportPluginClassName());
            reportList.setClientRules(oldReport.getClientRules());
            if (reportList == null) break;
            ReportViewPluginProxy service = (ReportViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            reportList.addPackageDataListener(arg_0 -> ((ReportViewPluginProxy)service).firePackageData(arg_0));
            break;
        }
        return reportList;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        DynamicObjectCollection orgCollection = this.getModel().getDataEntity().getDynamicObjectCollection("org");
        ArrayList orgIdList = Lists.newArrayListWithExpectedSize((int)10);
        if (!SWCListUtils.isEmpty((List)orgCollection)) {
            List orgList = orgCollection.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            orgIdList.addAll(orgList);
        }
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        String name = event.getProperty().getName();
        boolean superUser = SWCPermissionServiceHelper.isSuperUser();
        String appId = "0VO5EV13=I9W";
        String permItemId = "47150e89000000ac";
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"28", (String)appId, (String)entityNumber, (String)permItemId);
        ListFilterParameter parameter = formShowParameter.getListFilterParameter();
        switch (name) {
            case "displayscheme": {
                QFilter filter = new QFilter("sharescheme", "=", (Object)Boolean.TRUE);
                filter.or(new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()));
                parameter.getQFilters().add(filter);
                parameter.setOrderBy("modifytime desc");
                break;
            }
            case "empgroup": {
                Set empgrpSet;
                List empgoupIds = (List)SWCMServiceUtils.invokeHRMPService((String)"hbss", (String)"IHBSSService", (String)"getEmpgroupByAppNumber", (Object[])new Object[]{"hcdm"});
                QFilter qFilter = new QFilter("id", "in", (Object)empgoupIds);
                parameter.getQFilters().add(qFilter);
                if (superUser || (empgrpSet = SWCPermissionServiceHelper.getEmpgrpSetByPermItem((String)appId, (String)entityNumber, (String)permItemId)) == null) break;
                QFilter empFilter = new QFilter("id", "in", (Object)empgrpSet);
                parameter.getQFilters().add(empFilter);
                break;
            }
            case "salarystditem": {
                parameter.getQFilters().add(new QFilter("biztype", "like", (Object)"%1%"));
                if (null == permOrgs || permOrgs.hasAllOrgPerm()) break;
                ArrayList intersections = Lists.newArrayListWithExpectedSize((int)10);
                if (!SWCListUtils.isEmpty((List)orgIdList)) {
                    intersections.addAll(orgIdList.stream().filter(item -> permOrgs.getHasPermOrgs().contains(item)).collect(Collectors.toList()));
                } else {
                    intersections.addAll(permOrgs.getHasPermOrgs());
                }
                QFilter orgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_standarditem", (List)intersections, (boolean)true);
                if (orgFilter == null) break;
                parameter.getQFilters().add(orgFilter);
                break;
            }
            case "stdscm": {
                Set stdScmSetByPermItem;
                QFilter useOrgFilter = null;
                if (!permOrgs.hasAllOrgPerm()) {
                    List hasPermOrgList = permOrgs.getHasPermOrgs();
                    useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_stdscm", (List)hasPermOrgList, (boolean)true);
                }
                if (useOrgFilter != null) {
                    parameter.getQFilters().add(useOrgFilter);
                }
                if ((stdScmSetByPermItem = SWCPermissionServiceHelper.getStdScmSetByPermItem((String)appId, (String)entityNumber, (String)permItemId)) == null) break;
                QFilter stdScmQFilter = new QFilter("id", "in", (Object)stdScmSetByPermItem);
                parameter.getQFilters().add(stdScmQFilter);
                break;
            }
            case "org": {
                if (permOrgs.hasAllOrgPerm()) break;
                List hasPermOrgs = permOrgs.getHasPermOrgs();
                parameter.getQFilters().add(new QFilter("id", "in", (Object)hasPermOrgs));
                break;
            }
            case "department": {
                Set adminOrgSet;
                if (superUser || null == (adminOrgSet = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((String)appId, (String)entityNumber, (String)permItemId, (String)"hcdm_decadjrelperson.adminorg"))) break;
                parameter.getQFilters().add(new QFilter("id", "in", (Object)adminOrgSet));
                break;
            }
            case "salaystructure": {
                Set structSetByPermItem;
                QFilter useOrgFilter = null;
                if (!permOrgs.hasAllOrgPerm()) {
                    List hasPermOrgList = permOrgs.getHasPermOrgs();
                    useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_salaystructure", (List)hasPermOrgList, (boolean)true);
                }
                if (useOrgFilter != null) {
                    parameter.getQFilters().add(useOrgFilter);
                }
                if ((structSetByPermItem = SWCPermissionServiceHelper.getSalayStructureSetByPermItem((String)appId, (String)entityNumber, (String)permItemId)) == null) break;
                QFilter stdScmQFilter = new QFilter("id", "in", (Object)structSetByPermItem);
                parameter.getQFilters().add(stdScmQFilter);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent event) {
        if ("hcdm_adjfileinfo".equals(event.getRefEntityId())) {
            ArrayList<QFilter> qfilters = event.getQfilters();
            if (qfilters == null) {
                qfilters = new ArrayList<QFilter>(10);
            }
            qfilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
            event.setQfilters(qfilters);
        }
        if (SWCStringUtils.equals((String)"hcdm_salarygradeentrytodb", (String)event.getRefEntityId())) {
            this.dealDedupGradeRank(event, "hcdm_salarygradeentrytodb");
        }
        if (SWCStringUtils.equals((String)"hcdm_rankgradeentrytodb", (String)event.getRefEntityId())) {
            this.dealDedupGradeRank(event, "hcdm_rankgradeentrytodb");
        }
        String name = event.getFieldName();
        DynamicObjectCollection orgCollection = this.getModel().getDataEntity().getDynamicObjectCollection("org");
        ArrayList orgIdList = Lists.newArrayListWithExpectedSize((int)10);
        if (!SWCListUtils.isEmpty((List)orgCollection)) {
            List orgList = orgCollection.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            orgIdList.addAll(orgList);
        }
        boolean superUser = SWCPermissionServiceHelper.isSuperUser();
        String appId = "0VO5EV13=I9W";
        String permItemId = "47150e89000000ac";
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"28", (String)appId, (String)entityNumber, (String)permItemId);
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)10);
        switch (name) {
            case "hcdm_adjfileinfo.org.name": 
            case "hcdm_decadjrelperson.org.name": {
                if (permOrgs.hasAllOrgPerm()) break;
                List hasPermOrgs = permOrgs.getHasPermOrgs();
                qFilterList.add(new QFilter("id", "in", (Object)hasPermOrgs));
                event.setQfilters((List)qFilterList);
                break;
            }
            case "hcdm_adjfileinfo.empposorgrel.adminorg.name": 
            case "hcdm_decadjrelperson.adminorg.name": {
                Set adminOrgSet;
                if (superUser || null == (adminOrgSet = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((String)appId, (String)entityNumber, (String)permItemId, (String)"hcdm_decadjrelperson.adminorg"))) break;
                qFilterList.add(new QFilter("id", "in", (Object)adminOrgSet));
                break;
            }
            case "hcdm_adjfileinfo.empgroup.name": 
            case "hcdm_decadjrelperson.empgroup.name": {
                Set empgrpSet;
                List empgoupIds = (List)SWCMServiceUtils.invokeHRMPService((String)"hbss", (String)"IHBSSService", (String)"getEmpgroupByAppNumber", (Object[])new Object[]{"hcdm"});
                QFilter qFilter = new QFilter("id", "in", (Object)empgoupIds);
                qFilterList.add(qFilter);
                if (superUser || (empgrpSet = SWCPermissionServiceHelper.getEmpgrpSetByPermItem((String)appId, (String)entityNumber, (String)permItemId)) == null) break;
                QFilter empFilter = new QFilter("id", "in", (Object)empgrpSet);
                qFilterList.add(empFilter);
                break;
            }
            case "hcdm_decadjrelperson.stdscm.name": {
                Set stdScmSetByPermItem;
                QFilter useOrgFilter = null;
                if (null != permOrgs && !permOrgs.hasAllOrgPerm()) {
                    List hasPermOrgList = permOrgs.getHasPermOrgs();
                    useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_stdscm", (List)hasPermOrgList, (boolean)true);
                }
                if (useOrgFilter != null) {
                    qFilterList.add(useOrgFilter);
                }
                if ((stdScmSetByPermItem = SWCPermissionServiceHelper.getStdScmSetByPermItem((String)appId, (String)entityNumber, (String)permItemId)) == null) break;
                QFilter stdScmQFilter = new QFilter("id", "in", (Object)stdScmSetByPermItem);
                qFilterList.add(stdScmQFilter);
                break;
            }
            case "hcdm_decadjrelperson.salaystructure.name": {
                Set structSetByPermItem;
                QFilter useOrgFilter = null;
                if (null != permOrgs && !permOrgs.hasAllOrgPerm()) {
                    List hasPermOrgList = permOrgs.getHasPermOrgs();
                    useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_salaystructure", (List)hasPermOrgList, (boolean)true);
                }
                if (useOrgFilter != null) {
                    qFilterList.add(useOrgFilter);
                }
                if (null == (structSetByPermItem = SWCPermissionServiceHelper.getSalayStructureSetByPermItem((String)appId, (String)entityNumber, (String)permItemId))) break;
                QFilter stdScmQFilter = new QFilter("id", "in", (Object)structSetByPermItem);
                qFilterList.add(stdScmQFilter);
                break;
            }
            case "standarditem.name": {
                Set countrySet;
                qFilterList.add(new QFilter("biztype", "like", (Object)"%1%"));
                if (null != permOrgs && !permOrgs.hasAllOrgPerm()) {
                    ArrayList intersections = Lists.newArrayListWithExpectedSize((int)10);
                    if (!SWCListUtils.isEmpty((List)orgIdList)) {
                        intersections.addAll(orgIdList.stream().filter(item -> permOrgs.getHasPermOrgs().contains(item)).collect(Collectors.toList()));
                    } else {
                        intersections.addAll(permOrgs.getHasPermOrgs());
                    }
                    QFilter standardItemFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_standarditem", (List)intersections, (boolean)true);
                    if (null != standardItemFilter) {
                        qFilterList.add(standardItemFilter);
                    }
                }
                if (null == (countrySet = SWCPermissionServiceHelper.getCountrySetByPermItem((String)"0VO5EV13=I9W", (String)entityNumber, (String)"47150e89000000ac"))) break;
                QFilter filter = new QFilter("country", "in", (Object)countrySet);
                filter.or(new QFilter("areatype", "=", (Object)"1"));
                qFilterList.add(filter);
                break;
            }
            case "salaryadjrsn.name": {
                QFilter salaryAdjustRsnQFilter;
                if (null == permOrgs || permOrgs.hasAllOrgPerm() || null == (salaryAdjustRsnQFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salaryadjustrsn", (List)permOrgs.getHasPermOrgs(), (boolean)true))) break;
                qFilterList.add(salaryAdjustRsnQFilter);
                break;
            }
            case "hcdm_decadjrelperson.country.name": {
                Set countrySet = SWCPermissionServiceHelper.getCountrySetByPermItem((String)"0VO5EV13=I9W", (String)entityNumber, (String)"47150e89000000ac");
                if (null == countrySet) break;
                QFilter filter = new QFilter("id", "in", (Object)countrySet);
                qFilterList.add(filter);
                break;
            }
            case "frequency.name": {
                Set countrySet = SWCPermissionServiceHelper.getCountrySetByPermItem((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"47150e89000000ac");
                if (null == countrySet) break;
                qFilterList.add(new QFilter("country", "in", (Object)countrySet));
                break;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)qFilterList)) {
            event.getQfilters().addAll(qFilterList);
        }
    }

    private void dealDedupGradeRank(BeforeFilterF7SelectEvent event, String entityId) {
        ArrayList<QFilter> qfilters = event.getQfilters();
        if (qfilters == null) {
            qfilters = new ArrayList<QFilter>(10);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityId);
        DynamicObject[] rows = helper.query("id, name", new QFilter[0]);
        HashMap<String, Long> dataMap = new HashMap<String, Long>(16);
        for (DynamicObject row : rows) {
            dataMap.putIfAbsent(row.getString("name"), row.getLong("id"));
        }
        qfilters.add(new QFilter("id", "in", dataMap.values()));
        event.setQfilters(qfilters);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (CALL_BACK_SHEME.equals(actionId)) {
            this.doUpdateScheme();
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "lbl_display": 
            case "imgdisplay": {
                this.openScmForm();
                break;
            }
        }
    }

    private void openScmForm() {
        FormShowParameter param = this.getScmFormShowParameter();
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_SHEME));
        this.getView().showForm(param);
    }

    protected abstract FormShowParameter getScmFormShowParameter();

    private void doUpdateScheme() {
        DynamicObject displayScheme = (DynamicObject)this.getModel().getValue("displayscheme");
        this.getModel().setValue("displayscheme", null);
        if (displayScheme != null) {
            this.getModel().setValue("displayscheme", (Object)displayScheme.getLong("id"));
        }
    }

    protected void formatFilterGrid() {
    }

    protected boolean originalVerify(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        String org = filterInfo.getString("org");
        String scheme = filterInfo.getString("displayscheme");
        String startDate = filterInfo.getString("date_startdate");
        String endDate = filterInfo.getString("date_enddate");
        String salayStructure = filterInfo.getString("salaystructure");
        AdjFileReportEntity data = new AdjFileReportEntity(scheme, org, startDate, endDate, salayStructure);
        ValidateContext validateContext = new ValidateContext((Object)data);
        ValidatorTree validatorTree = AdjDetailReportDisplayHelper.getAdjFileRptQueryValidatorTree((ValidateContext)validateContext);
        ValidatorAdapter adpter = ValidatorAdapter.build((ValidateContext)validateContext, (ValidatorTree)validatorTree);
        adpter.validate();
        List results = validateContext.getResults();
        for (ValidateResult result : results) {
            if (result.isSuccess()) continue;
            this.showErrorMsg(result);
            return false;
        }
        return true;
    }

    protected void showErrorMsg(ValidateResult result) {
        ErrorLevel level = result.getLevel();
        List errorList = result.getErrorList();
        switch (level) {
            case FatalError: {
                errorList.forEach(str -> this.getView().showErrorNotification(str));
                break;
            }
            case Error: 
            case Warning: {
                errorList.forEach(str -> this.getView().showTipNotification(str));
                break;
            }
            case Info: {
                errorList.forEach(str -> this.getView().showMessage(str));
                break;
            }
        }
    }

    private void setF7SelectListener() {
        BasedataEdit structure;
        BasedataEdit department;
        BasedataEdit item;
        BasedataEdit displayScheme;
        BasedataEdit person;
        BasedataEdit stdScm;
        BasedataEdit company;
        BasedataEdit empGroup;
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((empGroup = (BasedataEdit)this.getControl("empgroup")) != null) {
            empGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((company = (BasedataEdit)this.getControl("company")) != null) {
            company.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((stdScm = (BasedataEdit)this.getControl("stdscm")) != null) {
            stdScm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((person = (BasedataEdit)this.getControl("person")) != null) {
            person.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((displayScheme = (BasedataEdit)this.getControl("displayscheme")) != null) {
            displayScheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((item = (BasedataEdit)this.getControl("salarystditem")) != null) {
            item.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((department = (BasedataEdit)this.getControl("department")) != null) {
            department.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((structure = (BasedataEdit)this.getControl("salaystructure")) != null) {
            structure.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }
}

