/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.salarystandard;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.swc.hcdm.business.salarystandard.ContrastDataHelper;
import kd.swc.hcdm.business.salarystandard.ContrastRelationSettingGridHelper;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hcdm.business.salarystandard.SalaryStandardPageInteractionHelper;
import kd.swc.hcdm.business.salarystandard.constraint.DeleteResult;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.formplugin.salarystandard.SalaryStandardBaseEdit;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public abstract class AbstractSalaryStandardEdit
extends SalaryStandardBaseEdit
implements TabSelectListener {
    protected static final String VARIABLEVALUE__ISTOPAGE = "isToPage";
    protected static final Map<Integer, String> pageMap;
    protected static final String OPTION_IGNORE_VALIDATE = "ignoreValidate";
    protected static final String OPTION_CURRENCY_PAGE = "nowCurrencyPage";
    protected static final String SALARYCOUNTAMOUNT = "salarycountamount";
    protected static final String[] typeRelationEntryIds;
    protected static final String[] typeRelationFieldIds;

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        int page = this.getKeyByValue(pageMap, tabKey);
        this.initCurrencyPage(page);
        this.resetCurrentPageButton(page);
        this.getModel().setValue("curpage", (Object)new BigDecimal(String.valueOf(page)));
    }

    public void propertyChanged(PropertyChangedArgs evt) {
    }

    public void resetCurrentPageButton(int page) {
        if (page <= 0) {
            Tab tab = (Tab)this.getView().getControl("tabap");
            String currentTab = tab.getCurrentTab();
            page = this.getKeyByValue(pageMap, currentTab);
        }
        if (this.getIndex() == page) {
            this.getView().setVisible(Boolean.valueOf(page != 1), new String[]{"lastpage"});
            this.getView().setVisible(Boolean.valueOf(page != pageMap.size()), new String[]{"nextpage"});
            this.getView().setVisible(Boolean.valueOf(page != pageMap.size()), new String[]{"baritemap"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "donothing_nextpage": {
                this.beforeToNextPage(args);
                break;
            }
            case "donothing_lastpage": {
                this.beforeToLastPage(args);
                break;
            }
            case "save": {
                this.beforeSave(args);
                break;
            }
            case "submit": {
                this.beforeSubmit(args);
                break;
            }
        }
    }

    private void beforeSave(BeforeDoOperationEventArgs args) {
        if (this.isCurrentPage(args)) {
            this.doBeforeSave(args);
        }
        SalaryStandardPageInteractionHelper.setGradeRankSeqMap((AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), (String)"salarygrade", (boolean)true);
        SalaryStandardPageInteractionHelper.setGradeRankSeqMap((AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), (String)"salaryrank", (boolean)true);
    }

    private void beforeSubmit(BeforeDoOperationEventArgs args) {
        if (this.isCurrentPage(args)) {
            this.doBeforeSave(args);
        }
    }

    protected void doBeforeSave(BeforeDoOperationEventArgs args) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "donothing_lastpage": {
                this.toLastPage(args);
                this.refreshBarVisible(args);
                break;
            }
            case "donothing_nextpage": {
                this.toNextPage(args);
                this.refreshBarVisible(args);
                break;
            }
            case "submit": 
            case "audit": {
                this.getModel().setDataChanged(false);
                if (!this.isCurrentPage(args) || !args.getOperationResult().isSuccess()) break;
                this.doRefreshChildPage(args);
                break;
            }
            case "confirmchange": {
                if (!this.isCurrentPage(args) || !args.getOperationResult().isSuccess()) break;
                this.setPageStatus(OperationStatus.VIEW);
                this.doRefreshChildPage(args);
                this.resetCurrentPageButton(0);
                break;
            }
            case "unsubmit": {
                if (!this.isCurrentPage(args) || !args.getOperationResult().isSuccess()) break;
                this.setPageStatus(OperationStatus.ADDNEW);
                this.doRefreshChildPage(args);
                break;
            }
        }
    }

    private void setPageStatus(OperationStatus status) {
        this.getView().setStatus(status);
    }

    protected void doRefreshChildPage(AfterDoOperationEventArgs args) {
    }

    private void refreshBarVisible(AfterDoOperationEventArgs args) {
        String entityId = this.getView().getEntityId();
        if (!entityId.contains("his")) {
            String status = (String)this.getModel().getValue("status");
            OperationResult operationResult = args.getOperationResult();
            if (operationResult != null && operationResult.isSuccess() && SWCStringUtils.equals((String)status, (String)"A")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable", "bar_enable"});
            }
        }
    }

    private void toNextPage(AfterDoOperationEventArgs args) {
        if (this.isCurrentPage(args)) {
            this.getView().getPageCache().remove("skipValidateVersionChange");
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        this.toPage(Integer.parseInt(option.getVariableValue(OPTION_CURRENCY_PAGE)) + 1);
    }

    private void toLastPage(AfterDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        this.toPage(Integer.parseInt(option.getVariableValue(OPTION_CURRENCY_PAGE)) - 1);
    }

    private void toPage(int page) {
        int minPage = 1;
        int maxPage = pageMap.size();
        if (page <= maxPage && page >= minPage) {
            this.setTab(page);
        }
    }

    private void beforeToNextPage(BeforeDoOperationEventArgs args) {
        boolean isSave = false;
        BigDecimal curPage = (BigDecimal)this.getModel().getValue("curpage");
        if (this.getIndex() == curPage.intValue()) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(VARIABLEVALUE__ISTOPAGE, Boolean.TRUE.toString());
            this.setCurPageToOption(operateOption);
            String status = (String)this.getModel().getValue("status");
            String tempPageStatusView = (String)this.getView().getFormShowParameter().getCustomParam("tempPageStatusView");
            if (null != tempPageStatusView && SWCStringUtils.equals((String)tempPageStatusView, (String)"1")) {
                isSave = true;
            } else if (SWCStringUtils.equals((String)status, (String)"A") && this.getModel().getDataChanged()) {
                this.getView().getPageCache().put("skipValidateVersionChange", "1");
                OperationResult result = this.getView().invokeOperation("save", operateOption);
                isSave = result.isSuccess();
            } else {
                isSave = true;
            }
        } else {
            return;
        }
        if (isSave) {
            FormOperate formOperate = (FormOperate)args.getSource();
            OperateOption option = formOperate.getOption();
            this.setCurPageToOption(option);
            String status = (String)this.getModel().getValue("status");
            if (!option.tryGetVariableValue(OPTION_IGNORE_VALIDATE, new RefObject()) && SWCStringUtils.equals((String)status, (String)"A")) {
                this.veriDataIntegrityBeforeDoOperation(args);
            }
        } else {
            args.setCancel(true);
        }
    }

    private void beforeToLastPage(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        this.setCurPageToOption(option);
    }

    private void setCurPageToOption(OperateOption option) {
        if (!option.tryGetVariableValue(OPTION_CURRENCY_PAGE, new RefObject())) {
            BigDecimal curPage = (BigDecimal)this.getModel().getValue("curpage");
            option.setVariableValue(OPTION_CURRENCY_PAGE, String.valueOf(curPage.intValue()));
        }
    }

    private void veriDataIntegrityBeforeDoOperation(BeforeDoOperationEventArgs args) {
        if (this.isCurrentPage(args) && !args.isCancel()) {
            this.veriDataIntegrityInCurrentPage(args);
        }
    }

    private boolean isCurrentPage(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        Map variables = option.getVariables();
        String curPageStr = (String)variables.get(OPTION_CURRENCY_PAGE);
        BigDecimal curPage = null;
        curPage = SWCStringUtils.isEmpty((String)curPageStr) ? (BigDecimal)this.getModel().getValue("curpage") : new BigDecimal(curPageStr);
        return this.getIndex() == curPage.intValue();
    }

    private boolean isCurrentPage(AfterDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        Map variables = option.getVariables();
        String curPageStr = (String)variables.get(OPTION_CURRENCY_PAGE);
        BigDecimal curPage = null;
        curPage = SWCStringUtils.isEmpty((String)curPageStr) ? (BigDecimal)this.getModel().getValue("curpage") : new BigDecimal(curPageStr);
        return this.getIndex() == curPage.intValue();
    }

    private void initCurrencyPage(int toPage) {
        if (this.getIndex() == toPage) {
            this.initPage();
        }
    }

    protected abstract void initPage();

    protected abstract void veriDataIntegrityInCurrentPage(BeforeDoOperationEventArgs var1);

    protected abstract int getIndex();

    protected void setTab(int toPage) {
        Integer index = this.getIndex();
        if (index != null && index.equals(toPage)) {
            String tabKey = pageMap.get(toPage);
            Tab tab = (Tab)this.getControl("tabap");
            if (SWCStringUtils.isNotEmpty((String)tabKey)) {
                tab.activeTab(tabKey);
                this.setFlexPanelTop("conentpanel");
                this.getModel().setValue("curpage", (Object)new BigDecimal(String.valueOf(toPage)));
            }
        }
    }

    private void setFlexPanelTop(String flexPanel) {
        HashMap<String, Boolean> metaMap = new HashMap<String, Boolean>(16);
        metaMap.put("scrollTop", Boolean.TRUE);
        this.getView().updateControlMetadata(flexPanel, metaMap);
        this.getView().executeClientCommand("panelScrollTop", new Object[]{flexPanel});
    }

    protected List<Long> getReturnDataIds(ListSelectedRowCollection rows) {
        ArrayList<Long> returnIds = new ArrayList<Long>(rows.size());
        for (ListSelectedRow row : rows) {
            returnIds.add((Long)row.getPrimaryKeyValue());
        }
        return returnIds;
    }

    protected void confirmIsContinue(ClosedCallBackEvent event) {
        Boolean isContinue;
        Object returnData = event.getReturnData();
        if (returnData instanceof Boolean && (isContinue = (Boolean)returnData).booleanValue()) {
            OperateOption op = OperateOption.create();
            op.setVariableValue(OPTION_IGNORE_VALIDATE, Boolean.TRUE.toString());
            this.getView().invokeOperation("donothing_nextpage", op);
        }
    }

    private int getKeyByValue(Map<Integer, String> map, Object val) {
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            if (!val.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return 1;
    }

    public void showErrorResults(List<ValidateResult> results, BeforeDoOperationEventArgs args) {
        ArrayList<String> allWorningMsg = new ArrayList<String>(10);
        ArrayList<String> errorMsg = new ArrayList<String>(10);
        boolean hasError = false;
        for (ValidateResult result : results) {
            if (result.isSuccess()) continue;
            hasError = true;
            ErrorLevel level = result.getLevel();
            if (ErrorLevel.FatalError.equals((Object)level) || ErrorLevel.Error.equals((Object)level)) {
                errorMsg.addAll(result.getErrorList());
            }
            if (!ErrorLevel.Warning.equals((Object)level)) continue;
            allWorningMsg.addAll(result.getErrorList());
        }
        if (hasError) {
            args.setCancel(true);
        }
        if (!errorMsg.isEmpty()) {
            this.showErrorForm(errorMsg, args);
            return;
        }
        if (!allWorningMsg.isEmpty()) {
            this.showWarningConfirmForm(allWorningMsg, args);
        }
    }

    private void showErrorForm(List<String> allErrorMsg, BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        if (!allErrorMsg.isEmpty()) {
            if (allErrorMsg.size() == 1) {
                this.getView().showTipNotification(allErrorMsg.get(0));
            } else {
                String tempMessage = ResManager.loadKDString((String)"\u201c{0}\u201d\u6709\u5185\u5bb9\u672a\u6309\u8981\u6c42\u586b\u5199\u3002", (String)"SalaryStandardCommonValidateEdit_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
                String message = MessageFormat.format(tempMessage, this.getModel().getValue("number"));
                FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)source.getOperateName().getLocaleValue(), (String)message, allErrorMsg);
                this.getView().showForm(parameters);
            }
        }
    }

    protected void showWarningConfirmForm(List<String> allWarningMsg, BeforeDoOperationEventArgs args) {
    }

    public void clearTypeRelationInfo() {
        this.getModel().beginInit();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        for (String entryId : typeRelationEntryIds) {
            dataEntity.getDynamicObjectCollection(entryId).clear();
            this.getView().updateView(entryId);
        }
        for (String fieldId : typeRelationFieldIds) {
            this.getModel().setValue(fieldId, null);
            this.getView().updateView(fieldId);
        }
        this.getModel().endInit();
    }

    public void doDeleteContrastData(DeleteResult deleteResult) {
        List delContrastRowDataEntities = deleteResult.getContrastData();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        SalaryStandardEntryData tabObj = EntityConverter.fetchEntityFromModelWithEntryName((DynamicObject)dataEntity, (String[])new String[]{"appliedrange", "contrastps", "contrastsumdata"});
        List contrastDataEntities = tabObj.getContrastRowEntities();
        ContrastDataHelper.afterDelContrastRowData((List)contrastDataEntities, (List)delContrastRowDataEntities);
        ContrastRelationSettingGridHelper.updateToParentEntry((List)contrastDataEntities, (IFormView)this.getView(), (boolean)false);
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    static {
        typeRelationEntryIds = new String[]{"salarystditem", "salarygrade", "salaryrank", "salarystddata_a", "contrastps", "contrastsumdata", "displayset"};
        typeRelationFieldIds = new String[]{"isusesalarycount", SALARYCOUNTAMOUNT, "isusesalaryrank"};
        pageMap = Maps.newHashMapWithExpectedSize((int)16);
        pageMap.put(1, "firstpage");
        pageMap.put(2, "secondpage");
        pageMap.put(3, "thirdpage");
        pageMap.put(4, "fourthpage");
    }
}

