/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.salarystandard;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.DisplayModeCheckBoxEntity;
import kd.sdk.swc.hcdm.common.stdtab.DisplayParamNew;
import kd.sdk.swc.hcdm.common.stdtab.PreviewStyleEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.swc.hcdm.business.SalaryStandardSerializationUtils;
import kd.swc.hcdm.business.salarystandard.ContrastGridQueryViewHelper;
import kd.swc.hcdm.business.salarystandard.ContrastGridViewHelper;
import kd.swc.hcdm.business.salarystandard.DisplayModePaintHelper;
import kd.swc.hcdm.business.salarystandard.DisplayParamHelper;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hcdm.business.salarystandard.FieldGenerator;
import kd.swc.hcdm.business.salarystandard.SalaryStandardCacheHelper;
import kd.swc.hcdm.business.salarystandard.StdTabValSetHelper;
import kd.swc.hcdm.business.salarystandard.grid.EntryParamContainerHelper;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hcdm.common.entity.salarystandard.ContrastDataQueryParam;
import kd.swc.hcdm.common.entity.salarystandard.DynamicCommonFieldIdGenerationParam;
import kd.swc.hcdm.common.entity.salarystandard.FieldEditGenerationParam;
import kd.swc.hcdm.common.entity.salarystandard.PreviewStyleEntity;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ContrastGridQueryView
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_QUERYPANEL = "querypanel";
    private static final String KEY_DISPLAY_ONLYSALARYCOUNT = "show_salary_count";
    private static final String KEY_FILTER_CONDITION_PANEL = "filter_condition_panel";
    private static final String FLEX_PANEL_AP_SHOW = "flexpanelap_show";
    private static final String FLEX_PANEL_AP_SHOW1 = "flexpanelap_show1";
    private static final String CACHEKEY_VIEWFLAG = "contrast_view_flag";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"vectorap", "vectorapclick", "previewap", "previewapclick", "vectorap2", "vectorapclick2"});
        this.addBeforeF7SelectListener();
        IFormView mainView = this.getView().getParentView();
        SWCPermissionServiceHelper.checkCancelDataAndFunctionRightWithException((IFormView)mainView, (boolean)true);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs evt) {
        super.loadCustomControlMetas(evt);
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)((FormShowParameter)evt.getSource()).getParentPageId());
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hcdm_salarystdgraph", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        FlexPanelAp panelAp = ContrastGridViewHelper.createQueryPanel((EntityMetadata)entityMetadata, (SalaryStandardEntryData)stdData);
        HashMap<String, String> mappanel = new HashMap<String, String>();
        mappanel.put("id", KEY_QUERYPANEL);
        mappanel.put("items", (String)panelAp.createControl().get("items"));
        evt.getItems().add(mappanel);
        DisplayModePaintHelper.toLoadCustomControlMetas((LoadCustomControlMetasArgs)evt, (String)FLEX_PANEL_AP_SHOW, (boolean)true, (SalaryStandardTypeEnum)stdData.getStdBaseEntity().getType());
        DisplayModePaintHelper.toLoadCustomControlMetas((LoadCustomControlMetasArgs)evt, (String)FLEX_PANEL_AP_SHOW1, (boolean)false, (SalaryStandardTypeEnum)stdData.getStdBaseEntity().getType(), (DisplayModeCheckBoxEntity)DisplayModePaintHelper.getSalaryCountBoxEntity((String)SalaryStandardConstants.ONLY_SALARYCOUNT()));
    }

    public void beforeBindData(EventObject evt) {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)parentPageId);
        int defaultCode = DisplayParamHelper.getDefaultCodeOfOnlyScByUseSc((int)stdData.getStdBaseEntity().getIsUseSalaryCount(), (SalaryStandardTypeEnum)this.getSalaryStandardType());
        this.getView().setVisible(Boolean.valueOf(DisplayParamHelper.checkVisibleByCode((int)defaultCode)), new String[]{KEY_DISPLAY_ONLYSALARYCOUNT});
        this.getModel().setValue(KEY_DISPLAY_ONLYSALARYCOUNT, (Object)DisplayParamHelper.getValueForBooleanAp((int)defaultCode));
        DisplayModePaintHelper.toBindData((IFormView)this.getView(), (String)FLEX_PANEL_AP_SHOW, (boolean)true, (SalaryStandardTypeEnum)stdData.getStdBaseEntity().getType());
        DisplayModePaintHelper.toBindData((IFormView)this.getView(), (String)FLEX_PANEL_AP_SHOW1, (boolean)false, (SalaryStandardTypeEnum)stdData.getStdBaseEntity().getType());
        DisplayModePaintHelper.trySetFromSecondOrFourthModel((IFormView)this.getView(), (DisplayParamNew)stdData.getDisplayParam(), (String)parentPageId, (SalaryStandardEntryData)stdData, (boolean)true);
        this.writeBackDisplayParamPropEntity(stdData.getDisplayParam(), stdData);
    }

    public void onGetControl(OnGetControlArgs evt) {
        super.onGetControl(evt);
        String key = evt.getKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        if (key.startsWith("dqpdf")) {
            FieldEdit mulBaseDataEdit = FieldGenerator.createMulBaseDataEdit((FieldEditGenerationParam)new FieldEditGenerationParam(key, "hcdm_contrastqueryview", this.getView()));
            evt.setControl((Control)mulBaseDataEdit);
        }
        if (key.startsWith("rank_") || key.startsWith("item_") || key.equals(KEY_DISPLAY_ONLYSALARYCOUNT)) {
            DisplayModePaintHelper.createCheckBoxControl((OnGetControlArgs)evt, (String)key, (IFormView)this.getView());
        }
    }

    public void createNewData(BizDataEventArgs evt) {
        DisplayModePaintHelper.toCreateNewData((BizDataEventArgs)evt, (IDataModel)this.getModel(), (SalaryStandardTypeEnum)this.getSalaryStandardType());
    }

    public void getEntityType(GetEntityTypeEventArgs evt) {
        MainEntityType oldMainType = evt.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new KDException((Throwable)e1, new ErrorCode("LoadCustomControlMetasSample", e1.getMessage()), new Object[0]);
        }
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)this.getView().getFormShowParameter().getParentPageId());
        if (stdData == null) {
            return;
        }
        ContrastGridViewHelper.registerPropertyQueryPanel((SalaryStandardEntryData)stdData, (EntityType)newMainType);
        DisplayModePaintHelper.registerDynamicProps((MainEntityType)newMainType, (boolean)true, (SalaryStandardTypeEnum)stdData.getStdBaseEntity().getType());
        DisplayModePaintHelper.registerDynamicProps((MainEntityType)newMainType, (boolean)false, (SalaryStandardTypeEnum)stdData.getStdBaseEntity().getType());
        evt.setNewEntityType(newMainType);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        String name = beforeF7SelectEvent.getProperty().getName();
        DynamicCommonFieldIdGenerationParam fieldIdGenerationParam = new DynamicCommonFieldIdGenerationParam();
        if (name.startsWith("dqpdf")) {
            SalaryStandardEntryData entryData = SalaryStandardCacheHelper.getEntryData((String)this.getView().getParentView().getPageId());
            List contrastDataEntities = entryData.getContrastRowEntities();
            fieldIdGenerationParam.parse(name);
            Long propId = Long.parseLong(fieldIdGenerationParam.getName());
            HashSet propValues = Sets.newHashSetWithExpectedSize((int)16);
            for (ContrastRowDataEntity row : contrastDataEntities) {
                List longs = (List)row.getStdPropValueMap().get(propId);
                if (!CollectionUtils.isNotEmpty((Collection)longs)) continue;
                propValues.addAll(longs);
            }
            qFilters.add(new QFilter("id", "in", (Object)propValues));
            Map previewQFilterWithExt = ContrastGridViewHelper.getPreviewQFilterWithExt(entryData.getContrastPropEntities().stream().map(ContrastPropEntity::getPropConfigEntity).collect(Collectors.toList()), (IFormView)this.getView().getParentView());
            List previewQFilters = (List)previewQFilterWithExt.get(propId);
            if (CollectionUtils.isNotEmpty((Collection)previewQFilters)) {
                qFilters.addAll(previewQFilters);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        IDataEntityProperty property = evt.getProperty();
        String name = property.getName();
        Map<Long, List<Long>> propDataMap = this.fetchAllQueryPropValue();
        ContrastDataQueryParam param = new ContrastDataQueryParam();
        param.setPropValues(propDataMap);
        String pagePattern = this.getPageCache().get(CACHEKEY_VIEWFLAG);
        if (name.startsWith("dqpdf")) {
            if (PreviewStyleEnum.PREVIEW.getValue().equals(pagePattern)) {
                this.openSalaryStdGraph(param);
            } else if (PreviewStyleEnum.LIST.getValue().equals(pagePattern)) {
                this.refreshContrastGrid(param, true, name, this.getBooleanValueToInt(evt.getChangeSet()[0].getNewValue()));
            } else if (PreviewStyleEnum.LISTSECOND.getValue().equals(pagePattern)) {
                this.refreshContrastGrid2(param, true, name, this.getBooleanValueToInt(evt.getChangeSet()[0].getNewValue()));
            }
            return;
        }
        if (name.startsWith("rank_") || name.startsWith("item_")) {
            this.refreshContrastGridByChangeDisplayMode(param, name, this.getBooleanValueToInt(evt.getChangeSet()[0].getNewValue()));
        }
        switch (name) {
            case "show_salary_count": {
                if (PreviewStyleEnum.LIST.getValue().equals(pagePattern)) {
                    this.refreshContrastGrid(param, true, name, this.getBooleanValueToInt(evt.getChangeSet()[0].getNewValue()));
                }
                if (!PreviewStyleEnum.LISTSECOND.getValue().equals(pagePattern)) break;
                this.refreshContrastGrid2(param, true, name, this.getBooleanValueToInt(evt.getChangeSet()[0].getNewValue()));
                break;
            }
        }
    }

    private int getBooleanValueToInt(Object newValue) {
        return DisplayParamHelper.displayParamBooleanValueToInt((Boolean)Boolean.valueOf(newValue.toString()));
    }

    private void refreshContrastGrid(ContrastDataQueryParam param, boolean isPropChange, String key, int value) {
        this.updateDisplayParam(isPropChange, key, value);
        this.openGridPage(param, "contrastgridflex", "hcdm_contrastgrid");
        this.getPageCache().put(CACHEKEY_VIEWFLAG, PreviewStyleEnum.LIST.getValue());
    }

    private void refreshContrastGrid2(ContrastDataQueryParam param, boolean isPropChange, String key, int value) {
        this.updateDisplayParam(isPropChange, key, value);
        this.openGridPage(param, "contrastgridflex", "hcdm_salstdcontrastview");
        this.getPageCache().put(CACHEKEY_VIEWFLAG, PreviewStyleEnum.LISTSECOND.getValue());
    }

    private void updateDisplayParam(boolean isPropChange, String key, int value) {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        SalaryStandardEntryData entryData = SalaryStandardCacheHelper.getEntryData((String)parentPageId);
        DisplayParamNew displayParam = entryData.getDisplayParam();
        if (isPropChange) {
            if (KEY_DISPLAY_ONLYSALARYCOUNT.equals(key)) {
                displayParam.setDisplayOnlySalaryCount(value);
            } else if (key.startsWith("item_")) {
                displayParam.setItemLevelValueById(Long.valueOf(key.substring(5)), value);
            } else if (key.startsWith("rank_")) {
                displayParam.setRankLevelValueById(Long.valueOf(key.substring(5)), value);
            }
            this.writeBackDisplayParamPropEntity(displayParam, entryData);
            SalaryStandardCacheHelper.putFourthPageId((String)parentPageId, (String)this.getView().getPageId());
        }
        this.paintDisplaySettingFlex(displayParam);
    }

    private void writeBackDisplayParamPropEntity(DisplayParamNew displayParam, SalaryStandardEntryData entryData) {
        String parentPageId = this.getView().getParentView().getPageId();
        if (displayParam != null) {
            TableValueSetter setter = StdTabValSetHelper.getDisplayParamTableValueSetter((DisplayParamNew)displayParam, (String)"temp");
            AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getParentView().getModel();
            model.deleteEntryData("displayset");
            model.batchCreateNewEntryRow("displayset", setter);
            model.setDataChanged(false);
            List displayParamPropEntities = EntityConverter.dynamicObjToDisplayParamPropEntity((DynamicObjectCollection)model.getEntityEntity("displayset"));
            SalaryStandardCacheHelper.putEntryData((String)parentPageId, (Object)entryData.buildDisplayParamProp(displayParamPropEntities));
        }
    }

    private void refreshContrastGridByChangeDisplayMode(ContrastDataQueryParam param, String fieldKey, int value) {
        this.updateDisplayParam(true, fieldKey, value);
        String pagePattern = this.getPageCache().get(CACHEKEY_VIEWFLAG);
        if (PreviewStyleEnum.LISTSECOND.getValue().equals(pagePattern)) {
            this.openGridPage(param, "contrastgridflex", "hcdm_salstdcontrastview");
        } else if (PreviewStyleEnum.LIST.getValue().equals(pagePattern)) {
            this.openGridPage(param, "contrastgridflex", "hcdm_contrastgrid");
        }
    }

    public Map<Long, List<Long>> fetchAllQueryPropValue() {
        HashMap<Long, List<Long>> propDataMap = new HashMap<Long, List<Long>>();
        DynamicCommonFieldIdGenerationParam fieldIdGenerationParam = new DynamicCommonFieldIdGenerationParam();
        for (IDataEntityProperty tempProperty : this.getModel().getDataEntityType().getProperties()) {
            if (!tempProperty.getName().startsWith("dqpdf")) continue;
            fieldIdGenerationParam.parse(tempProperty.getName());
            Long propId = Long.parseLong(fieldIdGenerationParam.getName());
            List pkIds = EntityConverter.getPkIdFromMulBaseData((DynamicObjectCollection)((DynamicObjectCollection)this.getModel().getValue(tempProperty.getName())));
            propDataMap.put(propId, pkIds);
        }
        return propDataMap;
    }

    private void openGridPage(ContrastDataQueryParam param, String targetKey, String formId) {
        FormShowParameter formShow = new FormShowParameter();
        OpenStyle openStyle = new OpenStyle();
        openStyle.setTargetKey(targetKey);
        openStyle.setShowType(ShowType.InContainer);
        formShow.setOpenStyle(openStyle);
        formShow.setFormId(formId);
        formShow.setCustomParam("contrastFilterParam", (Object)SalaryStandardSerializationUtils.toJsonString((Object)param));
        formShow.setCustomParam("main_page", (Object)this.getView().getParentView().getPageId());
        formShow.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
        this.getView().showForm(formShow);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        PreviewStyleEntity privewStyleWithExt = ContrastGridQueryViewHelper.initPrivewPage((IFormView)this.getView(), (String)"4");
        PreviewStyleEnum defaultPrivewStyle = privewStyleWithExt.getDefaultPrivewStyle();
        if (defaultPrivewStyle == PreviewStyleEnum.LIST) {
            this.refreshContrastGrid(null, false, "", 0);
        }
        if (defaultPrivewStyle == PreviewStyleEnum.LISTSECOND) {
            this.refreshContrastGrid2(null, false, "", 0);
        }
        if (defaultPrivewStyle == PreviewStyleEnum.PREVIEW) {
            this.openSalaryStdGraph(null);
        }
        this.setFilterConditionPanel();
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        Map<Long, List<Long>> propDataMap = this.fetchAllQueryPropValue();
        ContrastDataQueryParam param = new ContrastDataQueryParam();
        param.setPropValues(propDataMap);
        PreviewStyleEntity privewStyleWithExt = ContrastGridQueryViewHelper.getPreviewStyleWithExt((IFormView)this.getView(), (String)"4");
        Set hiddenFlexsSet = ContrastGridQueryViewHelper.getHiddenFlexs((PreviewStyleEntity)privewStyleWithExt);
        switch (key) {
            case "vectorap": {
                ContrastGridQueryViewHelper.setVisibleByHiddenExt((IFormView)this.getView(), (Set)hiddenFlexsSet, (PreviewStyleEnum)PreviewStyleEnum.LIST);
                this.refreshContrastGrid(param, false, "", 0);
                break;
            }
            case "previewap": {
                ContrastGridQueryViewHelper.setVisibleByHiddenExt((IFormView)this.getView(), (Set)hiddenFlexsSet, (PreviewStyleEnum)PreviewStyleEnum.PREVIEW);
                this.openSalaryStdGraph(param);
                break;
            }
            case "vectorap2": {
                ContrastGridQueryViewHelper.setVisibleByHiddenExt((IFormView)this.getView(), (Set)hiddenFlexsSet, (PreviewStyleEnum)PreviewStyleEnum.LISTSECOND);
                this.refreshContrastGrid2(param, false, "", 0);
                break;
            }
        }
    }

    private void openSalaryStdGraph(ContrastDataQueryParam param) {
        this.getPageCache().put(CACHEKEY_VIEWFLAG, PreviewStyleEnum.PREVIEW.getValue());
        FormShowParameter formShow = new FormShowParameter();
        OpenStyle openStyle = new OpenStyle();
        openStyle.setTargetKey("previewchartflex");
        openStyle.setShowType(ShowType.InContainer);
        formShow.setOpenStyle(openStyle);
        formShow.setFormId("hcdm_salarystdgraph");
        formShow.setCustomParam("contrastFilterParam", (Object)SalaryStandardSerializationUtils.toJsonString((Object)param));
        formShow.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
        this.getView().showForm(formShow);
    }

    private void setFilterConditionPanel() {
        Container flexPanel = (Container)this.getView().getControl(KEY_FILTER_CONDITION_PANEL);
        flexPanel.setCollapse(true);
    }

    private void addBeforeF7SelectListener() {
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)this.getView().getFormShowParameter().getParentPageId());
        List containers = EntryParamContainerHelper.createMulBaseParamForQueryPanel(null, (List)stdData.getContrastPropEntities());
        for (EntryParamContainer container : containers) {
            BasedataEdit control = (BasedataEdit)this.getView().getControl(container.getFieldIdGenerationParam().generateKey());
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private SalaryStandardTypeEnum getSalaryStandardType() {
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)this.getView().getFormShowParameter().getParentPageId());
        if (stdData == null) {
            return null;
        }
        SalaryStandardBaseEntity stdBaseEntity = stdData.getStdBaseEntity();
        if (stdBaseEntity != null) {
            return stdBaseEntity.getType();
        }
        return null;
    }

    private void paintDisplaySettingFlex(DisplayParamNew displayParam) {
        if (displayParam == null) {
            return;
        }
        this.initCheckBox(displayParam.getDisplayOnlySalaryCount(), KEY_DISPLAY_ONLYSALARYCOUNT);
        LinkedHashMap itemLevelParam = displayParam.getItemLevelParam();
        LinkedHashMap rankLevelParam = displayParam.getRankLevelParam();
        for (Map.Entry itemLevel : itemLevelParam.entrySet()) {
            this.initCheckBox((Integer)itemLevel.getValue(), "item_" + itemLevel.getKey());
        }
        for (Map.Entry rankLevel : rankLevelParam.entrySet()) {
            this.initCheckBox((Integer)rankLevel.getValue(), "rank_" + rankLevel.getKey());
        }
        this.getView().updateView(KEY_DISPLAY_ONLYSALARYCOUNT);
        for (Map.Entry itemLevel : itemLevelParam.entrySet()) {
            this.getView().updateView("item_" + itemLevel.getKey());
        }
        for (Map.Entry rankLevel : rankLevelParam.entrySet()) {
            this.getView().updateView("rank_" + rankLevel.getKey());
        }
    }

    private void initCheckBox(int code, String position) {
        if (this.getModel().getProperty(position) == null) {
            return;
        }
        if (DisplayParamHelper.checkVisibleByCode((int)code)) {
            this.getModel().setValue(position, (Object)DisplayParamHelper.getValueForBooleanAp((int)code));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{position});
        }
    }
}

