/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.salarystandard;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.swc.hcdm.business.salarystandard.ContrastGridViewHelper;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hcdm.business.salarystandard.SalaryStandardCacheHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardViewHelper;
import kd.swc.hcdm.business.utils.MetaUtils;
import kd.swc.hcdm.formplugin.salarystandard.view.ContrastDataPreviewEntryGrid;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import org.apache.commons.lang.StringUtils;

public class ContrastGridView
extends AbstractFormPlugin
implements EntryGridBindDataListener {
    private static final Log log = LogFactory.getLog(ContrastGridView.class);

    public void initialize() {
        super.initialize();
        Object currencyFixed = this.getModel().getContextVariable("currencyfixed");
        if (this.getModel().isDataLoaded() && currencyFixed == null) {
            SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)this.getView().getFormShowParameter().getParentPageId());
            try {
                DynamicObjectCollection rows = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                for (DynamicObject row : rows) {
                    SalaryStandardViewHelper.fixAmtPrecision((DynamicObject)row, (int)stdData.getStdBaseEntity().getCurrencyEntity().getAmtPrecision());
                }
                this.getModel().putContextVariable("currencyfixed", (Object)Boolean.TRUE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.getView().addCustomControls(new String[]{"entryentity"});
        this.createAndReplaceEntryControl();
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        IFormView mainView = this.getView().getParentView();
        SWCPermissionServiceHelper.checkCancelDataAndFunctionRightWithException((IFormView)mainView, (boolean)true);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs evt) {
        super.loadCustomControlMetas(evt);
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)((FormShowParameter)evt.getSource()).getParentPageId());
        if (stdData == null) {
            return;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hcdm_contrastgrid", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        stdData.getViewControlParam().setCanEdit(0);
        EntryAp entryAp = ContrastGridViewHelper.createEntryApForGrid((EntityMetadata)entityMetadata, (SalaryStandardEntryData)stdData);
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        evt.getItems().add(mapEntry);
    }

    public void beforeBindData(EventObject evt) {
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)this.getView().getParentView().getPageId());
        if (stdData == null) {
            return;
        }
        this.getModel().setValue("currencyamountstr", (Object)EntityConverter.generateMoneyaryUnitStr((SalaryStandardBaseEntity)stdData.getStdBaseEntity()));
        OnGetControlArgs ea = new OnGetControlArgs((Object)this, "entryentity");
        this.onGetControl(ea);
    }

    public void onGetControl(OnGetControlArgs evt) {
        String key = evt.getKey();
        if (StringUtils.equals((String)"entryentity", (String)key)) {
            Control rootControl = this.getView().getRootControl();
            EntryGrid oldGrid = (EntryGrid)MetaUtils.findControl(Collections.singletonList(rootControl), (String)"entryentity");
            SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)this.getView().getFormShowParameter().getParentPageId());
            if (stdData == null) {
                evt.setControl((Control)oldGrid);
                return;
            }
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hcdm_contrastgrid", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
            stdData.getViewControlParam().setCanEdit(0);
            EntryGrid entryGrid = this.createEntryControl(entityMetadata, stdData);
            evt.setControl((Control)entryGrid);
            EntryAp entryAp = ContrastGridViewHelper.createEntryApForGrid((EntityMetadata)entityMetadata, (SalaryStandardEntryData)stdData);
            entryGrid.getItems().addAll(((Container)entryAp.buildRuntimeControl()).getItems());
            MetaUtils.setControlView((List)entryGrid.getItems(), (IFormView)this.getView());
            entryGrid.endInit();
            evt.setControl((Control)entryGrid);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent evt) {
    }

    public void getEntityType(GetEntityTypeEventArgs evt) {
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)this.getView().getFormShowParameter().getParentPageId());
        if (stdData == null) {
            return;
        }
        MainEntityType oldMainType = evt.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            return;
        }
        ContrastGridViewHelper.registerPropertyForGrid((SalaryStandardEntryData)stdData, (EntryType)((EntryType)newMainType.getAllEntities().get("entryentity")));
        evt.setNewEntityType(newMainType);
    }

    private void createAndReplaceEntryControl() {
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)this.getView().getFormShowParameter().getParentPageId());
        if (stdData == null) {
            return;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hcdm_contrastgrid", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        EntryGrid grid = this.createEntryControl(entityMetadata, stdData);
        Container entryParentAp = (Container)this.findControl(((Container)this.getView().getRootControl()).getItems(), "flexpanelap");
        List subItems = entryParentAp.getItems();
        int index = this.findControlIndex(subItems, "entryentity");
        if (index >= 0) {
            subItems.set(index, grid);
        }
        this.getView().createControlIndex(grid.getItems());
    }

    private int findControlIndex(List<Control> controls, String key) {
        int index = -1;
        for (int i = 0; i < controls.size(); ++i) {
            String target = controls.get(i).getKey();
            if (!StringUtils.equals((String)target, (String)key)) continue;
            index = i;
            break;
        }
        return index;
    }

    public Control findControl(List<Control> controls, String key) {
        for (Control control : controls) {
            Control subResult;
            String target = control.getKey();
            if (StringUtils.equals((String)target, (String)key)) {
                return control;
            }
            if (!(control instanceof Container) || (subResult = this.findControl(((Container)control).getItems(), key)) == null) continue;
            return subResult;
        }
        return null;
    }

    private EntryGrid createEntryControl(EntityMetadata entityMetadata, SalaryStandardEntryData stdData) {
        EntryAp entryAp = ContrastGridViewHelper.createEntryApForGrid((EntityMetadata)entityMetadata, (SalaryStandardEntryData)stdData);
        ContrastDataPreviewEntryGrid grid = new ContrastDataPreviewEntryGrid();
        grid.setStdId(stdData.getStdBaseEntity().getId());
        grid.setGridType("hcdm_contrastgrid");
        grid.setMainPageId((String)this.getView().getFormShowParameter().getCustomParam("main_page"));
        grid.setGridViewPageId(this.getView().getPageId());
        grid.setEntryKey("entryentity");
        grid.setKey("entryentity");
        grid.setSplitPage(true);
        grid.setPageRow(5000);
        grid.getItems().clear();
        grid.getItems().addAll(((Container)entryAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex((List)Lists.newArrayList((Object[])new Control[]{grid}));
        grid.endInit();
        return grid;
    }
}

