/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.salarystandard;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.IHcdmContrastPropExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetCustomerQFilterEvent;
import kd.sdk.swc.hcdm.common.stdtab.AppliedRangeEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropConfigEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankKey;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankRangeDBEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdGridDisplayTypeEnum;
import kd.swc.hcdm.business.imports.ImportHelper;
import kd.swc.hcdm.business.matchprop.HcdmContrastPropPlugin;
import kd.swc.hcdm.business.salarystandard.ContrastRelationSettingGridHelper;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardCacheHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardImportHelper;
import kd.swc.hcdm.business.salarystandard.StdValidatorHelper;
import kd.swc.hcdm.business.salarystandard.constraint.ConstraintValidateResult;
import kd.swc.hcdm.business.salarystandard.constraint.StandardTabConstrainManager;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintResult;
import kd.swc.hcdm.business.validator.ValidatorAdapter;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.business.validator.bean.ValidatorTree;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hcdm.common.entity.salarystandard.DynamicCommonFieldIdGenerationParam;
import kd.swc.hcdm.common.entity.salarystandard.DynamicFieldIdGenerationParamForTabular;
import kd.swc.hcdm.formplugin.salarystandard.ContrastSetGridCommon;
import kd.swc.hcdm.formplugin.salarystandard.ContrastSetImportContext;
import kd.swc.hsbp.business.export.SWCExportEntryHelper;
import kd.swc.hsbp.business.export.entity.ImportConfig;
import kd.swc.hsbp.business.imports.ValidateResults;
import kd.swc.hsbp.business.imports.perm.IPermissionHandler;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.entity.EntryColumnContainer;
import kd.swc.hsbp.common.entity.EntryColumnWrapper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.imports.EntryImportContext;
import kd.swc.hsbp.formplugin.imports.IDataPort;
import kd.swc.hsbp.formplugin.imports.ProgressHandler;
import kd.swc.hsbp.formplugin.imports.event.DataImportEvent;
import kd.swc.hsbp.formplugin.imports.event.DownLoadTemplateEvent;
import kd.swc.hsbp.formplugin.imports.event.LoadCustomEntryMetasEvent;
import kd.swc.hsbp.formplugin.imports.event.OnGetImportConfigEvent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ContrastSetGridImportEdit
extends ContrastSetGridCommon
implements IDataPort {
    private static final Log log = LogFactory.getLog(ContrastSetGridImportEdit.class);
    private static final int fixHeadHeight = 3;
    private static final String SWC_HCDM_FORMPLUGIN = "swc-hcdm-formplugin";
    private static final String[] gradeRankPropertyName = new String[]{"salarygrade", "salaryrank"};
    private static final String[] gradePropertyName = new String[]{"salarygrade"};
    private StandardTabConstrainManager constrainManager = new StandardTabConstrainManager();
    private Set<Long> templateDisplayNumber = Sets.newHashSet((Object[])new Long[]{1310L, 1010L, 1020L, 1030L, 1040L, 1130L, 1135L, 1070L});
    private static final String HBJM_JOBLEVELHR = "hbjm_joblevelhr";
    private static final String HBJM_JOBLEVELSCMHR = "hbjm_joblevelscmhr";
    private static final String HBJM_JOBGRADEHR = "hbjm_jobgradehr";
    private static final String HBJM_JOBGRADESCMHR = "hbjm_jobgradescmhr";
    private static final Long HBJM_JOBLEVELHR_CFGID = 1050L;
    private static final Long HBJM_JOBGRADEHR_CFGID = 1060L;

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "donothing_import": {
                ValidateResult result = this.validateMustInput();
                if (result.isSuccess()) {
                    IDataPort.openImportWindow((IFormView)this.getView(), (IFormPlugin)this, null);
                    break;
                }
                IFormView pareView = this.getView().getParentView();
                pareView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u6210\u5fc5\u586b\u9879\u8bbe\u7f6e\uff0c\u518d\u8fdb\u884c\u6a21\u677f\u4e0b\u8f7d\u3002", (String)"SalaryStandardGridImportEdit_0", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
                this.getView().sendFormAction(pareView);
                break;
            }
        }
    }

    public void onGetImportConfig(OnGetImportConfigEvent evt) {
        String templateFirstName = this.getTemplateFirstName();
        ImportConfig config = new ImportConfig();
        LocalDate now = LocalDate.now();
        config.setTemplateCaption(templateFirstName);
        String month = String.format(Locale.ROOT, "%02d", now.getMonthValue());
        String day = String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
        String fileName = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_\u85aa\u916c\u6807\u51c6\u8868\u5bf9\u7167\u5c5e\u6027\u5bfc\u5165\u6a21\u677f_{0}{1}", (String)"ContrastSetGridImportEdit_23", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[]{month, day});
        config.setTemplateFileName(fileName);
        config.setTemplateWarningInfo(ResManager.loadKDString((String)"1.\u8bf7\u52ff\u4fee\u6539\u6a21\u677f\uff01", (String)"ContrastSetGridImportEdit_7", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
        config.setModelName(templateFirstName);
        HashSet<String> mustInputFields = new HashSet<String>(2);
        mustInputFields.add("hbjm_joblevelscmhr&mulbasedatafield&1");
        mustInputFields.add("hbjm_jobgradescmhr&mulbasedatafield&1");
        config.setMustInputFields(mustInputFields);
        config.setMaxRowCount(30000);
        config.setNeedSplitBatchImport(true);
        evt.setImportConfig(config);
    }

    public void onValidateTemplate(DataImportEvent evt) {
        EntryColumnWrapper wrapper = SWCExportEntryHelper.readEntryColumnInfo((IFormView)this.getView(), (String)"entryentity");
        IDataModel mainModel = this.getView().getParentView().getModel();
        SalaryStandardBaseEntity baseEntity = EntityConverter.dynamicObjToSalaryStdEntity((DynamicObject)mainModel.getDataEntity());
        List<EntryColumnContainer> splitEntryColumns = this.createEntryColumnList(baseEntity.getType(), baseEntity.getIsUseSalaryRank() > 0);
        List<EntryColumnContainer> containers = this.replaceEntryColumnContainer(wrapper.getContainers(), splitEntryColumns);
        List<EntryColumnContainer> entryColumnContainers = this.addEntryColumnContainer(containers);
        Set ignoreSet = SWCExportEntryHelper.getIgnoreColumnByFeatures((DataEntityPropertyCollection)this.getModel().getEntryEntity("entryentity").getDynamicObjectType().getProperties(), (boolean)true);
        SWCExportEntryHelper.removeIgnoreColumn(entryColumnContainers, (Set)ignoreSet);
        int headHeight = SWCExportEntryHelper.calcSheetHeadHeight(entryColumnContainers);
        List dataHeadSource = SalaryStandardImportHelper.getSourceHeadData(entryColumnContainers, (int)headHeight, (IDataModel)this.getModel());
        ValidateResults validateResult = new ValidateResults(ErrorLevel.Error);
        AbstractFormPlugin source = (AbstractFormPlugin)evt.getSource();
        Map dataHeadSourceKeys = (Map)dataHeadSource.get(0);
        Map dataHeadExcelKeys = (Map)evt.getDataHead().get(0);
        if (!SalaryStandardImportHelper.chekMapEqual((Map)dataHeadSourceKeys, (Map)dataHeadExcelKeys)) {
            validateResult.failed();
            source.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002", (String)"ImportConstants_3", (String)"swc-hcdm-common", (Object[])new Object[0]));
        }
        evt.setValidateResults(validateResult);
    }

    public void dataImport(DataImportEvent evt) {
        boolean needUpdateAll;
        ContrastSetImportContext context = this.getImportContext(evt.getImportContext());
        SalaryStandardEntryData stdData = context.getStdData();
        boolean isUseSalaryRank = stdData.getStdBaseEntity().isUseSalaryRank();
        Map<String, KeyValue> captions = context.getCaptions();
        List dataHead = evt.getDataHead();
        Map colIdMap = (Map)dataHead.get(0);
        List dataRow = evt.getDataRow();
        ProgressHandler processHandler = evt.getProcessHandler();
        Map<String, LocaleString> gradeRankKeyNameMap = this.generateGradeRankMap();
        ArrayList gradeRankKeys = Lists.newArrayList(gradeRankKeyNameMap.keySet());
        String beginGradeKey = (String)gradeRankKeys.get(0);
        String beginRankKey = (String)gradeRankKeys.get(1);
        String endGradeKey = (String)gradeRankKeys.get(2);
        String endRankKey = (String)gradeRankKeys.get(3);
        Map<String, Long> stdPropKeyMap = context.getStdPropKeyMap();
        List props = stdData.getContrastPropEntities().stream().map(ContrastPropEntity::getPropConfigEntity).collect(Collectors.toList());
        HashMap<String, IPermissionHandler> customQFilterHandlerMap = context.getCustomQFilterHandlerMap();
        Map gradeEntityMap = GradeRankHelper.groupByGradeName((List)stdData.getGradeEntities());
        Map rankEntityMap = GradeRankHelper.groupByRankName((List)stdData.getRankEntities());
        long beginTime = System.currentTimeMillis();
        Map<String, String> queryFieldMap = this.getCustomerQueryField(colIdMap);
        Map colDynamic = ImportHelper.loadBaseData((Map)colIdMap, (List)dataRow, (IDataModel)this.getModel(), customQFilterHandlerMap, queryFieldMap);
        log.info("ImportHelper.loadBaseData cose {} ms", (Object)(System.currentTimeMillis() - beginTime));
        List<ContrastRowDataEntity> contrastDataList = new ArrayList<ContrastRowDataEntity>(10);
        String jobLevelScmTips = ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u201c\u804c\u7ea7\u65b9\u6848\u540d\u79f0\u201d\u672a\u586b\u5199\u3002", (String)"ContrastSetGridImportEdit_17", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
        String jobGradeScmTips = ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u201c\u804c\u7b49\u65b9\u6848\u540d\u79f0\u201d\u672a\u586b\u5199\u3002", (String)"ContrastSetGridImportEdit_18", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
        for (int i = 0; i < dataRow.size(); ++i) {
            List<String> emptyFieldNames;
            String pattern;
            Map rowMap = (Map)dataRow.get(i);
            Integer excelRow = Integer.valueOf((String)rowMap.get(EntryImportContext.EXCEL_ROW_NUMBER));
            ContrastRowDataEntity rowDataEntity = new ContrastRowDataEntity();
            rowDataEntity.setProps(stdData.getContrastPropEntities());
            HashMap stdPropOfOneRow = Maps.newHashMapWithExpectedSize((int)props.size());
            GradeRankRangeDBEntity rangeEntity = null;
            boolean rowFlag = true;
            String beginGradeStr = null;
            String beginRankStr = null;
            String endGradeStr = null;
            String endRankStr = null;
            ArrayList nullGradeRankList = Lists.newArrayListWithExpectedSize((int)4);
            boolean rowIsEmpty = true;
            ArrayList<String> jobLevelList = new ArrayList<String>(10);
            ArrayList<String> jobLevelScmList = new ArrayList<String>(10);
            ArrayList<String> jobGradeList = new ArrayList<String>(10);
            ArrayList<String> jobGradeScmList = new ArrayList<String>(10);
            for (int col = 0; col < captions.size(); ++col) {
                String valJobGrade;
                String val = (String)rowMap.get(col);
                String colId = (String)colIdMap.get(col);
                if (null != val && !val.isEmpty()) {
                    rowIsEmpty = false;
                    KeyValue keyValue = captions.get(colId);
                    if (beginGradeKey.equals(colId)) {
                        beginGradeStr = val;
                        continue;
                    }
                    if (beginRankKey.equals(colId)) {
                        beginRankStr = val;
                        continue;
                    }
                    if (endGradeKey.equals(colId)) {
                        endGradeStr = val;
                        continue;
                    }
                    if (endRankKey.equals(colId)) {
                        endRankStr = val;
                        continue;
                    }
                    Map stringListMap = (Map)colDynamic.get(colId);
                    String[] cellValue = StringUtils.split((String)val, (char)';');
                    ValidateResult validateResult = this.verifyCellValueIsExist(cellValue, stringListMap, (String)keyValue.value);
                    if (validateResult.isSuccess()) {
                        Long propId = stdPropKeyMap.get(colId);
                        if (propId != null) {
                            stdPropOfOneRow.put(propId, this.fetchPkIds(stringListMap, cellValue));
                        }
                        this.initJobCheckParam(jobLevelList, jobLevelScmList, jobGradeList, jobGradeScmList, cellValue, colId);
                        continue;
                    }
                    rowFlag = false;
                    processHandler.putRowError(excelRow, (String)validateResult.getErrorList().get(0));
                    continue;
                }
                if ("hbjm_joblevelscmhr&mulbasedatafield&1".equals(colId)) {
                    String valJobLevel = (String)rowMap.get(col + 1);
                    if (null == valJobLevel || valJobLevel.isEmpty()) continue;
                    rowFlag = false;
                    processHandler.putRowError(excelRow, jobLevelScmTips);
                    continue;
                }
                if (!"hbjm_jobgradescmhr&mulbasedatafield&1".equals(colId) || null == (valJobGrade = (String)rowMap.get(col + 1)) || valJobGrade.isEmpty()) continue;
                rowFlag = false;
                processHandler.putRowError(excelRow, jobGradeScmTips);
            }
            if (rowIsEmpty) {
                rowFlag = false;
                String emptyMsg = ResManager.loadKDString((String)"\u6570\u636e\u884c\u4e3a\u7a7a,\u65e0\u6cd5\u5bfc\u5165", (String)"ContrastSetGridImportEdit_25", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
                processHandler.putRowError(excelRow, emptyMsg);
            }
            if (!nullGradeRankList.isEmpty()) {
                rowFlag = false;
                String pattern2 = ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u6570\u636e\u884c\u4e2d\u7684\u5fc5\u5f55\u9879\uff1a%s\u3002", (String)"ContrastSetGridImportEdit_8", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
                processHandler.putRowError(excelRow, String.format(Locale.ROOT, pattern2, this.conversionFormat(nullGradeRankList, ",")));
            } else if (GradeRankHelper.checkGradeRankNotEmpty(beginGradeStr, beginRankStr, endGradeStr, endRankStr, (boolean)isUseSalaryRank)) {
                rangeEntity = GradeRankHelper.getRangeByGradeRankName(beginGradeStr, beginRankStr, endGradeStr, endRankStr, (Map)gradeEntityMap, (Map)rankEntityMap, (boolean)isUseSalaryRank);
                rangeEntity.saveChange();
                if (StringUtils.isBlank((String)rangeEntity.getRangeCodeString())) {
                    rowFlag = false;
                    String gradeRankStr = this.generateGradeRankStr(beginGradeStr, beginRankStr, endGradeStr, endRankStr, stdData.getStdBaseEntity().isUseSalaryRank());
                    pattern = ResManager.loadKDString((String)"%s\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6,\u8bf7\u8c03\u6574\u3002", (String)"ContrastSetGridImportEdit_1", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
                    processHandler.putRowError(excelRow, String.format(Locale.ROOT, pattern, gradeRankStr));
                }
            } else if ((StringUtils.isNotEmpty(beginGradeStr) || StringUtils.isNotEmpty(beginRankStr) || StringUtils.isNotEmpty(endGradeStr) || StringUtils.isNotEmpty(endRankStr)) && !(emptyFieldNames = this.checkNotInputFieldName(beginGradeStr, beginRankStr, endGradeStr, endRankStr, stdData.getStdBaseEntity().isUseSalaryRank(), gradeRankKeyNameMap)).isEmpty()) {
                rowFlag = false;
                pattern = ResManager.loadKDString((String)"%s\u672a\u586b\u5199,\u8bf7\u8c03\u6574\u3002", (String)"ContrastSetGridImportEdit_16", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
                processHandler.putRowError(excelRow, String.format(Locale.ROOT, pattern, StringUtils.join(emptyFieldNames, (char)'\u3001')));
            }
            List<String> errMsgs = this.validateAndFilterJobLevelAndJobGrade(colDynamic, colIdMap, jobLevelList, jobLevelScmList, jobGradeList, jobGradeScmList, stdPropOfOneRow);
            if (!errMsgs.isEmpty()) {
                rowFlag = false;
                processHandler.putRowError(excelRow, this.conversionFormat(errMsgs, ";"));
            }
            if (rowFlag) {
                rowDataEntity.setGradeRankRangeDBEntity(rangeEntity);
                rowDataEntity.setStdContrastData((Map)stdPropOfOneRow);
                rowDataEntity.setRowIndex(excelRow.intValue());
                contrastDataList.add(rowDataEntity);
                continue;
            }
            processHandler.incrByProgress(0, 1);
        }
        if (CollectionUtils.isEmpty(contrastDataList = this.validateForImportContrastData(contrastDataList, colDynamic, colIdMap, processHandler, stdData.getContrastPropEntities(), stdData.getAppliedRangeEntities(), stdData.getStdBaseEntity().getCountryId()))) {
            return;
        }
        int lastRowIndex = ContrastRelationSettingGridHelper.getLastRowIndex((IFormView)this.getView(), (boolean)false);
        boolean bl = needUpdateAll = lastRowIndex == -1;
        if (!needUpdateAll) {
            for (ContrastRowDataEntity rowDataEntity : contrastDataList) {
                rowDataEntity.setRowIndex(++lastRowIndex);
            }
        }
        ContrastRelationSettingGridHelper.updateToParentEntry(contrastDataList, (IFormView)this.getView().getParentView(), (boolean)needUpdateAll);
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        this.setEntryContent(rows, contrastDataList);
        this.getModel().updateEntryCache(rows);
    }

    private Map<String, String> getCustomerQueryField(Map<Integer, String> colIdMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)this.templateDisplayNumber.size());
        for (Map.Entry<Integer, String> entry : colIdMap.entrySet()) {
            Long propConfigId;
            String propName = entry.getValue();
            if (!propName.startsWith("dgdf") || !this.templateDisplayNumber.contains(propConfigId = DynamicFieldIdGenerationParamForTabular.parseFrom((String)propName).getIdentityId())) continue;
            resultMap.put(propName, "number");
        }
        return resultMap;
    }

    private void initJobCheckParam(List<String> jobLevelList, List<String> jobLevelScmList, List<String> jobGradeList, List<String> jobGradeScmList, String[] cellValue, String colId) {
        if (colId != null && colId.startsWith("dgdf")) {
            DynamicFieldIdGenerationParamForTabular generationParam = DynamicFieldIdGenerationParamForTabular.parseFrom((String)colId);
            if (HBJM_JOBLEVELHR_CFGID.equals(generationParam.getIdentityId())) {
                this.setList(jobLevelList, cellValue);
            } else if (HBJM_JOBGRADEHR_CFGID.equals(generationParam.getIdentityId())) {
                this.setList(jobGradeList, cellValue);
            }
        } else if ("hbjm_joblevelscmhr&mulbasedatafield&1".equals(colId)) {
            this.setList(jobLevelScmList, cellValue);
        } else if ("hbjm_jobgradescmhr&mulbasedatafield&1".equals(colId)) {
            this.setList(jobGradeScmList, cellValue);
        }
    }

    private void setList(List<String> jobLevelList, String[] cellValue) {
        if (cellValue != null) {
            for (String val : cellValue) {
                if (!StringUtils.isNotEmpty((String)val)) continue;
                jobLevelList.add(val);
            }
        }
    }

    private List<String> validateAndFilterJobLevelAndJobGrade(Map<String, Map<String, List<DynamicObject>>> colDynamic, Map<Integer, String> colIdMap, List<String> jobLevelList, List<String> jobLevelScmList, List<String> jobGradeList, List<String> jobGradeScmList, HashMap<Long, List<Long>> stdPropOfOneRow) {
        ArrayList<String> errMsgs = new ArrayList<String>(2);
        if (jobLevelList.isEmpty() && jobGradeList.isEmpty()) {
            return errMsgs;
        }
        errMsgs.addAll(this.validateJobLevel(colDynamic, colIdMap, jobLevelList, jobLevelScmList, stdPropOfOneRow));
        errMsgs.addAll(this.validateJobGrade(colDynamic, colIdMap, jobGradeList, jobGradeScmList, stdPropOfOneRow));
        return errMsgs;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> validateJobLevel(Map<String, Map<String, List<DynamicObject>>> colDynamic, Map<Integer, String> colIdMap, List<String> jobLevelList, List<String> jobLevelScmList, HashMap<Long, List<Long>> stdPropOfOneRow) {
        ArrayList<String> errMsgs = new ArrayList<String>(2);
        if (!jobLevelList.isEmpty()) {
            void var15_21;
            String jobLevelKey = "";
            for (Map.Entry<Integer, String> colIdEntry : colIdMap.entrySet()) {
                DynamicFieldIdGenerationParamForTabular generationParam;
                String value = colIdEntry.getValue();
                if (!value.startsWith("dgdf") || !HBJM_JOBLEVELHR_CFGID.equals((generationParam = DynamicFieldIdGenerationParamForTabular.parseFrom((String)value)).getIdentityId())) continue;
                jobLevelKey = value;
                break;
            }
            Map<String, List<DynamicObject>> jobLevelAllObjMap = colDynamic.get(jobLevelKey);
            Map<String, List<DynamicObject>> jobLevelAllScmObjMap = colDynamic.get("hbjm_joblevelscmhr&mulbasedatafield&1");
            Map jobLevelCurRowObjMap = jobLevelList.stream().collect(Collectors.toMap(jobLevelName -> jobLevelName, jobLevelAllObjMap::get, (a1, b1) -> b1, () -> Maps.newHashMapWithExpectedSize((int)jobLevelList.size())));
            Map jobLevelCurRowScmObjMap = jobLevelScmList.stream().collect(Collectors.toMap(jobLevelScmName -> jobLevelScmName, jobLevelAllScmObjMap::get, (a1, b1) -> b1, () -> Maps.newHashMapWithExpectedSize((int)jobLevelScmList.size())));
            HashMap levelAndScmIdMap = new HashMap(16);
            HashMap scmIds = new HashMap(16);
            for (Map.Entry entry : jobLevelCurRowObjMap.entrySet()) {
                List jobLevelDyObjs = (List)entry.getValue();
                jobLevelDyObjs.forEach(obj -> levelAndScmIdMap.put(obj.getLong("id"), obj.getLong("joblevelscm.id")));
            }
            for (Map.Entry entry : jobLevelCurRowScmObjMap.entrySet()) {
                List jobLevelScmDyObjs = (List)entry.getValue();
                jobLevelScmDyObjs.forEach(obj -> {
                    String cfr_ignored_0 = (String)scmIds.put(obj.getLong("id"), entry.getKey());
                });
            }
            HashSet<Long> possibleScmIds = new HashSet<Long>(16);
            for (Long scmId : levelAndScmIdMap.values()) {
                if (!scmIds.containsKey(scmId)) continue;
                possibleScmIds.add(scmId);
            }
            if (possibleScmIds.isEmpty()) {
                errMsgs.add(this.getTips(jobLevelScmList, jobLevelList, true));
                return errMsgs;
            }
            HashMap hashMap = new HashMap(16);
            HashMap<String, List> notMatchedLevelTips = new HashMap<String, List>(16);
            Long matchedScmId = 0L;
            for (Long l : possibleScmIds) {
                HashMap matchedLevel = new HashMap(16);
                boolean isAllMatch = true;
                for (Map.Entry jobLevelCurRowObjEntry : jobLevelCurRowObjMap.entrySet()) {
                    List jobLevelDyObjs = (List)jobLevelCurRowObjEntry.getValue();
                    ArrayList<Long> matchedLevelIds = new ArrayList<Long>(10);
                    for (DynamicObject jobLevelDyObj : jobLevelDyObjs) {
                        if (l.longValue() != jobLevelDyObj.getLong("joblevelscm.id")) continue;
                        matchedLevelIds.add(jobLevelDyObj.getLong("id"));
                    }
                    if (matchedLevelIds.isEmpty()) {
                        isAllMatch = false;
                        List notMatchLevs = notMatchedLevelTips.computeIfAbsent((String)scmIds.get(l), lev -> new ArrayList(10));
                        notMatchLevs.add(jobLevelCurRowObjEntry.getKey());
                        continue;
                    }
                    matchedLevel.put(jobLevelCurRowObjEntry.getKey(), matchedLevelIds);
                }
                if (!isAllMatch) continue;
                HashMap hashMap2 = matchedLevel;
                matchedScmId = l;
                break;
            }
            if (var15_21.isEmpty()) {
                for (Map.Entry entry : notMatchedLevelTips.entrySet()) {
                    errMsgs.add(this.getTips(Collections.singletonList(entry.getKey()), (List)entry.getValue(), true));
                }
                return errMsgs;
            }
            ArrayList levelIds = Lists.newArrayListWithExpectedSize((int)var15_21.size());
            var15_21.values().forEach(levelIds::addAll);
            stdPropOfOneRow.put(HBJM_JOBLEVELHR_CFGID, levelIds);
        }
        return errMsgs;
    }

    private String getTips(List<String> jobScms, List<String> jobs, boolean isJobLevel) {
        StringBuilder sb = new StringBuilder();
        String jobLevel = this.conversionFormat(jobs, "\uff0c");
        String levelTips = ResManager.loadKDString((String)"\u804c\u7ea7\u4e0d\u5c5e\u4e8e\u804c\u7ea7\u65b9\u6848\uff1a\u201c{0}\u201d\u672a\u5305\u542b\u804c\u7ea7\uff1a\u201c{1}\u201d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ContrastSetGridImportEdit_19", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
        if (!isJobLevel) {
            levelTips = ResManager.loadKDString((String)"\u804c\u7b49\u4e0d\u5c5e\u4e8e\u804c\u7b49\u65b9\u6848\uff1a\u201c{0}\u201d\u672a\u5305\u542b\u804c\u7b49\uff1a\u201c{1}\u201d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ContrastSetGridImportEdit_20", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
        }
        for (String jobScm : jobScms) {
            sb.append(MessageFormat.format(levelTips, jobScm, jobLevel));
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private List<String> validateJobGrade(Map<String, Map<String, List<DynamicObject>>> colDynamic, Map<Integer, String> colIdMap, List<String> jobLevelList, List<String> jobLevelScmList, HashMap<Long, List<Long>> stdPropOfOneRow) {
        ArrayList<String> errMsgs = new ArrayList<String>(2);
        if (!jobLevelList.isEmpty()) {
            void var15_21;
            String jobLevelKey = "";
            for (Map.Entry<Integer, String> colIdEntry : colIdMap.entrySet()) {
                DynamicFieldIdGenerationParamForTabular generationParam;
                String value = colIdEntry.getValue();
                if (!value.startsWith("dgdf") || !HBJM_JOBGRADEHR_CFGID.equals((generationParam = DynamicFieldIdGenerationParamForTabular.parseFrom((String)value)).getIdentityId())) continue;
                jobLevelKey = value;
                break;
            }
            Map<String, List<DynamicObject>> jobLevelAllObjMap = colDynamic.get(jobLevelKey);
            Map<String, List<DynamicObject>> jobLevelAllScmObjMap = colDynamic.get("hbjm_jobgradescmhr&mulbasedatafield&1");
            Map jobLevelCurRowObjMap = jobLevelList.stream().collect(Collectors.toMap(jobLevelName -> jobLevelName, jobLevelAllObjMap::get, (a1, b1) -> b1, () -> Maps.newHashMapWithExpectedSize((int)jobLevelList.size())));
            Map jobLevelCurRowScmObjMap = jobLevelScmList.stream().collect(Collectors.toMap(jobLevelScmName -> jobLevelScmName, jobLevelAllScmObjMap::get, (a1, b1) -> b1, () -> Maps.newHashMapWithExpectedSize((int)jobLevelScmList.size())));
            HashMap levelAndScmIdMap = new HashMap(16);
            HashMap scmIds = new HashMap(16);
            for (Map.Entry entry : jobLevelCurRowObjMap.entrySet()) {
                List jobLevelDyObjs = (List)entry.getValue();
                jobLevelDyObjs.forEach(obj -> levelAndScmIdMap.put(obj.getLong("id"), obj.getLong("jobgradescm.id")));
            }
            for (Map.Entry entry : jobLevelCurRowScmObjMap.entrySet()) {
                List jobLevelScmDyObjs = (List)entry.getValue();
                jobLevelScmDyObjs.forEach(obj -> {
                    String cfr_ignored_0 = (String)scmIds.put(obj.getLong("id"), entry.getKey());
                });
            }
            HashSet<Long> possibleScmIds = new HashSet<Long>(16);
            for (Long scmId : levelAndScmIdMap.values()) {
                if (!scmIds.containsKey(scmId)) continue;
                possibleScmIds.add(scmId);
            }
            if (possibleScmIds.isEmpty()) {
                errMsgs.add(this.getTips(jobLevelScmList, jobLevelList, false));
                return errMsgs;
            }
            HashMap hashMap = new HashMap(16);
            HashMap<String, List> notMatchedLevelTips = new HashMap<String, List>(16);
            Long matchedScmId = 0L;
            for (Long l : possibleScmIds) {
                HashMap matchedLevel = new HashMap(16);
                boolean isAllMatch = true;
                for (Map.Entry jobLevelCurRowObjEntry : jobLevelCurRowObjMap.entrySet()) {
                    List jobLevelDyObjs = (List)jobLevelCurRowObjEntry.getValue();
                    ArrayList<Long> matchedLevelIds = new ArrayList<Long>(10);
                    for (DynamicObject jobLevelDyObj : jobLevelDyObjs) {
                        if (l.longValue() != jobLevelDyObj.getLong("jobgradescm.id")) continue;
                        matchedLevelIds.add(jobLevelDyObj.getLong("id"));
                    }
                    if (matchedLevelIds.isEmpty()) {
                        isAllMatch = false;
                        List notMatchLevs = notMatchedLevelTips.computeIfAbsent((String)scmIds.get(l), lev -> new ArrayList(10));
                        notMatchLevs.add(jobLevelCurRowObjEntry.getKey());
                        continue;
                    }
                    matchedLevel.put(jobLevelCurRowObjEntry.getKey(), matchedLevelIds);
                }
                if (!isAllMatch) continue;
                HashMap hashMap2 = matchedLevel;
                matchedScmId = l;
                break;
            }
            if (var15_21.isEmpty()) {
                for (Map.Entry entry : notMatchedLevelTips.entrySet()) {
                    errMsgs.add(this.getTips(Collections.singletonList(entry.getKey()), (List)entry.getValue(), false));
                }
                return errMsgs;
            }
            ArrayList levelIds = Lists.newArrayListWithExpectedSize((int)var15_21.size());
            var15_21.values().forEach(levelIds::addAll);
            stdPropOfOneRow.put(HBJM_JOBGRADEHR_CFGID, levelIds);
        }
        return errMsgs;
    }

    private List<String> checkNotInputFieldName(String beginGradeStr, String beginRankStr, String endGradeStr, String endRankStr, boolean useSalaryRank, Map<String, LocaleString> gradeRankKeyNameMap) {
        ArrayList fieldNames = Lists.newArrayList();
        if (useSalaryRank) {
            if (StringUtils.isEmpty((String)beginGradeStr)) {
                fieldNames.add(gradeRankKeyNameMap.get("dgff_begaingrade").getLocaleValue());
            }
            if (StringUtils.isEmpty((String)beginRankStr)) {
                fieldNames.add(gradeRankKeyNameMap.get("dgff_begainrank").getLocaleValue());
            }
            if (StringUtils.isEmpty((String)endGradeStr)) {
                fieldNames.add(gradeRankKeyNameMap.get("dgff_endgrade").getLocaleValue());
            }
            if (StringUtils.isEmpty((String)endRankStr)) {
                fieldNames.add(gradeRankKeyNameMap.get("dgff_endrank").getLocaleValue());
            }
        } else {
            if (StringUtils.isEmpty((String)beginGradeStr)) {
                fieldNames.add(gradeRankKeyNameMap.get("dgff_begaingrade").getLocaleValue());
            }
            if (StringUtils.isEmpty((String)endGradeStr)) {
                fieldNames.add(gradeRankKeyNameMap.get("dgff_endgrade").getLocaleValue());
            }
        }
        return fieldNames;
    }

    public Map<Long, List<QFilter>> getQFilterWithExtForDownloadTpl(List<ContrastPropConfigEntity> propConfigEntities) {
        return this.getQFilterWithExtForContrastProp(propConfigEntities, "downloadTemplate");
    }

    public Map<Long, List<QFilter>> getQFilterWithExtForImportValidate(List<ContrastPropConfigEntity> propConfigEntities) {
        return this.getQFilterWithExtForContrastProp(propConfigEntities, "importValidate");
    }

    private Map<Long, List<QFilter>> getQFilterWithExtForContrastProp(List<ContrastPropConfigEntity> propConfigEntities, String scene) {
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)new HcdmContrastPropPlugin(), IHcdmContrastPropExtPlugin.class, (String)"kd.sdk.swc.hcdm.business.extpoint.salarystd.IHcdmContrastPropExtPlugin#onGetCustomerQFilter", null);
        OnGetCustomerQFilterEvent event = new OnGetCustomerQFilterEvent((Object)this.getView().getParentView());
        event.setPropCfgList(propConfigEntities);
        event.setScene(scene);
        pluginProxy.callAfter(plugin -> {
            plugin.onGetCustomerQFilter(event);
            return null;
        });
        log.info("onGetCustomerQFilterEvent");
        return event.getCustomerQFilter();
    }

    private String generateGradeRankStr(String beginGradeStr, String beginRankStr, String endGradeStr, String endRankStr, boolean useSalaryRank) {
        String sep = "~";
        if (useSalaryRank) {
            return beginGradeStr + beginRankStr + sep + endGradeStr + endRankStr;
        }
        return beginGradeStr + sep + endGradeStr;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (SWCStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"ImportStartCloseCallBack")) {
            this.getView().updateView();
        }
    }

    public void afterImport(DataImportEvent evt) {
    }

    public void beforeDownLoadTemplate(DownLoadTemplateEvent evt) {
        SXSSFWorkbook wb = evt.getWb();
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)this.getView().getFormShowParameter().getParentPageId());
        if (stdData == null) {
            return;
        }
        this.createConstrastSheet(wb, stdData.getContrastPropEntities());
        this.createGradeRankSheet(wb, stdData);
    }

    private void createGradeRankSheet(SXSSFWorkbook wb, SalaryStandardEntryData stdData) {
        SalaryStandardBaseEntity stdBaseEntity = stdData.getStdBaseEntity();
        SalaryStandardTypeEnum type = stdBaseEntity.getType();
        boolean useSalaryRank = stdBaseEntity.isUseSalaryRank();
        if (SalaryStandardTypeEnum.BROADBAND == type || useSalaryRank) {
            String sheetName = SalaryStandardConstants.FORM_STATIC_GRADE_RANK_FIELD_NAME();
            this.prapareExportGradeRank(wb, stdData, SalaryStandardImportHelper.getPropertiesMap((String)sheetName, (String[])gradeRankPropertyName, (String[])new String[]{SalaryStandardConstants.FORM_STATIC_GRADE_FIELD_NAME(), SalaryStandardConstants.FORM_STATIC_RANK_FIELD_NAME()}));
        } else {
            String sheetName = SalaryStandardConstants.FORM_STATIC_GRADE_FIELD_NAME();
            this.prapareExportGrade(wb, stdData, SalaryStandardImportHelper.getPropertiesMap((String)sheetName, (String[])gradePropertyName, (String[])new String[]{SalaryStandardConstants.FORM_STATIC_GRADE_FIELD_NAME()}));
        }
    }

    private void prapareExportGrade(SXSSFWorkbook wb, SalaryStandardEntryData stdData, Map<String, Object> propertiesMap) {
        SXSSFSheet sheet = wb.createSheet((String)propertiesMap.get("sheetName"));
        sheet.trackAllColumnsForAutoSizing();
        List alias = (List)propertiesMap.get("alias");
        this.createTitle(wb, sheet, alias);
        List gradeEntities = stdData.getGradeEntities();
        GradeRankHelper.sortGradeList((List)gradeEntities, (int)1);
        ArrayList<String[]> datas = new ArrayList<String[]>(gradeEntities.size());
        for (SalaryGradeEntity gradeEntity : gradeEntities) {
            String gradeName = gradeEntity.getGradeName();
            datas.add(new String[]{gradeName});
        }
        this.createDataRows(wb, sheet, datas);
    }

    private void prapareExportGradeRank(SXSSFWorkbook wb, SalaryStandardEntryData stdData, Map<String, Object> propertiesMap) {
        SXSSFSheet sheet = wb.createSheet((String)propertiesMap.get("sheetName"));
        sheet.trackAllColumnsForAutoSizing();
        List alias = (List)propertiesMap.get("alias");
        this.createTitle(wb, sheet, alias);
        List gradeEntities = stdData.getGradeEntities();
        List rankEntities = stdData.getRankEntities();
        List sortedRankEntities = rankEntities.stream().filter(rankEntity -> SalaryRankLabelEnum.STANDARD == rankEntity.getRankLabel()).sorted(Comparator.comparingInt(SalaryRankEntity::getRankIndex)).collect(Collectors.toList());
        List allGradeRankKeyList = GradeRankHelper.getAllGradeRankKeyList((List)gradeEntities, sortedRankEntities);
        GradeRankHelper.sortGradeRankKeyList((List)allGradeRankKeyList, (int)1, (int)1);
        ArrayList<String[]> datas = new ArrayList<String[]>(allGradeRankKeyList.size());
        for (int i = 0; i < allGradeRankKeyList.size(); ++i) {
            GradeRankKey gradeRankKey = (GradeRankKey)allGradeRankKeyList.get(i);
            String gradeName = gradeRankKey.getGradeEntity().getGradeName();
            String rankName = gradeRankKey.getRankEntity().getRankName();
            datas.add(new String[]{gradeName, rankName});
        }
        this.createDataRows(wb, sheet, datas);
    }

    private void createConstrastSheet(SXSSFWorkbook wb, List<ContrastPropEntity> contrastPropEntities) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getParentView().getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection appliedRangeColl = dataEntity.getDynamicObjectCollection("appliedrange");
        DynamicObject country = (DynamicObject)model.getValue("country");
        Long countryId = country != null ? Long.valueOf(country.getLong("id")) : null;
        List applyRangeData = EntityConverter.dynamicObjToAppliedRangeEntity((DynamicObjectCollection)appliedRangeColl, (Long)dataEntity.getLong("id"));
        List<ContrastPropConfigEntity> propCfgIds = contrastPropEntities.stream().map(ContrastPropEntity::getPropConfigEntity).collect(Collectors.toList());
        Map<Long, List<QFilter>> qFilterWithExtForDownloadTpl = this.getQFilterWithExtForDownloadTpl(propCfgIds);
        for (ContrastPropEntity contrastPropEntity : contrastPropEntities) {
            String propName = contrastPropEntity.getPropConfigEntity().getName();
            String entityName = contrastPropEntity.getPropConfigEntity().getObjectTypeIId();
            String queryFields = contrastPropEntity.getPropConfigEntity().getQueryFields();
            if (HBJM_JOBLEVELHR_CFGID.equals(contrastPropEntity.getPropConfigId())) {
                queryFields = "joblevelscm.number,joblevelscm.name," + queryFields;
            } else if (HBJM_JOBGRADEHR_CFGID.equals(contrastPropEntity.getPropConfigId())) {
                queryFields = "jobgradescm.number,jobgradescm.name," + queryFields;
            }
            this.prepareExport(wb, entityName, SalaryStandardImportHelper.getPropertiesMap((String)entityName, (String)propName, (String)queryFields), contrastPropEntity, applyRangeData, qFilterWithExtForDownloadTpl.get(contrastPropEntity.getPropConfigId()), countryId);
        }
    }

    private void prepareExport(SXSSFWorkbook wb, String entityName, Map<String, Object> propertiesMap, ContrastPropEntity contrastPropEntity, List<AppliedRangeEntity> applyRangeData, List<QFilter> customQFilters, Long countryId) {
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)3);
        if (CollectionUtils.isNotEmpty(customQFilters)) {
            qFilters.addAll(customQFilters);
        }
        List propertyList = (List)propertiesMap.get("property");
        String selectProperties = this.conversionFormat(propertyList, ",");
        QFilter calcConstraintQFilter = this.getCalcConstraintQFilter(contrastPropEntity, applyRangeData, countryId);
        if (calcConstraintQFilter != null) {
            log.info("\u5b9e\u4f53\u6807\u8bc6\uff1a{} \uff1b\u8c03\u7528\u8ba1\u7b97\u5bf9\u7167\u5c5e\u6027\u7ea7\u8054\u63a5\u53e3\u8fd4\u56deQFilter : {}", (Object)entityName, (Object)calcConstraintQFilter);
            qFilters.add(calcConstraintQFilter);
        }
        Date begin = TimeServiceHelper.now();
        DynamicObject[] dynamicObjects = new SWCDataServiceHelper(entityName).query(selectProperties, qFilters.toArray(new QFilter[0]));
        this.addSheet(wb, entityName, propertiesMap, propertyList, begin, dynamicObjects);
    }

    private void addSheet(SXSSFWorkbook wb, String entityName, Map<String, Object> propertiesMap, List<String> propertyList, Date begin, DynamicObject[] dynamicObjects) {
        List alias = (List)propertiesMap.get("alias");
        Date end = TimeServiceHelper.now();
        log.info("query entity {} cost {} ms , rowcount is {}", new Object[]{entityName, end.getTime() - begin.getTime(), dynamicObjects.length});
        SXSSFSheet sheet = wb.createSheet((String)propertiesMap.get("sheetName"));
        sheet.trackAllColumnsForAutoSizing();
        this.createTitle(wb, sheet, alias);
        ArrayList<String[]> datas = new ArrayList<String[]>(dynamicObjects.length);
        int propSize = propertyList.size();
        for (int i = 0; i < dynamicObjects.length; ++i) {
            datas.add(new String[propSize]);
        }
        if (dynamicObjects.length > 0) {
            BiFunction<IDataEntityProperty, DynamicObject, String> valueProviderFun = (prop1, dynamicObject) -> {
                String val = "";
                if (prop1 instanceof BooleanProp) {
                    val = Boolean.TRUE.equals(prop1.getValue(dynamicObject)) ? ResManager.loadKDString((String)"\u662f", (String)"ContrastSetGridImportEdit_9", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ContrastSetGridImportEdit_10", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
                } else if (prop1 instanceof BasedataProp) {
                    DynamicObject dy = (DynamicObject)prop1.getValue(dynamicObject);
                    val = ((BasedataProp)prop1).getDisplayValue((Object)dy);
                } else if (prop1 instanceof MulBasedataProp) {
                    DynamicObjectCollection value = (DynamicObjectCollection)prop1.getValue(dynamicObject);
                    BasedataProp refBaseProp = (BasedataProp)((MulBasedataProp)prop1).getRefBaseProp();
                    ArrayList<String> valStrs = new ArrayList<String>(value.size());
                    for (int j = 0; j < value.size(); ++j) {
                        DynamicObject baseDataObj = ((DynamicObject)value.get(j)).getDynamicObject((IDataEntityProperty)refBaseProp);
                        String displayValue = refBaseProp.getDisplayValue((Object)baseDataObj);
                        valStrs.add(j, displayValue);
                    }
                    val = String.join((CharSequence)";", valStrs);
                } else {
                    val = prop1 instanceof MuliLangTextProp ? prop1.getValue(dynamicObject).toString() : (String)prop1.getValue(dynamicObject);
                }
                return val;
            };
            DataEntityPropertyCollection properties = dynamicObjects[0].getDataEntityType().getProperties();
            for (int i = 0; i < propertyList.size(); ++i) {
                String field = propertyList.get(i);
                IDataEntityProperty prop = (IDataEntityProperty)properties.get((Object)field);
                for (int j = 0; j < dynamicObjects.length; ++j) {
                    if (prop != null) {
                        ((String[])datas.get((int)j))[i] = valueProviderFun.apply(prop, dynamicObjects[j]);
                        continue;
                    }
                    if (SWCStringUtils.equals((String)entityName, (String)HBJM_JOBLEVELHR)) {
                        if ("joblevelscm.number".equals(field)) {
                            ((String[])datas.get((int)j))[i] = dynamicObjects[j].getString("joblevelscm.number");
                            continue;
                        }
                        if (!"joblevelscm.name".equals(field)) continue;
                        ((String[])datas.get((int)j))[i] = dynamicObjects[j].getString("joblevelscm.name");
                        continue;
                    }
                    if (!SWCStringUtils.equals((String)entityName, (String)HBJM_JOBGRADEHR)) continue;
                    if ("jobgradescm.number".equals(field)) {
                        ((String[])datas.get((int)j))[i] = dynamicObjects[j].getString("jobgradescm.number");
                        continue;
                    }
                    if (!"jobgradescm.name".equals(field)) continue;
                    ((String[])datas.get((int)j))[i] = dynamicObjects[j].getString("jobgradescm.name");
                }
            }
        }
        long beginTime = System.currentTimeMillis();
        this.createDataRows(wb, sheet, datas);
        long cost = System.currentTimeMillis() - beginTime;
        log.info("create sheet entity is {}, costtime {} ms , rowcount is {}", new Object[]{entityName, cost, dynamicObjects.length});
    }

    public void loadCustomEntryMetas(LoadCustomEntryMetasEvent evt) {
        EntryColumnWrapper wrapper = SWCExportEntryHelper.readEntryColumnInfo((IFormView)this.getView(), (String)"entryentity");
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)this.getView().getFormShowParameter().getParentPageId());
        if (stdData == null) {
            return;
        }
        List<EntryColumnContainer> splitEntryColumns = this.createEntryColumnList(stdData.getStdBaseEntity().getType(), stdData.getStdBaseEntity().isUseSalaryRank());
        List<EntryColumnContainer> replacedList = this.replaceEntryColumnContainer(wrapper.getContainers(), splitEntryColumns);
        List<EntryColumnContainer> entryColumnContainers = this.addEntryColumnContainer(replacedList);
        wrapper.setContainers(entryColumnContainers);
        evt.setEntryColumnWrapper(wrapper);
    }

    public List<EntryColumnContainer> replaceEntryColumnContainer(List<EntryColumnContainer> containers, List<EntryColumnContainer> splitEntryColumns) {
        String gradeRankKey = new DynamicCommonFieldIdGenerationParam("dgff", "grade_rank").generateKey();
        ArrayList<EntryColumnContainer> resultList = new ArrayList<EntryColumnContainer>(10);
        for (EntryColumnContainer container : containers) {
            if (container.getKey().equals(gradeRankKey)) {
                resultList.addAll(splitEntryColumns);
                continue;
            }
            resultList.add(container);
        }
        return resultList;
    }

    public List<EntryColumnContainer> addEntryColumnContainer(List<EntryColumnContainer> containers) {
        ArrayList<EntryColumnContainer> resultList = new ArrayList<EntryColumnContainer>(containers.size());
        String numberCaption = ResManager.loadKDString((String)"\u7f16\u7801", (String)"ContrastSetGridImportEdit_21", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
        String nameCaption = ResManager.loadKDString((String)"\u540d\u79f0", (String)"ContrastSetGridImportEdit_22", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
        for (EntryColumnContainer container : containers) {
            String key = container.getKey();
            if (key.startsWith("dgdf")) {
                MainEntityType mainEntityType;
                DynamicFieldIdGenerationParamForTabular generationParam = DynamicFieldIdGenerationParamForTabular.parseFrom((String)key);
                if (HBJM_JOBLEVELHR_CFGID.equals(generationParam.getIdentityId())) {
                    EntryColumnContainer jobLevelScm = new EntryColumnContainer();
                    mainEntityType = MetadataServiceHelper.getDataEntityType((String)HBJM_JOBLEVELSCMHR);
                    jobLevelScm.setKey("hbjm_joblevelscmhr&mulbasedatafield&1");
                    jobLevelScm.setHeader(new LocaleString(mainEntityType.getDisplayName().getLocaleValue() + "." + nameCaption));
                    jobLevelScm.setVisible(true);
                    jobLevelScm.setType(EntryColumnContainer.EntryColumnTypeEnum.ENTRY_FILED.getCode());
                    resultList.add(jobLevelScm);
                } else if (HBJM_JOBGRADEHR_CFGID.equals(generationParam.getIdentityId())) {
                    EntryColumnContainer jobGradeScm = new EntryColumnContainer();
                    mainEntityType = MetadataServiceHelper.getDataEntityType((String)HBJM_JOBGRADESCMHR);
                    jobGradeScm.setKey("hbjm_jobgradescmhr&mulbasedatafield&1");
                    jobGradeScm.setHeader(new LocaleString(mainEntityType.getDisplayName().getLocaleValue() + "." + nameCaption));
                    jobGradeScm.setVisible(true);
                    jobGradeScm.setType(EntryColumnContainer.EntryColumnTypeEnum.ENTRY_FILED.getCode());
                    resultList.add(jobGradeScm);
                }
                if (this.templateDisplayNumber.contains(generationParam.getIdentityId())) {
                    container.setHeader(new LocaleString(container.getHeader().getLocaleValue() + "." + numberCaption));
                } else {
                    container.setHeader(new LocaleString(container.getHeader().getLocaleValue() + "." + nameCaption));
                }
            }
            resultList.add(container);
        }
        return resultList;
    }

    public List<EntryColumnContainer> createEntryColumnList(SalaryStandardTypeEnum type, boolean useSalaryRank) {
        ArrayList<EntryColumnContainer> resultList = new ArrayList<EntryColumnContainer>(10);
        if (SalaryStandardTypeEnum.BROADBAND == type || useSalaryRank) {
            this.getEntryColumnContainers(resultList, this.generateGradeRankMap());
        } else {
            this.getEntryColumnContainers(resultList, this.generateGradeMap());
        }
        return resultList;
    }

    private void getEntryColumnContainers(List<EntryColumnContainer> resultList, Map<String, LocaleString> gradeRankMap) {
        for (Map.Entry<String, LocaleString> map : gradeRankMap.entrySet()) {
            EntryColumnContainer entryColumnContainer = new EntryColumnContainer();
            entryColumnContainer.setKey(map.getKey());
            entryColumnContainer.setHeader(map.getValue());
            entryColumnContainer.setVisible(true);
            entryColumnContainer.setType(EntryColumnContainer.EntryColumnTypeEnum.ENTRY_FILED.getCode());
            resultList.add(entryColumnContainer);
        }
    }

    private QFilter getEditControlFilter(String colId, Map<String, QFilter> qFilterMap) {
        QFilter qFilter = qFilterMap.get(colId);
        if (qFilter == null) {
            MulBasedataEdit control = (MulBasedataEdit)this.getView().getControl(colId);
            qFilter = control.getQFilter();
            qFilterMap.put(colId, qFilter);
        }
        return qFilter;
    }

    private void pushContrastData(List<ContrastRowDataEntity> contrastDataList, String operation) {
        if (CollectionUtils.isEmpty(contrastDataList)) {
            return;
        }
    }

    private ArrayList<Long> fetchPkIds(Map<String, List<DynamicObject>> dyMap, String[] value) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)value.length);
        for (String val : value) {
            List<DynamicObject> objArr = dyMap.get(val);
            if (!CollectionUtils.isNotEmpty(objArr)) continue;
            list.addAll(objArr.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
        }
        return list;
    }

    private ValidateResult verifyCellValueIsExist(String[] value, Map<String, List<DynamicObject>> stringListMap, String colName) {
        ValidateResult result = new ValidateResult(ErrorLevel.Error);
        for (String val : value) {
            if (!MapUtils.isEmpty(stringListMap) && stringListMap.containsKey(val)) continue;
            String format = ResManager.loadKDString((String)"\u201c%1$s-%2$s\u201d\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6,\u8bf7\u8c03\u6574\u3002", (String)"ContrastSetGridImportEdit_11", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
            result.addErrorMsgs((Collection)Lists.newArrayList((Object[])new String[]{String.format(format, colName, val)}));
        }
        return result;
    }

    private String getTemplateFirstName() {
        return ResManager.loadKDString((String)"\u85aa\u916c\u6807\u51c6\u8868-\u5bf9\u7167\u5c5e\u6027", (String)"ContrastSetGridImportEdit_0", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private ValidateResult validateMustInput() {
        SalaryStandardEntryData entryData = SalaryStandardCacheHelper.getEntryData((String)this.getView().getFormShowParameter().getParentPageId());
        ValidateContext validateContext = new ValidateContext((Object)entryData);
        ValidatorTree validators = StdValidatorHelper.getMustValidatorTreeForContrast((ValidateContext)validateContext);
        ValidatorAdapter adpter = ValidatorAdapter.build((ValidateContext)validateContext, (ValidatorTree)validators);
        adpter.validate();
        List results = adpter.getValidateContext().getResults();
        return (ValidateResult)results.get(0);
    }

    private String conversionFormat(List<String> properties, String delimiter) {
        StringJoiner sj = new StringJoiner(delimiter, "", "");
        for (String property : properties) {
            sj.add(property);
        }
        return sj.toString();
    }

    protected void createTitle(SXSSFWorkbook wb, SXSSFSheet sheet, List<String> title) {
        CellStyle cellStyle = this.getAndSetXSSFCellStyleHeader(wb);
        int rownum = 0;
        SXSSFRow row = sheet.createRow(rownum);
        for (int j = 0; j < title.size(); ++j) {
            sheet.setColumnWidth(j, 6144);
            Cell cell = row.createCell(j);
            cell.setCellValue(title.get(j));
            cell.setCellStyle(cellStyle);
        }
    }

    protected CellStyle getAndSetXSSFCellStyleHeader(SXSSFWorkbook wb) {
        CellStyle cellStyle = wb.createCellStyle();
        Font headerFont = wb.createFont();
        headerFont.setBold(true);
        cellStyle.setFont(headerFont);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        return cellStyle;
    }

    private void createDataRows(SXSSFWorkbook wb, SXSSFSheet sheet, List<String[]> datas) {
        if (datas != null) {
            int index = 1;
            CellStyle style = null;
            for (String[] data : datas) {
                SXSSFRow row = sheet.createRow(index);
                int cellIndex = 0;
                for (String rowdata : data) {
                    if (style == null) {
                        style = wb.createCellStyle();
                        this.setBorderStyle(style);
                    }
                    Cell cell1 = row.createCell((int)((short)cellIndex));
                    cell1.setCellValue(rowdata);
                    cell1.setCellStyle(style);
                    ++cellIndex;
                }
                ++index;
            }
        }
    }

    private void setBorderStyle(CellStyle cellStyle) {
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
    }

    private Map<String, LocaleString> generateGradeRankMap() {
        LinkedHashMap<String, LocaleString> gradeRankMap = new LinkedHashMap<String, LocaleString>(4);
        gradeRankMap.put("dgff_begaingrade", ResManager.getLocaleString((String)"\u5f00\u59cb\u85aa\u7b49", (String)"ContrastSetGridImportEdit_3", (String)SWC_HCDM_FORMPLUGIN));
        gradeRankMap.put("dgff_begainrank", ResManager.getLocaleString((String)"\u5f00\u59cb\u85aa\u6863", (String)"ContrastSetGridImportEdit_4", (String)SWC_HCDM_FORMPLUGIN));
        gradeRankMap.put("dgff_endgrade", ResManager.getLocaleString((String)"\u7ed3\u675f\u85aa\u7b49", (String)"ContrastSetGridImportEdit_5", (String)SWC_HCDM_FORMPLUGIN));
        gradeRankMap.put("dgff_endrank", ResManager.getLocaleString((String)"\u7ed3\u675f\u85aa\u6863", (String)"ContrastSetGridImportEdit_6", (String)SWC_HCDM_FORMPLUGIN));
        return gradeRankMap;
    }

    private Map<String, LocaleString> generateGradeMap() {
        LinkedHashMap<String, LocaleString> gradeMap = new LinkedHashMap<String, LocaleString>(4);
        gradeMap.put("dgff_begaingrade", ResManager.getLocaleString((String)"\u5f00\u59cb\u85aa\u7b49", (String)"ContrastSetGridImportEdit_3", (String)SWC_HCDM_FORMPLUGIN));
        gradeMap.put("dgff_endgrade", ResManager.getLocaleString((String)"\u7ed3\u675f\u85aa\u7b49", (String)"ContrastSetGridImportEdit_5", (String)SWC_HCDM_FORMPLUGIN));
        return gradeMap;
    }

    private List<ContrastRowDataEntity> validateForImportContrastData(List<ContrastRowDataEntity> contrastDataOriginal, Map<String, Map<String, List<DynamicObject>>> colDynamic, Map<Integer, String> colIdMap, ProgressHandler processHandler, List<ContrastPropEntity> props, List<AppliedRangeEntity> applyRangeData, Long countryId) {
        if (CollectionUtils.isEmpty(contrastDataOriginal)) {
            return contrastDataOriginal;
        }
        boolean enableConstraintValidate = Boolean.parseBoolean(System.getProperty("swc_hcdm_enableConstaintValidateFormImport", "true"));
        if (!enableConstraintValidate) {
            processHandler.incrByProgress(contrastDataOriginal.size(), 0);
            log.info("swc_hcdm_enableConstaintValidateFormImport flag = false,not need validate constraint");
            return contrastDataOriginal;
        }
        log.info("-----\u300b validateForImportContrastData contrastDataList\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(contrastDataOriginal));
        Map propMap = props.stream().collect(Collectors.toMap(ContrastPropEntity::getPropConfigId, Function.identity()));
        log.info("-----\u300b\u5f85\u6821\u9a8c\u7684\u5bf9\u7167\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(contrastDataOriginal));
        Map<Long, Integer> propIndexMap = this.getPropIndexMap(props);
        this.setStdPropArrValue(contrastDataOriginal, propIndexMap, props);
        List resultList = new StandardTabConstrainManager().validateForContrastData(countryId, applyRangeData, props, contrastDataOriginal);
        ArrayList finalContrastDataEntities = Lists.newArrayListWithExpectedSize((int)contrastDataOriginal.size());
        for (int idx = 0; idx < contrastDataOriginal.size(); ++idx) {
            ContrastRowDataEntity excelContrastRowEntity = contrastDataOriginal.get(idx);
            Integer excelRowIndex = excelContrastRowEntity.getRowIndex();
            List resultListOriginal = (List)resultList.get(idx);
            boolean validateErrorTag = false;
            StringBuilder sb = new StringBuilder();
            if (CollectionUtils.isNotEmpty((Collection)resultListOriginal)) {
                sb.append(ResManager.getLocaleString((String)"\u5bfc\u5165\u7684\u6570\u636e", (String)"ContrastSetGridImportEdit_24", (String)SWC_HCDM_FORMPLUGIN));
                HashSet rangeStrList = Sets.newHashSetWithExpectedSize((int)resultListOriginal.size());
                StringJoiner sj = new StringJoiner("\u3001");
                for (ConstraintValidateResult validateResult : resultListOriginal) {
                    List notMatchPkIds = validateResult.getNotMatchPkIds();
                    if (CollectionUtils.isNotEmpty((Collection)notMatchPkIds)) {
                        validateErrorTag = true;
                    }
                    Long propConfigId = validateResult.getPropConfigId();
                    ContrastPropEntity contrastPropEntity = (ContrastPropEntity)propMap.get(propConfigId);
                    String name = contrastPropEntity.getPropConfigEntity().getName();
                    DynamicFieldIdGenerationParamForTabular idGenParam = new DynamicFieldIdGenerationParamForTabular("dgdf", SalaryStdGridDisplayTypeEnum.TABULAR, "mulbasedatafield", contrastPropEntity.getPropConfigId());
                    Map<String, List<DynamicObject>> stringListMap = colDynamic.get(idGenParam.generateKey());
                    HashMap pkIdsMap = Maps.newHashMapWithExpectedSize((int)stringListMap.size());
                    for (Map.Entry<String, List<DynamicObject>> stringMap : stringListMap.entrySet()) {
                        List<DynamicObject> objs = stringMap.getValue();
                        for (DynamicObject obj : objs) {
                            pkIdsMap.put(obj.getLong("id"), stringMap.getKey());
                        }
                    }
                    for (Long notMatchPkId : notMatchPkIds) {
                        String value = (String)pkIdsMap.get(notMatchPkId);
                        sj.add(name + ":" + value);
                    }
                    rangeStrList.addAll(validateResult.getRelationNodeName());
                }
                String tips = ResManager.loadKDString((String)"{0}\uff0c\u4e0d\u5728\u5bf9\u5e94\u7684\u5bf9\u7167\u5c5e\u6027\uff08{1}\uff09\u7684\u7b5b\u9009\u6761\u4ef6\u8303\u56f4\u5185\u3002", (String)"ContrastSetGridImportEdit_14", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[]{sj.toString(), String.join((CharSequence)"\u3001", rangeStrList)});
                sb.append(tips);
            }
            if (validateErrorTag) {
                processHandler.putRowError(excelRowIndex, sb.toString());
                processHandler.incrByProgress(0, 1);
                continue;
            }
            finalContrastDataEntities.add(excelContrastRowEntity);
            processHandler.incrByProgress(1, 0);
        }
        return finalContrastDataEntities;
    }

    private void setStdPropArrValue(List<ContrastRowDataEntity> contrastDataOriginal, Map<Long, Integer> propIndexMap, List<ContrastPropEntity> props) {
        for (ContrastRowDataEntity entity : contrastDataOriginal) {
            Map valueMap = entity.getStdPropValueMap();
            ArrayList valueArr = Lists.newArrayListWithExpectedSize((int)propIndexMap.size());
            for (int i = 0; i < props.size(); ++i) {
                Long propConfigId = props.get(i).getPropConfigId();
                valueArr.add(valueMap.getOrDefault(propConfigId, Collections.emptyList()));
            }
            entity.setStdContrastArrValue((List)valueArr);
        }
    }

    private Map<Long, Integer> getPropIndexMap(List<ContrastPropEntity> props) {
        HashMap propIndexMap = Maps.newHashMapWithExpectedSize((int)props.size());
        for (int i = 0; i < props.size(); ++i) {
            propIndexMap.put(props.get(i).getPropConfigId(), i);
        }
        return propIndexMap;
    }

    private Map<Long, Map<String, List<Long>>> fetchPkIdWithNameGroup(Map<String, Map<String, List<DynamicObject>>> colDynamic, List<ContrastPropEntity> props) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)props.size());
        for (ContrastPropEntity propEntity : props) {
            String fieldKey = new DynamicFieldIdGenerationParamForTabular("dgdf", SalaryStdGridDisplayTypeEnum.TABULAR, "mulbasedatafield", propEntity.getPropConfigId()).generateKey();
            Map valueMap = resultMap.computeIfAbsent(propEntity.getPropConfigId(), v1 -> Maps.newHashMap());
            Map<String, List<DynamicObject>> valueToObjs = colDynamic.get(fieldKey);
            if (valueToObjs == null) continue;
            for (Map.Entry<String, List<DynamicObject>> entry : valueToObjs.entrySet()) {
                List pkIds = entry.getValue().stream().map(o1 -> o1.getLong("id")).collect(Collectors.toList());
                valueMap.putIfAbsent(entry.getKey(), pkIds);
            }
        }
        return resultMap;
    }

    @Deprecated
    private Map<Integer, List<ContrastRowDataEntity>> splitContrastRowBySameName(List<ContrastRowDataEntity> contrastDataOriginal, Map<String, Map<String, List<DynamicObject>>> colDynamic, List<ContrastPropEntity> props) {
        return null;
    }

    @Deprecated
    private List<List<ConstraintValidateResult>> mergeResultAndData(List<ContrastRowDataEntity> contrastDataOriginal, Map<Integer, List<ContrastRowDataEntity>> contrastRowMapAfterSplit, Map<Integer, List<List<ConstraintValidateResult>>> resultRowMap) {
        return null;
    }

    private QFilter getCalcConstraintQFilter(ContrastPropEntity contrastPropEntity, List<AppliedRangeEntity> applyRangeData, Long countryId) {
        Long propConfigId = contrastPropEntity.getPropConfigId();
        log.info("\u5f53\u524d\u64cd\u4f5c\u7684\u5bf9\u7167\u5c5e\u6027\u914d\u7f6eid \uff1a {}", (Object)propConfigId);
        ArrayList props = Lists.newArrayList((Object[])new ContrastPropEntity[]{contrastPropEntity});
        ContrastRowDataEntity contrastRowDataEntity = new ContrastRowDataEntity();
        contrastRowDataEntity.setStdContrastArrValue((List)Lists.newArrayList((Object[])new List[props.size()]));
        ConstraintResult constraintResult = this.constrainManager.calcConstraintForContrastProp(countryId, applyRangeData, (List)props, contrastRowDataEntity, propConfigId);
        return constraintResult.getConstraintFilter();
    }

    private ContrastSetImportContext getImportContext(EntryImportContext importContext) {
        ContrastSetImportContext context;
        Map extParams = importContext.getExtParams();
        if (extParams == null) {
            importContext.setExtParams((Map)Maps.newHashMapWithExpectedSize((int)16));
        }
        if ((context = (ContrastSetImportContext)importContext.getExtParams().get("ContrastSetGridImportContext")) == null) {
            context = new ContrastSetImportContext(this);
            importContext.getExtParams().put("ContrastSetGridImportContext", context);
        }
        return context;
    }
}

