/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.salarystandard;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropConfigEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdGridDisplayTypeEnum;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hcdm.common.entity.salarystandard.DynamicFieldIdGenerationParamForTabular;
import kd.swc.hcdm.formplugin.salarystandard.ContrastSetGridImportEdit;
import kd.swc.hsbp.business.export.SWCExportEntryHelper;
import kd.swc.hsbp.business.imports.perm.IPermissionHandler;
import kd.swc.hsbp.common.entity.EntryColumnContainer;
import kd.swc.hsbp.common.entity.EntryColumnWrapper;
import org.apache.commons.collections.CollectionUtils;

public class ContrastSetImportContext {
    private ContrastSetGridImportEdit importEdit;
    private SalaryStandardEntryData stdData;
    private Map<String, KeyValue> captions;
    private HashMap<String, IPermissionHandler> customQFilterHandlerMap;
    private Map<String, Long> stdPropKeyMap;

    public ContrastSetImportContext(ContrastSetGridImportEdit importEdit) {
        this.importEdit = importEdit;
    }

    public SalaryStandardEntryData getStdData() {
        if (this.stdData == null) {
            IDataModel mainModel = this.importEdit.getView().getParentView().getModel();
            this.stdData = EntityConverter.fetchEntityFromModelWithEntryName((DynamicObject)mainModel.getDataEntity(true), (String[])new String[]{"appliedrange", "contrastps", "salarygrade", "salaryrank"});
        }
        return this.stdData;
    }

    public Map<String, KeyValue> getCaptions() {
        if (this.captions == null) {
            EntryColumnWrapper wrapper = SWCExportEntryHelper.readEntryColumnInfo((IFormView)this.importEdit.getView(), (String)"entryentity");
            SalaryStandardEntryData stdDataEntity = this.getStdData();
            boolean isUseSalaryRank = stdDataEntity.getStdBaseEntity().isUseSalaryRank();
            List<EntryColumnContainer> splitEntryColumns = this.importEdit.createEntryColumnList(stdDataEntity.getStdBaseEntity().getType(), isUseSalaryRank);
            List<EntryColumnContainer> containers = this.importEdit.replaceEntryColumnContainer(wrapper.getContainers(), splitEntryColumns);
            List<EntryColumnContainer> entryColumnContainers = this.importEdit.addEntryColumnContainer(containers);
            Set ignoreSet = SWCExportEntryHelper.getIgnoreColumnByFeatures((DataEntityPropertyCollection)this.importEdit.getView().getModel().getEntryEntity("entryentity").getDynamicObjectType().getProperties(), (boolean)true);
            SWCExportEntryHelper.removeIgnoreColumn(entryColumnContainers, (Set)ignoreSet);
            this.captions = SWCExportEntryHelper.getEntryFieldCaptions(entryColumnContainers);
        }
        return this.captions;
    }

    public HashMap<String, IPermissionHandler> getCustomQFilterHandlerMap() {
        if (this.customQFilterHandlerMap == null) {
            List<ContrastPropConfigEntity> props = this.stdData.getContrastPropEntities().stream().map(ContrastPropEntity::getPropConfigEntity).collect(Collectors.toList());
            Map<Long, List<QFilter>> customFilter = this.importEdit.getQFilterWithExtForImportValidate(props);
            HashMap customQFilterHandlerMap = Maps.newHashMapWithExpectedSize((int)props.size());
            HashMap stdPropKeyMap = Maps.newHashMapWithExpectedSize((int)props.size());
            for (ContrastPropConfigEntity prop : props) {
                List<QFilter> customQFilter = customFilter.get(prop.getId());
                String excelFieldKey = new DynamicFieldIdGenerationParamForTabular("dgdf", SalaryStdGridDisplayTypeEnum.TABULAR, "mulbasedatafield", prop.getId()).generateKey();
                if (CollectionUtils.isNotEmpty(customQFilter)) {
                    customQFilterHandlerMap.put(excelFieldKey, () -> customQFilter.toArray(new QFilter[0]));
                }
                stdPropKeyMap.put(excelFieldKey, prop.getId());
            }
            this.stdPropKeyMap = stdPropKeyMap;
            this.customQFilterHandlerMap = customQFilterHandlerMap;
        }
        return this.customQFilterHandlerMap;
    }

    public Map<String, Long> getStdPropKeyMap() {
        if (this.stdPropKeyMap == null) {
            this.getCustomQFilterHandlerMap();
        }
        return this.stdPropKeyMap;
    }
}

