/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.salarystandard;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.swc.hcdm.common.stdtab.ContrastDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.swc.hcdm.business.salarystandard.ContrastDataHelper;
import kd.swc.hcdm.business.salarystandard.ContrastRelationSettingGridHelper;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hcdm.business.salarystandard.SalaryStandardPageInteractionHelper;
import kd.swc.hcdm.business.salarystandard.StdValidatorHelper;
import kd.swc.hcdm.business.salarystandard.constraint.DeleteResult;
import kd.swc.hcdm.business.salarystandard.constraint.StandardTabConstrainManager;
import kd.swc.hcdm.business.validator.ValidatorAdapter;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidatorTree;
import kd.swc.hcdm.common.entity.salarystandard.ContrastDataOutbound;
import kd.swc.hcdm.formplugin.salarystandard.AbstractSalaryStandardEdit;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;

public class SalaryStandardContrastRelationSettingEdit
extends AbstractSalaryStandardEdit {
    private static final Log logger = LogFactory.getLog(SalaryStandardContrastRelationSettingEdit.class);
    private static final String CONFIRM_CALLBACKID_ISDELETE_CONTRASTPS = "confirm_callbackid_isdeleteContrastps";
    private static final String CLOSECALLBACK_ACTIONID_OBJECTTYPEF7 = "closecallback_actionid_objecttypef7";
    private static final String CALBACKID_STDGRADERANKFORM = "calbackid_stdgraderankform";
    private static final String CALLBACKID_NONECONTRASTDATA = "calbackid_nonecontrastdata";
    private static final String JOBSCM_FIELD_KEY = "jobscm";
    private static final String JOBSCM_FLEX_KEY = "jobscmflex";

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "confirm_callbackid_isdeleteContrastps": {
                this.setContrastpsAfterConfirm(event);
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs evt) {
        String propertyName;
        super.propertyChanged(evt);
        switch (propertyName = evt.getProperty().getName()) {
            case "jobscm": {
                super.openContrastSetGrid();
                break;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "donothing_addcontrastps": {
                this.openContrastpsF7();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        switch (actionId = event.getActionId()) {
            case "closecallback_actionid_objecttypef7": {
                this.confirmToSetContrastps(event);
                break;
            }
            case "calbackid_nonecontrastdata": {
                this.confirmIsContinue(event);
                break;
            }
        }
    }

    @Deprecated
    private void updateGradeRankToContrastps() {
    }

    private void setContrastpsAfterConfirm(MessageBoxClosedEvent event) {
        MessageBoxResult result = event.getResult();
        if (MessageBoxResult.Yes.equals((Object)result) || MessageBoxResult.OK.equals((Object)result)) {
            List<Long> oldIds = this.getAllContrastpsIds();
            DynamicObjectCollection tempContrastps = (DynamicObjectCollection)this.getModel().getValue("tempcontrastps");
            MulBasedataProp prop = new MulBasedataProp();
            List cols = prop.getRefBasedataPkValues(tempContrastps);
            ArrayList<Long> newIds = new ArrayList<Long>(cols.size());
            cols.forEach(id -> newIds.add((Long)id));
            this.doUpdateContrastps(newIds, oldIds);
        }
        this.getModel().setValue("tempcontrastps", null);
    }

    private void confirmToSetContrastps(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData instanceof ListSelectedRowCollection) {
            String confirmMsg = ResManager.loadKDString((String)"\u5220\u9664\u540e\uff0c\u5bf9\u5e94\u5c5e\u6027\u5217\u53ca\u6240\u586b\u5145\u7684\u5c5e\u6027\u503c\u5c06\u540c\u6b65\u5220\u9664\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"SalaryStandardContrastRelationSettingEdit_2", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
            List<Long> oldIds = this.getAllContrastpsIds();
            List<Long> newIds = this.getReturnDataIds((ListSelectedRowCollection)returnData);
            this.getModel().setValue("tempcontrastps", (Object)newIds.toArray());
            if (newIds.containsAll(oldIds)) {
                this.doUpdateContrastps(newIds, oldIds);
            } else {
                this.getView().showConfirm(confirmMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CALLBACKID_ISDELETE_CONTRASTPS));
            }
        }
    }

    private void doUpdateContrastps(List<Long> newIds, List<Long> oldIds) {
        DeleteResult deleteResult;
        ArrayList addIds = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList<Long> delIds = new ArrayList<Long>(oldIds);
        for (Long newId : newIds) {
            if (delIds.contains(newId)) {
                delIds.remove(newId);
                continue;
            }
            addIds.add(newId);
        }
        if (!CollectionUtils.isEmpty(delIds) && (deleteResult = this.beforeDeleteContrastps(delIds)) != null) {
            this.doDeleteContrastData(deleteResult);
        }
        this.updateContrastpsToEnt(addIds, delIds);
        this.drawContrastRelationLabel();
        this.openContrastSetGrid();
    }

    private void updateContrastpsToEnt(List<Long> addIds, List<Long> delIds) {
        String entryEntityName = "contrastps";
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        if (!delIds.isEmpty()) {
            SalaryStandardPageInteractionHelper.deleteContrastpsEnt((IFormView)this.getView(), delIds);
        }
        if (!addIds.isEmpty()) {
            SalaryStandardPageInteractionHelper.batchAddNewdeleteContrastpsEnt((AbstractFormDataModel)model, addIds);
        }
        SalaryStandardPageInteractionHelper.resetContrastpsIndex((DynamicObjectCollection)this.getModel().getDataEntity(true).getDynamicObjectCollection(entryEntityName));
        this.getView().updateView(entryEntityName);
        this.getView().updateView("contrastsumdata");
    }

    private void openContrastpsF7() {
        List<Long> allContrastpsIds = this.getAllContrastpsIds();
        if (allContrastpsIds != null) {
            Object[] pkIds = allContrastpsIds.toArray();
            ListShowParameter f7 = this.getF7("hcdm_contrastpropconf", pkIds, this.getIgnoreContsFilter());
            f7.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_ACTIONID_OBJECTTYPEF7));
            this.getView().showForm((FormShowParameter)f7);
        }
    }

    private List<QFilter> getIgnoreContsFilter() {
        return Collections.emptyList();
    }

    @Deprecated
    private void updateAllContrastpsDataEnt() {
    }

    @Override
    protected int getIndex() {
        return 3;
    }

    @Override
    protected void initPage() {
        this.drawContrastRelationLabel();
        this.resetContrastRowIndex();
        this.openContrastSetGrid();
    }

    private void resetContrastRowIndex() {
        DynamicObjectCollection contrastsumdata = this.getModel().getEntryEntity("contrastsumdata");
        boolean hasReset = false;
        for (int i = 0; i < contrastsumdata.size(); ++i) {
            DynamicObject row = (DynamicObject)contrastsumdata.get(i);
            if (row.getInt("sumrowindex") == i) continue;
            row.set("sumrowindex", (Object)i);
            hasReset = true;
        }
        if (hasReset) {
            this.getModel().updateEntryCache(contrastsumdata);
        }
    }

    @Override
    protected void doBeforeSave(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        SalaryStandardEntryData tab = EntityConverter.fetchEntityFromModel((DynamicObject)dataEntity);
        ValidateContext validateContext = new ValidateContext((Object)tab);
        ValidatorTree tree = StdValidatorHelper.getMustValidatorTreeForContrast((ValidateContext)validateContext);
        ValidatorAdapter adapter = ValidatorAdapter.build((ValidateContext)validateContext, (ValidatorTree)tree);
        adapter.validate();
        List results = adapter.getValidateContext().getResults();
        this.showErrorResults(results, args);
        if (!args.cancel) {
            boolean rowCountChanged;
            List rowDatas = tab.getContrastRowEntities();
            int oldRowCount = rowDatas.size();
            List mergeResult = ContrastDataHelper.mergeContrastData((List)rowDatas, (List)tab.getContrastPropEntities());
            ContrastRelationSettingGridHelper.updateToParentEntry((List)mergeResult, (IFormView)this.getView(), (boolean)true);
            tab.buildContrastRowData(mergeResult);
            boolean bl = rowCountChanged = mergeResult.size() != oldRowCount;
            if (rowCountChanged) {
                this.openContrastSetGrid();
            }
        }
    }

    @Override
    protected void veriDataIntegrityInCurrentPage(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        SalaryStandardEntryData entryData = EntityConverter.fetchEntityFromModel((DynamicObject)dataEntity);
        ValidateContext validateContext = new ValidateContext((Object)entryData);
        ValidatorTree tree = StdValidatorHelper.getValidatorTreeForContrast((ValidateContext)validateContext);
        ValidatorAdapter adapter = ValidatorAdapter.build((ValidateContext)validateContext, (ValidatorTree)tree);
        adapter.validate();
        List results = adapter.getValidateContext().getResults();
        this.showErrorResults(results, args);
    }

    @Override
    protected void doRefreshChildPage(AfterDoOperationEventArgs args) {
        this.drawContrastRelationLabel();
        this.openContrastSetGrid();
    }

    private DeleteResult beforeDeleteContrastps(List<Long> delIds) {
        if (CollectionUtils.isEmpty(delIds)) {
            return null;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        SalaryStandardEntryData tabObj = EntityConverter.fetchEntityFromModelWithEntryName((DynamicObject)dataEntity, (String[])new String[]{"appliedrange", "contrastps", "contrastsumdata"});
        StandardTabConstrainManager constrainManager = new StandardTabConstrainManager();
        DeleteResult deleteResult = constrainManager.calcDeleteByRemovedContrastProp(tabObj.getStdBaseEntity().getCountryId(), tabObj.getAppliedRangeEntities(), tabObj.getContrastPropEntities(), tabObj.getContrastRowEntities(), delIds);
        logger.info("calcDeleteByRemovedContrastProp result: deleteResult = {}", (Object)JSON.toJSONString((Object)deleteResult));
        return deleteResult;
    }

    private void doDeleteContrastps(DeleteResult deleteResult) {
    }

    @Deprecated
    private void postEntryData(List<ContrastDataEntity> contrastDataEntities) {
    }

    private ContrastDataOutbound fetchEntryData(List<ContrastDataEntity> contrastDataEntities) {
        String contrastSetGridViewPageId = this.getView().getPageCache().get("contrastsetgridview_page_id");
        DynamicObjectCollection rows = this.getView().getView(contrastSetGridViewPageId).getModel().getEntryEntity("entryentity");
        if (rows.size() == 0) {
            contrastDataEntities = Collections.emptyList();
        }
        ContrastDataOutbound contrastDataOutbound = new ContrastDataOutbound();
        contrastDataOutbound.getDataList().addAll(contrastDataEntities);
        return contrastDataOutbound;
    }

    @Override
    protected void showWarningConfirmForm(List<String> allWarningMsg, BeforeDoOperationEventArgs args) {
        FormShowParameter operationResultParameter = SWCShowFormServiceHelper.getOperationConfirmParameter((CloseCallBack)new CloseCallBack((IFormPlugin)this, CALLBACKID_NONECONTRASTDATA), (String)ResManager.loadKDString((String)"\u8bbe\u7f6e\u5bf9\u7167\u5173\u7cfb", (String)"SalaryStandardContrastRelationSettingEdit_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u8bbe\u7f6e\u5bf9\u7167\u5173\u7cfb\u5b58\u5728\u672a\u586b\u5199\u5185\u5bb9\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SalaryStandardContrastRelationSettingEdit_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), allWarningMsg, (boolean)true);
        this.getView().showForm(operationResultParameter);
    }
}

