/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.salarystandard;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.sdk.swc.hcdm.common.stdtab.SalaryItemLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardCacheHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardPageInteractionHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.business.salarystandard.StdValidatorHelper;
import kd.swc.hcdm.business.validator.ValidatorAdapter;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.business.validator.bean.ValidatorTree;
import kd.swc.hcdm.business.vo.salarystandard.SalaryStandardEntryEntityVO;
import kd.swc.hcdm.formplugin.salarystandard.AbstractSalaryStandardEdit;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.ListUtils;

public class SalaryStandardDesignEdit
extends AbstractSalaryStandardEdit {
    private static final String TEMP_ITEMS = "tempitems";
    private static final String SALARYCOUNTAMOUNT = "salarycountamount";
    private static final String AP_BASEINFO_CFG = "baseinfocfgap";
    private static final String LBL_SETRANKITEM = "setrankitem";
    private static final String LBL_SETCOUNTITEM = "setcountitem";
    private static final String BIZTYPE_SALARY = "1";
    private static final String CONFIRM_CALLBACKID_ISDELETEITEM = "confirm_callbackid_isdeleteitem";
    private static final String CONFIRM_CALLBACKID_ISCHANGETYPE = "confirm_callbackid_ischangetype";
    private static final String CLOSECALLBACK_ACTIONID_SALARYITEMF7 = "closecallback_actionId_salaryItemF7";
    private static final String CLOSECALLBACK_ACTIONID_SALARYCOUNTITEMF7 = "closecallback_actionid_salarycountitemf7";
    private static final String CLOSECALLBACK_ACTIONID_SALARYRANKITEMF7 = "closecallback_actionid_salaryrankitemf7";
    private static final String CALLBACKID_HASEMPTYSTDSET = "callbackid_hasemptystdset";

    @Override
    protected int getIndex() {
        return 2;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "donothing_calcandsave": {
                this.doBeforeCal(args);
                break;
            }
            case "confirmchange": {
                if (args.isCancel()) break;
                this.doBeforeSave(args);
                break;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "donothing_addsalaryitem": {
                this.openSalaryItemF7();
                break;
            }
            case "donothing_calcandsave": {
                this.doStdGridCalc(false, this.getView());
                break;
            }
        }
    }

    @Override
    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"setsalarygrade", "setsalaryrank", LBL_SETRANKITEM, LBL_SETCOUNTITEM});
    }

    @Override
    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName;
        super.propertyChanged(args);
        switch (propertyName = args.getProperty().getName()) {
            case "isusesalaryrank": {
                this.isUseSalaryRank(false);
                this.updateBaseSummary();
                this.openSalaryStandardSettingGrid();
                break;
            }
            case "isusesalarycount": {
                this.isUseSalaryCount(false);
                this.openSalaryStandardSettingGrid();
                break;
            }
            case "salarycountamount": {
                this.doStdGridCalc(true, this.getView());
                break;
            }
            case "type": {
                this.confirmToChangeType();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "setsalarygrade": {
                this.showSetSalaryGradeForm();
                break;
            }
            case "setsalaryrank": {
                this.showSetSalaryRankForm();
                break;
            }
            case "setrankitem": {
                this.openSalaryRankItemF7();
                break;
            }
            case "setcountitem": {
                this.openSalaryCountItemF7();
                break;
            }
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.isUseSalaryRank(true);
        this.isUseSalaryCount(true);
        this.setGradeCountInfo();
        this.setRankCountInfo();
        this.getModel().setDataChanged(false);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "confirm_callbackid_isdeleteitem": {
                this.itemAfterConfirm(event);
                break;
            }
            case "confirm_callbackid_ischangetype": {
                this.typeAfterConfirm(event);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "closecallback_actionId_salaryItemF7": {
                this.confirmToSetItem(event);
                break;
            }
            case "closecallback_actionid_setsalarygrade": {
                this.setSalaryGrade(event);
                break;
            }
            case "closecallback_actionid_setsalaryrank": {
                this.setSalaryRank(event);
                break;
            }
            case "closecallback_actionid_salaryrankitemf7": {
                this.setSalaryRankItem(event);
                break;
            }
            case "closecallback_actionid_salarycountitemf7": {
                this.setSalaryCountItem(event);
                break;
            }
            case "callbackid_hasemptystdset": {
                this.confirmIsContinue(event);
                break;
            }
        }
    }

    private void limitDataTotal(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)returnData;
        } else if (returnData instanceof SalaryStandardEntryEntityVO) {
            SalaryStandardEntryEntityVO salaryStandardEntryEntityVO = (SalaryStandardEntryEntityVO)returnData;
        }
    }

    private void setSalaryCountItem(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData instanceof ListSelectedRowCollection) {
            List<Long> salaryItemIds = this.getReturnDataIds((ListSelectedRowCollection)returnData);
            DynamicObjectCollection salaryStdItems = this.getModel().getEntryEntity("salarystditem");
            for (DynamicObject salaryStdItem : salaryStdItems) {
                String itemlabel = salaryStdItem.getString("itemlabel");
                if (!SWCStringUtils.equals((String)SalaryItemLabelEnum.STANDARD.name(), (String)itemlabel)) continue;
                long salaryItemId = salaryStdItem.getLong("salaryitem.id");
                if (salaryItemIds.contains(salaryItemId)) {
                    salaryStdItem.set("itemisusesalarycount", (Object)Boolean.TRUE);
                    continue;
                }
                salaryStdItem.set("itemisusesalarycount", (Object)Boolean.FALSE);
            }
            this.getView().updateView("salarystditem");
            this.drawSalaryCountItemLabel();
            this.openSalaryStandardSettingGrid();
        }
    }

    private void setSalaryRankItem(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData instanceof ListSelectedRowCollection) {
            List<Long> salaryItemIds = this.getReturnDataIds((ListSelectedRowCollection)returnData);
            DynamicObjectCollection salaryStdItems = this.getModel().getEntryEntity("salarystditem");
            ArrayList delDataItemIds = Lists.newArrayListWithExpectedSize((int)salaryStdItems.size());
            SalaryStandardPageInteractionHelper.setSalaryRankItem(salaryItemIds, (DynamicObjectCollection)salaryStdItems, (List)delDataItemIds);
            List<SalaryRankEntity> allRankEntity = this.getAllRankFromModel();
            SalaryRankEntity minStandardRank = GradeRankHelper.getMinStandardRank(allRankEntity);
            long firstRankId = minStandardRank == null ? 0L : minStandardRank.getRankIdentity();
            List specialRankIds = GradeRankHelper.fetchSpecialRank(allRankEntity).stream().map(SalaryRankEntity::getRankIdentity).collect(Collectors.toList());
            ArrayList retainRankIds = Lists.newArrayListWithExpectedSize((int)10);
            retainRankIds.addAll(specialRankIds);
            if (firstRankId != 0L) {
                retainRankIds.add(firstRankId);
            }
            DynamicObjectCollection salaryStdDatas = this.getModel().getDataEntity(true).getDynamicObjectCollection("salarystddata_a");
            String gradeRankSeqMapStr = this.getModel().getDataEntity().getString("graderankseqmap");
            SalaryStandardPageInteractionHelper.deleteStdUseRankData((DynamicObjectCollection)salaryStdDatas, (List)retainRankIds, (List)delDataItemIds, (String)gradeRankSeqMapStr);
            this.getView().updateView("salarystddata_a");
            this.getView().updateView("salarystditem");
            this.drawRankItemLabel();
            this.setRankCountInfo();
            this.openSalaryStandardSettingGrid();
        }
    }

    private void setSalaryGrade(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData instanceof SalaryStandardEntryEntityVO) {
            SalaryStandardEntryEntityVO returnVo = (SalaryStandardEntryEntityVO)returnData;
            this.updateSalaryGradeToEnt(returnVo);
            this.setGradeCountInfo();
            this.updateBaseSummary();
        }
    }

    private void setSalaryRank(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData instanceof SalaryStandardEntryEntityVO) {
            SalaryStandardEntryEntityVO returnVo = (SalaryStandardEntryEntityVO)returnData;
            this.updateSalaryRankToEnt(returnVo);
            this.drawRankItemLabel();
            this.setRankCountInfo();
            this.updateBaseSummary();
        }
    }

    private void updateSalaryGradeToEnt(SalaryStandardEntryEntityVO entityVo) {
        List entityList = entityVo.getSalaryStandardEntryEntities();
        HashMap entityMap = new HashMap(entityList.size());
        ArrayList addNewEntityList = Lists.newArrayListWithExpectedSize((int)10);
        SalaryStandardPageInteractionHelper.setNewListAndUpdateMap((List)entityList, (List)addNewEntityList, entityMap);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        SalaryStandardPageInteractionHelper.updateSalaryGradeToEnt((AbstractFormDataModel)model, (List)addNewEntityList, entityMap);
        this.getView().updateView("salarygrade");
        this.getView().updateView("salarystddata_a");
        this.getView().updateView("contrastsumdata");
        this.cacheEntryData(this.getView());
        this.refreshGridByInvokeAction(this.getView());
    }

    private void updateSalaryRankToEnt(SalaryStandardEntryEntityVO entityVO) {
        List entityList = entityVO.getSalaryStandardEntryEntities();
        HashMap entityMap = new HashMap(entityList.size());
        ArrayList addNewEntityList = Lists.newArrayListWithExpectedSize((int)10);
        SalaryStandardPageInteractionHelper.setNewListAndUpdateMap((List)entityList, (List)addNewEntityList, entityMap);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        SalaryStandardPageInteractionHelper.updateSalaryRankToEnt((AbstractFormDataModel)model, (List)addNewEntityList, entityMap);
        this.getView().updateView("salaryrank");
        this.getView().updateView("salarystddata_a");
        this.getView().updateView("contrastsumdata");
        this.cacheEntryData(this.getView());
        this.refreshGridByInvokeAction(this.getView());
    }

    private void confirmToSetItem(ClosedCallBackEvent event) {
        String confirmMsg = ResManager.loadKDString((String)"\u5220\u9664\u5b9a\u8c03\u85aa\u9879\u76ee\uff0c\u5c06\u540c\u6b65\u5220\u9664\u5bf9\u5e94\u6807\u51c6\u8868\u5df2\u586b\u5145\u7684\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SalaryStandardDesignEdit_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        List<SalaryStdItemEntity> salaryStdItemList = this.getStandardItemEntityList();
        List oldItems = SalaryStdItemHelper.getAllSalaryItemIds(salaryStdItemList);
        Object returnData = event.getReturnData();
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            List<Long> newItems = this.getReturnDataIds((ListSelectedRowCollection)returnData);
            this.getModel().setValue(TEMP_ITEMS, (Object)newItems.toArray());
            if (!newItems.containsAll(oldItems)) {
                this.getView().showConfirm(confirmMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CALLBACKID_ISDELETEITEM));
                List delIds = ListUtils.subtract((List)oldItems, newItems);
                if (SWCListUtils.isEmpty((List)delIds)) {
                    return;
                }
                this.getView().showConfirm(confirmMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CALLBACKID_ISDELETEITEM));
            } else {
                this.doUpdateSalaryItems(newItems, oldItems);
            }
        }
    }

    private void confirmToChangeType() {
        String confirmMsg = ResManager.loadKDString((String)"\u5207\u6362\u7c7b\u578b\uff0c\u5c06\u540c\u6b65\u5220\u9664\u5bf9\u5e94\u6807\u51c6\u8868\u5df2\u586b\u5145\u7684\u6570\u636e\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"SalaryStandardDesignEdit_6", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(confirmMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CALLBACKID_ISCHANGETYPE));
    }

    private void itemAfterConfirm(MessageBoxClosedEvent event) {
        MessageBoxResult result = event.getResult();
        if (MessageBoxResult.Yes.equals((Object)result) || MessageBoxResult.OK.equals((Object)result)) {
            List<SalaryStdItemEntity> salaryStdItemList = this.getStandardItemEntityList();
            List oldItems = SalaryStdItemHelper.getAllSalaryItemIds(salaryStdItemList);
            DynamicObjectCollection tempitems = (DynamicObjectCollection)this.getModel().getValue(TEMP_ITEMS);
            MulBasedataProp prop = new MulBasedataProp();
            List cols = prop.getRefBasedataPkValues(tempitems);
            List<Long> newItems = cols.stream().map(o1 -> (Long)o1).collect(Collectors.toList());
            this.doUpdateSalaryItems(newItems, oldItems);
        }
        this.getModel().setValue(TEMP_ITEMS, null);
    }

    private void typeAfterConfirm(MessageBoxClosedEvent event) {
        MessageBoxResult result = event.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.clearTypeRelationInfo();
            this.initPage();
        } else if (MessageBoxResult.Cancel.equals((Object)result)) {
            SalaryStandardEntryData entryData = SalaryStandardCacheHelper.getEntryData((String)this.getView().getPageId());
            this.getModel().beginInit();
            this.getModel().setValue("type", (Object)entryData.getStdBaseEntity().getType().getCode());
            this.getModel().endInit();
            this.getView().updateView("type");
        }
    }

    private void doUpdateSalaryItems(List<Long> newItems, List<Long> oldItems) {
        ArrayList<Long> addItems = new ArrayList<Long>(newItems);
        ArrayList<Long> delItems = new ArrayList<Long>(oldItems);
        delItems.removeAll(newItems);
        addItems.removeAll(oldItems);
        this.updateItemToEnt(addItems, delItems);
        this.updateBaseSummary();
        this.drawAllItemLabel();
        this.drawRankItemLabel();
        this.drawSalaryCountItemLabel();
        this.cacheEntryData(this.getView());
        this.refreshGridByInvokeAction(this.getView());
    }

    private void updateItemToEnt(List<Long> addItems, List<Long> delItems) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        if (!delItems.isEmpty()) {
            SalaryStandardPageInteractionHelper.deleteItemEnt((AbstractFormDataModel)model, delItems);
        }
        if (!addItems.isEmpty()) {
            SalaryStandardPageInteractionHelper.batchAddNewSalaryStdItems((AbstractFormDataModel)model, addItems);
        }
        SalaryStandardPageInteractionHelper.resetSalaryStdItemsIndex((DynamicObjectCollection)this.getModel().getDataEntity(true).getDynamicObjectCollection("salarystditem"));
        this.getView().updateView("salarystditem");
        this.getView().updateView("salarystddata_a");
    }

    private void openSalaryItemF7() {
        List<SalaryStdItemEntity> salaryStdItemList = this.getStandardItemEntityList();
        List allSalaryItemIds = SalaryStdItemHelper.getAllSalaryItemIds(salaryStdItemList);
        Object[] pkIds = allSalaryItemIds.toArray();
        List<QFilter> filters = this.getSalaryItemFilters();
        ListShowParameter f7 = this.getBaseDataF7("hsbs_standarditem", pkIds, filters, true);
        f7.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_ACTIONID_SALARYITEMF7));
        f7.setFormId("hsbs_standarditemf7list");
        f7.setCustomParam("salarystditem", (Object)"true");
        f7.setCustomParam("salarygradecount", (Object)String.valueOf(this.getModel().getEntryRowCount("salarygrade")));
        f7.setCustomParam("salaryrankcount", (Object)String.valueOf(this.getModel().getEntryRowCount("salaryrank")));
        this.getView().showForm((FormShowParameter)f7);
    }

    private void openSalaryRankItemF7() {
        List<SalaryStdItemEntity> salaryStdItemList = this.getStandardItemEntityList();
        List useRankSalaryItemIds = SalaryStdItemHelper.getUseRankSalaryItemIds(salaryStdItemList);
        if (useRankSalaryItemIds != null) {
            Object[] pkIds = useRankSalaryItemIds.toArray();
            ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
            List allSalaryItemIds = SalaryStdItemHelper.getAllSalaryItemIds(salaryStdItemList);
            QFilter filter = new QFilter("id", "in", (Object)allSalaryItemIds);
            filters.add(filter);
            ListShowParameter f7 = this.getBaseDataF7("hsbs_standarditem", pkIds, filters, false);
            f7.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_ACTIONID_SALARYRANKITEMF7));
            this.getView().showForm((FormShowParameter)f7);
        }
    }

    private void openSalaryCountItemF7() {
        List<SalaryStdItemEntity> salaryStdItemList = this.getStandardItemEntityList();
        List useCountSalaryItemIds = SalaryStdItemHelper.getUseCountSalaryItemIds(salaryStdItemList);
        if (useCountSalaryItemIds != null) {
            Object[] pkIds = useCountSalaryItemIds.toArray();
            ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
            List allSalaryItemIds = SalaryStdItemHelper.getAllSalaryItemIds(salaryStdItemList);
            QFilter filter = new QFilter("id", "in", (Object)allSalaryItemIds);
            filters.add(filter);
            ListShowParameter f7 = this.getBaseDataF7("hsbs_standarditem", pkIds, filters, false);
            f7.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_ACTIONID_SALARYCOUNTITEMF7));
            this.getView().showForm((FormShowParameter)f7);
        }
    }

    private List<QFilter> getSalaryItemFilters() {
        ArrayList qfilters = Lists.newArrayListWithExpectedSize((int)10);
        Long countryId = this.getModel().getDataEntity().getLong("country.id");
        QFilter filter = new QFilter("country", "=", (Object)countryId);
        QFilter areaTypeQFilter = new QFilter("areatype", "=", (Object)BIZTYPE_SALARY);
        filter.or(areaTypeQFilter);
        qfilters.add(filter);
        qfilters.add(new QFilter("biztype", "like", (Object)"%1%"));
        Long createOrgId = this.getModel().getDataEntity().getLong("createorg.id");
        QFilter useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_standarditem", (Long)createOrgId);
        if (useOrgFilter != null) {
            qfilters.add(useOrgFilter);
        }
        return qfilters;
    }

    public void doStdGridCalc(boolean needRefresh, IFormView formView) {
        this.doCalc(formView);
        if (needRefresh) {
            this.cacheEntryData(formView);
            this.refreshGridByInvokeAction(formView);
        }
    }

    private void refreshGridByInvokeAction(IFormView mainPage) {
        String settingPageId = mainPage.getPageCache().get("hcdm_standardsettingform");
        IFormView displaySetView = mainPage.getView(settingPageId);
        if (displaySetView != null && displaySetView.getModel().isDataLoaded()) {
            displaySetView.invokeOperation("donothing_refreshtable");
            mainPage.sendFormAction(displaySetView);
        }
    }

    @Override
    protected void initPage() {
        DynamicObjectCollection rankEnt;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection itemEnt = model.getEntityEntity("salarystditem");
        if (CollectionUtils.isEmpty((Collection)itemEnt)) {
            SalaryStandardPageInteractionHelper.preSetSalaryItemEnt((AbstractFormDataModel)model);
            view.updateView("salarystditem");
        }
        if ((rankEnt = model.getEntityEntity("salaryrank")) != null && rankEnt.isEmpty()) {
            SalaryStandardPageInteractionHelper.preSetSalaryRankEnt((AbstractFormDataModel)model);
            view.updateView("salaryrank");
            SalaryStandardPageInteractionHelper.setGradeRankSeqMap((AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), (String)"salaryrank", (boolean)false);
        }
        this.getModel().setValue("salarygradecount", (Object)0);
        this.getModel().setValue("salaryrankcount", (Object)0);
        this.initBaseinfoCfg();
        this.drawAllItemLabel();
        this.setGradeCountInfo();
        this.isUseSalaryRank(true);
        this.setRankCountInfo();
        this.setMonetaryCurUnit();
        this.isUseSalaryCount(true);
        SalaryStandardTypeEnum typeEnum = SalaryStandardTypeEnum.getFromCode((String)((String)model.getValue("type")));
        this.setDefaultValueByType(typeEnum);
        this.setVisibleInfoByType(typeEnum);
        this.updateBaseSummary();
        this.openSalaryStandardSettingGrid();
    }

    private void initBaseinfoCfg() {
        Container container = (Container)this.getControl(AP_BASEINFO_CFG);
        List<ValidateResult> mustInputValidate = this.mustInputValidate();
        for (ValidateResult validateResult : mustInputValidate) {
            if (validateResult.isSuccess()) continue;
            container.setCollapse(false);
            return;
        }
        container.setCollapse(true);
    }

    private void setDefaultValueByType(SalaryStandardTypeEnum typeEnum) {
        if (typeEnum == SalaryStandardTypeEnum.BROADBAND) {
            this.getModel().setValue("isusesalaryrank", (Object)BIZTYPE_SALARY);
        }
        if (typeEnum == SalaryStandardTypeEnum.SALARYCOUNT) {
            ComboEdit calcCombo = (ComboEdit)this.getControl("calcmethod");
            if (SWCObjectUtils.isEmpty((Object)calcCombo)) {
                return;
            }
            ComboProp calcProp = (ComboProp)calcCombo.getProperty();
            this.getModel().setValue("calcmethod", calcProp.getDefValue());
        }
    }

    @Override
    protected void veriDataIntegrityInCurrentPage(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        SalaryStandardEntryData entryData = EntityConverter.fetchEntityFromModel((DynamicObject)dataEntity);
        ValidateContext validateContext = new ValidateContext((Object)entryData);
        ValidatorTree tree = StdValidatorHelper.getToNextValidatorTreeForDesign((ValidateContext)validateContext, (SalaryStandardEntryData)entryData);
        ValidatorAdapter adapter = ValidatorAdapter.build((ValidateContext)validateContext, (ValidatorTree)tree);
        adapter.validate();
        List results = adapter.getValidateContext().getResults();
        this.showErrorResults(results, args);
    }

    @Override
    protected void doBeforeSave(BeforeDoOperationEventArgs args) {
        super.doBeforeSave(args);
        FormOperate source = (FormOperate)args.getSource();
        String ignoreCalc = (String)source.getOption().getVariables().get("ignoreCalc");
        if (!StringUtils.equals((CharSequence)ignoreCalc, (CharSequence)"true")) {
            this.doStdGridCalc(true, this.getView());
        }
        List<ValidateResult> results = this.mustInputValidate();
        this.showErrorResults(results, args);
    }

    @Override
    protected void doRefreshChildPage(AfterDoOperationEventArgs args) {
        this.isUseSalaryRank(true);
        this.isUseSalaryCount(true);
        this.setGradeCountInfo();
        this.setRankCountInfo();
        this.openSalaryStandardSettingGrid();
    }

    private List<ValidateResult> mustInputValidate() {
        SalaryStandardEntryData entryData = EntityConverter.fetchEntityFromModel((DynamicObject)this.getModel().getDataEntity(true));
        ValidateContext validateContext = new ValidateContext((Object)entryData);
        ValidatorTree tree = StdValidatorHelper.getMustInputValidatorTreeForDesign((ValidateContext)validateContext);
        ValidatorAdapter adapter = ValidatorAdapter.build((ValidateContext)validateContext, (ValidatorTree)tree);
        adapter.validate();
        return adapter.getValidateContext().getResults();
    }

    private void doBeforeCal(BeforeDoOperationEventArgs args) {
        SalaryStandardEntryData entryData = EntityConverter.fetchEntityFromModel((DynamicObject)this.getModel().getDataEntity(true));
        ValidateContext validateContext = new ValidateContext((Object)entryData);
        ValidatorTree tree = StdValidatorHelper.getValidatorTreeForCal((ValidateContext)validateContext);
        ValidatorAdapter adapter = ValidatorAdapter.build((ValidateContext)validateContext, (ValidatorTree)tree);
        adapter.validate();
        List results = adapter.getValidateContext().getResults();
        this.showCalErrorResults(results, args);
    }

    private void showCalErrorResults(List<ValidateResult> results, BeforeDoOperationEventArgs args) {
        ArrayList allWorningMsg = new ArrayList(10);
        for (ValidateResult result : results) {
            if (result.isSuccess()) continue;
            ErrorLevel level = result.getLevel();
            if (ErrorLevel.FatalError.equals((Object)level)) {
                args.setCancel(true);
                for (String msg : result.getErrorList()) {
                    this.getView().showErrorNotification(msg);
                }
                continue;
            }
            allWorningMsg.addAll(result.getErrorList());
        }
        if (!allWorningMsg.isEmpty()) {
            FormShowParameter operationResultParameter = SWCShowFormServiceHelper.getOperationResultParameter((String)ResManager.loadKDString((String)"\u4fdd\u5b58\u5e76\u8ba1\u7b97", (String)"SalaryStandardDesignEdit_7", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u6807\u51c6\u8868\u8bbe\u7f6e\u5b58\u5728\u672a\u586b\u5199\u5185\u5bb9\u3002", (String)"SalaryStandardDesignEdit_8", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), allWorningMsg);
            this.getView().showForm(operationResultParameter);
        }
    }

    @Override
    public void updateCalcType(String calcType, IFormView mainPage) {
        IDataModel model = mainPage.getModel();
        model.setValue("calcmethod", (Object)calcType);
        SalaryStandardEntryData entryData = EntityConverter.fetchEntityFromModel((DynamicObject)model.getDataEntity(true));
        entryData.getViewControlParam().setCanEdit(OperationStatus.VIEW.equals((Object)SalaryStandardDesignEdit.getChildStatus(this.getView())) ? 0 : 1);
        SalaryStandardCacheHelper.putEntryData((String)this.getView().getPageId(), (Object)entryData);
    }

    @Override
    protected void showWarningConfirmForm(List<String> allWarningMsg, BeforeDoOperationEventArgs args) {
        FormShowParameter operationResultParameter = SWCShowFormServiceHelper.getOperationConfirmParameter((CloseCallBack)new CloseCallBack((IFormPlugin)this, CALLBACKID_HASEMPTYSTDSET), (String)ResManager.loadKDString((String)"\u6807\u51c6\u8868\u8bbe\u7f6e", (String)"SalaryStandardDesignEdit_9", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u6807\u51c6\u8868\u8bbe\u7f6e\u5b58\u5728\u672a\u586b\u5199\u5185\u5bb9\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SalaryStandardDesignEdit_5", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), allWarningMsg, (boolean)true);
        this.getView().showForm(operationResultParameter);
    }
}

