/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.salarystandard;

import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.swc.hcdm.common.stdtab.CalculationMethodEnum;
import kd.sdk.swc.hcdm.common.stdtab.DisplayParamNew;
import kd.sdk.swc.hcdm.common.stdtab.DisplayParamPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.ViewControlParam;
import kd.swc.hcdm.business.salarystandard.DisplayModePaintHelper;
import kd.swc.hcdm.business.salarystandard.DisplayParamHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardCacheHelper;
import kd.swc.hcdm.business.salarystandard.StdValidatorHelper;
import kd.swc.hcdm.business.validator.ValidatorAdapter;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.business.validator.bean.ValidatorTree;
import kd.swc.hcdm.formplugin.salarystandard.SalaryStandardBaseEdit;

public class SalaryStandardDisplaySettingEdit
extends SalaryStandardBaseEdit {
    private static final String AP_CALC = "calcap";
    private static final String LBL_CALC = "labelap";
    public static final String LAB_SUFFIX = "_lab";
    public static final String SALARY_GRADE_SORT = "salary_grade_sort";
    public static final String SALARY_RANK_SORT = "salary_rank_sort";
    public static final String SHOW_SALARY_COUNT = "show_salary_count";
    public static final String PROJECT_TAB = "project_tab";
    public static final String GRADE_TAB = "grade_tab";
    public static final String AP_SETTING = "settingap";
    private static final String FLEX_PANEL_AP_SHOW = "flexpanelap_show";
    public static Map<String, String> fieldRegistry = new HashMap<String, String>(16);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        Object type = SessionManager.getCurrent().getViewNoPlugin(((FormShowParameter)args.getSource()).getParentPageId()).getModel().getValue("type");
        SalaryStandardTypeEnum typeEnum = type == null ? SalaryStandardTypeEnum.SALARYCOUNT : SalaryStandardTypeEnum.getFromCode((String)((String)type));
        DisplayModePaintHelper.toLoadCustomControlMetas((LoadCustomControlMetasArgs)args, (String)FLEX_PANEL_AP_SHOW, (boolean)false, (SalaryStandardTypeEnum)typeEnum);
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        MainEntityType oldMainType = args.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("getEntityType", exp.getMessage()), new Object[0]);
        }
        if (this.getView().getParentView() != null) {
            Object type = this.getView().getParentView().getModel().getValue("type");
            SalaryStandardTypeEnum typeEnum = type == null ? SalaryStandardTypeEnum.SALARYCOUNT : SalaryStandardTypeEnum.getFromCode((String)((String)type));
            DisplayModePaintHelper.registerDynamicProps((MainEntityType)newMainType, (boolean)false, (SalaryStandardTypeEnum)typeEnum);
            args.setNewEntityType(newMainType);
        }
    }

    public void onGetControl(OnGetControlArgs args) {
        String key = args.getKey();
        if (key.startsWith("rank_") || key.startsWith("item_") || key.equals(SHOW_SALARY_COUNT)) {
            DisplayModePaintHelper.createCheckBoxControl((OnGetControlArgs)args, (String)key, (IFormView)this.getView());
        }
    }

    public void createNewData(BizDataEventArgs args) {
        DisplayModePaintHelper.toCreateNewData((BizDataEventArgs)args, (IDataModel)this.getModel(), (boolean)false, (SalaryStandardTypeEnum)this.getSalaryStandardType());
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)this.getView().getFormShowParameter().getParentPageId());
        if (stdData != null) {
            if (stdData.getStdBaseEntity() != null) {
                DisplayModePaintHelper.toBindData((IFormView)this.getView(), (String)FLEX_PANEL_AP_SHOW, (boolean)false, (SalaryStandardTypeEnum)stdData.getStdBaseEntity().getType());
            }
            this.updateSettingForm(stdData.getDisplayParam(), this.getView().getParentView());
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.initDisplaySettingByCacheEntryData();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "donothing_refreshtable": {
                this.reflushSettingFlexVisible();
                this.initSettingFormByFormId();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String key = args.getProperty().getName();
        if (key.startsWith("rank_") || key.startsWith("item_")) {
            this.updateEntryEntityByPosition(key, this.getBooleanValueToInt(args.getChangeSet()[0].getNewValue()));
        } else {
            switch (key) {
                case "salary_rank_sort": 
                case "salary_grade_sort": {
                    this.updateEntryEntityByPosition(fieldRegistry.get(key), this.getIntValue(args.getChangeSet()[0].getNewValue()));
                    break;
                }
                case "calcmethod": {
                    this.updateCalcType((String)args.getChangeSet()[0].getNewValue(), this.getView().getParentView());
                    this.initSettingFormByFormId();
                    break;
                }
                case "show_salary_count": {
                    this.updateEntryEntityByPosition(fieldRegistry.get(key), this.getBooleanValueToInt(args.getChangeSet()[0].getNewValue()));
                    break;
                }
            }
        }
    }

    private void initDisplaySettingFlex(DisplayParamNew displayParam) {
        this.getView().setVisible(Boolean.TRUE, new String[]{SALARY_RANK_SORT, SALARY_GRADE_SORT, SHOW_SALARY_COUNT});
        this.initComboBox(displayParam.getDisplaySalaryRankSort(), SALARY_RANK_SORT);
        this.initComboBox(displayParam.getDisplaySalaryGradeSort(), SALARY_GRADE_SORT);
        this.initCheckBox(displayParam.getDisplayOnlySalaryCount(), SHOW_SALARY_COUNT);
        LinkedHashMap itemLevelParam = displayParam.getItemLevelParam();
        LinkedHashMap rankLevelParam = displayParam.getRankLevelParam();
        for (Map.Entry itemLevel : itemLevelParam.entrySet()) {
            this.initCheckBox((Integer)itemLevel.getValue(), "item_" + itemLevel.getKey());
        }
        for (Map.Entry rankLevel : rankLevelParam.entrySet()) {
            this.initCheckBox((Integer)rankLevel.getValue(), "rank_" + rankLevel.getKey());
        }
    }

    private void initAvailableCalcMethod() {
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)this.getView().getFormShowParameter().getParentPageId());
        SalaryStandardBaseEntity stdBaseEntity = stdData.getStdBaseEntity();
        SalaryStandardTypeEnum typeEnum = stdBaseEntity.getType();
        if (typeEnum == null) {
            return;
        }
        List availableCalcMethod = DisplayParamHelper.getAvailableCalcMethod((SalaryStandardTypeEnum)typeEnum);
        this.initAvailableCalcMethod(availableCalcMethod, stdBaseEntity.getCalcMethod(), stdData.getViewControlParam());
    }

    private void initAvailableCalcMethod(List<CalculationMethodEnum> availableCalcMethod, CalculationMethodEnum calcMethod, ViewControlParam viewControlParam) {
        if (CollectionUtils.isEmpty(availableCalcMethod)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{AP_CALC});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{AP_CALC});
        if (viewControlParam.getCanEdit() < 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{AP_CALC});
        }
        for (CalculationMethodEnum calculationMethodEnum : CalculationMethodEnum.values()) {
            String key = this.getCalcMethodItemKey("calcmethod", calculationMethodEnum);
            this.getView().setVisible(Boolean.valueOf(availableCalcMethod.contains(calculationMethodEnum)), new String[]{key});
        }
        if (availableCalcMethod.contains(calcMethod)) {
            this.getModel().setValue("calcmethod", (Object)calcMethod.getCode());
        } else {
            this.getModel().setValue("calcmethod", (Object)availableCalcMethod.get(0).getCode());
        }
    }

    private String getCalcMethodItemKey(String calcMethodGroup, CalculationMethodEnum calculationMethodEnum) {
        return calcMethodGroup + calculationMethodEnum.getCode();
    }

    private void initDisplaySettingByCacheEntryData() {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)parentPageId);
        if (null == stdData) {
            return;
        }
        SalaryStandardBaseEntity stdBaseEntity = stdData.getStdBaseEntity();
        SalaryStandardTypeEnum typeEnum = stdBaseEntity.getType();
        if (null == typeEnum) {
            return;
        }
        DisplayParamNew displayParam = stdData.getDisplayParam();
        DisplayModePaintHelper.trySetFromSecondOrFourthModel((IFormView)this.getView(), (DisplayParamNew)displayParam, (String)parentPageId, (SalaryStandardEntryData)stdData, (boolean)false);
        this.getModel().beginInit();
        this.initDisplaySettingFlex(displayParam);
        this.setSettingFlexVisible(stdData);
        List availableCalcMethod = DisplayParamHelper.getAvailableCalcMethod((SalaryStandardTypeEnum)typeEnum);
        this.initAvailableCalcMethod(availableCalcMethod, stdBaseEntity.getCalcMethod(), stdData.getViewControlParam());
        this.initSettingFormByFormId();
        this.getModel().endInit();
        this.getView().updateView(SHOW_SALARY_COUNT);
        this.getView().updateView(SALARY_RANK_SORT);
        this.getView().updateView(SALARY_GRADE_SORT);
        this.getView().updateView(SALARY_RANK_SORT);
        this.getView().updateView(AP_CALC);
        LinkedHashMap itemLevelParam = displayParam.getItemLevelParam();
        LinkedHashMap rankLevelParam = displayParam.getRankLevelParam();
        for (Map.Entry itemLevel : itemLevelParam.entrySet()) {
            this.getView().updateView("item_" + itemLevel.getKey());
        }
        for (Map.Entry rankLevel : rankLevelParam.entrySet()) {
            this.getView().updateView("rank_" + rankLevel.getKey());
        }
    }

    private void setSettingFlexVisible(SalaryStandardEntryData stdData) {
        this.getView().setVisible(Boolean.TRUE, new String[]{AP_SETTING});
    }

    private void reflushSettingFlexVisible() {
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)this.getView().getFormShowParameter().getParentPageId());
        this.setSettingFlexVisible(stdData);
    }

    private boolean validateMustInput(SalaryStandardEntryData entryData) {
        ValidateContext validateContext = new ValidateContext((Object)entryData);
        ValidatorTree tree = StdValidatorHelper.getMustInputValidatorTreeForDesign((ValidateContext)validateContext);
        ValidatorAdapter adapter = ValidatorAdapter.build((ValidateContext)validateContext, (ValidatorTree)tree);
        adapter.validate();
        List results = adapter.getValidateContext().getResults();
        for (ValidateResult result : results) {
            if (result.isSuccess()) continue;
            return false;
        }
        return true;
    }

    private void initComboBox(int code, String position) {
        if (DisplayParamHelper.checkVisibleByCode((int)code)) {
            this.getModel().setValue(position, (Object)code);
            return;
        }
        this.hiddenAreaWithLab(position);
    }

    private void initCheckBox(int code, String position) {
        if (this.getModel().getProperty(position) == null) {
            return;
        }
        if (DisplayParamHelper.checkVisibleByCode((int)code)) {
            this.getModel().setValue(position, (Object)DisplayParamHelper.getValueForBooleanAp((int)code));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{position});
        }
    }

    private void updateEntryEntityByPosition(String position, int value) {
        this.doUpdateEntryEntityByPosition(new DisplayParamPropEntity(position, value), this.getView().getParentView());
        this.initAvailableCalcMethod();
        this.initSettingFormByFormId();
    }

    private int getBooleanValueToInt(Object newValue) {
        return DisplayParamHelper.displayParamBooleanValueToInt((Boolean)Boolean.valueOf(newValue.toString()));
    }

    private int getIntValue(Object newValue) {
        return Integer.parseInt(Optional.ofNullable(newValue).map(Object::toString).orElse("-1"));
    }

    private SalaryStandardTypeEnum getSalaryStandardType() {
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)this.getView().getFormShowParameter().getParentPageId());
        if (stdData == null) {
            return null;
        }
        SalaryStandardBaseEntity stdBaseEntity = stdData.getStdBaseEntity();
        if (stdBaseEntity != null) {
            return stdBaseEntity.getType();
        }
        return null;
    }

    static {
        fieldRegistry.put(SALARY_RANK_SORT, "displaySalaryRankSort");
        fieldRegistry.put(SALARY_GRADE_SORT, "displaySalaryGradeSort");
        fieldRegistry.put(SHOW_SALARY_COUNT, "displayOnlySalaryCount");
    }
}

