/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.salarystandard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.swc.hcdm.business.SalaryStandardSerializationUtils;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardCacheHelper;
import kd.swc.hcdm.business.salarystandard.StdTabValSetHelper;
import kd.swc.hcdm.common.entity.salarystandard.GradeRankValueOutbound;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SalaryStandardGradeRankFormPlugin
extends AbstractFormPlugin {
    private static final String AP_TIPS_CONTENT = "tipscontentap";
    private static final String LAB_VISIBLE = "labvisible";
    private static final String KEY_TIPS_VISIBLE = "rediskey_tips_visible";
    protected static final String SWC_HCDM_FORMPLUGIN = "swc-hcdm-formplugin";

    public void propertyChanged(PropertyChangedArgs args) {
        ChangeData[] changeSet = args.getChangeSet();
        if (args.getProperty().getName() != "graderank") {
            for (ChangeData changeData : changeSet) {
                this.reFreshGradeRankStr(changeData);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "donothing_clearent": {
                this.getModel().deleteEntryData("entryentity");
                break;
            }
            case "donothing_tips": {
                this.collapseSetting();
                break;
            }
        }
    }

    private void reFreshGradeRankStr(ChangeData changeData) {
        String gradeEndName;
        int rowIndex = changeData.getRowIndex();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String boundStr = (String)customParams.get("setGradeRankBound");
        String parentPageId = (String)formShowParameter.getCustomParam("main_page");
        GradeRankValueOutbound bound = (GradeRankValueOutbound)SalaryStandardSerializationUtils.fromJsonString((String)boundStr, GradeRankValueOutbound.class);
        boolean isUseRank = this.getModel().getDataEntity().getBoolean("isuserank");
        SalaryStandardEntryData entryData = SalaryStandardCacheHelper.getEntryData((String)parentPageId);
        List gradeEntities = entryData.getGradeEntities();
        List rankEntities = GradeRankHelper.fetchStandardRank((Collection)entryData.getRankEntities());
        Map gradeIndexMap = GradeRankHelper.getGradeIndexNameMap((List)gradeEntities);
        Map rankIndexMap = GradeRankHelper.getRankIndexNameMap((List)rankEntities);
        int carryBit = bound.getCarryBit();
        String gradeBegin = entryRowEntity.getString("gradebegin");
        String gradeEnd = entryRowEntity.getString("gradeend");
        String beginRankName = "";
        String endRankName = "";
        if (isUseRank) {
            String rankBegin = entryRowEntity.getString("rankbegin");
            String rankEnd = entryRowEntity.getString("rankend");
            beginRankName = StringUtils.isBlank((CharSequence)rankBegin) ? "" : (String)rankIndexMap.get(Integer.parseInt(rankBegin) + 1);
            endRankName = StringUtils.isBlank((CharSequence)rankEnd) ? "" : (String)rankIndexMap.get(Integer.parseInt(rankEnd) + 1);
        }
        String beginGradeName = StringUtils.isBlank((CharSequence)gradeBegin) ? "" : (String)gradeIndexMap.get(Integer.parseInt(gradeBegin) + 1);
        String string = gradeEndName = StringUtils.isBlank((CharSequence)gradeEnd) ? "" : (String)gradeIndexMap.get(Integer.parseInt(gradeEnd) + 1);
        if (StringUtils.isNotBlank((CharSequence)beginGradeName) || StringUtils.isNotBlank((CharSequence)beginRankName) || StringUtils.isNotBlank((CharSequence)gradeEndName) || StringUtils.isNotBlank((CharSequence)endRankName)) {
            String format = String.format("%s%s~%s%s", beginGradeName, beginRankName, gradeEndName, endRankName);
            this.getModel().setValue("graderank", (Object)format, rowIndex);
        } else {
            this.getModel().setValue("graderank", null, rowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "donothing_ok": {
                this.returnDataToParent(args);
                break;
            }
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.getView().setStatus(this.getView().getFormShowParameter().getStatus());
        this.bindDataFormParent();
        this.expand();
    }

    private void preSettingParam(GradeRankValueOutbound bound) {
        this.getModel().setValue("rowindex", (Object)bound.getRowIndex());
        this.getModel().setValue("carrybit", (Object)bound.getCarryBit());
    }

    private void bindDataFormParent() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String boundStr = (String)customParams.get("setGradeRankBound");
        String mainPageId = (String)customParams.get("main_page");
        IDataModel parentModel = this.getView().getView(mainPageId).getModel();
        DynamicObject mainEntity = parentModel.getDataEntity();
        List gradeEntities = EntityConverter.dynamicObjToSalaryGradeEntity((DynamicObjectCollection)parentModel.getEntryEntity("salarygrade"), (Long)mainEntity.getLong("id"));
        List rankEntities = EntityConverter.dynamicObjToSalaryRankEntity((DynamicObjectCollection)parentModel.getEntryEntity("salaryrank"), (Long)mainEntity.getLong("id"), (SalaryStandardTypeEnum)SalaryStandardTypeEnum.getFromCode((String)mainEntity.getString("type")));
        rankEntities = GradeRankHelper.fetchStandardRank((Collection)rankEntities);
        Map gradeIndexNameMap = GradeRankHelper.getGradeIndexNameMap((List)gradeEntities);
        Map rankIndexNameMap = GradeRankHelper.getRankIndexNameMap((List)rankEntities);
        GradeRankValueOutbound bound = (GradeRankValueOutbound)SalaryStandardSerializationUtils.fromJsonString((String)boundStr, GradeRankValueOutbound.class);
        this.preSettingParam(bound);
        this.setComboItems(this.buildComboItem(gradeIndexNameMap), "gradebegin", "gradeend");
        Boolean isUseRank = (Boolean)parentModel.getValue("isusesalaryrank");
        if (isUseRank.booleanValue()) {
            this.getModel().setValue("isuserank", (Object)Boolean.TRUE);
            this.setComboItems(this.buildComboItem(rankIndexNameMap), "rankbegin", "rankend");
        } else {
            isUseRank = false;
            this.getView().setVisible(Boolean.FALSE, new String[]{"rankbegin"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"rankend"});
            this.getModel().setValue("isuserank", (Object)Boolean.FALSE);
        }
        List valueList = bound.getValueList();
        if (!valueList.isEmpty()) {
            int carryBit = bound.getCarryBit();
            TableValueSetter tableValueSetter = StdTabValSetHelper.getGradeRankTableSetter((List)valueList, (int)carryBit, (Map)gradeIndexNameMap, (Map)rankIndexNameMap, (boolean)isUseRank);
            model.batchCreateNewEntryRow("entryentity", tableValueSetter);
        } else {
            model.createNewEntryRow("entryentity");
        }
        this.getView().updateView("entryentity");
    }

    private List<ComboItem> buildComboItem(Map<Integer, String> gradeIndexMap) {
        return gradeIndexMap.entrySet().stream().map(entry -> new ComboItem(new LocaleString((String)entry.getValue()), String.valueOf((Integer)entry.getKey() - 1))).collect(Collectors.toList());
    }

    private void setComboItems(List<ComboItem> gradeComboItems, String ... keys) {
        for (String key : keys) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(key);
            if (comboEdit == null) continue;
            comboEdit.setComboItems(gradeComboItems);
            comboEdit.setMustInput(false);
        }
    }

    private void returnDataToParent(BeforeDoOperationEventArgs args) {
        if (this.hasWrongData()) {
            args.setCancel(true);
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String boundStr = (String)customParams.get("setGradeRankBound");
        GradeRankValueOutbound oldBound = (GradeRankValueOutbound)SalaryStandardSerializationUtils.fromJsonString((String)boundStr, GradeRankValueOutbound.class);
        GradeRankValueOutbound newBound = this.buildReturnData(oldBound);
        if (CollectionUtils.isNotEmpty((Collection)newBound.getValueList())) {
            List gradeRankValues = GradeRankHelper.unionRangeByCode((List)newBound.getValueList());
            newBound.setValueList(gradeRankValues);
        }
        this.getView().returnDataToParent((Object)newBound);
        this.getView().close();
    }

    private boolean hasWrongData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        Boolean isUseRank = (Boolean)this.getModel().getValue("isuserank");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String boundStr = (String)customParams.get("setGradeRankBound");
        GradeRankValueOutbound oldBound = (GradeRankValueOutbound)SalaryStandardSerializationUtils.fromJsonString((String)boundStr, GradeRankValueOutbound.class);
        int carryBit = oldBound.getCarryBit();
        int i1 = 1;
        ArrayList<Integer> wrongIndex = new ArrayList<Integer>(10);
        ArrayList<Integer> emptyIndex = new ArrayList<Integer>(10);
        if (entryEntity.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u85aa\u7b49\u3001\u85aa\u6863\u3002", (String)"SalaryStandardGradeRankFormPlugin_3", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
        }
        for (DynamicObject entryRowEntity : entryEntity) {
            boolean rankEmpty;
            int gradeBegin = entryRowEntity.getInt("gradebegin");
            int rankBegin = entryRowEntity.getInt("rankbegin");
            int gradeEnd = entryRowEntity.getInt("gradeend");
            int rankEnd = entryRowEntity.getInt("rankend");
            boolean gradeEmpty = StringUtils.isBlank((CharSequence)entryRowEntity.getString("gradebegin")) || StringUtils.isBlank((CharSequence)entryRowEntity.getString("gradeend"));
            boolean bl = rankEmpty = StringUtils.isBlank((CharSequence)entryRowEntity.getString("rankbegin")) || StringUtils.isBlank((CharSequence)entryRowEntity.getString("rankend"));
            if (gradeEmpty || isUseRank != null && isUseRank.booleanValue() && rankEmpty) {
                emptyIndex.add(i1++);
                continue;
            }
            int begin = gradeBegin * carryBit + rankBegin;
            int end = gradeEnd * carryBit + rankEnd;
            if (begin > end) {
                wrongIndex.add(i1);
            }
            ++i1;
        }
        if (wrongIndex.isEmpty() && emptyIndex.isEmpty()) {
            return false;
        }
        this.showErrorMsg(wrongIndex, emptyIndex);
        return true;
    }

    private void showErrorMsg(List<Integer> wrongIndex, List<Integer> emptyIndex) {
        Object format;
        StringJoiner sj;
        String splitPoint = "\u3001";
        if (wrongIndex != null && !wrongIndex.isEmpty()) {
            sj = new StringJoiner(splitPoint);
            for (Integer index : wrongIndex) {
                sj.add(index.toString());
            }
            Boolean isUseRank = (Boolean)this.getModel().getValue("isuserank");
            format = isUseRank != null && isUseRank != false ? ResManager.loadKDString((String)"\u7b2c%s\u884c\u7ed3\u675f\u85aa\u7b49\u85aa\u6863\u5c0f\u4e8e\u5f00\u59cb\u85aa\u7b49\u85aa\u6863\uff0c\u8bf7\u9009\u62e9\u7ed3\u675f\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u7684\u85aa\u7b49\u85aa\u6863\u3002", (String)"SalaryStandardGradeRankFormPlugin_0", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7b2c%s\u884c\u7ed3\u675f\u85aa\u7b49\u5c0f\u4e8e\u5f00\u59cb\u85aa\u7b49\uff0c\u8bf7\u9009\u62e9\u7ed3\u675f\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u7684\u85aa\u7b49\u3002", (String)"SalaryStandardGradeRankFormPlugin_1", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(String.format(Locale.ROOT, (String)format, sj.toString()));
        }
        if (emptyIndex != null && !emptyIndex.isEmpty()) {
            sj = new StringJoiner(splitPoint);
            for (Integer index : emptyIndex) {
                sj.add(index.toString());
            }
            format = ResManager.loadKDString((String)"\u7b2c%s\u884c\u5b58\u5728\u7a7a\u503c\uff0c\u8bf7\u586b\u5199\u5b8c\u6574\u3002", (String)"SalaryStandardGradeRankFormPlugin_2", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(String.format(Locale.ROOT, (String)format, sj.toString()));
        }
    }

    private GradeRankValueOutbound buildReturnData(GradeRankValueOutbound oldBound) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        return EntityConverter.dynamicObjToGradeRankValueOutbound((DynamicObjectCollection)entryEntity, (int)oldBound.getRowIndex(), (int)oldBound.getCarryBit());
    }

    private void collapseSetting() {
        IPageCache pageCache = this.getPageCache();
        String str = pageCache.get(KEY_TIPS_VISIBLE);
        if (SWCStringUtils.isNotEmpty((String)str) && Boolean.parseBoolean(str)) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    private void collapse() {
        Label labVisible = (Label)this.getControl(LAB_VISIBLE);
        labVisible.setText(ResManager.loadKDString((String)"\u5c55\u5f00", (String)"DisplaySettingTipsEdit_13", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
        this.getView().setVisible(Boolean.FALSE, new String[]{AP_TIPS_CONTENT});
        this.getPageCache().put(KEY_TIPS_VISIBLE, Boolean.FALSE.toString());
    }

    private void expand() {
        Label labVisible = (Label)this.getControl(LAB_VISIBLE);
        labVisible.setText(ResManager.loadKDString((String)"\u6536\u8d77", (String)"DisplaySettingTipsEdit_14", (String)SWC_HCDM_FORMPLUGIN, (Object[])new Object[0]));
        this.getView().setVisible(Boolean.TRUE, new String[]{AP_TIPS_CONTENT});
        this.getPageCache().put(KEY_TIPS_VISIBLE, Boolean.TRUE.toString());
    }
}

