/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.salarystandard;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdGridDisplayTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.calculate.SalaryStdCalculateHelper;
import kd.swc.hcdm.business.converter.DecimalConverter;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardCacheHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardImportHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardPageInteractionHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.business.salarystandard.constraint.EntryFieldConstraintMapping;
import kd.swc.hcdm.business.validator.ValidatorAdapter;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.business.validator.bean.ValidatorTree;
import kd.swc.hcdm.common.entity.salarystandard.DynamicFieldIdGenerationParamForGroup;
import kd.swc.hcdm.common.entity.salarystandard.FixedFieldIdGenerationParam;
import kd.swc.hcdm.formplugin.salarystandard.SalaryStandardGridViewCommon;
import kd.swc.hsbp.business.export.SWCExportEntryHelper;
import kd.swc.hsbp.business.export.entity.ImportConfig;
import kd.swc.hsbp.business.imports.ValidateResults;
import kd.swc.hsbp.common.entity.EntryColumnContainer;
import kd.swc.hsbp.common.entity.EntryColumnWrapper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.imports.EntryImportContext;
import kd.swc.hsbp.formplugin.imports.IDataPort;
import kd.swc.hsbp.formplugin.imports.ProgressHandler;
import kd.swc.hsbp.formplugin.imports.event.BeforeWriteTemplateEvent;
import kd.swc.hsbp.formplugin.imports.event.DataImportEvent;
import kd.swc.hsbp.formplugin.imports.event.LoadCustomEntryMetasEvent;
import kd.swc.hsbp.formplugin.imports.event.OnGetImportConfigEvent;
import org.apache.commons.lang.StringUtils;

public class SalaryStandardGridImportEdit
extends SalaryStandardGridViewCommon
implements IDataPort {
    private static final int FIXHEADHEIGHT = 3;
    private static Log log = LogFactory.getLog(SalaryStandardGridImportEdit.class);

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "donothing_import": {
                ValidateResult result = this.validateMustInput();
                if (result.isSuccess()) {
                    IDataPort.openImportWindow((IFormView)this.getView(), (IFormPlugin)this, (String)ResManager.loadKDString((String)"\u85aa\u916c\u6807\u51c6\u8868\u5bfc\u5165\u8d77\u59cb\u9875", (String)"SalaryStandardGridImportEdit_4", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                IFormView pareView = this.getView().getParentView();
                for (String msg : result.getErrorList()) {
                    pareView.showErrorNotification(msg);
                    this.getView().sendFormAction(pareView);
                }
                break;
            }
        }
    }

    public void onGetImportConfig(OnGetImportConfigEvent evt) {
        List columns = SWCExportEntryHelper.readRuntimeEntryColumn((IFormView)this.getView(), (String)"entryentity");
        Set ignoreSet = SWCExportEntryHelper.getIgnoreColumn((List)columns);
        List containers = SWCExportEntryHelper.getEntryColumnContainers((List)columns, (Set)ignoreSet);
        Set<String> clearColumns = this.getClearColumns(containers);
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)this.getMainPage(this.getView().getFormShowParameter()));
        String templateFirstName = SalaryStandardImportHelper.getTemplateFirstName((SalaryStandardEntryData)stdData);
        String modelName = ResManager.loadKDString((String)"\u85aa\u916c\u6807\u51c6\u8868-\u6807\u51c6\u8868\u8bbe\u7f6e", (String)"SalaryStandardGridImportEdit_3", (String)"swc-hcdm-formplugin", (Object[])new Object[0]);
        ImportConfig config = new ImportConfig();
        config.setImportType(ImportConfig.ImportType.Complete);
        int maxRow = SalaryStandardImportHelper.getMaxRow((String)"formnumber");
        config.setMaxRowCount(maxRow);
        config.setTemplateCaption(templateFirstName);
        config.setModelName(modelName);
        LocalDate now = LocalDate.now();
        String monthDay = String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
        String fileName = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_\u85aa\u916c\u6807\u51c6\u8868\u8bbe\u8ba1\u6807\u51c6\u8868\u5bfc\u5165\u6a21\u677f_{0}", (String)"SalaryStandardGridImportEdit_5", (String)"swc-hcdm-formplugin", (Object[])new Object[]{monthDay});
        config.setTemplateFileName(fileName);
        evt.setImportConfig(config);
    }

    public void onValidateTemplate(DataImportEvent evt) {
        List dataHead = evt.getDataHead();
        List dataRow = evt.getDataRow();
        List columns = SWCExportEntryHelper.readRuntimeEntryColumn((IFormView)this.getView(), (String)"entryentity");
        List containers = SWCExportEntryHelper.getEntryColumnContainers((List)columns, (Set)SWCExportEntryHelper.getIgnoreColumn((List)columns));
        int headHeight = SWCExportEntryHelper.calcSheetHeadHeight((List)containers);
        List dataHeadSource = SalaryStandardImportHelper.getSourceHeadData((List)containers, (int)headHeight, (IDataModel)this.getModel());
        Map gradeDataFromEntry = SalaryStandardImportHelper.getGradeDataFromEntry((DynamicObjectCollection)this.getModel().getEntryEntity("entryentity"), (int)(headHeight + 3));
        Map gradeDataFromExcel = SalaryStandardImportHelper.getGradeDataFromExcel((List)dataRow, (int)(headHeight + 3));
        AbstractFormPlugin source = (AbstractFormPlugin)evt.getSource();
        ValidateResults validateResult = new ValidateResults(ErrorLevel.Error);
        if (!SalaryStandardImportHelper.isEqualCollection((List)dataHeadSource, (List)dataHead) || !SalaryStandardImportHelper.chekMapEqual((Map)gradeDataFromEntry, (Map)gradeDataFromExcel)) {
            validateResult.failed();
            source.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002", (String)"ImportConstants_3", (String)"swc-hcdm-common", (Object[])new Object[0]));
        }
        List<Map<Integer, String>> copyList = this.copyList(dataRow);
        if (validateResult.isSuccess() && this.isRowDataEmpty(copyList)) {
            validateResult.failed();
            source.getView().showMessage(ResManager.loadKDString((String)"\u672a\u89e3\u6790\u5230\u6709\u6548\u6570\u636e\u3002", (String)"ImportConstants_0", (String)"swc-hcdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6570\u636e\u540e\u518d\u8bd5\u3002", (String)"ImportConstants_1", (String)"swc-hcdm-common", (Object[])new Object[0]), MessageTypes.Default);
        }
        evt.setValidateResults(validateResult);
    }

    public void dataImport(DataImportEvent evt) {
        List columns = SWCExportEntryHelper.readRuntimeEntryColumn((IFormView)this.getView(), (String)"entryentity");
        List containers = SWCExportEntryHelper.getEntryColumnContainers((List)columns, (Set)SWCExportEntryHelper.getIgnoreColumn((List)columns));
        int headHeight = SWCExportEntryHelper.calcSheetHeadHeight((List)containers);
        Map captions = SWCExportEntryHelper.getEntryFieldCaptions((List)containers);
        List dataHead = evt.getDataHead();
        Map colMap = (Map)dataHead.get(0);
        List dataRow = evt.getDataRow();
        ProgressHandler processHandler = evt.getProcessHandler();
        SalaryStandardEntryData stdData = SalaryStandardCacheHelper.getEntryData((String)this.getMainPage(this.getView().getFormShowParameter()));
        Map itemMap = SalaryStdItemHelper.groupById((List)stdData.getItemEntities());
        Map rankMap = GradeRankHelper.groupByRankIdentity((List)stdData.getRankEntities());
        Long stdId = stdData.getStdBaseEntity().getId();
        ArrayList<SalaryStdDataEntity> stdDataList = new ArrayList<SalaryStdDataEntity>(10);
        EntryFieldConstraintMapping constraintMapping = new EntryFieldConstraintMapping();
        for (int i = 0; i < dataRow.size(); ++i) {
            Map rowMap = (Map)dataRow.get(i);
            Integer excelRow = Integer.valueOf((String)rowMap.get(EntryImportContext.EXCEL_ROW_NUMBER));
            String gradeName = (String)rowMap.get(0);
            for (int col = 1; col < captions.size(); ++col) {
                String val = (String)rowMap.get(col);
                if (null == val || val.isEmpty()) continue;
                String colId = (String)colMap.get(col);
                DynamicFieldIdGenerationParamForGroup param = DynamicFieldIdGenerationParamForGroup.parseFrom((String)colId);
                Long itemId = param.getItemId();
                Long rankId = param.getRankId();
                int seq = param.getSeq();
                DecimalConverter converter = constraintMapping.getConstraintWithCache(stdData.getStdBaseEntity(), (SalaryStdItemEntity)itemMap.get(itemId), (SalaryRankEntity)rankMap.get(rankId), seq);
                ValidateResults validateType = converter.checkType((Object)val);
                if (validateType.isSuccess()) {
                    ValidateResults validateVal = converter.checkVal((Object)val);
                    if (validateVal.isSuccess()) {
                        SalaryGradeEntity gradeEntity = GradeRankHelper.getGradeByName((List)stdData.getGradeEntities(), (String)gradeName);
                        SalaryStdDataEntity entity = new SalaryStdDataEntity(stdId, itemId, gradeEntity.getGradeIdentity(), rankId, null, null, null, null);
                        entity.setValueBySeq(new BigDecimal(val), seq);
                        stdDataList.add(entity);
                        continue;
                    }
                    String message = (String)validateVal.getErrorList().get(0);
                    String itemName = ((SalaryStdItemEntity)itemMap.get(itemId)).getItemName();
                    String rankName = ((SalaryRankEntity)rankMap.get(rankId)).getRankName();
                    String errorMsg = this.generateErrorMsg(stdData, gradeName, itemName, rankName, message);
                    processHandler.putRowError(excelRow, errorMsg);
                    continue;
                }
                String message = (String)validateType.getErrorList().get(0);
                String itemName = ((SalaryStdItemEntity)itemMap.get(itemId)).getItemName();
                String rankName = ((SalaryRankEntity)rankMap.get(rankId)).getRankName();
                String errorMsg = this.generateErrorMsg(stdData, gradeName, itemName, rankName, message);
                processHandler.putRowError(excelRow, errorMsg);
            }
        }
        if (processHandler.getLogCache().size() == 0) {
            IFormView mainPage = this.getView().getView(this.getMainPage(this.getView().getFormShowParameter()));
            List oldstdDataList = stdData.getStdDataEntities();
            List<SalaryStdDataEntity> allstdDataList = this.mergeSalaryStdDataEntities(oldstdDataList, stdDataList);
            stdData.buildStdData(allstdDataList);
            SalaryStdCalculateHelper.calculate((IFormView)mainPage, (SalaryStandardEntryData)stdData, null);
            this.pushStdData(stdData.getStdDataEntities(), mainPage);
            processHandler.updateProgress(SalaryStandardImportHelper.getRowDataSize((List)dataRow), 0);
        } else {
            processHandler.updateProgress(0, SalaryStandardImportHelper.getRowDataSize((List)dataRow));
        }
    }

    public void afterImport(DataImportEvent evt) {
    }

    public void loadCustomEntryMetas(LoadCustomEntryMetasEvent evt) {
        EntryColumnWrapper wrapper = SWCExportEntryHelper.readEntryColumnInfo((IFormView)this.getView(), (String)"entryentity");
        evt.setEntryColumnWrapper(wrapper);
    }

    public void beforeImport(DataImportEvent evt) {
        int rowDataSize = SalaryStandardImportHelper.getRowDataSize((List)evt.getDataRow());
        evt.setEffectiveDataRow(rowDataSize);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"ImportStartCloseCallBack")) {
            this.getView().updateView();
        }
    }

    public void beforeWriteTemplate(BeforeWriteTemplateEvent evt) {
        IDataModel model = this.getView().getModel();
        DynamicObjectCollection rows = model.getEntryEntity("entryentity");
        EntryColumnWrapper wrapper = SWCExportEntryHelper.readEntryColumnInfo((IFormView)this.getView(), (String)"entryentity");
        Map captions = SWCExportEntryHelper.getEntryFieldCaptions((List)wrapper.getContainers());
        String gradeFieldKey = new FixedFieldIdGenerationParam("dgff", SalaryStdGridDisplayTypeEnum.GROUPITEMS, "textfield", "grade").generateKey();
        DynamicObjectCollection dyColl = new DynamicObjectCollection();
        for (DynamicObject row : rows) {
            for (String filedName : captions.keySet()) {
                if (SWCStringUtils.equals((String)filedName, (String)gradeFieldKey)) continue;
                row.set(filedName, null);
            }
            dyColl.add((Object)row);
        }
        evt.setDynamicObjectCollection(dyColl);
    }

    private List<ValidateResult> getValidateResults(SalaryStandardEntryData stdData) {
        ValidateContext validateContext = new ValidateContext((Object)stdData);
        ValidatorTree tree = new ValidatorTree();
        ValidatorTree.ValidatorNode root = tree.getRoot();
        ValidatorAdapter adapter = ValidatorAdapter.build((ValidateContext)validateContext, (ValidatorTree)tree);
        adapter.validate();
        return adapter.getValidateContext().getResults();
    }

    private List<SalaryStdDataEntity> mergeSalaryStdDataEntities(List<SalaryStdDataEntity> oldStdDataList, List<SalaryStdDataEntity> newStdDataList) {
        if (CollectionUtils.isEmpty(oldStdDataList)) {
            return newStdDataList;
        }
        ArrayList<SalaryStdDataEntity> notExistList = new ArrayList<SalaryStdDataEntity>(10);
        for (SalaryStdDataEntity oldDntity : oldStdDataList) {
            int mark = 0;
            for (SalaryStdDataEntity newEntity : newStdDataList) {
                if (!oldDntity.getItemIdentity().equals(newEntity.getItemIdentity()) || !oldDntity.getGradeIdentity().equals(newEntity.getGradeIdentity()) || !oldDntity.getRankIdentity().equals(newEntity.getRankIdentity())) continue;
                ++mark;
            }
            if (mark != 0) continue;
            notExistList.add(oldDntity);
        }
        newStdDataList.addAll(notExistList);
        return newStdDataList;
    }

    private String generateErrorMsg(SalaryStandardEntryData stdData, String gradeName, String itemName, String rankName, String msg) {
        SalaryStandardBaseEntity stdBaseEntity = stdData.getStdBaseEntity();
        SalaryStandardTypeEnum type = stdBaseEntity.getType();
        int isUseSalaryRank = stdBaseEntity.getIsUseSalaryRank();
        StringBuilder sb = new StringBuilder();
        sb.append(itemName).append(gradeName);
        if (SalaryStandardTypeEnum.BROADBAND == type || isUseSalaryRank > 0) {
            return sb.append(rankName).append('\uff1a').append(msg).toString();
        }
        return sb.append('\uff1a').append(msg).toString();
    }

    private List<Map<Integer, String>> copyList(List<Map<Integer, String>> dataRows) {
        ArrayList<Map<Integer, String>> deepCopyList = new ArrayList<Map<Integer, String>>(dataRows.size());
        for (Map<Integer, String> dataRow : dataRows) {
            try {
                Map newInstance = (Map)dataRow.getClass().newInstance();
                newInstance.putAll(dataRow);
                deepCopyList.add(newInstance);
            }
            catch (InstantiationException e) {
                log.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Throwable)e);
            }
        }
        return deepCopyList;
    }

    private boolean isRowDataEmpty(List<Map<Integer, String>> dataRow) {
        for (Map<Integer, String> rowMap : dataRow) {
            rowMap.keySet().removeIf(key -> key == 0);
            if (CollectionUtils.isEmpty(rowMap)) continue;
            return false;
        }
        return true;
    }

    private ValidateResult validateMustInput() {
        SalaryStandardEntryData entryData = SalaryStandardCacheHelper.getEntryData((String)this.getMainPage(this.getView().getFormShowParameter()));
        ValidateContext validateContext = new ValidateContext((Object)entryData);
        ValidatorTree validators = SalaryStandardImportHelper.getMustInputValidatorTreeForDesign((ValidateContext)validateContext);
        ValidatorAdapter adpter = ValidatorAdapter.build((ValidateContext)validateContext, (ValidatorTree)validators);
        adpter.validate();
        List results = adpter.getValidateContext().getResults();
        for (ValidateResult result : results) {
            if (result.isSuccess()) continue;
            ValidateResult validateResult = new ValidateResult(ErrorLevel.Warning);
            validateResult.addErrorMsg(ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u6210\u5fc5\u586b\u9879\u8bbe\u7f6e\uff0c\u518d\u8fdb\u884c\u6a21\u677f\u4e0b\u8f7d\u3002", (String)"SalaryStandardGridImportEdit_0", (String)"swc-hcdm-formplugin", (Object[])new Object[0]));
            return validateResult;
        }
        return new ValidateResult(ErrorLevel.Info);
    }

    private boolean isSuccess(List<ValidateResult> results) {
        for (ValidateResult result : results) {
            if (result.isSuccess()) continue;
            return false;
        }
        return true;
    }

    private void pushStdData(List<SalaryStdDataEntity> stdDataList, IFormView mainPage) {
        SalaryStandardPageInteractionHelper.updateSalaryStdDataEnt((IFormView)mainPage, stdDataList);
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        this.cacheEntryData(mainPage);
        this.setEntryContent(rows);
        this.getModel().updateEntryCache(rows);
    }

    private Set<String> getClearColumns(List<EntryColumnContainer> containers) {
        Map captions = SWCExportEntryHelper.getEntryFieldCaptions(containers);
        HashSet<String> result = new HashSet<String>(16);
        String gradeFieldKey = new FixedFieldIdGenerationParam("dgff", SalaryStdGridDisplayTypeEnum.GROUPITEMS, "textfield", "grade").generateKey();
        for (String key : captions.keySet()) {
            if (gradeFieldKey.equals(key)) continue;
            result.add(key);
        }
        return result;
    }
}

