/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.salarystandard;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.EntryGridSetRowDataEvent;
import kd.bos.form.control.events.EntryGridSetRowDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.swc.hcdm.business.calculate.SalaryStdCalculateHelper;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hcdm.business.salarystandard.FieldGenerator;
import kd.swc.hcdm.business.salarystandard.SalaryStandardCacheHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardPageInteractionHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardViewHelper;
import kd.swc.hcdm.business.utils.MetaUtils;
import kd.swc.hcdm.common.entity.salarystandard.BaseDynamicGridFieldIdGenerationParam;
import kd.swc.hcdm.common.entity.salarystandard.DynamicFieldIdGenerationParamForGroup;
import kd.swc.hcdm.common.entity.salarystandard.FieldEditGenerationParam;
import kd.swc.hcdm.formplugin.salarystandard.SalaryStandardGridViewCommon;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.ReflectUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;

public class SalaryStandardGridView
extends SalaryStandardGridViewCommon
implements EntryGridBindDataListener,
EntryGridSetRowDataListener {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        IFormView mainView = this.getView().getParentView().getParentView();
        SWCPermissionServiceHelper.checkCancelDataAndFunctionRightWithException((IFormView)mainView, (boolean)true);
        this.getView().getPageCache().put("BOS.setRowDataByNumberUpdateView", "true");
        this.completeFieldEdit(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter source = (FormShowParameter)args.getSource();
        SalaryStandardEntryData stdData = this.getStdTabFromCache(source);
        if (stdData == null) {
            return;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hcdm_salarystdgridview", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        EntryAp entryAp = SalaryStandardViewHelper.createEntryAp((EntityMetadata)entityMetadata, (SalaryStandardEntryData)stdData);
        Object columns = entryAp.createControl().get("columns");
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)columns);
        args.getItems().add(mapEntry);
    }

    public void entryGridSetRowData(EntryGridSetRowDataEvent e) {
        this.batchDoPropertyChange(e.getValues());
    }

    public void beforeBindData(EventObject eventObject) {
        this.completeFieldEdit(false);
        SalaryStandardEntryData stdData = this.getStdTabFromCache(this.getView().getFormShowParameter());
        this.getModel().setValue("currencyamountstr", (Object)EntityConverter.generateMoneyaryUnitStr((SalaryStandardBaseEntity)stdData.getStdBaseEntity()));
        this.getView().setVisible(Boolean.valueOf(stdData.getViewControlParam().getCanEdit() > 0), new String[]{"calcandsave"});
        this.getView().setVisible(Boolean.valueOf(stdData.getViewControlParam().getCanEdit() > 0), new String[]{"buttonap_import"});
        this.getView().getPageCache().put("BOS.setRowDataByNumberDisable", "false");
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (key.startsWith("dgff") || key.startsWith("dgdf")) {
            BaseDynamicGridFieldIdGenerationParam generationParam = BaseDynamicGridFieldIdGenerationParam.parseFrom((String)key);
            FieldEdit fieldEdit = FieldGenerator.invokeCreateFieldEdit((FieldEditGenerationParam)new FieldEditGenerationParam(key, "entryentity", this.getView()), (String)generationParam.getFieldType());
            args.setControl((Control)fieldEdit);
        }
    }

    public void createNewData(BizDataEventArgs args) {
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entryentity");
        this.setEntryContent(rows);
        args.setDataEntity((Object)dataEntity);
    }

    public void entryGridBindData(EntryGridBindDataEvent event) {
        SalaryStandardEntryData standardEntryData = this.getStdTabFromCache(this.getView().getFormShowParameter());
        if (standardEntryData != null) {
            SalaryStandardBaseEntity baseEntity = standardEntryData.getStdBaseEntity();
            for (RowDataEntity row : event.getRows()) {
                SalaryStandardViewHelper.fixAmtPrecision((DynamicObject)row.getDataEntity(), (int)baseEntity.getCurrencyEntity().getAmtPrecision());
            }
        }
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        MainEntityType oldMainType = args.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new KDException((Throwable)e1, new ErrorCode("LoadCustomControlMetasSample", e1.getMessage()), new Object[0]);
        }
        SalaryStandardEntryData stdData = this.getStdTabFromCache(this.getView().getFormShowParameter());
        if (stdData == null) {
            return;
        }
        IDataEntityProperty property = this.getModel().getProperty("entryentity");
        Object rowIndexObj = this.getView().getFormShowParameter().getCustomParam("graderankrowindex");
        SalaryStandardViewHelper.registerProperty((SalaryStandardEntryData)stdData, (EntryType)((EntryType)newMainType.getAllEntities().get("entryentity")), (IDataEntityProperty)property, (Object)rowIndexObj);
        args.setNewEntityType(newMainType);
    }

    public void beforePropertyChanged(PropertyChangedArgs args) {
        SalaryStandardEntryData standardEntryData;
        if (args.getProperty() instanceof AmountProp && (standardEntryData = this.getStdTabFromCache(this.getView().getFormShowParameter())) != null) {
            SalaryStandardBaseEntity baseEntity = standardEntryData.getStdBaseEntity();
            for (ChangeData changeData : args.getChangeSet()) {
                SalaryStandardViewHelper.fixAmtPrecision((DynamicObject)changeData.getDataEntity(), (int)baseEntity.getCurrencyEntity().getAmtPrecision());
            }
        }
    }

    private void batchDoPropertyChange(Map<String, List<Tuple<Integer, Object>>> values) {
        ArrayList stdDataList = Lists.newArrayListWithCapacity((int)10);
        IFormView mainPage = this.getView().getView(this.getMainPage(this.getView().getFormShowParameter()));
        SalaryStandardEntryData entryData = this.getStdTabFromCache(this.getView().getFormShowParameter());
        int amtPrecision = entryData.getStdBaseEntity().getCurrencyEntity().getAmtPrecision();
        BigDecimal salaryCountAmount = entryData.getStdBaseEntity().getSalaryCountAmount();
        EntryProp entryProp = (EntryProp)this.getModel().getProperty("entryentity");
        DataEntityPropertyCollection properties = entryProp.getDynamicCollectionItemPropertyType().getProperties();
        List dynamicProperties = SalaryStandardViewHelper.findPropertyWithPrefix((List)properties, (String)"dgdf");
        for (Map.Entry<String, List<Tuple<Integer, Object>>> entry : values.entrySet()) {
            String properName = entry.getKey();
            if (properName.startsWith("dgdf")) {
                DynamicObject dynamicObject;
                Integer rowIndex;
                DecimalProp dp = (DecimalProp)properties.get((Object)properName);
                DynamicFieldIdGenerationParamForGroup param = DynamicFieldIdGenerationParamForGroup.parseFrom((String)properName);
                IDataEntityProperty valueProp = param.findValueFieldProperty(dynamicProperties);
                if (param.isSalaryCountField()) {
                    for (Tuple<Integer, Object> changeData : entry.getValue()) {
                        rowIndex = (Integer)changeData.item1;
                        dynamicObject = this.getModel().getEntryRowEntity("entryentity", rowIndex.intValue());
                        BigDecimal salaryCountNum = this.getBigDecimal(changeData.item2);
                        BigDecimal valValue = SalaryStdCalculateHelper.doCalcValueBySalaryCount((BigDecimal)salaryCountNum, (BigDecimal)salaryCountAmount, (int)amtPrecision);
                        SalaryGradeEntity gradeEntity = SalaryStandardViewHelper.fetchGradeFromEntryRow((DynamicObject)dynamicObject, (List)entryData.getGradeEntities());
                        SalaryStdDataEntity entity = new SalaryStdDataEntity(entryData.getStdBaseEntity().getId(), param.getItemId(), gradeEntity.getGradeIdentity(), param.getRankId(), salaryCountNum, valValue, BigDecimal.ZERO, BigDecimal.ZERO);
                        stdDataList.add(entity);
                        if (valueProp != null) {
                            this.getModel().setValue(valueProp, dynamicObject, (Object)valValue);
                            continue;
                        }
                        this.checkPrecision(valValue, dp, salaryCountNum);
                    }
                } else {
                    for (Tuple<Integer, Object> changeData : entry.getValue()) {
                        rowIndex = (Integer)changeData.item1;
                        dynamicObject = this.getModel().getEntryRowEntity("entryentity", rowIndex.intValue());
                        BigDecimal valValue = this.getBigDecimal(changeData.item2);
                        SalaryGradeEntity gradeEntity = SalaryStandardViewHelper.fetchGradeFromEntryRow((DynamicObject)dynamicObject, (List)entryData.getGradeEntities());
                        SalaryStdDataEntity entity = new SalaryStdDataEntity(entryData.getStdBaseEntity().getId(), param.getItemId(), gradeEntity.getGradeIdentity(), param.getRankId(), null, valValue, BigDecimal.ZERO, BigDecimal.ZERO);
                        stdDataList.add(entity);
                    }
                }
            }
            this.pushStdData(stdDataList, mainPage);
        }
    }

    private BigDecimal getBigDecimal(Object val) {
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val instanceof String && NumberUtils.isNumber((String)((String)val))) {
            return BigDecimal.valueOf(NumberUtils.toDouble((String)((String)val)));
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        IDataEntityProperty property = args.getProperty();
        if (property.getName().startsWith("dgdf")) {
            ArrayList collect = Lists.newArrayListWithCapacity((int)args.getChangeSet().length);
            for (ChangeData changeData : args.getChangeSet()) {
                collect.add(new Tuple((Object)changeData.getRowIndex(), changeData.getNewValue()));
            }
            this.batchDoPropertyChange(Collections.singletonMap(property.getName(), collect));
        }
    }

    protected boolean checkPrecision(BigDecimal decimal, DecimalProp decimalProp, BigDecimal salaryCountNum) {
        if (null == decimal) {
            return true;
        }
        if (decimal.precision() - decimal.scale() > decimalProp.getPrecision() - decimalProp.getScale() && decimal.compareTo(BigDecimal.valueOf(0L)) != 0) {
            LocaleString displayName = decimalProp.getDisplayName();
            String err = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d \u00d7 \u201c\u85aa\u70b9\u201d \u7684\u7ed3\u679c\u503c\u8fc7\u5927\u3002\u6574\u6570\u90e8\u5206\u4e0d\u80fd\u8d85\u8fc7%2$s\u4f4d\uff0c\u5c0f\u6570\u90e8\u5206\u4e0d\u80fd\u8d85\u8fc7%3$s\u4f4d\u3002", (String)"SalaryStandardGridView_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), displayName != null ? displayName.toString() : decimalProp.getName(), String.valueOf(decimalProp.getPrecision() - decimalProp.getScale()), String.valueOf(decimalProp.getScale()));
            throw new KDBizException(err);
        }
        return true;
    }

    private void pushStdData(List<SalaryStdDataEntity> stdDataList, IFormView mainPage) {
        SalaryStandardPageInteractionHelper.updateSalaryStdDataEnt((IFormView)mainPage, stdDataList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        this.completeFieldEdit(true);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"donothing_calcandsave")) {
            IFormView mainPage = this.getView().getView(this.getMainPage(this.getView().getFormShowParameter()));
            mainPage.getPageCache().put("calcLockPage", "true");
            this.getView().showLoading(ResManager.getLocaleString((String)"\u4fdd\u5b58\u4e2d", (String)"SalaryStandardGridView_2", (String)"swc-hcdm-formplugin"));
            try {
                this.doCalc(mainPage);
                this.cacheEntryData(mainPage);
                this.setEntryContent(this.getModel().getEntryEntity("entryentity"));
                OperateOption option = OperateOption.create();
                option.setVariableValue("ignoreCalc", "true");
                mainPage.invokeOperation("save", option);
                mainPage.getModel().updateCache();
            }
            catch (Exception exception) {
            }
            finally {
                mainPage.getPageCache().remove("calcLockPage");
                this.getView().hideLoading();
            }
            this.getView().updateView();
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        SalaryStandardCacheHelper.clearCache((String)this.getView().getPageId());
    }

    public void initialize() {
        SalaryStandardEntryData standardEntryData;
        super.initialize();
        SalaryStandardCacheHelper.putStdGridPageId((String)this.getMainPage(this.getView().getFormShowParameter()), (Object)this.getView().getPageId());
        System.setProperty("checkamountprecision", "true");
        Object currencyFixed = this.getModel().getContextVariable("currencyfixed");
        if (this.getModel().isDataLoaded() && currencyFixed == null && (standardEntryData = this.getStdTabFromCache(this.getView().getFormShowParameter())) != null) {
            SalaryStandardBaseEntity baseEntity = standardEntryData.getStdBaseEntity();
            try {
                DynamicObjectCollection rows = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                for (DynamicObject row : rows) {
                    SalaryStandardViewHelper.fixAmtPrecision((DynamicObject)row, (int)baseEntity.getCurrencyEntity().getAmtPrecision());
                }
                this.getModel().putContextVariable("currencyfixed", (Object)Boolean.TRUE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void completeFieldEdit(boolean resetDataIndexNull) {
        SalaryStandardEntryData stdData = this.getStdTabFromCache(this.getView().getFormShowParameter());
        if (stdData == null) {
            return;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hcdm_salarystdgridview", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        EntryAp entryAp = SalaryStandardViewHelper.createEntryAp((EntityMetadata)entityMetadata, (SalaryStandardEntryData)stdData);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        entryGrid.addSetRowDataListener((EntryGridSetRowDataListener)this);
        List controlList = MetaUtils.fetchFieldEdit((List)((Container)entryAp.buildRuntimeControl()).getItems());
        for (Control fieldEdit : controlList) {
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
        if (resetDataIndexNull) {
            ReflectUtils.setFieldValue((String)"dataIndex", (Object)entryGrid, null);
        }
    }
}

