/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.formplugin.salarystandard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.swc.hcdm.business.SalaryStandardSerializationUtils;
import kd.swc.hcdm.business.enums.SalaryStandardPreDataPolicyType;
import kd.swc.hcdm.business.enums.StdDimensionsType;
import kd.swc.hcdm.business.policy.salarystandard.IPreDataPolicy;
import kd.swc.hcdm.business.salarystandard.SalaryStandardCacheHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardImportHelper;
import kd.swc.hcdm.business.salarystandard.StdTabValSetHelper;
import kd.swc.hcdm.business.salarystandard.dimensions.ComparisonTemplate;
import kd.swc.hcdm.business.salarystandard.dimensions.GradeComparisonTemplate;
import kd.swc.hcdm.business.salarystandard.dimensions.RankComparisonTemplate;
import kd.swc.hcdm.business.vo.salarystandard.SalaryStandardEntryEntity;
import kd.swc.hcdm.business.vo.salarystandard.SalaryStandardEntryEntityVO;
import kd.swc.hcdm.business.vo.salarystandard.SalaryStandardPreDataParam;

public class SalaryStandardNameDesignerEdit
extends AbstractBasePlugIn {
    private static final int ONE_ROW = 1;
    private static final Long EMPTY_ID = 0L;
    public static final String PROJECT_RESOURCE = "swc-hcdm-formplugin";
    private static final String ENTRY_SEQ = "seq";
    private static final String ENTRY_DISPLAY_NAME = "displayname";
    private static final String ENTRY_ENTITY_ID = "entityid";
    private static final String FORM_NUMBER = "formnumber";
    private static final String RANK_FORM_NUMBER = "formnumber1";
    private static final String FORM_PRE_DATA_POLICY = "predatapolicy";
    private static final String FORM_MIN_COUNT = "mincount";
    private static final String FORM_PREFIX = "prefix";
    private static final String FORM_SUFFIX = "suffix";
    private static final String FORM_DIMENSIONS_TYPE = "dimensionstype";
    private static final String FORM_TYPE_SUFFIX = "typesuffix";
    private static final String BAR_ADD = "bar_add";
    private static final String BAR_CLEAN = "bar_clean";
    private static final String TOOL_BAR = "advcontoolbarap";
    private static final String BTN_CANCEL = "btn_cancel";
    private static final String BTN_SAVE = "btn_save";
    private static final String DELETE_CONFIRM = "delete_confirm";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{TOOL_BAR});
        this.addClickListeners(new String[]{BTN_SAVE, BTN_CANCEL});
    }

    public void itemClick(ItemClickEvent evt) {
        String operateKey;
        super.itemClick(evt);
        switch (operateKey = evt.getItemKey()) {
            case "bar_add": {
                this.addOneRowLast();
                break;
            }
            case "bar_clean": {
                this.cleanEntryEntity();
                break;
            }
        }
    }

    private void cleanEntryEntity() {
        String stepperName = this.getStepperName();
        this.getModel().setValue(stepperName, (Object)0);
        this.getView().updateView(stepperName);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.getView().setStatus(this.getView().getFormShowParameter().getStatus());
        SalaryStandardEntryEntityVO transformData = this.getTransformData();
        this.initFormData(transformData);
        this.hiddenStepper();
    }

    private void hiddenStepper() {
        if (this.getDimensionsTypeFromModel() == StdDimensionsType.RANK) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FORM_NUMBER});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{RANK_FORM_NUMBER});
        }
    }

    private SalaryStandardEntryEntityVO getTransformData() {
        String content = (String)this.getView().getFormShowParameter().getCustomParam("data");
        return (SalaryStandardEntryEntityVO)SalaryStandardSerializationUtils.fromJsonString((String)content, SalaryStandardEntryEntityVO.class);
    }

    private void initFormData(SalaryStandardEntryEntityVO transformData) {
        if (null == transformData) {
            transformData = new SalaryStandardEntryEntityVO();
        }
        StdDimensionsType stdDimensionsType = Optional.ofNullable(transformData.getType()).orElse(StdDimensionsType.RANK);
        this.getModel().setValue(FORM_DIMENSIONS_TYPE, (Object)stdDimensionsType.name());
        this.getModel().setValue(FORM_TYPE_SUFFIX, (Object)stdDimensionsType.getNameParam().loadKDString());
        this.getModel().setValue(FORM_MIN_COUNT, (Object)transformData.getMinCount());
        this.getModel().setValue(FORM_PRE_DATA_POLICY, (Object)Optional.ofNullable(transformData.getPreDataPolicy()).map(SalaryStandardPreDataParam::getPreDataPolicyType).map(SalaryStandardPreDataPolicyType::getName).orElseGet(() -> ((SalaryStandardPreDataPolicyType)SalaryStandardPreDataPolicyType.NUMBER).getName()));
        List<SalaryStandardEntryEntity> salaryStandardEntryEntities = this.getTransformEntryData(transformData);
        if (stdDimensionsType == StdDimensionsType.GRADE) {
            this.getModel().setValue(FORM_NUMBER, (Object)salaryStandardEntryEntities.size());
        } else {
            this.getModel().setValue(RANK_FORM_NUMBER, (Object)salaryStandardEntryEntities.size());
        }
        this.getModel().setValue(FORM_PREFIX, (Object)this.getPrefix(transformData));
        this.getModel().setValue(FORM_SUFFIX, (Object)this.getSuffix(transformData));
        this.insertEntryEntity(salaryStandardEntryEntities);
    }

    private List<SalaryStandardEntryEntity> getTransformEntryData(SalaryStandardEntryEntityVO transformData) {
        return transformData.getSalaryStandardEntryEntities().stream().sorted(Comparator.comparing(SalaryStandardEntryEntity::getIndex)).collect(Collectors.toList());
    }

    private String getSuffix(SalaryStandardEntryEntityVO transformData) {
        String suffix = Optional.ofNullable(transformData.getPreDataPolicy()).map(SalaryStandardPreDataParam::getSuffix).orElse("");
        if (Lang.en_US.equals((Object)RequestContext.get().getLang())) {
            suffix = " " + suffix;
        }
        return suffix;
    }

    private String getPrefix(SalaryStandardEntryEntityVO transformData) {
        String prefix = Optional.ofNullable(transformData.getPreDataPolicy()).map(SalaryStandardPreDataParam::getPrefix).orElse("");
        if (Lang.en_US.equals((Object)RequestContext.get().getLang())) {
            prefix = prefix + " ";
        }
        return prefix;
    }

    private void insertEntryEntity(List<SalaryStandardEntryEntity> salaryStandardEntryEntities) {
        TableValueSetter setter = StdTabValSetHelper.getNameDesignerGridTableValueSetter(salaryStandardEntryEntities);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs args) {
        String stepperName = this.getStepperName();
        this.resetCount(this.getEntryEntityRowCount(), stepperName);
        this.resetIdWithOldDataIndex();
    }

    public void afterAddRow(AfterAddRowEventArgs args) {
        int rowCount = this.getEntryEntityRowCount();
        String stepperName = this.getStepperName();
        this.resetCount(rowCount, stepperName);
        this.selectLastRow(rowCount);
    }

    private void resetIdWithOldDataIndex() {
        Map<Integer, SalaryStandardEntryEntity> oldDataMapByIndex = this.getOldDataMapByIndex();
        this.getModel().beginInit();
        int entryEntityRowCount = this.getEntryEntityRowCount();
        for (int i = 0; i < entryEntityRowCount; ++i) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", i);
            rowEntity.set("index", (Object)(i + 1));
            SalaryStandardEntryEntity oldEntityByIndex = oldDataMapByIndex.get(i);
            if (oldEntityByIndex == null) continue;
            this.getModel().setValue(ENTRY_ENTITY_ID, (Object)oldEntityByIndex.getId(), i);
        }
        this.getModel().endInit();
    }

    private void selectLastRow(int rowCount) {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        grid.focusCell(rowCount - 1, ENTRY_DISPLAY_NAME);
    }

    private void addOneRowLast() {
        int maxRow = SalaryStandardImportHelper.getMaxRow((String)this.getStepperName());
        this.addRowLast(1, maxRow);
    }

    private void addRowLast(int count, int maxRow) {
        int rowCount = this.getEntryEntityRowCount();
        if (rowCount >= maxRow) {
            this.showOutOfLimitMessage(maxRow);
        } else {
            List<SalaryStandardEntryEntity> createdDataList = this.createSalaryStandardEntryEntity(rowCount, count, this.getPrefixFromModel(), this.getSuffixFromModel());
            this.getModel().beginInit();
            this.insertEntryEntity(createdDataList);
            this.getModel().endInit();
        }
        rowCount = this.getEntryEntityRowCount();
        String stepperName = this.getStepperName();
        this.resetCount(rowCount, stepperName);
        this.selectLastRow(rowCount);
    }

    private String getStepperName() {
        return this.getDimensionsTypeFromModel() == StdDimensionsType.GRADE ? FORM_NUMBER : RANK_FORM_NUMBER;
    }

    private void showOutOfLimitMessage(int maxRow) {
        String errMsg = this.getDimensionsTypeFromModel() == StdDimensionsType.RANK ? String.format(Locale.ROOT, ResManager.loadKDString((String)"\u85aa\u6863\u6709\u6548\u8303\u56f4\u4e3a1~%d\u6863\uff0c\u8bf7\u5728\u6b64\u8303\u56f4\u5185\u65b0\u589e\u3002", (String)"SalaryStandardNameDesignerEdit_3", (String)PROJECT_RESOURCE, (Object[])new Object[0]), maxRow) : String.format(Locale.ROOT, ResManager.loadKDString((String)"\u85aa\u7b49\u6709\u6548\u8303\u56f4\u4e3a1~%d\uff0c\u8bf7\u5728\u6b64\u8303\u56f4\u5185\u65b0\u589e\u3002", (String)"SalaryStandardNameDesignerEdit_4", (String)PROJECT_RESOURCE, (Object[])new Object[0]), maxRow);
        this.getView().showTipNotification(errMsg);
    }

    private List<SalaryStandardEntryEntity> createSalaryStandardEntryEntity(int currentRowIndex, int count, String prefix, String suffix) {
        return this.createSalaryStandardEntryEntities(currentRowIndex, count, this.getPreDataPolicy().createPreData(currentRowIndex, count, prefix, suffix));
    }

    private List<SalaryStandardEntryEntity> createSalaryStandardEntryEntities(int currentRowIndex, int count, List<String> preDataList) {
        ArrayList<SalaryStandardEntryEntity> result = new ArrayList<SalaryStandardEntryEntity>(count);
        Map<Integer, SalaryStandardEntryEntity> oldDataMap = this.getOldDataMapByIndex();
        for (int i = 0; i < count; ++i) {
            String data = preDataList.get(i);
            SalaryStandardEntryEntity entryEntity = new SalaryStandardEntryEntity();
            int index = currentRowIndex + i;
            SalaryStandardEntryEntity salaryStandardEntryEntity = oldDataMap.get(index);
            entryEntity.setId(salaryStandardEntryEntity != null ? salaryStandardEntryEntity.getId() : EMPTY_ID);
            entryEntity.setIndex(Integer.valueOf(index));
            entryEntity.setDisplayName(data);
            result.add(entryEntity);
        }
        return result;
    }

    private Map<Integer, SalaryStandardEntryEntity> getOldDataMapByIndex() {
        SalaryStandardEntryEntityVO oldData = this.getTransformData();
        List salaryStandardEntryEntities = oldData.getSalaryStandardEntryEntities();
        return salaryStandardEntryEntities.stream().collect(Collectors.toMap(entity -> entity.getIndex() - 1, Function.identity(), (p1, p2) -> p1));
    }

    private IPreDataPolicy getPreDataPolicy() {
        Object value = this.getModel().getValue(FORM_PRE_DATA_POLICY);
        if (null == value) {
            return SalaryStandardPreDataPolicyType.NUMBER.getPreDataPolicy();
        }
        return SalaryStandardPreDataPolicyType.valueOf((String)value.toString()).getPreDataPolicy();
    }

    private int getEntryEntityRowCount() {
        return this.getModel().getEntryEntity("entryentity").getRowCount();
    }

    private String getPrefixFromModel() {
        return this.getFormStringValue(FORM_PREFIX);
    }

    private String getSuffixFromModel() {
        return this.getFormStringValue(FORM_SUFFIX);
    }

    private String getFormStringValue(String position) {
        return Optional.ofNullable(this.getModel().getValue(position)).map(Object::toString).orElse("");
    }

    private StdDimensionsType getDimensionsTypeFromModel() {
        return StdDimensionsType.valueOf((String)this.getModel().getValue(FORM_DIMENSIONS_TYPE).toString());
    }

    private void resetCount(int count, String stepperName) {
        this.getModel().beginInit();
        this.getModel().setValue(stepperName, (Object)count);
        this.getModel().endInit();
        this.getView().updateView(stepperName);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_cancel": {
                this.getView().close();
                break;
            }
            case "btn_save": {
                this.validateAndShowConfirm();
                break;
            }
        }
    }

    private void validateAndShowConfirm() {
        ComparisonTemplate template;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (!this.isDateCountEnough()) {
            return;
        }
        if (!this.isDataWithoutBlank(entryEntity)) {
            String errMsg = ResManager.loadKDString((String)"\u663e\u793a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SalaryStandardNameDesignerEdit_1", (String)PROJECT_RESOURCE, (Object[])new Object[0]);
            this.getView().showTipNotification(errMsg);
            return;
        }
        List<SalaryStandardEntryEntity> entities = this.makeEntryEntities(entryEntity);
        if (!this.isDataWithoutDuplication(entities)) {
            return;
        }
        SalaryStandardEntryData cachedData = this.getSalaryStandardEntryData();
        Set<Long> preRankIds = cachedData.getRankEntities().stream().filter(entity -> entity.getRankIsUserSet() == 0 || entity.getRankIsSysPreSet() == 1).map(SalaryRankEntity::getRankIdentity).collect(Collectors.toSet());
        StdDimensionsType dimensionsType = this.getDimensionsTypeFromModel();
        List transformEntryData = this.getTransformData().getSalaryStandardEntryEntities();
        if (!CollectionUtils.isEmpty((Collection)transformEntryData) && (template = this.getTemplateByType(this.getTransformData().getSalaryStandardEntryEntities(), entities, dimensionsType, preRankIds)).hasAnyDeleted()) {
            this.showWarnConfirm(template.warningMessage());
            return;
        }
        this.transferDataToParentPage(entities);
    }

    private void showWarnConfirm(String message) {
        this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_CONFIRM, (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals(DELETE_CONFIRM) && this.isClickYes(messageBoxClosedEvent)) {
            this.transferDataToParentPage(this.makeEntryEntities(this.getModel().getEntryEntity("entryentity")));
        }
    }

    private boolean isClickYes(MessageBoxClosedEvent messageBoxClosedEvent) {
        return StringUtils.equals((CharSequence)"Yes", (CharSequence)messageBoxClosedEvent.getResultValue());
    }

    private ComparisonTemplate getTemplateByType(List<SalaryStandardEntryEntity> transformData, List<SalaryStandardEntryEntity> entities, StdDimensionsType dimensionsType, Set<Long> preRankIds) {
        if (dimensionsType == StdDimensionsType.RANK) {
            return new RankComparisonTemplate(transformData, this.getOriginEntryData(entities), preRankIds);
        }
        return new GradeComparisonTemplate(transformData, this.getOriginEntryData(entities));
    }

    private Set<Long> getOriginEntryData(List<SalaryStandardEntryEntity> entities) {
        return entities.stream().filter(entity -> entity.getId() != 0L).map(SalaryStandardEntryEntity::getId).collect(Collectors.toSet());
    }

    private void transferDataToParentPage(List<SalaryStandardEntryEntity> entities) {
        SalaryStandardEntryEntityVO entityVO = new SalaryStandardEntryEntityVO();
        entityVO.setSalaryStandardEntryEntities(entities);
        if (entities != null && this.isOverLimitDataTotal(entities.size())) {
            return;
        }
        this.getView().returnDataToParent((Object)entityVO);
        this.getView().close();
    }

    private SalaryStandardEntryData getSalaryStandardEntryData() {
        return SalaryStandardCacheHelper.getEntryData((String)this.getView().getFormShowParameter().getParentPageId());
    }

    private boolean isOverLimitDataTotal(int curCount) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        if (fsp != null) {
            String itemCountStr;
            int itemCount;
            String rankCountStr;
            int rankCount;
            int total;
            if ("true".equals(fsp.getCustomParam("salaryrank"))) {
                String itemCountStr2;
                int itemCount2;
                String gradeCountStr = (String)fsp.getCustomParam("salarygradecount");
                int gradeCount = Integer.parseInt(gradeCountStr);
                int total2 = gradeCount * (itemCount2 = Integer.parseInt(itemCountStr2 = (String)fsp.getCustomParam("salaryitemcount"))) * curCount;
                if (total2 > 100000) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u4e3a\u4fdd\u8bc1\u4f7f\u7528\u4f53\u9a8c\uff0c\u85aa\u6863\u6700\u591a\u53ef\u9009\u62e9{0}\u6863\u3002", (String)"SalaryStandardNameDesignerEdit_7", (String)PROJECT_RESOURCE, (Object[])new Object[]{100000 / gradeCount / itemCount2}));
                    return true;
                }
            } else if ("true".equals(fsp.getCustomParam("salarygrade")) && (total = (rankCount = Integer.parseInt(rankCountStr = (String)fsp.getCustomParam("salaryrankcount"))) * (itemCount = Integer.parseInt(itemCountStr = (String)fsp.getCustomParam("salaryitemcount"))) * curCount) > 100000) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u4e3a\u4fdd\u8bc1\u4f7f\u7528\u4f53\u9a8c\uff0c\u85aa\u7b49\u6700\u591a\u53ef\u9009\u62e9{0}\u7b49\u3002", (String)"SalaryStandardNameDesignerEdit_8", (String)PROJECT_RESOURCE, (Object[])new Object[]{100000 / rankCount / itemCount}));
                return true;
            }
        }
        return false;
    }

    private boolean isDataWithoutDuplication(List<SalaryStandardEntryEntity> entities) {
        Map<String, List<SalaryStandardEntryEntity>> entryEntitiesByDisplayName = entities.stream().collect(Collectors.groupingBy(SalaryStandardEntryEntity::getDisplayName));
        List duplicationEntryEntity = entryEntitiesByDisplayName.values().stream().filter(entryEntities -> entryEntities.size() > 1).collect(Collectors.toList());
        if (duplicationEntryEntity.isEmpty()) {
            return true;
        }
        String errMsg = ResManager.loadKDString((String)"\u663e\u793a\u540d\u79f0\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SalaryStandardNameDesignerEdit_2", (String)PROJECT_RESOURCE, (Object[])new Object[0]);
        this.getView().showTipNotification(errMsg);
        return false;
    }

    private boolean isDataWithoutBlank(DynamicObjectCollection entryEntity) {
        return null == entryEntity.stream().filter(entity -> org.apache.commons.lang3.StringUtils.isBlank((CharSequence)entity.getString(ENTRY_DISPLAY_NAME))).findFirst().orElse(null);
    }

    private List<SalaryStandardEntryEntity> makeEntryEntities(DynamicObjectCollection entryEntity) {
        return entryEntity.stream().map(this::makeEntryEntity).collect(Collectors.toList());
    }

    private SalaryStandardEntryEntity makeEntryEntity(DynamicObject dynamicObject) {
        SalaryStandardEntryEntity entity = new SalaryStandardEntryEntity();
        entity.setId(Long.valueOf(dynamicObject.getLong(ENTRY_ENTITY_ID)));
        String displayName = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dynamicObject.getString(ENTRY_DISPLAY_NAME)) ? dynamicObject.getString(ENTRY_DISPLAY_NAME) : dynamicObject.getString(ENTRY_DISPLAY_NAME).trim();
        dynamicObject.set(ENTRY_DISPLAY_NAME, (Object)displayName);
        entity.setDisplayName(dynamicObject.getString(ENTRY_DISPLAY_NAME));
        entity.setIndex(Integer.valueOf(dynamicObject.getInt(ENTRY_SEQ)));
        return entity;
    }

    private boolean isDateCountEnough() {
        int minCount = Integer.parseInt(this.getModel().getValue(FORM_MIN_COUNT).toString());
        if (this.getEntryEntityRowCount() < minCount) {
            String errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u8bbe\u7f6e%d\u884c\u3002", (String)"SalaryStandardNameDesignerEdit_0", (String)PROJECT_RESOURCE, (Object[])new Object[0]), minCount);
            this.getView().showTipNotification(errMsg);
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        switch (name = args.getProperty().getName()) {
            case "formnumber": {
                this.changeRowCount(args, SalaryStandardImportHelper.getMaxRow((String)FORM_NUMBER));
                break;
            }
            case "formnumber1": {
                this.changeRowCount(args, SalaryStandardImportHelper.getMaxRow((String)RANK_FORM_NUMBER));
                break;
            }
        }
    }

    private void changeRowCount(PropertyChangedArgs args, int maxRow) {
        int newValue;
        ChangeData changeData = args.getChangeSet()[0];
        int oldValue = Optional.ofNullable(changeData).map(ChangeData::getOldValue).map(p1 -> Integer.parseInt(p1.toString())).orElse(0);
        if (oldValue == (newValue = Optional.ofNullable(changeData).map(ChangeData::getNewValue).map(p1 -> Integer.parseInt(p1.toString())).orElse(0).intValue()) || oldValue > maxRow || oldValue < 0) {
            return;
        }
        if (newValue > maxRow) {
            this.showOutOfLimitMessage(maxRow);
            newValue = maxRow;
        }
        if (newValue < 0) {
            this.showOutOfLimitMessage(maxRow);
            newValue = 0;
        }
        this.controlGridRows(oldValue, newValue, maxRow);
    }

    private void controlGridRows(int oldValue, int newValue, int maxRow) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        if (oldValue > newValue) {
            model.deleteEntryRows("entryentity", this.createIntArrayRange(newValue, oldValue));
        } else {
            this.addRowLast(newValue - oldValue, maxRow);
        }
    }

    private int[] createIntArrayRange(int newValue, int oldValue) {
        int[] result = new int[oldValue - newValue];
        for (int i = newValue; i < oldValue; ++i) {
            result[i - newValue] = i;
        }
        return result;
    }
}

